/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.llvm;

import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMCallHelperFunctionNode;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import sun.misc.Unsafe;

abstract class GraalHPyLLVMNodes {
    private GraalHPyLLVMNodes() {
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMFromCharPointerNode
    extends GraalHPyNodes.HPyFromCharPointerNode {
        HPyLLVMFromCharPointerNode() {
        }

        @Specialization
        static TruffleString doCStringWrapper(GraalHPyContext hpyContext, CArrayWrappers.CStringWrapper cStringWrapper, int n, TruffleString.Encoding encoding, boolean copy) {
            return cStringWrapper.getString();
        }

        @Specialization
        static TruffleString doCByteArrayWrapper(GraalHPyContext hpyContext, CArrayWrappers.CByteArrayWrapper cByteArrayWrapper, int n, TruffleString.Encoding encoding, boolean copy, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            byte[] byteArray = cByteArrayWrapper.getByteArray();
            int length = n < 0 ? byteArray.length : n;
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(byteArray, 0, length, encoding, copy), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isCArrayWrapper(charPtr)", "isPointer(lib, charPtr)"})
        static TruffleString doPointer(GraalHPyContext hpyContext, Object charPtr, int n, TruffleString.Encoding encoding, boolean copy, @Cached.Shared @CachedLibrary(limit="2") InteropLibrary lib, @Cached TruffleString.FromNativePointerNode fromNative) {
            int length;
            long pointer;
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            try {
                pointer = lib.asPointer(charPtr);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (n < 0) {
                length = 0;
                Unsafe unsafe = hpyContext.getContext().getUnsafe();
                while (unsafe.getByte(pointer + (long)length) != 0) {
                    ++length;
                }
            } else {
                length = n;
            }
            return fromNative.execute(charPtr, 0, length, encoding, copy);
        }

        @Specialization(guards={"!isCArrayWrapper(charPtr)", "!isPointer(lib, charPtr)"})
        static TruffleString doForeignArray(GraalHPyContext hpyContext, Object charPtr, int n, TruffleString.Encoding encoding, boolean copy, @Cached.Shared @CachedLibrary(limit="2") InteropLibrary lib, @CachedLibrary(limit="1") InteropLibrary elementLib, @Cached GraalHPyLLVMCallHelperFunctionNode callHelperFunctionNode, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            try {
                int length;
                Object typedCharPtr;
                if (!lib.hasArrayElements(charPtr)) {
                    int size = n < 0 ? Integer.MAX_VALUE : n;
                    typedCharPtr = callHelperFunctionNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_FROM_I8_ARRAY, charPtr, size);
                    if (n < 0) {
                        length = 0;
                        while (elementLib.asByte(lib.readArrayElement(typedCharPtr, (long)length)) != 0) {
                            ++length;
                        }
                    } else {
                        length = n;
                    }
                } else {
                    typedCharPtr = charPtr;
                    int n2 = length = n < 0 ? PInt.intValueExact(lib.getArraySize(charPtr)) : n;
                }
                assert (lib.hasArrayElements(typedCharPtr));
                assert (length >= 0);
                byte[] bytes = getByteArrayNode.execute(typedCharPtr, length);
                return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, 0, bytes.length, encoding, false), PythonUtils.TS_ENCODING);
            }
            catch (OverflowException | InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        static boolean isCArrayWrapper(Object object) {
            return object instanceof CArrayWrappers.CArrayWrapper || object instanceof PySequenceArrayWrapper;
        }

        static boolean isPointer(InteropLibrary lib, Object object) {
            return lib.isPointer(object);
        }
    }
}

