/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.jni;

import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyMode;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIConvertArgNode;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNITrampolines;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class GraalHPyJNIFunctionPointer
implements TruffleObject {
    final long pointer;
    final GraalHPyContext.LLVMType signature;
    final HPyMode mode;

    public GraalHPyJNIFunctionPointer(long pointer, GraalHPyContext.LLVMType signature, HPyMode mode) {
        this.pointer = pointer;
        this.signature = signature;
        this.mode = mode;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.pointer;
    }

    @ExportMessage
    static final class Execute {
        Execute() {
        }

        @Specialization(guards={"receiver.signature == cachedSignature"}, limit="1")
        static Object doCached(GraalHPyJNIFunctionPointer receiver, Object[] arguments, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached(value="receiver.signature") GraalHPyContext.LLVMType cachedSignature, @Cached(parameters={"receiver.signature"}) GraalHPyJNIConvertArgNode convertArgNode) {
            return switch (receiver.mode) {
                case HPyMode.MODE_UNIVERSAL -> Execute.callUniversal(receiver, cachedSignature, Execute.convertHPyContext(arguments), arguments, interopLibrary, convertArgNode);
                case HPyMode.MODE_DEBUG -> Execute.callDebug(receiver, cachedSignature, Execute.convertHPyDebugContext(arguments), arguments, interopLibrary, convertArgNode);
                case HPyMode.MODE_TRACE -> Execute.callUniversal(receiver, cachedSignature, Execute.convertHPyTraceContext(arguments), arguments, interopLibrary, convertArgNode);
                default -> throw CompilerDirectives.shouldNotReachHere((String)"unsupported HPy mode");
            };
        }

        private static long callUniversal(GraalHPyJNIFunctionPointer receiver, GraalHPyContext.LLVMType signature, long ctx, Object[] arguments, InteropLibrary interopLibrary, GraalHPyJNIConvertArgNode convertArgNode) {
            switch (signature) {
                case HPyModule_init: {
                    return GraalHPyJNITrampolines.executeModuleInit(receiver.pointer);
                }
                case HPyModule_create: {
                    return GraalHPyJNITrampolines.executeModcreate(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_noargs: {
                    return GraalHPyJNITrampolines.executeNoargs(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_unaryfunc: {
                    return GraalHPyJNITrampolines.executeUnaryfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_getiterfunc: {
                    return GraalHPyJNITrampolines.executeGetiterfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_iternextfunc: {
                    return GraalHPyJNITrampolines.executeIternextfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_reprfunc: {
                    return GraalHPyJNITrampolines.executeReprfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_lenfunc: {
                    return GraalHPyJNITrampolines.executeLenfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_hashfunc: {
                    return GraalHPyJNITrampolines.executeHashfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_binaryfunc: {
                    return GraalHPyJNITrampolines.executeBinaryfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_o: {
                    return GraalHPyJNITrampolines.executeO(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getter: {
                    return GraalHPyJNITrampolines.executeGetter(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getattrfunc: {
                    return GraalHPyJNITrampolines.executeGetattrfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getattrofunc: {
                    return GraalHPyJNITrampolines.executeGetattrofunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_ssizeargfunc: {
                    return GraalHPyJNITrampolines.executeSsizeargfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_traverseproc: {
                    return GraalHPyJNITrampolines.executeTraverseproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_varargs: {
                    return GraalHPyJNITrampolines.executeVarargs(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_ternaryfunc: {
                    return GraalHPyJNITrampolines.executeTernaryfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_descrgetfunc: {
                    return GraalHPyJNITrampolines.executeDescrgetfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_ssizessizeargfunc: {
                    return GraalHPyJNITrampolines.executeSsizessizeargfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_keywords: {
                    return GraalHPyJNITrampolines.executeKeywords(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3), convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_inquiry: {
                    return GraalHPyJNITrampolines.executeInquiry(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_ssizeobjargproc: {
                    return GraalHPyJNITrampolines.executeSsizeobjargproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), (Long)arguments[2], convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_initproc: {
                    return GraalHPyJNITrampolines.executeInitproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), (Long)arguments[3], convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_ssizessizeobjargproc: {
                    return GraalHPyJNITrampolines.executeSsizessizeobjargproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), (Long)arguments[2], (Long)arguments[3], convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_setter: {
                    return GraalHPyJNITrampolines.executeSetter(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_setattrfunc: {
                    return GraalHPyJNITrampolines.executeSetattrfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_objobjargproc: {
                    return GraalHPyJNITrampolines.executeObjobjargproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_descrsetfunc: {
                    return GraalHPyJNITrampolines.executeDescrsetfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_setattrofunc: {
                    return GraalHPyJNITrampolines.executeSetattrofunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_freefunc: {
                    GraalHPyJNITrampolines.executeFreefunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                    return 0L;
                }
                case HPyFunc_richcmpfunc: {
                    return GraalHPyJNITrampolines.executeRichcmpfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), ((Integer)arguments[3]).intValue());
                }
                case HPyFunc_objobjproc: {
                    return GraalHPyJNITrampolines.executeObjobjproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getbufferproc: {
                    return GraalHPyJNITrampolines.executeGetbufferproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), (Integer)arguments[3]);
                }
                case HPyFunc_releasebufferproc: {
                    GraalHPyJNITrampolines.executeReleasebufferproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                    return 0L;
                }
                case HPyFunc_destroyfunc: {
                    GraalHPyJNITrampolines.executeDestroyfunc(receiver.pointer, Execute.convertPointer(arguments[0], interopLibrary));
                    return 0L;
                }
                case HPyFunc_destructor: {
                    GraalHPyJNITrampolines.executeDestructor(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                    return 0L;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        private static long callTrace(GraalHPyJNIFunctionPointer receiver, GraalHPyContext.LLVMType signature, Object[] arguments, InteropLibrary interopLibrary, GraalHPyJNIConvertArgNode convertArgNode) {
            switch (signature) {
                case HPyModule_init: {
                    return GraalHPyJNITrampolines.executeModuleInit(receiver.pointer);
                }
                case HPyModule_create: {
                    return GraalHPyJNITrampolines.executeDebugModcreate(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_noargs: {
                    return GraalHPyJNITrampolines.executeDebugNoargs(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_unaryfunc: {
                    return GraalHPyJNITrampolines.executeDebugUnaryfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_getiterfunc: {
                    return GraalHPyJNITrampolines.executeDebugGetiterfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_iternextfunc: {
                    return GraalHPyJNITrampolines.executeDebugIternextfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_reprfunc: {
                    return GraalHPyJNITrampolines.executeDebugReprfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_lenfunc: {
                    return GraalHPyJNITrampolines.executeDebugLenfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_hashfunc: {
                    return GraalHPyJNITrampolines.executeDebugHashfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_binaryfunc: {
                    return GraalHPyJNITrampolines.executeDebugBinaryfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_o: {
                    return GraalHPyJNITrampolines.executeDebugO(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getattrofunc: {
                    return GraalHPyJNITrampolines.executeDebugGetattrofunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getattrfunc: {
                    return GraalHPyJNITrampolines.executeDebugGetattrfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_ssizeargfunc: {
                    return GraalHPyJNITrampolines.executeDebugSsizeargfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getter: {
                    return GraalHPyJNITrampolines.executeDebugGetter(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_traverseproc: {
                    return GraalHPyJNITrampolines.executeTraverseproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_varargs: {
                    return GraalHPyJNITrampolines.executeDebugVarargs(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_ternaryfunc: {
                    return GraalHPyJNITrampolines.executeDebugTernaryfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_descrgetfunc: {
                    return GraalHPyJNITrampolines.executeDebugDescrgetfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_ssizessizeargfunc: {
                    return GraalHPyJNITrampolines.executeDebugSsizessizeargfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_keywords: {
                    return GraalHPyJNITrampolines.executeDebugKeywords(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3), convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_inquiry: {
                    return GraalHPyJNITrampolines.executeDebugInquiry(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_ssizeobjargproc: {
                    return GraalHPyJNITrampolines.executeDebugSsizeobjargproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), (Long)arguments[2], convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_initproc: {
                    return GraalHPyJNITrampolines.executeDebugInitproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), (Long)arguments[3], convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_ssizessizeobjargproc: {
                    return GraalHPyJNITrampolines.executeDebugSsizessizeobjargproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), (Long)arguments[2], (Long)arguments[3], convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_setter: {
                    return GraalHPyJNITrampolines.executeDebugSetter(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_setattrfunc: {
                    return GraalHPyJNITrampolines.executeDebugSetattrfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_objobjargproc: {
                    return GraalHPyJNITrampolines.executeDebugObjobjargproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_descrsetfunc: {
                    return GraalHPyJNITrampolines.executeDebugDescrsetfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_setattrofunc: {
                    return GraalHPyJNITrampolines.executeDebugSetattrofunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_freefunc: {
                    GraalHPyJNITrampolines.executeDebugFreefunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                    return 0L;
                }
                case HPyFunc_richcmpfunc: {
                    return GraalHPyJNITrampolines.executeDebugRichcmpfunc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), ((Integer)arguments[3]).intValue());
                }
                case HPyFunc_objobjproc: {
                    return GraalHPyJNITrampolines.executeDebugObjobjproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getbufferproc: {
                    return GraalHPyJNITrampolines.executeDebugGetbufferproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), (Integer)arguments[3]);
                }
                case HPyFunc_releasebufferproc: {
                    GraalHPyJNITrampolines.executeDebugReleasebufferproc(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                    return 0L;
                }
                case HPyFunc_destroyfunc: {
                    GraalHPyJNITrampolines.executeDestroyfunc(Execute.convertPointer(arguments[0], interopLibrary), receiver.pointer);
                    return 0L;
                }
                case HPyFunc_destructor: {
                    GraalHPyJNITrampolines.executeDebugDestructor(receiver.pointer, Execute.convertHPyTraceContext(arguments), convertArgNode.execute(arguments, 1));
                    return 0L;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        private static long callDebug(GraalHPyJNIFunctionPointer receiver, GraalHPyContext.LLVMType signature, long ctx, Object[] arguments, InteropLibrary interopLibrary, GraalHPyJNIConvertArgNode convertArgNode) {
            switch (signature) {
                case HPyModule_init: {
                    return GraalHPyJNITrampolines.executeModuleInit(receiver.pointer);
                }
                case HPyModule_create: {
                    return GraalHPyJNITrampolines.executeDebugModcreate(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_noargs: {
                    return GraalHPyJNITrampolines.executeDebugNoargs(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_unaryfunc: {
                    return GraalHPyJNITrampolines.executeDebugUnaryfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_getiterfunc: {
                    return GraalHPyJNITrampolines.executeDebugGetiterfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_iternextfunc: {
                    return GraalHPyJNITrampolines.executeDebugIternextfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_reprfunc: {
                    return GraalHPyJNITrampolines.executeDebugReprfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_lenfunc: {
                    return GraalHPyJNITrampolines.executeDebugLenfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_hashfunc: {
                    return GraalHPyJNITrampolines.executeDebugHashfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_binaryfunc: {
                    return GraalHPyJNITrampolines.executeDebugBinaryfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_o: {
                    return GraalHPyJNITrampolines.executeDebugO(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getattrofunc: {
                    return GraalHPyJNITrampolines.executeDebugGetattrofunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getattrfunc: {
                    return GraalHPyJNITrampolines.executeDebugGetattrfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_ssizeargfunc: {
                    return GraalHPyJNITrampolines.executeDebugSsizeargfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getter: {
                    return GraalHPyJNITrampolines.executeDebugGetter(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_traverseproc: {
                    return GraalHPyJNITrampolines.executeTraverseproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_varargs: {
                    return GraalHPyJNITrampolines.executeDebugVarargs(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_ternaryfunc: {
                    return GraalHPyJNITrampolines.executeDebugTernaryfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_descrgetfunc: {
                    return GraalHPyJNITrampolines.executeDebugDescrgetfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_ssizessizeargfunc: {
                    return GraalHPyJNITrampolines.executeDebugSsizessizeargfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_keywords: {
                    return GraalHPyJNITrampolines.executeDebugKeywords(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3), convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_inquiry: {
                    return GraalHPyJNITrampolines.executeDebugInquiry(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                }
                case HPyFunc_ssizeobjargproc: {
                    return GraalHPyJNITrampolines.executeDebugSsizeobjargproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), (Long)arguments[2], convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_initproc: {
                    return GraalHPyJNITrampolines.executeDebugInitproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), (Long)arguments[3], convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_ssizessizeobjargproc: {
                    return GraalHPyJNITrampolines.executeDebugSsizessizeobjargproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), (Long)arguments[2], (Long)arguments[3], convertArgNode.execute(arguments, 4));
                }
                case HPyFunc_setter: {
                    return GraalHPyJNITrampolines.executeDebugSetter(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_setattrfunc: {
                    return GraalHPyJNITrampolines.executeDebugSetattrfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_objobjargproc: {
                    return GraalHPyJNITrampolines.executeDebugObjobjargproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_descrsetfunc: {
                    return GraalHPyJNITrampolines.executeDebugDescrsetfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_setattrofunc: {
                    return GraalHPyJNITrampolines.executeDebugSetattrofunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), convertArgNode.execute(arguments, 3));
                }
                case HPyFunc_freefunc: {
                    GraalHPyJNITrampolines.executeDebugFreefunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                    return 0L;
                }
                case HPyFunc_richcmpfunc: {
                    return GraalHPyJNITrampolines.executeDebugRichcmpfunc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), ((Integer)arguments[3]).intValue());
                }
                case HPyFunc_objobjproc: {
                    return GraalHPyJNITrampolines.executeDebugObjobjproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                }
                case HPyFunc_getbufferproc: {
                    return GraalHPyJNITrampolines.executeDebugGetbufferproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2), (Integer)arguments[3]);
                }
                case HPyFunc_releasebufferproc: {
                    GraalHPyJNITrampolines.executeDebugReleasebufferproc(receiver.pointer, ctx, convertArgNode.execute(arguments, 1), convertArgNode.execute(arguments, 2));
                    return 0L;
                }
                case HPyFunc_destroyfunc: {
                    GraalHPyJNITrampolines.executeDestroyfunc(Execute.convertPointer(arguments[0], interopLibrary), receiver.pointer);
                    return 0L;
                }
                case HPyFunc_destructor: {
                    GraalHPyJNITrampolines.executeDebugDestructor(receiver.pointer, ctx, convertArgNode.execute(arguments, 1));
                    return 0L;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        private static long convertHPyContext(Object[] arguments) {
            GraalHPyJNIContext jniBackend = GraalHPyJNIConvertArgNode.getHPyContext(arguments);
            try {
                return jniBackend.asPointer();
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        private static long convertHPyDebugContext(Object[] arguments) {
            GraalHPyJNIContext jniBackend = GraalHPyJNIConvertArgNode.getHPyContext(arguments);
            assert (jniBackend.getHPyDebugContext() != 0L);
            return jniBackend.getHPyDebugContext();
        }

        private static long convertHPyTraceContext(Object[] arguments) {
            GraalHPyJNIContext jniBackend = GraalHPyJNIConvertArgNode.getHPyContext(arguments);
            assert (jniBackend.getHPyTraceContext() != 0L);
            return jniBackend.getHPyTraceContext();
        }

        private static long convertPointer(Object argument2, InteropLibrary interopLibrary) {
            if (!interopLibrary.isPointer(argument2)) {
                interopLibrary.toNative(argument2);
            }
            try {
                return interopLibrary.asPointer(argument2);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }
}

