/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PyMemoryViewWrapperFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonReplacingNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

public final class PyMemoryViewWrapper
extends PythonReplacingNativeWrapper {
    public PyMemoryViewWrapper(PythonObject delegate) {
        super(delegate);
        assert (delegate instanceof PMemoryView);
    }

    @Override
    protected Object allocateReplacememtObject() {
        return PyMemoryViewWrapperFactory.AllocateNodeGen.getUncached().execute(this.getDelegate());
    }

    @GenerateUncached
    public static abstract class AllocateNode
    extends PNodeWithContext {
        public abstract Object execute(Object var1);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object doPythonNativeWrapper(PMemoryView object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClass, @Cached CApiTransitions.PythonToNativeNewRefNode toNative, @Cached CStructAccess.AllocateNode allocNode, @Cached CStructAccess.GetElementPtrNode getElementNode, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CStructAccess.WriteLongNode writeI64Node, @Cached CStructAccess.WriteIntNode writeI32Node, @Cached SequenceNodes.GetSequenceStorageNode getStorage, @Cached SequenceNodes.SetSequenceStorageNode setStorage, @Cached CExtNodes.PointerAddNode pointerAddNode, @Cached PySequenceArrayWrapper.ToNativeStorageNode toNativeStorageNode, @Cached IntArrayToNativePySSizeArray intArrayToNativePySSizeArray, @Cached CExtNodes.AsCharPointerNode asCharPointerNode) {
            Object buf;
            Object mem = allocNode.alloc(CStructs.PyMemoryViewObject);
            writeI64Node.write(mem, CFields.PyObject__ob_refcnt, 4096L);
            writePointerNode.write(mem, CFields.PyObject__ob_type, toNative.execute(getClass.execute(inliningTarget, object)));
            writeI32Node.write(mem, CFields.PyMemoryViewObject__flags, object.getFlags());
            writeI64Node.write(mem, CFields.PyMemoryViewObject__exports, object.getExports().get());
            Object view = getElementNode.getElementPtr(mem, CFields.PyMemoryViewObject__view);
            if (object.getBufferPointer() == null) {
                PSequence owner = (PSequence)object.getOwner();
                NativeSequenceStorage nativeStorage = toNativeStorageNode.execute(getStorage.execute(inliningTarget, owner), owner instanceof PBytesLike);
                if (nativeStorage == null) {
                    throw CompilerDirectives.shouldNotReachHere((String)"cannot allocate native storage");
                }
                setStorage.execute(inliningTarget, owner, nativeStorage);
                Object pointer = nativeStorage.getPtr();
                buf = object.getOffset() == 0 ? pointer : pointerAddNode.execute(pointer, object.getOffset());
            } else {
                buf = object.getOffset() == 0 ? object.getBufferPointer() : pointerAddNode.execute(object.getBufferPointer(), object.getOffset());
            }
            writePointerNode.write(view, CFields.Py_buffer__buf, buf);
            if (object.getOwner() != null) {
                writePointerNode.write(view, CFields.Py_buffer__obj, toNative.execute(object.getOwner()));
            }
            writeI64Node.write(view, CFields.Py_buffer__len, object.getLength());
            writeI64Node.write(view, CFields.Py_buffer__itemsize, object.getItemSize());
            writeI32Node.write(view, CFields.Py_buffer__readonly, PInt.intValue(object.isReadOnly()));
            writeI32Node.write(view, CFields.Py_buffer__ndim, object.getDimensions());
            if (object.getFormatString() != null) {
                writePointerNode.write(view, CFields.Py_buffer__format, asCharPointerNode.execute(object.getFormatString()));
            }
            if (object.getBufferShape() != null) {
                writePointerNode.write(view, CFields.Py_buffer__shape, intArrayToNativePySSizeArray.execute(object.getBufferShape()));
            }
            if (object.getBufferStrides() != null) {
                writePointerNode.write(view, CFields.Py_buffer__strides, intArrayToNativePySSizeArray.execute(object.getBufferStrides()));
            }
            if (object.getBufferSuboffsets() != null) {
                writePointerNode.write(view, CFields.Py_buffer__suboffsets, intArrayToNativePySSizeArray.execute(object.getBufferSuboffsets()));
            }
            return mem;
        }

        @GenerateUncached
        static abstract class IntArrayToNativePySSizeArray
        extends Node {
            IntArrayToNativePySSizeArray() {
            }

            public abstract Object execute(int[] var1);

            @Specialization
            static Object getShape(int[] intArray, @Cached CStructAccess.AllocateNode alloc, @Cached CStructAccess.WriteLongNode write) {
                Object mem = alloc.alloc(intArray.length * 8);
                write.writeIntArray(mem, intArray);
                return mem;
            }
        }
    }
}

