/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObject;
import com.oracle.graal.python.builtins.modules.hashlib.ShakeDigestObjectBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.hashlib.ShakeDigestObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Sha3Shake128Type, PythonBuiltinClassType.Sha3Shake256Type, PythonBuiltinClassType.HashlibHashXof})
public final class ShakeDigestObjectBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ShakeDigestObjectBuiltinsFactory.getFactories();
    }

    @Builtin(name="hexdigest", parameterNames={"self", "length"})
    @GenerateNodeFactory
    @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index)
    static abstract class HexdigestNode
    extends PythonBinaryClinicBuiltinNode {
        HexdigestNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ShakeDigestObjectBuiltinsClinicProviders.HexdigestNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        TruffleString hexdigest(DigestObject self, int length, @Cached BytesNodes.ByteToHexNode toHexNode) {
            if (self.getDigestLength() != length) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.ONLY_DEFAULT_DIGEST_LENGTHS);
            }
            byte[] digest = self.digest();
            return toHexNode.execute(digest, digest.length, (byte)0, 0);
        }
    }

    @Builtin(name="digest", parameterNames={"self", "length"})
    @GenerateNodeFactory
    @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index)
    static abstract class DigestNode
    extends PythonBinaryClinicBuiltinNode {
        DigestNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ShakeDigestObjectBuiltinsClinicProviders.DigestNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PBytes digest(DigestObject self, int length) {
            if (self.getDigestLength() != length) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.ONLY_DEFAULT_DIGEST_LENGTHS);
            }
            return this.factory().createBytes(self.digest());
        }
    }

    @Builtin(name="digest_size", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DigestSizeNode
    extends PythonUnaryBuiltinNode {
        DigestSizeNode() {
        }

        @Specialization
        static int get(DigestObject self) {
            return 0;
        }
    }
}

