/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecState;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteDecodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteEncodeBuffer;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.Charset;

public class MultibyteCodec {
    protected final TruffleString encoding;
    protected final Charset charset;
    protected final CodecType type;

    protected MultibyteCodec(TruffleString encoding, Charset charset, CodecType type) {
        this.encoding = encoding;
        this.charset = charset;
        this.type = type;
    }

    protected boolean canEncreset() {
        return this.type == CodecType.ISO2022 || this.type == CodecType.STATEFUL;
    }

    public void codecinit() {
    }

    public MultibyteCodecState encinit(TruffleString errors) {
        return MultibyteCodecState.encoder(this.charset, errors);
    }

    @CompilerDirectives.TruffleBoundary
    public int encode(MultibyteCodecState state, MultibyteEncodeBuffer buf, int flags) {
        MultibyteCodecState.Encoder encoder = (MultibyteCodecState.Encoder)state;
        return encoder.encode(buf, flags);
    }

    public int encreset(MultibyteCodecState state, MultibyteEncodeBuffer buf) {
        MultibyteCodecState.Encoder encoder = (MultibyteCodecState.Encoder)state;
        return encoder.encreset(buf);
    }

    public MultibyteCodecState decinit(TruffleString errors) {
        return MultibyteCodecState.decoder(this.charset, errors);
    }

    @CompilerDirectives.TruffleBoundary
    public int decode(MultibyteCodecState state, MultibyteDecodeBuffer buf, PRaiseNode raiseNode) {
        MultibyteCodecState.Decoder decoder = (MultibyteCodecState.Decoder)state;
        return decoder.decode(buf, raiseNode);
    }

    public void decreset(MultibyteCodecState state) {
        MultibyteCodecState.Decoder decoder = (MultibyteCodecState.Decoder)state;
        decoder.decreset();
    }

    @CompilerDirectives.TruffleBoundary
    public int getErrorLength(MultibyteCodecState state) {
        return state.coderResult.length();
    }

    private TruffleString getErrorReason(MultibyteCodecState state) {
        if (state.coderResult.isMalformed()) {
            return ErrorMessages.MALFORMED_INPUT;
        }
        if (state.coderResult.isUnmappable()) {
            return ErrorMessages.UNMAPPABLE_CHARACTER;
        }
        throw new IllegalArgumentException("Unicode error constructed from non-error result");
    }

    static enum CodecType {
        STATELESS_WINIT,
        STATELESS,
        STATEFUL,
        ISO2022;

    }
}

