/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;

public final class IntArrayBuilder {
    private int[] data;
    private int size;

    public IntArrayBuilder() {
        this(8);
    }

    public IntArrayBuilder(int capacity) {
        this.data = new int[capacity];
    }

    public void add(int item) {
        if (this.size == this.data.length) {
            try {
                this.data = IntArrayBuilder.arrayCopyOf(this.data, PythonUtils.multiplyExact(this.size, 2));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreter();
                throw new OutOfMemoryError();
            }
        }
        this.data[this.size++] = item;
    }

    public int get(int index) {
        assert (index >= 0 && index < this.size);
        return this.data[index];
    }

    public int[] toArray() {
        return IntArrayBuilder.arrayCopyOf(this.data, this.size);
    }

    public int size() {
        return this.size;
    }

    private static int[] arrayCopyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        PythonUtils.arraycopy(original, 0, copy, 0, Math.min(newLength, original.length));
        return copy;
    }
}

