/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public enum BufferFormat {
    UINT_8(1, "B"),
    INT_8(1, "b"),
    UINT_16(2, "H"),
    INT_16(2, "h"),
    UINT_32(4, "I"),
    INT_32(4, "i"),
    UINT_64(8, "L"),
    INT_64(8, "l"),
    FLOAT(4, "f"),
    DOUBLE(8, "d"),
    UNICODE(4, "u"),
    CHAR(1, "c"),
    BOOLEAN(1, "?"),
    OTHER(-1, null);

    public static final TruffleString T_UINT_8_TYPE_CODE;
    public static final TruffleString T_UNICODE_TYPE_CODE_U;
    public static final TruffleString T_UNICODE_TYPE_CODE_W;
    public final int bytesize;
    public final TruffleString baseTypeCode;

    private BufferFormat(int bytesize, String baseTypeCode) {
        this.bytesize = bytesize;
        this.baseTypeCode = PythonUtils.toTruffleStringUncached(baseTypeCode);
    }

    public static BufferFormat forMemoryView(TruffleString formatString, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        char fmtchar;
        int length = lengthNode.execute((AbstractTruffleString)formatString, PythonUtils.TS_ENCODING);
        if (length == 1) {
            fmtchar = (char)atIndexNode.execute((AbstractTruffleString)formatString, 0, PythonUtils.TS_ENCODING);
        } else if (length == 2 && atIndexNode.execute((AbstractTruffleString)formatString, 0, PythonUtils.TS_ENCODING) == 64) {
            fmtchar = (char)atIndexNode.execute((AbstractTruffleString)formatString, 1, PythonUtils.TS_ENCODING);
        } else {
            return OTHER;
        }
        switch (fmtchar) {
            case 'N': 
            case 'P': {
                return UINT_64;
            }
            case 'n': {
                return INT_64;
            }
            case '?': {
                return BOOLEAN;
            }
            case 'c': {
                return CHAR;
            }
        }
        BufferFormat format = BufferFormat.fromCharCommon(fmtchar);
        return format != null ? format : OTHER;
    }

    public static BufferFormat forArray(TruffleString formatString, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        int length = lengthNode.execute((AbstractTruffleString)formatString, PythonUtils.TS_ENCODING);
        if (length == 1) {
            char fmtchar = (char)atIndexNode.execute((AbstractTruffleString)formatString, 0, PythonUtils.TS_ENCODING);
            if (fmtchar == 'u') {
                return UNICODE;
            }
            return BufferFormat.fromCharCommon(fmtchar);
        }
        return null;
    }

    private static BufferFormat fromCharCommon(char fmtchar) {
        switch (fmtchar) {
            case 'B': {
                return UINT_8;
            }
            case 'b': {
                return INT_8;
            }
            case 'H': {
                return UINT_16;
            }
            case 'h': {
                return INT_16;
            }
            case 'I': {
                return UINT_32;
            }
            case 'i': {
                return INT_32;
            }
            case 'L': 
            case 'Q': {
                return UINT_64;
            }
            case 'l': 
            case 'q': {
                return INT_64;
            }
            case 'f': {
                return FLOAT;
            }
            case 'd': {
                return DOUBLE;
            }
        }
        return null;
    }

    public static boolean isFloatingPoint(BufferFormat format) {
        return format == FLOAT || format == DOUBLE;
    }

    static {
        T_UINT_8_TYPE_CODE = PythonUtils.tsLiteral("B");
        T_UNICODE_TYPE_CODE_U = PythonUtils.tsLiteral("u");
        T_UNICODE_TYPE_CODE_W = PythonUtils.tsLiteral("w");
    }
}

