/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.exception;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.exception.TopLevelExceptionHandler;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    @CompilerDirectives.TruffleBoundary
    public static void printPythonLikeStackTrace() {
        CompilerAsserts.neverPartOfCompilation((String)"printPythonLikeStackTrace is a debug method");
        ArrayList<String> stack = new ArrayList<String>();
        Truffle.getRuntime().iterateFrames(frameInstance -> {
            RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
            RootNode rootNode = target.getRootNode();
            Node location = frameInstance.getCallNode();
            if (location == null) {
                location = rootNode;
            }
            int lineno = ExceptionUtils.getLineno(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY));
            ExceptionUtils.appendStackLine(stack, location, rootNode, true, lineno);
            return null;
        });
        ExceptionUtils.printStack(new PrintWriter(System.err, true), stack);
    }

    private static int getLineno(Frame frame) {
        FrameDescriptor fd;
        int lineno = -1;
        if (frame != null && (fd = frame.getFrameDescriptor()).getInfo() instanceof FrameInfo) {
            FrameInfo frameInfo = (FrameInfo)fd.getInfo();
            int bci = frameInfo.getBci(frame);
            lineno = frameInfo.getRootNode().bciToLine(bci);
        }
        return lineno;
    }

    @CompilerDirectives.TruffleBoundary
    public static void printPythonLikeStackTrace(Throwable e) {
        ExceptionUtils.printPythonLikeStackTrace(new PrintWriter(System.err, true), e);
    }

    @CompilerDirectives.TruffleBoundary
    public static void printPythonLikeStackTrace(PythonContext context, Throwable e) {
        ExceptionUtils.printPythonLikeStackTrace(new PrintWriter(context.getEnv().err(), true), e);
    }

    private static void printPythonLikeStackTrace(PrintWriter p, Throwable e) {
        InteropLibrary lib;
        List stackTrace = TruffleStackTrace.getStackTrace((Throwable)e);
        if (stackTrace != null) {
            ArrayList<String> stack = new ArrayList<String>();
            for (TruffleStackTraceElement frame : stackTrace) {
                Node location = frame.getLocation();
                RootNode rootNode = frame.getTarget().getRootNode();
                int lineno = ExceptionUtils.getLineno(frame.getFrame());
                ExceptionUtils.appendStackLine(stack, location, rootNode, false, lineno);
            }
            ExceptionUtils.printStack(p, stack);
        }
        if ((lib = InteropLibrary.getUncached()).isException((Object)e) && lib.hasExceptionMessage((Object)lib)) {
            try {
                p.println(lib.getExceptionMessage((Object)e));
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        } else {
            p.println(e.getMessage());
        }
    }

    private static void appendStackLine(ArrayList<String> stack, Node location, RootNode rootNode, boolean evenWithoutSource, int lineno) {
        SourceSection sourceSection;
        if (rootNode instanceof TopLevelExceptionHandler) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        SourceSection sourceSection2 = sourceSection = location != null ? location.getEncapsulatingSourceSection() : null;
        if (sourceSection != null) {
            sb.append("  File \"");
            Source source = sourceSection.getSource();
            sb.append(source.getPath() != null ? source.getPath() : source.getName());
            sb.append("\", line ");
            sb.append(lineno > 0 ? lineno : sourceSection.getStartLine());
            sb.append(", in ");
            sb.append(rootNode.getName());
        } else if (evenWithoutSource) {
            if (rootNode instanceof BuiltinFunctionRootNode) {
                sb.append("  Builtin function ");
                sb.append(rootNode.getName());
                sb.append(" (node class ");
                sb.append(((BuiltinFunctionRootNode)rootNode).getFactory().getNodeClass().getName());
                sb.append(")");
            } else {
                sb.append("  Builtin root ");
                sb.append(rootNode.getName());
                sb.append(" (class ");
                sb.append(rootNode.getClass().getName());
                sb.append(")");
            }
        }
        if (sb.length() > 0) {
            stack.add(sb.toString());
        }
    }

    private static void printStack(PrintWriter p, ArrayList<String> stack) {
        p.println("Traceback (most recent call last):");
        ListIterator<String> listIterator = stack.listIterator(stack.size());
        while (listIterator.hasPrevious()) {
            p.println(listIterator.previous());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void printExceptionTraceback(PythonContext context, Object pythonException) {
        Object type = GetClassNode.executeUncached(pythonException);
        Object tb = ExceptionNodes.GetTracebackNode.executeUncached(pythonException);
        Object hook = context.lookupBuiltinModule(BuiltinNames.T_SYS).getAttribute(BuiltinNames.T_EXCEPTHOOK);
        if (hook != PNone.NO_VALUE) {
            try {
                CallNode.getUncached().execute((Frame)null, hook, new Object[]{type, pythonException, tb}, PKeyword.EMPTY_KEYWORDS);
            }
            catch (PException internalError) {
                if (pythonException instanceof PBaseException) {
                    PBaseException managedException = (PBaseException)pythonException;
                    throw managedException.getExceptionForReraise(managedException.getTraceback());
                }
                throw PException.fromObject(pythonException, null, false);
            }
        }
        try {
            context.getEnv().err().write("sys.excepthook is missing\n".getBytes());
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void printJavaStackTrace(PException e) {
        PException exception;
        LazyTraceback traceback;
        for (traceback = e.getTraceback(); traceback != null && traceback.getNextChain() != null; traceback = traceback.getNextChain()) {
        }
        if (traceback != null && (exception = traceback.getException()) != null && exception.getCause() != null && exception.getCause().getStackTrace().length != 0) {
            exception.getCause().printStackTrace();
        }
    }

    public static PException wrapJavaException(Throwable e, Node node, PBaseException pythonException) {
        return PException.fromObject((Object)pythonException, node, e);
    }
}

