/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PGuards.class})
@GenerateInline
@GenerateCached(value=false)
abstract class CastToJavaLongNode
extends PNodeWithContext {
    CastToJavaLongNode() {
    }

    public abstract long execute(Node var1, Object var2) throws CannotCastException;

    @Specialization
    static long doLong(byte x) {
        return x;
    }

    @Specialization
    static long doLong(int x) {
        return x;
    }

    @Specialization
    static long doLong(long x) {
        return x;
    }

    @Specialization
    static long doLong(boolean x) {
        return x ? 1L : 0L;
    }

    @Specialization
    static long doNativeObject(Node inliningTarget, PythonNativeObject x, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode) {
        if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, x), (Object)PythonBuiltinClassType.PInt)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new RuntimeException("casting a native long object to a Java long is not implemented yet");
        }
        throw CannotCastException.INSTANCE;
    }

    @Fallback
    static long doUnsupported(Object x) {
        throw CannotCastException.INSTANCE;
    }
}

