/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.AbstractCallMethodNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallQuaternaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNodeGen;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
public abstract class CallVarargsMethodNode
extends AbstractCallMethodNode {
    public abstract Object execute(Frame var1, Object var2, Object[] var3, PKeyword[] var4);

    @NeverDefault
    public static CallVarargsMethodNode create() {
        return CallVarargsMethodNodeGen.create();
    }

    public static CallVarargsMethodNode getUncached() {
        return CallVarargsMethodNodeGen.getUncached();
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()", rewriteOn={PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.class})
    static Object callVarargsDirect(VirtualFrame frame, PBuiltinFunction func, Object[] arguments, PKeyword[] keywords, @Cached(value="func") PBuiltinFunction cachedFunc, @Cached(value="getVarargs(frame, func)") PythonVarargsBuiltinNode builtinNode) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
        return builtinNode.varArgExecute(frame, PNone.NO_VALUE, arguments, keywords);
    }

    @Specialization(guards={"func.getCallTarget() == ct", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()", rewriteOn={PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.class})
    static Object callVarargs(VirtualFrame frame, PBuiltinFunction func, Object[] arguments, PKeyword[] keywords, @Cached(value="func.getCallTarget()") RootCallTarget ct, @Cached(value="getVarargs(frame, func)") PythonVarargsBuiltinNode builtinNode) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
        return builtinNode.varArgExecute(frame, PNone.NO_VALUE, arguments, keywords);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "takesSelfArg"}, rewriteOn={PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.class}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSelfMethodSingleContext(VirtualFrame frame, PBuiltinMethod func, Object[] arguments, PKeyword[] keywords, @Cached(value="func", weak=true) PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getVarargs(frame, func.getBuiltinFunction())") PythonVarargsBuiltinNode builtinNode) {
        return builtinNode.varArgExecute(frame, func.getSelf(), arguments, keywords);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()", rewriteOn={PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.class})
    static Object callSelfMethod(VirtualFrame frame, PBuiltinMethod func, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getVarargs(frame, func.getBuiltinFunction())") PythonVarargsBuiltinNode builtinNode) {
        return builtinNode.varArgExecute(frame, func.getSelf(), arguments, keywords);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "!takesSelfArg"}, rewriteOn={PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.class}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSelfMethodSingleContextNoSelf(VirtualFrame frame, PBuiltinMethod func, Object[] arguments, PKeyword[] keywords, @Cached(value="func") PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getVarargs(frame, func.getBuiltinFunction())") PythonVarargsBuiltinNode builtinNode) {
        return builtinNode.varArgExecute(frame, PNone.NO_VALUE, arguments, keywords);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "!takesSelfArg"}, rewriteOn={PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.class}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSelfMethodNoSelf(VirtualFrame frame, PBuiltinMethod func, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getVarargs(frame, func.getBuiltinFunction())") PythonVarargsBuiltinNode builtinNode) {
        return builtinNode.varArgExecute(frame, PNone.NO_VALUE, arguments, keywords);
    }

    @Specialization(guards={"arguments.length == 1", "keywords.length == 0"})
    static Object callUnary(VirtualFrame frame, Object callable, Object[] arguments, PKeyword[] keywords, @Cached CallUnaryMethodNode callUnaryMethodNode) {
        return callUnaryMethodNode.executeObject((Frame)frame, callable, arguments[0]);
    }

    @Specialization(guards={"arguments.length == 2", "keywords.length == 0"})
    static Object callBinary(VirtualFrame frame, Object callable, Object[] arguments, PKeyword[] keywords, @Cached CallBinaryMethodNode callBinaryMethodNode) {
        return callBinaryMethodNode.executeObject((Frame)frame, callable, arguments[0], arguments[1]);
    }

    @Specialization(guards={"arguments.length == 3", "keywords.length == 0"})
    static Object callTernary(VirtualFrame frame, Object callable, Object[] arguments, PKeyword[] keywords, @Cached CallTernaryMethodNode callTernaryMethodNode) {
        return callTernaryMethodNode.execute((Frame)frame, callable, arguments[0], arguments[1], arguments[2]);
    }

    @Specialization(guards={"arguments.length == 4", "keywords.length == 0"})
    static Object callQuaternary(VirtualFrame frame, Object callable, Object[] arguments, PKeyword[] keywords, @Cached CallQuaternaryMethodNode callQuaternaryMethodNode) {
        return callQuaternaryMethodNode.execute((Frame)frame, callable, arguments[0], arguments[1], arguments[2], arguments[3]);
    }

    @Specialization(replaces={"callVarargsDirect", "callVarargs", "callSelfMethodSingleContext", "callSelfMethod", "callSelfMethodSingleContextNoSelf", "callSelfMethodNoSelf", "callUnary", "callBinary", "callTernary", "callQuaternary"})
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    static Object call(VirtualFrame frame, Object func, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached InlinedConditionProfile isBoundProfile) {
        if (isBoundProfile.profile(inliningTarget, func instanceof BoundDescriptor)) {
            Object[] boundArguments = new Object[arguments.length - 1];
            PythonUtils.arraycopy(arguments, 1, boundArguments, 0, boundArguments.length);
            return callNode.execute((Frame)frame, ((BoundDescriptor)func).descriptor, boundArguments, keywords);
        }
        return callNode.execute((Frame)frame, func, arguments, keywords);
    }
}

