/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.nodes.attributes.ObjectAttributeNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
@GenerateUncached
@GenerateInline(value=false)
public abstract class WriteAttributeToDynamicObjectNode
extends ObjectAttributeNode {
    public abstract boolean execute(Object var1, HiddenKey var2, Object var3);

    public abstract boolean execute(Object var1, TruffleString var2, Object var3);

    public abstract boolean execute(Object var1, Object var2, Object var3);

    @NeverDefault
    public static WriteAttributeToDynamicObjectNode create() {
        return WriteAttributeToDynamicObjectNodeGen.create();
    }

    public static WriteAttributeToDynamicObjectNode getUncached() {
        return WriteAttributeToDynamicObjectNodeGen.getUncached();
    }

    @Specialization(limit="getAttributeAccessInlineCacheMaxDepth()")
    static boolean writeDirect(DynamicObject dynamicObject, TruffleString key, Object value, @CachedLibrary(value="dynamicObject") DynamicObjectLibrary dylib) {
        dylib.put(dynamicObject, (Object)key, value);
        return true;
    }

    @Specialization(limit="getAttributeAccessInlineCacheMaxDepth()")
    static boolean writeDirectHidden(DynamicObject dynamicObject, HiddenKey key, Object value, @CachedLibrary(value="dynamicObject") DynamicObjectLibrary dylib) {
        dylib.put(dynamicObject, (Object)key, value);
        return true;
    }

    @Specialization(guards={"!isHiddenKey(key)"}, replaces={"writeDirect"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    static boolean write(DynamicObject dynamicObject, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castNode, @CachedLibrary(value="dynamicObject") DynamicObjectLibrary dylib) {
        dylib.put(dynamicObject, (Object)WriteAttributeToDynamicObjectNode.attrKey(inliningTarget, key, castNode), value);
        return true;
    }
}

