/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectDelItemNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectDelItem
extends Node {
    public final void executeCached(Frame frame, Object container, Object index) {
        this.execute(frame, this, container, index);
    }

    public abstract void execute(Frame var1, Node var2, Object var3, Object var4);

    @Specialization
    static void doWithFrame(VirtualFrame frame, Node inliningTarget, Object primary, Object index, @Cached.Shared(value="getclass") @Cached GetClassNode getClassNode, @Cached(value="create(DelItem)") LookupSpecialMethodSlotNode lookupDelitem, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raise, @Cached.Shared(value="callNode") @Cached(inline=false) CallBinaryMethodNode callDelitem) {
        Object delitem = lookupDelitem.execute((Frame)frame, getClassNode.execute(inliningTarget, primary), primary);
        if (delitem == PNone.NO_VALUE) {
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOESNT_SUPPORT_DELETION, primary);
        }
        callDelitem.executeObject((Frame)frame, delitem, primary, index);
    }

    @Specialization(replaces={"doWithFrame"})
    @HostCompilerDirectives.InliningCutoff
    static void doGeneric(Node inliningTarget, Object primary, Object index, @Cached.Shared(value="getclass") @Cached GetClassNode getClassNode, @Cached(parameters={"DelItem"}, inline=false) LookupCallableSlotInMRONode lookupDelitem, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raise, @Cached.Shared(value="callNode") @Cached(inline=false) CallBinaryMethodNode callDelitem) {
        Object setitem = lookupDelitem.execute(getClassNode.execute(inliningTarget, primary));
        if (setitem == PNone.NO_VALUE) {
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOESNT_SUPPORT_DELETION, primary);
        }
        callDelitem.executeObject(null, setitem, primary, index);
    }

    @NeverDefault
    public static PyObjectDelItem create() {
        return PyObjectDelItemNodeGen.create();
    }

    public static PyObjectDelItem getUncached() {
        return PyObjectDelItemNodeGen.getUncached();
    }
}

