/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.compiler.BinaryOps;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.compiler.SourceMap;
import com.oracle.graal.python.compiler.UnaryOps;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;

public final class CodeUnit {
    private static final int DISASSEMBLY_NUM_COLUMNS = 8;
    public final TruffleString name;
    public final TruffleString qualname;
    public final int argCount;
    public final int kwOnlyArgCount;
    public final int positionalOnlyArgCount;
    public final int stacksize;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] code;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] srcOffsetTable;
    public final int flags;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] names;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] varnames;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] cellvars;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final TruffleString[] freevars;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] cell2arg;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] arg2cell;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final Object[] constants;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final long[] primitiveConstants;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] exceptionHandlerRanges;
    public final int conditionProfileCount;
    public final int startLine;
    public final int startColumn;
    public final int endLine;
    public final int endColumn;
    @CompilerDirectives.CompilationFinal
    SourceMap sourceMap;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] outputCanQuicken;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] variableShouldUnbox;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[][] generalizeInputsMap;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[][] generalizeVarsMap;

    public CodeUnit(TruffleString name, TruffleString qualname, int argCount, int kwOnlyArgCount, int positionalOnlyArgCount, int stacksize, byte[] code, byte[] linetable, int flags, TruffleString[] names, TruffleString[] varnames, TruffleString[] cellvars, TruffleString[] freevars, int[] cell2arg, Object[] constants, long[] primitiveConstants, int[] exceptionHandlerRanges, int conditionProfileCount, int startLine, int startColumn, int endLine, int endColumn, byte[] outputCanQuicken, byte[] variableShouldUnbox, int[][] generalizeInputsMap, int[][] generalizeVarsMap) {
        this.name = name;
        this.qualname = qualname != null ? qualname : name;
        this.argCount = argCount;
        this.kwOnlyArgCount = kwOnlyArgCount;
        this.positionalOnlyArgCount = positionalOnlyArgCount;
        this.stacksize = stacksize;
        this.code = code;
        this.srcOffsetTable = linetable;
        this.flags = flags;
        this.names = names;
        this.varnames = varnames;
        this.cellvars = cellvars;
        this.freevars = freevars;
        this.cell2arg = cell2arg;
        int[] arg2cellValue = null;
        if (cell2arg != null) {
            arg2cellValue = new int[this.getTotalArgCount()];
            Arrays.fill(arg2cellValue, -1);
            for (int i = 0; i < cell2arg.length; ++i) {
                if (cell2arg[i] < 0) continue;
                arg2cellValue[cell2arg[i]] = i;
            }
        }
        this.arg2cell = arg2cellValue;
        this.constants = constants;
        this.primitiveConstants = primitiveConstants;
        this.exceptionHandlerRanges = exceptionHandlerRanges;
        this.conditionProfileCount = conditionProfileCount;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.outputCanQuicken = outputCanQuicken;
        this.variableShouldUnbox = variableShouldUnbox;
        this.generalizeInputsMap = generalizeInputsMap;
        this.generalizeVarsMap = generalizeVarsMap;
    }

    public SourceMap getSourceMap() {
        if (this.sourceMap == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.sourceMap = new SourceMap(this.code, this.srcOffsetTable, this.startLine, this.startColumn);
        }
        return this.sourceMap;
    }

    public int bciToLine(int bci) {
        if (bci < 0 || bci >= this.code.length) {
            return -1;
        }
        return this.getSourceMap().startLineMap[bci];
    }

    public int bciToColumn(int bci) {
        if (bci < 0 || bci >= this.code.length) {
            return -1;
        }
        return this.getSourceMap().startColumnMap[bci];
    }

    public SourceSection getSourceSection(Source source) {
        return SourceMap.getSourceSection(source, this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public boolean takesVarKeywordArgs() {
        return (this.flags & 8) != 0;
    }

    public boolean takesVarArgs() {
        return (this.flags & 4) != 0;
    }

    public boolean isGenerator() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isCoroutine() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isAsyncGenerator() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isGeneratorOrCoroutine() {
        return (this.flags & 0x3A0) != 0;
    }

    public int getRegularArgCount() {
        return this.argCount + this.positionalOnlyArgCount + this.kwOnlyArgCount;
    }

    public int getTotalArgCount() {
        int count = this.getRegularArgCount();
        if (this.takesVarArgs()) {
            ++count;
        }
        if (this.takesVarKeywordArgs()) {
            ++count;
        }
        return count;
    }

    public String toString() {
        return this.toString(this.code);
    }

    public String toString(byte[] bytecode) {
        StringBuilder sb = new StringBuilder();
        HashMap<Integer, String[]> lines = new HashMap<Integer, String[]>();
        sb.append("Disassembly of ").append(this.qualname).append(":\n");
        ArrayList<String> flagNames = new ArrayList<String>();
        if (this.isGenerator()) {
            flagNames.add("CO_GENERATOR");
        }
        if (this.isCoroutine()) {
            flagNames.add("CO_COROUTINE");
        }
        if (this.isAsyncGenerator()) {
            flagNames.add("CO_ASYNC_GENERATOR");
        }
        if (!flagNames.isEmpty()) {
            sb.append("Flags: ").append(String.join((CharSequence)" | ", flagNames)).append("\n");
        }
        int bci = 0;
        int oparg = 0;
        SourceMap map = this.getSourceMap();
        while (bci < bytecode.length) {
            int bcBCI = bci;
            OpCodes opcode = OpCodes.fromOpCode(bytecode[bci++]);
            String[] line = lines.computeIfAbsent(bcBCI, k -> new String[8]);
            line[0] = String.format("%3d:%-3d - %3d:%-3d", map.startLineMap[bcBCI], map.startColumnMap[bcBCI], map.endLineMap[bcBCI], map.endColumnMap[bcBCI]);
            if (line[1] == null) {
                line[1] = "";
            }
            line[2] = String.valueOf(bcBCI);
            line[3] = opcode.toString();
            byte[] followingArgs = PythonUtils.EMPTY_BYTE_ARRAY;
            if (!opcode.hasArg()) {
                line[4] = "";
            } else {
                oparg |= Byte.toUnsignedInt(bytecode[bci++]);
                if (opcode.argLength > 1) {
                    followingArgs = new byte[opcode.argLength - 1];
                    for (int i = 0; i < opcode.argLength - 1; ++i) {
                        followingArgs[i] = bytecode[bci++];
                    }
                }
                line[4] = String.format("% 2d", oparg);
            }
            block28: while (true) {
                switch (opcode) {
                    case EXTENDED_ARG: {
                        line[4] = "";
                        break block28;
                    }
                    case LOAD_BYTE: {
                        line[4] = String.format("% 2d", (byte)oparg);
                        break block28;
                    }
                    case LOAD_CONST: 
                    case LOAD_BIGINT: 
                    case LOAD_STRING: 
                    case LOAD_BYTES: 
                    case LOAD_CONST_COLLECTION: 
                    case MAKE_KEYWORD: {
                        Object constant = this.constants[oparg];
                        if (constant instanceof CodeUnit) {
                            line[5] = ((CodeUnit)constant).qualname.toJavaStringUncached();
                        } else if (constant instanceof TruffleString) {
                            line[5] = StringNodes.StringReprNode.getUncached().execute((TruffleString)constant).toJavaStringUncached();
                        } else if (constant instanceof byte[]) {
                            byte[] bytes = (byte[])constant;
                            line[5] = BytesUtils.bytesRepr(bytes, bytes.length);
                        } else {
                            line[5] = constant instanceof int[] ? Arrays.toString((int[])constant) : (constant instanceof long[] ? Arrays.toString((long[])constant) : (constant instanceof boolean[] ? Arrays.toString((boolean[])constant) : (constant instanceof double[] ? Arrays.toString((double[])constant) : (constant instanceof Object[] ? Arrays.toString((Object[])constant) : Objects.toString(constant)))));
                        }
                        if (opcode != OpCodes.LOAD_CONST_COLLECTION) break block28;
                        line[5] = line[5] + " type " + CodeUnit.collectionTypeToString(followingArgs[0]) + " into " + CodeUnit.collectionKindToString(followingArgs[0]);
                        break block28;
                    }
                    case MAKE_FUNCTION: {
                        line[4] = String.format("% 2d", followingArgs[0]);
                        CodeUnit codeUnit = (CodeUnit)this.constants[oparg];
                        line[5] = codeUnit.qualname.toJavaStringUncached();
                        break block28;
                    }
                    case LOAD_INT: 
                    case LOAD_LONG: {
                        line[5] = Objects.toString(this.primitiveConstants[oparg]);
                        break block28;
                    }
                    case LOAD_DOUBLE: {
                        line[5] = Objects.toString(Double.longBitsToDouble(this.primitiveConstants[oparg]));
                        break block28;
                    }
                    case LOAD_COMPLEX: {
                        double[] num = (double[])this.constants[oparg];
                        if (num[0] == 0.0) {
                            line[5] = String.format("%gj", num[1]);
                            break block28;
                        }
                        line[5] = String.format("%g%+gj", num[0], num[1]);
                        break block28;
                    }
                    case LOAD_CLOSURE: 
                    case LOAD_DEREF: 
                    case STORE_DEREF: 
                    case DELETE_DEREF: {
                        if (oparg >= this.cellvars.length) {
                            line[5] = this.freevars[oparg - this.cellvars.length].toJavaStringUncached();
                            break block28;
                        }
                        line[5] = this.cellvars[oparg].toJavaStringUncached();
                        break block28;
                    }
                    case LOAD_FAST: 
                    case STORE_FAST: 
                    case DELETE_FAST: {
                        line[5] = this.varnames[oparg].toJavaStringUncached();
                        break block28;
                    }
                    case LOAD_NAME: 
                    case LOAD_METHOD: 
                    case STORE_NAME: 
                    case DELETE_NAME: 
                    case IMPORT_NAME: 
                    case IMPORT_FROM: 
                    case LOAD_GLOBAL: 
                    case STORE_GLOBAL: 
                    case DELETE_GLOBAL: 
                    case LOAD_ATTR: 
                    case STORE_ATTR: 
                    case DELETE_ATTR: 
                    case CALL_METHOD_VARARGS: {
                        line[5] = this.names[oparg].toJavaStringUncached();
                        break block28;
                    }
                    case FORMAT_VALUE: {
                        int type = oparg & 3;
                        switch (type) {
                            case 1: {
                                line[5] = "STR";
                                break;
                            }
                            case 2: {
                                line[5] = "REPR";
                                break;
                            }
                            case 3: {
                                line[5] = "ASCII";
                                break;
                            }
                            case 0: {
                                line[5] = "NONE";
                            }
                        }
                        if ((oparg & 4) != 4) break block28;
                        line[5] = line[5] + " + SPEC";
                        break block28;
                    }
                    case CALL_METHOD: {
                        line[4] = String.format("% 2d", oparg);
                        break block28;
                    }
                    case UNARY_OP: {
                        line[5] = UnaryOps.values()[oparg].toString();
                        break block28;
                    }
                    case BINARY_OP: {
                        line[5] = BinaryOps.values()[oparg].toString();
                        break block28;
                    }
                    case COLLECTION_FROM_STACK: 
                    case COLLECTION_ADD_STACK: 
                    case COLLECTION_FROM_COLLECTION: 
                    case COLLECTION_ADD_COLLECTION: 
                    case ADD_TO_COLLECTION: {
                        line[4] = String.format("% 2d", OpCodes.CollectionBits.elementCount(oparg));
                        line[5] = CodeUnit.collectionKindToString(oparg);
                        break block28;
                    }
                    case UNPACK_EX: {
                        line[5] = String.format("%d, %d", oparg, Byte.toUnsignedInt(followingArgs[0]));
                        break block28;
                    }
                    case JUMP_BACKWARD: {
                        lines.computeIfAbsent(Integer.valueOf((int)(bcBCI - oparg)), (Function<Integer, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$toString$1(java.lang.Integer ), (Ljava/lang/Integer;)[Ljava/lang/String;)())[1] = ">>";
                        line[5] = String.format("to %d", bcBCI - oparg);
                        break block28;
                    }
                    case FOR_ITER: 
                    case JUMP_FORWARD: 
                    case POP_AND_JUMP_IF_FALSE: 
                    case POP_AND_JUMP_IF_TRUE: 
                    case JUMP_IF_FALSE_OR_POP: 
                    case JUMP_IF_TRUE_OR_POP: 
                    case MATCH_EXC_OR_JUMP: 
                    case SEND: {
                        lines.computeIfAbsent(Integer.valueOf((int)(bcBCI + oparg)), (Function<Integer, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$toString$2(java.lang.Integer ), (Ljava/lang/Integer;)[Ljava/lang/String;)())[1] = ">>";
                        line[5] = String.format("to %d", bcBCI + oparg);
                        break block28;
                    }
                    default: {
                        if (opcode.quickens == null) break block28;
                        opcode = opcode.quickens;
                        continue block28;
                    }
                }
                break;
            }
            if (opcode == OpCodes.EXTENDED_ARG) {
                oparg <<= 8;
                continue;
            }
            oparg = 0;
        }
        for (int i = 0; i < this.exceptionHandlerRanges.length; i += 4) {
            int start = this.exceptionHandlerRanges[i];
            int stop = this.exceptionHandlerRanges[i + 1];
            int handler = this.exceptionHandlerRanges[i + 2];
            int stackAtHandler = this.exceptionHandlerRanges[i + 3];
            String[] line = (String[])lines.get(handler);
            assert (line != null);
            String handlerStr = String.format("exc handler %d - %d; stack: %d", start, stop, stackAtHandler);
            line[6] = line[6] == null ? handlerStr : line[6] + " | " + handlerStr;
        }
        for (bci = 0; bci < bytecode.length; ++bci) {
            String[] line = (String[])lines.get(bci);
            if (line == null) continue;
            line[5] = line[5] == null ? "" : String.format("(%s)", line[5]);
            line[6] = line[6] == null ? "" : String.format("(%s)", line[6]);
            line[7] = "";
            if (this.outputCanQuicken != null && (this.outputCanQuicken[bci] != 0 || this.generalizeInputsMap[bci] != null)) {
                StringBuilder quickenSb = new StringBuilder();
                if (this.outputCanQuicken[bci] != 0) {
                    quickenSb.append("can quicken");
                }
                if (this.generalizeInputsMap[bci] != null) {
                    if (quickenSb.length() > 0) {
                        quickenSb.append(", ");
                    }
                    quickenSb.append("generalizes: ");
                    for (int i = 0; i < this.generalizeInputsMap[bci].length; ++i) {
                        if (i > 0) {
                            quickenSb.append(", ");
                        }
                        quickenSb.append(this.generalizeInputsMap[bci][i]);
                    }
                }
                line[7] = quickenSb.toString();
            }
            String formatted = String.format("%-8s %2s %4s %-32s %-3s   %-32s %s %s", line);
            sb.append(formatted.stripTrailing());
            sb.append('\n');
        }
        for (Object c : this.constants) {
            if (!(c instanceof CodeUnit)) continue;
            sb.append('\n');
            sb.append(c);
        }
        return sb.toString();
    }

    private static String collectionKindToString(int oparg) {
        switch (OpCodes.CollectionBits.collectionKind(oparg)) {
            case 32: {
                return "list";
            }
            case 64: {
                return "tuple";
            }
            case 96: {
                return "set";
            }
            case 128: {
                return "dict";
            }
            case 160: {
                return "PKeyword[]";
            }
            case 192: {
                return "Object[]";
            }
        }
        throw new IllegalStateException("Unknown kind");
    }

    private static String collectionTypeToString(int oparg) {
        switch (OpCodes.CollectionBits.elementType(oparg)) {
            case 3: {
                return "boolean";
            }
            case 1: {
                return "int";
            }
            case 2: {
                return "long";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "Object";
            }
        }
        throw new IllegalStateException("Unknown type");
    }

    public static void iterateBytecode(byte[] bytecode, BytecodeAction action) {
        OpCodes op;
        int oparg = 0;
        for (int bci = 0; bci < bytecode.length; bci += op.length()) {
            op = OpCodes.fromOpCode(bytecode[bci]);
            if (op == OpCodes.EXTENDED_ARG) {
                oparg |= Byte.toUnsignedInt(bytecode[bci + 1]);
                oparg <<= 8;
                continue;
            }
            byte[] followingArgs = null;
            if (op.argLength > 0) {
                oparg |= Byte.toUnsignedInt(bytecode[bci + 1]);
                if (op.argLength > 1) {
                    followingArgs = new byte[op.argLength - 1];
                    System.arraycopy(bytecode, bci + 2, followingArgs, 0, followingArgs.length);
                }
            }
            action.run(bci, op, oparg, followingArgs);
            oparg = 0;
        }
    }

    public void iterateBytecode(BytecodeAction action) {
        CodeUnit.iterateBytecode(this.code, action);
    }

    private static /* synthetic */ String[] lambda$toString$2(Integer k) {
        return new String[8];
    }

    private static /* synthetic */ String[] lambda$toString$1(Integer k) {
        return new String[8];
    }

    @FunctionalInterface
    public static interface BytecodeAction {
        public void run(int var1, OpCodes var2, int var3, byte[] var4);
    }
}

