/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.method.MethodWrapperBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MethodWrapper})
public final class MethodWrapperBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MethodWrapperBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString reprBuiltinMethod(VirtualFrame frame, PBuiltinMethod self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode getNameNode, @Cached.Shared @Cached TypeNodes.GetNameNode getTypeNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString typeName = getTypeNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self.getSelf()));
            return simpleTruffleStringFormatNode.format("<method-wrapper '%s' of %s object at 0x%s>", getNameNode.executeObject(frame, self.getFunction()), typeName, PythonAbstractObject.systemHashCodeAsHexString(self.getSelf()));
        }

        @Specialization
        static TruffleString reprBuiltinMethod(VirtualFrame frame, PMethod self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode getNameNode, @Cached.Shared @Cached TypeNodes.GetNameNode getTypeNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString typeName = getTypeNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self.getSelf()));
            return simpleTruffleStringFormatNode.format("<method-wrapper '%s' of %s object at 0x%s>", getNameNode.executeObject(frame, self.getFunction()), typeName, PythonAbstractObject.systemHashCodeAsHexString(self.getSelf()));
        }

        @NeverDefault
        protected static GetAttributeNode createGetAttributeNode() {
            return GetAttributeNode.create(SpecialAttributeNames.T___NAME__);
        }
    }

    @Builtin(name="__objclass__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ObjclassNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object objclass(PBuiltinMethod self) {
            return self.getBuiltinFunction().getEnclosingType();
        }
    }
}

