/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.memoryview;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.memoryview.BufferReference;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyMemoryViewFromObject;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMemoryView})
public final class MemoryViewBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MemoryViewBuiltinsFactory.getFactories();
    }

    @Builtin(name="contiguous", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ContiguousNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        boolean get(PMemoryView self) {
            self.checkReleased(this);
            return self.isCContiguous() || self.isFortranContiguous();
        }
    }

    @Builtin(name="f_contiguous", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class FContiguousNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        boolean get(PMemoryView self) {
            self.checkReleased(this);
            return self.isFortranContiguous();
        }
    }

    @Builtin(name="c_contiguous", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class CContiguousNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        boolean get(PMemoryView self) {
            self.checkReleased(this);
            return self.isCContiguous();
        }
    }

    @Builtin(name="ndim", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class NDimNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int get(PMemoryView self) {
            self.checkReleased(this);
            return self.getDimensions();
        }
    }

    @Builtin(name="readonly", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ReadonlyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        boolean get(PMemoryView self) {
            self.checkReleased(this);
            return self.isReadOnly();
        }
    }

    @Builtin(name="suboffsets", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class SuboffsetsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object get(PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile nullProfile) {
            self.checkReleased(this);
            if (nullProfile.profile(inliningTarget, self.getBufferSuboffsets() == null)) {
                return this.factory().createEmptyTuple();
            }
            return this.factory().createTuple(new IntSequenceStorage(self.getBufferSuboffsets()));
        }
    }

    @Builtin(name="strides", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class StridesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object get(PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile nullProfile) {
            self.checkReleased(this);
            if (nullProfile.profile(inliningTarget, self.getBufferStrides() == null)) {
                return this.factory().createEmptyTuple();
            }
            return this.factory().createTuple(new IntSequenceStorage(self.getBufferStrides()));
        }
    }

    @Builtin(name="shape", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ShapeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object get(PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile nullProfile) {
            self.checkReleased(this);
            if (nullProfile.profile(inliningTarget, self.getBufferShape() == null)) {
                return this.factory().createEmptyTuple();
            }
            return this.factory().createTuple(new IntSequenceStorage(self.getBufferShape()));
        }
    }

    @Builtin(name="format", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class FormatNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object get(PMemoryView self) {
            self.checkReleased(this);
            return self.getFormatString() != null ? self.getFormatString() : BufferFormat.T_UINT_8_TYPE_CODE;
        }
    }

    @Builtin(name="obj", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ObjNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object get(PMemoryView self) {
            self.checkReleased(this);
            return self.getOwner() != null ? self.getOwner() : PNone.NONE;
        }
    }

    @Builtin(name="nbytes", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class NBytesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int get(PMemoryView self) {
            self.checkReleased(this);
            return self.getLength();
        }
    }

    @Builtin(name="itemsize", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ItemSizeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int get(PMemoryView self) {
            self.checkReleased(this);
            return self.getItemSize();
        }
    }

    @Builtin(name="release", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReleaseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object release(VirtualFrame frame, PMemoryView self, @Cached MemoryViewNodes.ReleaseNode releaseNode) {
            releaseNode.execute(frame, self);
            return PNone.NONE;
        }
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    public static abstract class ExitNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization
        static Object exit(VirtualFrame frame, PMemoryView self, Object type, Object val, Object tb, @Cached MemoryViewNodes.ReleaseNode releaseNode) {
            releaseNode.execute(frame, self);
            return PNone.NONE;
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class EnterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object enter(PMemoryView self) {
            self.checkReleased(this);
            return self;
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int hash(PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile cachedProfile, @Cached InlinedConditionProfile writableProfile, @Cached MemoryViewNodes.ToJavaBytesNode toJavaBytesNode) {
            if (cachedProfile.profile(inliningTarget, self.getCachedHash() != -1)) {
                return self.getCachedHash();
            }
            self.checkReleased(this);
            if (writableProfile.profile(inliningTarget, !self.isReadOnly())) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_HASH_WRITEABLE_MEMORYVIEW);
            }
            int hash = HashNode.hashArray(toJavaBytesNode.execute(self));
            self.setCachedHash(hash);
            return hash;
        }

        @CompilerDirectives.TruffleBoundary
        private static int hashArray(byte[] array) {
            return Arrays.hashCode(array);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(PMemoryView self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            if (self.isReleased()) {
                return simpleTruffleStringFormatNode.format("<released memory at 0x%s>", PythonAbstractObject.systemHashCodeAsHexString(self));
            }
            return simpleTruffleStringFormatNode.format("<memory at 0x%s>", PythonAbstractObject.systemHashCodeAsHexString(self));
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int len(PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile zeroDimProfile) {
            self.checkReleased(this);
            return zeroDimProfile.profile(inliningTarget, self.getDimensions() == 0) ? 1 : self.getBufferShape()[0];
        }
    }

    @Builtin(name="cast", minNumOfPositionalArgs=2, parameterNames={"$self", "format", "shape"})
    @ArgumentClinic(name="format", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class CastNode
    extends PythonTernaryClinicBuiltinNode {
        @Specialization
        PMemoryView cast(PMemoryView self, TruffleString formatString, PNone none, @Cached.Shared @Cached TruffleString.CodePointLengthNode lengthNode, @Cached.Shared @Cached TruffleString.CodePointAtIndexNode atIndexNode) {
            self.checkReleased(this);
            return this.doCast(self, formatString, 1, null, PythonContext.get(this), lengthNode, atIndexNode);
        }

        @Specialization(guards={"isPTuple(shapeObj) || isList(shapeObj)"})
        PMemoryView cast(VirtualFrame frame, PMemoryView self, TruffleString formatString, Object shapeObj, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode lengthNode, @Cached.Shared @Cached TruffleString.CodePointAtIndexNode atIndexNode) {
            self.checkReleased(this);
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, shapeObj);
            int ndim = storage.length();
            int[] shape = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                shape[i] = asSizeNode.executeExact((Frame)frame, inliningTarget, getItemScalarNode.execute(inliningTarget, storage, i));
                if (shape[i] > 0) continue;
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_CAST_ELEMENTS_MUST_BE_POSITIVE_INTEGERS);
            }
            return this.doCast(self, formatString, ndim, shape, PythonContext.get(this), lengthNode, atIndexNode);
        }

        @Specialization(guards={"!isPTuple(shape)", "!isList(shape)", "!isPNone(shape)"})
        PMemoryView error(PMemoryView self, TruffleString format, Object shape) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_S_MUST_BE_A_LIST_OR_TUPLE, "shape");
        }

        private PMemoryView doCast(PMemoryView self, TruffleString formatString, int ndim, int[] shape, PythonContext context, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
            int[] newStrides;
            int[] newShape;
            if (!self.isCContiguous()) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_CASTS_RESTRICTED_TO_C_CONTIGUOUS);
            }
            BufferFormat format = BufferFormat.forMemoryView(formatString, lengthNode, atIndexNode);
            int itemsize = format.bytesize;
            if (itemsize < 0) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.MEMORYVIEW_DESTINATION_FORMAT_ERROR);
            }
            if (!MemoryViewNodes.isByteFormat(format) && !MemoryViewNodes.isByteFormat(self.getFormat())) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_CANNOT_CAST_NON_BYTE);
            }
            if (self.getLength() % itemsize != 0) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_LENGTH_NOT_MULTIPLE_OF_ITEMSIZE);
            }
            if (shape != null || self.getDimensions() != 1) {
                for (int i = 0; i < self.getDimensions(); ++i) {
                    if (self.getBufferShape()[i] != 0) continue;
                    throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_CANNOT_CAST_VIEW_WITH_ZEROS_IN_SHAPE_OR_STRIDES);
                }
            }
            int flags = 2;
            if (ndim == 0) {
                newShape = null;
                newStrides = null;
                flags |= 8;
                if (self.getLength() != itemsize) {
                    throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_CAST_WRONG_LENGTH);
                }
            } else {
                if (shape == null) {
                    newShape = new int[]{self.getLength() / itemsize};
                } else {
                    if (ndim != 1 && self.getDimensions() != 1) {
                        throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_CAST_MUST_BE_1D_TO_ND_OR_ND_TO_1D);
                    }
                    if (ndim > 64) {
                        throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.MEMORYVIEW_NUMBER_OF_DIMENSIONS_MUST_NOT_EXCEED_D, ndim);
                    }
                    int newLength = itemsize;
                    for (int i = 0; i < ndim; ++i) {
                        newLength *= shape[i];
                    }
                    if (newLength != self.getLength()) {
                        throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_CAST_WRONG_LENGTH);
                    }
                    newShape = shape;
                }
                newStrides = PMemoryView.initStridesFromShape(ndim, itemsize, shape);
            }
            return this.factory().createMemoryView(context, self.getLifecycleManager(), self.getBuffer(), self.getOwner(), self.getLength(), self.isReadOnly(), itemsize, format, formatString, ndim, self.getBufferPointer(), self.getOffset(), newShape, newStrides, null, flags);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MemoryViewBuiltinsClinicProviders.CastNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="toreadonly", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ToReadonlyNode
    extends PythonUnaryBuiltinNode {
        public final Object call(VirtualFrame frame, Object arg) {
            return this.execute(frame, arg);
        }

        @Specialization
        PMemoryView toreadonly(PMemoryView self) {
            self.checkReleased(this);
            return this.factory().createMemoryView(PythonContext.get(this), self.getLifecycleManager(), self.getBuffer(), self.getOwner(), self.getLength(), true, self.getItemSize(), self.getFormat(), self.getFormatString(), self.getDimensions(), self.getBufferPointer(), self.getOffset(), self.getBufferShape(), self.getBufferStrides(), self.getBufferSuboffsets(), self.getFlags());
        }
    }

    @Builtin(name="hex", minNumOfPositionalArgs=1, parameterNames={"$self", "sep", "bytes_per_sep"})
    @ArgumentsClinic(value={@ArgumentClinic(name="sep", conversionClass=BytesBuiltins.SepExpectByteNode.class, defaultValue="PNone.NO_VALUE"), @ArgumentClinic(name="bytes_per_sep", conversionClass=BytesBuiltins.ExpectIntNode.class, defaultValue="1")})
    @GenerateNodeFactory
    static abstract class HexNode
    extends PythonTernaryClinicBuiltinNode {
        HexNode() {
        }

        @Specialization
        TruffleString none(PMemoryView self, PNone sep, int bytesPerSepGroup, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="p") @Cached InlinedConditionProfile earlyExit, @Cached.Shared(value="b") @Cached MemoryViewNodes.ToJavaBytesNode toJavaBytesNode, @Cached.Shared(value="h") @Cached BytesNodes.ByteToHexNode toHexNode) {
            return this.hex(self, (byte)0, 0, inliningTarget, earlyExit, toJavaBytesNode, toHexNode);
        }

        @Specialization
        TruffleString hex(PMemoryView self, byte sep, int bytesPerSepGroup, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="p") @Cached InlinedConditionProfile earlyExit, @Cached.Shared(value="b") @Cached MemoryViewNodes.ToJavaBytesNode toJavaBytesNode, @Cached.Shared(value="h") @Cached BytesNodes.ByteToHexNode toHexNode) {
            self.checkReleased(this);
            if (earlyExit.profile(inliningTarget, self.getLength() == 0)) {
                return StringLiterals.T_EMPTY_STRING;
            }
            byte[] b = toJavaBytesNode.execute(self);
            return toHexNode.execute(b, b.length, sep, bytesPerSepGroup);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MemoryViewBuiltinsClinicProviders.HexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="tobytes", minNumOfPositionalArgs=1, parameterNames={"$self", "order"})
    @ArgumentClinic(name="order", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_C", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class ToBytesNode
    extends PythonBinaryClinicBuiltinNode {
        static final TruffleString T_A = PythonUtils.tsLiteral("A");
        static final TruffleString T_C = PythonUtils.tsLiteral("C");
        static final TruffleString T_F = PythonUtils.tsLiteral("F");
        @Node.Child
        private MemoryViewNodes.ToJavaBytesNode toJavaBytesNode;
        @Node.Child
        private MemoryViewNodes.ToJavaBytesFortranOrderNode toJavaBytesFortranOrderNode;

        @Specialization
        PBytes tobytes(PMemoryView self, TruffleString order, @Cached TruffleString.EqualNode equalNode) {
            byte[] bytes;
            self.checkReleased(this);
            if (equalNode.execute((AbstractTruffleString)order, (AbstractTruffleString)T_C, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)order, (AbstractTruffleString)T_A, PythonUtils.TS_ENCODING)) {
                bytes = this.getToJavaBytesNode().execute(self);
            } else if (equalNode.execute((AbstractTruffleString)order, (AbstractTruffleString)T_F, PythonUtils.TS_ENCODING)) {
                bytes = this.getToJavaBytesFortranOrderNode().execute(self);
            } else {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.ORDER_MUST_BE_C_F_OR_A);
            }
            return this.factory().createBytes(bytes);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MemoryViewBuiltinsClinicProviders.ToBytesNodeClinicProviderGen.INSTANCE;
        }

        private MemoryViewNodes.ToJavaBytesNode getToJavaBytesNode() {
            if (this.toJavaBytesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toJavaBytesNode = (MemoryViewNodes.ToJavaBytesNode)this.insert(MemoryViewNodes.ToJavaBytesNode.create());
            }
            return this.toJavaBytesNode;
        }

        private MemoryViewNodes.ToJavaBytesFortranOrderNode getToJavaBytesFortranOrderNode() {
            if (this.toJavaBytesFortranOrderNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toJavaBytesFortranOrderNode = (MemoryViewNodes.ToJavaBytesFortranOrderNode)this.insert(MemoryViewNodes.ToJavaBytesFortranOrderNode.create());
            }
            return this.toJavaBytesFortranOrderNode;
        }
    }

    @Builtin(name="tolist", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ToListNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        private CExtNodes.PCallCapiFunction callCapiFunction;

        @Specialization(guards={"self.getDimensions() == cachedDimensions", "cachedDimensions < 8"}, limit="3")
        Object tolistCached(VirtualFrame frame, PMemoryView self, @Cached(value="self.getDimensions()") int cachedDimensions, @Cached.Shared @Cached MemoryViewNodes.ReadItemAtNode readItemAtNode) {
            self.checkReleased(this);
            if (cachedDimensions == 0) {
                return readItemAtNode.execute(frame, self, self.getBufferPointer(), self.getOffset());
            }
            return this.recursive(frame, self, readItemAtNode, 0, cachedDimensions, self.getBufferPointer(), self.getOffset());
        }

        @Specialization(replaces={"tolistCached"})
        Object tolist(VirtualFrame frame, PMemoryView self, @Cached.Shared @Cached MemoryViewNodes.ReadItemAtNode readItemAtNode) {
            self.checkReleased(this);
            if (self.getDimensions() == 0) {
                return readItemAtNode.execute(frame, self, self.getBufferPointer(), self.getOffset());
            }
            return this.recursiveBoundary(frame, self, readItemAtNode, 0, self.getDimensions(), self.getBufferPointer(), self.getOffset());
        }

        private PList recursiveBoundary(VirtualFrame frame, PMemoryView self, MemoryViewNodes.ReadItemAtNode readItemAtNode, int dim, int ndim, Object ptr, int offset) {
            return this.recursive(frame, self, readItemAtNode, dim, ndim, ptr, offset);
        }

        private PList recursive(VirtualFrame frame, PMemoryView self, MemoryViewNodes.ReadItemAtNode readItemAtNode, int dim, int ndim, Object ptr, int initialOffset) {
            int offset = initialOffset;
            Object[] objects = new Object[self.getBufferShape()[dim]];
            for (int i = 0; i < self.getBufferShape()[dim]; ++i) {
                Object xptr = ptr;
                int xoffset = offset;
                if (self.getBufferSuboffsets() != null && self.getBufferSuboffsets()[dim] >= 0) {
                    xptr = this.getCallCapiFunction().call(NativeCAPISymbol.FUN_TRUFFLE_ADD_SUBOFFSET, ptr, offset, self.getBufferSuboffsets()[dim]);
                    xoffset = 0;
                }
                objects[i] = dim == ndim - 1 ? readItemAtNode.execute(frame, self, xptr, xoffset) : this.recursive(frame, self, readItemAtNode, dim + 1, ndim, xptr, xoffset);
                offset += self.getBufferStrides()[dim];
            }
            return this.factory().createList(objects);
        }

        private CExtNodes.PCallCapiFunction getCallCapiFunction() {
            if (this.callCapiFunction == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callCapiFunction = (CExtNodes.PCallCapiFunction)this.insert(CExtNodes.PCallCapiFunction.create());
            }
            return this.callCapiFunction;
        }
    }

    @Builtin(name="__delitem__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DelItemNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object error(PMemoryView self) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_DELETE_MEMORY);
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private CExtNodes.PCallCapiFunction callCapiFunction;

        @Specialization
        boolean eq(VirtualFrame frame, PMemoryView self, PMemoryView other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared @Cached MemoryViewNodes.ReadItemAtNode readSelf, @Cached.Shared @Cached MemoryViewNodes.ReadItemAtNode readOther) {
            if (self.isReleased() || other.isReleased()) {
                return self == other;
            }
            int ndim = self.getDimensions();
            if (ndim != other.getDimensions()) {
                return false;
            }
            for (int i = 0; i < ndim; ++i) {
                if (self.getBufferShape()[i] != other.getBufferShape()[i]) {
                    return false;
                }
                if (self.getBufferShape()[i] == 0) break;
            }
            if (ndim == 0) {
                Object selfItem = readSelf.execute(frame, self, self.getBufferPointer(), 0);
                Object otherItem = readOther.execute(frame, other, other.getBufferPointer(), 0);
                return eqNode.compare((Frame)frame, inliningTarget, selfItem, otherItem);
            }
            return this.recursive(frame, inliningTarget, eqNode, self, other, readSelf, readOther, 0, ndim, self.getBufferPointer(), self.getOffset(), other.getBufferPointer(), other.getOffset());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isMemoryView(other)"})
        Object eq(VirtualFrame frame, PMemoryView self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyMemoryViewFromObject memoryViewNode, @Cached MemoryViewNodes.ReleaseNode releaseNode, @Cached.Shared @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared @Cached MemoryViewNodes.ReadItemAtNode readSelf, @Cached.Shared @Cached MemoryViewNodes.ReadItemAtNode readOther) {
            PMemoryView memoryView;
            try {
                memoryView = memoryViewNode.execute(frame, other);
            }
            catch (PException e) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            try {
                Boolean bl = this.eq(frame, self, memoryView, inliningTarget, eqNode, readSelf, readOther);
                return bl;
            }
            finally {
                releaseNode.execute(frame, memoryView);
            }
        }

        @Fallback
        static Object eq(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        private boolean recursive(VirtualFrame frame, Node inliningTarget, PyObjectRichCompareBool.EqNode eqNode, PMemoryView self, PMemoryView other, MemoryViewNodes.ReadItemAtNode readSelf, MemoryViewNodes.ReadItemAtNode readOther, int dim, int ndim, Object selfPtr, int initialSelfOffset, Object otherPtr, int initialOtherOffset) {
            int selfOffset = initialSelfOffset;
            int otherOffset = initialOtherOffset;
            for (int i = 0; i < self.getBufferShape()[dim]; ++i) {
                Object otherItem;
                Object selfItem;
                Object selfXPtr = selfPtr;
                int selfXOffset = selfOffset;
                Object otherXPtr = otherPtr;
                int otherXOffset = otherOffset;
                if (self.getBufferSuboffsets() != null && self.getBufferSuboffsets()[dim] >= 0) {
                    selfXPtr = this.getCallCapiFunction().call(NativeCAPISymbol.FUN_TRUFFLE_ADD_SUBOFFSET, selfPtr, selfOffset, self.getBufferSuboffsets()[dim]);
                    selfXOffset = 0;
                }
                if (other.getBufferSuboffsets() != null && other.getBufferSuboffsets()[dim] >= 0) {
                    otherXPtr = this.getCallCapiFunction().call(NativeCAPISymbol.FUN_TRUFFLE_ADD_SUBOFFSET, otherPtr, otherOffset, other.getBufferSuboffsets()[dim]);
                    otherXOffset = 0;
                }
                if (dim == ndim - 1 ? !eqNode.compare((Frame)frame, inliningTarget, selfItem = readSelf.execute(frame, self, selfXPtr, selfXOffset), otherItem = readOther.execute(frame, other, otherXPtr, otherXOffset)) : !this.recursive(frame, inliningTarget, eqNode, self, other, readSelf, readOther, dim + 1, ndim, selfXPtr, selfXOffset, otherXPtr, otherXOffset)) {
                    return false;
                }
                selfOffset += self.getBufferStrides()[dim];
                otherOffset += other.getBufferStrides()[dim];
            }
            return true;
        }

        private CExtNodes.PCallCapiFunction getCallCapiFunction() {
            if (this.callCapiFunction == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callCapiFunction = (CExtNodes.PCallCapiFunction)this.insert(CExtNodes.PCallCapiFunction.create());
            }
            return this.callCapiFunction;
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SetItemNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"!isPSlice(index)", "!isEllipsis(index)"})
        Object setitem(VirtualFrame frame, PMemoryView self, Object index, Object object, @Cached.Shared @Cached MemoryViewNodes.PointerLookupNode pointerLookupNode, @Cached.Shared @Cached MemoryViewNodes.WriteItemAtNode writeItemAtNode) {
            self.checkReleased(this);
            this.checkReadonly(self);
            MemoryViewNodes.MemoryPointer ptr = pointerLookupNode.execute(frame, self, index);
            writeItemAtNode.execute(frame, self, ptr.ptr, ptr.offset, object);
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object setitem(VirtualFrame frame, PMemoryView self, PSlice slice, Object object, @Bind(value="this") Node inliningTarget, @Cached GetItemNode getItemNode, @Cached PyMemoryViewFromObject createMemoryView, @Cached MemoryViewNodes.ReleaseNode releaseNode, @Cached.Shared @Cached MemoryViewNodes.PointerLookupNode pointerLookupNode, @Cached MemoryViewNodes.ToJavaBytesNode toJavaBytesNode, @Cached MemoryViewNodes.WriteBytesAtNode writeBytesAtNode) {
            self.checkReleased(this);
            this.checkReadonly(self);
            if (self.getDimensions() != 1) {
                throw this.raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.MEMORYVIEW_SLICE_ASSIGNMENT_RESTRICTED_TO_DIM_1);
            }
            PMemoryView srcView = createMemoryView.execute(frame, object);
            try {
                PMemoryView destView = (PMemoryView)getItemNode.execute(frame, self, slice);
                try {
                    if (srcView.getDimensions() != destView.getDimensions() || srcView.getBufferShape()[0] != destView.getBufferShape()[0] || srcView.getFormat() != destView.getFormat()) {
                        throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.MEMORYVIEW_DIFFERENT_STRUCTURES);
                    }
                    byte[] srcBytes = toJavaBytesNode.execute(srcView);
                    int itemsize = srcView.getItemSize();
                    for (int i = 0; i < destView.getBufferShape()[0]; ++i) {
                        MemoryViewNodes.MemoryPointer destPtr = pointerLookupNode.execute(frame, destView, i);
                        writeBytesAtNode.execute(inliningTarget, srcBytes, i * itemsize, itemsize, self, destPtr.ptr, destPtr.offset);
                    }
                    PNone pNone = PNone.NONE;
                    releaseNode.execute(frame, destView);
                    return pNone;
                }
                catch (Throwable throwable) {
                    releaseNode.execute(frame, destView);
                    throw throwable;
                }
            }
            finally {
                releaseNode.execute(frame, srcView);
            }
        }

        @Specialization
        Object setitem(VirtualFrame frame, PMemoryView self, PEllipsis ellipsis, Object object, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile zeroDimProfile, @Cached.Shared @Cached MemoryViewNodes.WriteItemAtNode writeItemAtNode) {
            self.checkReleased(this);
            this.checkReadonly(self);
            if (zeroDimProfile.profile(inliningTarget, self.getDimensions() == 0)) {
                writeItemAtNode.execute(frame, self, self.getBufferPointer(), 0, object);
                return PNone.NONE;
            }
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_INDEXING_OF_0_DIM_MEMORY);
        }

        private void checkReadonly(PMemoryView self) {
            if (self.isReadOnly()) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_MODIFY_READONLY_MEMORY);
            }
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetItemNode
    extends PythonBinaryBuiltinNode {
        GetItemNode() {
        }

        @Specialization(guards={"!isPSlice(index)", "!isEllipsis(index)"})
        Object getitem(VirtualFrame frame, PMemoryView self, Object index, @Cached MemoryViewNodes.PointerLookupNode pointerFromIndexNode, @Cached MemoryViewNodes.ReadItemAtNode readItemAtNode) {
            self.checkReleased(this);
            MemoryViewNodes.MemoryPointer ptr = pointerFromIndexNode.execute(frame, self, index);
            return readItemAtNode.execute(frame, self, ptr.ptr, ptr.offset);
        }

        @Specialization
        Object getitemSlice(PMemoryView self, PSlice slice, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile zeroDimProfile, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached MemoryViewNodes.InitFlagsNode initFlagsNode) {
            self.checkReleased(this);
            if (zeroDimProfile.profile(inliningTarget, self.getDimensions() == 0)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_INDEXING_OF_0_DIM_MEMORY);
            }
            int[] shape = self.getBufferShape();
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, shape[0], sliceUnpack.execute(inliningTarget, slice));
            int[] strides = self.getBufferStrides();
            int[] newStrides = new int[strides.length];
            newStrides[0] = strides[0] * sliceInfo.step;
            PythonUtils.arraycopy(strides, 1, newStrides, 1, strides.length - 1);
            int[] newShape = new int[shape.length];
            newShape[0] = sliceInfo.sliceLength;
            PythonUtils.arraycopy(shape, 1, newShape, 1, shape.length - 1);
            int[] suboffsets = self.getBufferSuboffsets();
            int length = self.getLength() - (shape[0] - newShape[0]) * self.getItemSize();
            int flags = initFlagsNode.execute(inliningTarget, self.getDimensions(), self.getItemSize(), newShape, newStrides, suboffsets);
            return this.factory().createMemoryView(PythonContext.get(this), self.getLifecycleManager(), self.getBuffer(), self.getOwner(), length, self.isReadOnly(), self.getItemSize(), self.getFormat(), self.getFormatString(), self.getDimensions(), self.getBufferPointer(), self.getOffset() + sliceInfo.start * strides[0], newShape, newStrides, suboffsets, flags);
        }

        @Specialization
        Object getitemEllipsis(PMemoryView self, PEllipsis ellipsis, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile zeroDimProfile) {
            self.checkReleased(this);
            if (zeroDimProfile.profile(inliningTarget, self.getDimensions() == 0)) {
                return self;
            }
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_INVALID_SLICE_KEY);
        }
    }

    static class NativeBufferReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final BufferReference reference;

        public NativeBufferReleaseCallback(BufferReference reference) {
            this.reference = reference;
        }

        @Override
        public void execute(PythonContext context) {
            if (this.reference.isReleased()) {
                return;
            }
            MemoryViewNodes.ReleaseBufferNode.executeUncached(this.reference.getLifecycleManager());
        }
    }
}

