/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.CompressBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PCompress;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCompress})
public final class CompressBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CompressBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(PCompress self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = this.factory().createTuple(new Object[]{self.getData(), self.getSelectors()});
            return this.factory().createTuple(new Object[]{type, tuple});
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object next(VirtualFrame frame, PCompress self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached PyObjectIsTrueNode isTrue, @Cached InlinedLoopConditionProfile loopConditionProfile) {
            Object nextItem;
            Object nextSelector;
            do {
                nextItem = nextNode.execute(frame, self.getData(), PNone.NO_VALUE);
            } while (loopConditionProfile.profile(inliningTarget, !isTrue.execute((Frame)frame, inliningTarget, nextSelector = nextNode.execute(frame, self.getSelectors(), PNone.NO_VALUE))));
            return nextItem;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PCompress self) {
            return self;
        }
    }
}

