/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.floats;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyFloatCheckNode;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallVarargsNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.formatting.FormattingUtils;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteOrder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFloat})
public final class FloatBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FloatBuiltinsFactory.getFactories();
    }

    public static double asDouble(boolean right) {
        return right ? 1.0 : 0.0;
    }

    private static double castToDoubleChecked(Node inliningTarget, Object obj, CastToJavaDoubleNode cast) {
        try {
            return cast.execute(inliningTarget, obj);
        }
        catch (CannotCastException e) {
            throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_REQUIRES_S_OBJ_RECEIVED_P, "float", obj);
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetNewArgsNode
    extends AbstractNumericUnaryBuiltin {
        GetNewArgsNode() {
        }

        @Override
        protected Object op(double self) {
            return this.factory().createTuple(new Object[]{this.factory().createFloat(self)});
        }
    }

    @Builtin(name="is_integer", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsIntegerNode
    extends AbstractNumericUnaryBuiltin {
        IsIntegerNode() {
        }

        @Override
        protected Object op(double value) {
            return Double.isFinite(value) && (double)((long)value) == value;
        }
    }

    @Builtin(name="__getformat__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class GetFormatNode
    extends PythonBinaryBuiltinNode {
        private static final TruffleString T_FLOAT = PythonUtils.tsLiteral("float");
        private static final TruffleString T_DOUBLE = PythonUtils.tsLiteral("double");
        private static final TruffleString T_UNKNOWN = PythonUtils.tsLiteral("unknown");
        private static final TruffleString T_IEEE_LITTLE = PythonUtils.tsLiteral("IEEE, little-endian");
        private static final TruffleString T_IEEE_BIG = PythonUtils.tsLiteral("IEEE, big-endian");

        GetFormatNode() {
        }

        private static TruffleString getDetectedEndianess() {
            try {
                ByteOrder byteOrder = ByteOrder.nativeOrder();
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return T_IEEE_BIG;
                }
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return T_IEEE_LITTLE;
                }
            }
            catch (Error error) {
                // empty catch block
            }
            return T_UNKNOWN;
        }

        protected boolean isValidTypeStr(TruffleString typeStr, TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)typeStr, (AbstractTruffleString)T_FLOAT, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)typeStr, (AbstractTruffleString)T_DOUBLE, PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"isValidTypeStr(typeStr, equalNode)"}, limit="1")
        static TruffleString getFormat(Object cls, TruffleString typeStr, @Cached TruffleString.EqualNode equalNode) {
            return GetFormatNode.getDetectedEndianess();
        }

        @Fallback
        TruffleString getFormat(Object cls, Object typeStr) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.ARG_D_MUST_BE_S_OR_S, "__getformat__()", 1, "double", "float");
        }
    }

    @Builtin(name="conjugate", minNumOfPositionalArgs=1, doc="Returns self, the complex conjugate of any float.")
    @GenerateNodeFactory
    static abstract class ConjugateNode
    extends FloatNode {
        ConjugateNode() {
        }
    }

    @Builtin(name="as_integer_ratio", parameterNames={"x"})
    @GenerateNodeFactory
    static abstract class AsIntegerRatio
    extends PythonUnaryBuiltinNode {
        AsIntegerRatio() {
        }

        @Specialization
        PTuple get(Object selfObj, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached InlinedConditionProfile nanProfile, @Cached InlinedConditionProfile infProfile) {
            double self = FloatBuiltins.castToDoubleChecked(inliningTarget, selfObj, cast);
            if (nanProfile.profile(inliningTarget, Double.isNaN(self))) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_CONVERT_S_TO_INT_RATIO, "NaN");
            }
            if (infProfile.profile(inliningTarget, Double.isInfinite(self))) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.CANNOT_CONVERT_S_TO_INT_RATIO, "Infinity");
            }
            int exponent = 0;
            double mantissa = 0.0;
            if (self != 0.0 && self != -0.0) {
                boolean neg = false;
                mantissa = self;
                if (mantissa < 0.0) {
                    mantissa = -mantissa;
                    neg = true;
                }
                if (mantissa >= 1.0) {
                    while (mantissa >= 1.0) {
                        ++exponent;
                        mantissa /= 2.0;
                    }
                } else if (mantissa < 0.5) {
                    while (mantissa < 0.5) {
                        --exponent;
                        mantissa *= 2.0;
                    }
                }
                if (neg) {
                    mantissa = -mantissa;
                }
            }
            return this.factory().createTuple(this.countIt(mantissa, exponent));
        }

        @CompilerDirectives.TruffleBoundary
        private Object[] countIt(double manitssa, int exponent) {
            double m = manitssa;
            int e = exponent;
            for (int i = 0; i < 300 && Double.compare(m, Math.floor(m)) != 0; ++i) {
                m *= 2.0;
                --e;
            }
            BigInteger numerator = BigInteger.valueOf(Double.valueOf(m).longValue());
            BigInteger denominator = BigInteger.ONE;
            BigInteger py_exponent = denominator.shiftLeft(Math.abs(e));
            if (e > 0) {
                numerator = numerator.multiply(py_exponent);
            } else {
                denominator = py_exponent;
            }
            if (numerator.bitLength() < 64 && denominator.bitLength() < 64) {
                return new Object[]{numerator.longValue(), denominator.longValue()};
            }
            return new Object[]{this.factory().createInt(numerator), this.factory().createInt(denominator)};
        }
    }

    @Builtin(name="imag", minNumOfPositionalArgs=1, isGetter=true, doc="the imaginary part of a complex number")
    @GenerateNodeFactory
    static abstract class ImagNode
    extends PythonUnaryBuiltinNode {
        ImagNode() {
        }

        @Specialization
        static double get(Object self) {
            return 0.0;
        }
    }

    @Builtin(name="real", minNumOfPositionalArgs=1, isGetter=true, doc="the real part of a complex number")
    @GenerateNodeFactory
    static abstract class RealNode
    extends FloatNode {
        RealNode() {
        }
    }

    @Builtin(name="__ceil__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class CeilNode
    extends PythonUnaryBuiltinNode {
        CeilNode() {
        }

        @Specialization
        static Object ceil(Object self, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, Math.ceil(FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast)));
        }
    }

    @Builtin(name="__floor__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class FloorNode
    extends PythonUnaryBuiltinNode {
        FloorNode() {
        }

        @Specialization
        static Object floor(Object self, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, Math.floor(FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast)));
        }
    }

    @Builtin(name="__neg__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class NegNode
    extends AbstractNumericUnaryBuiltin {
        NegNode() {
        }

        @Override
        protected Object op(double arg) {
            return -arg;
        }
    }

    @Builtin(name="__pos__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class PosNode
    extends FloatNode {
        PosNode() {
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GeNode
    extends AbstractComparisonNode {
        @Override
        protected boolean op(double a, double b) {
            return a >= b;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GtNode
    extends AbstractComparisonNode {
        @Override
        protected boolean op(double a, double b) {
            return a > b;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LeNode
    extends AbstractComparisonNode {
        @Override
        protected boolean op(double a, double b) {
            return a <= b;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LtNode
    extends AbstractComparisonNode {
        @Override
        protected boolean op(double a, double b) {
            return a < b;
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NeNode
    extends AbstractComparisonNode {
        NeNode() {
        }

        @Override
        protected boolean op(double a, double b) {
            return a != b;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends AbstractComparisonNode {
        @Override
        protected boolean op(double a, double b) {
            return a == b;
        }
    }

    @GenerateCached(value=false)
    public static abstract class AbstractComparisonNode
    extends PythonBinaryBuiltinNode {
        protected abstract boolean op(double var1, double var3);

        @Specialization
        boolean doDD(double a, double b) {
            return this.op(a, b);
        }

        @Specialization
        boolean doDI(double a, int b) {
            return this.op(a, b);
        }

        @Specialization(guards={"check.execute(inliningTarget, bObj)"}, replaces={"doDD"}, limit="1")
        boolean doOO(Object aObj, Object bObj, @Bind(value="this") Node inliningTarget, @Cached PyFloatCheckNode check, @Cached.Exclusive @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            double b = FloatBuiltins.castToDoubleChecked(inliningTarget, bObj, cast);
            return this.op(a, b);
        }

        @Specialization(replaces={"doDI"})
        boolean doOI(Object aObj, int b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            return this.op(a, b);
        }

        @Specialization
        boolean doOL(Object aObj, long b, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaDoubleNode cast, @Cached InlinedConditionProfile longFitsToDoubleProfile) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            return this.op(AbstractComparisonNode.compareDoubleToLong(inliningTarget, a, b, longFitsToDoubleProfile), 0.0);
        }

        @Specialization
        boolean doOPInt(Object aObj, PInt b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            return this.op(AbstractComparisonNode.compareDoubleToLargeInt(a, b), 0.0);
        }

        @Specialization
        boolean doOB(Object aObj, boolean b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            return this.op(a, b ? 1.0 : 0.0);
        }

        @Fallback
        static PNotImplemented fallback(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        public static double compareDoubleToLong(Node inliningTarget, double v, long w, InlinedConditionProfile wFitsInDoubleProfile) {
            if (wFitsInDoubleProfile.profile(inliningTarget, w > -281474976710656L && w < 0x1000000000000L)) {
                return v - (double)w;
            }
            return AbstractComparisonNode.compareUsingBigDecimal(v, PInt.longToBigInteger(w));
        }

        public static double compareDoubleToLargeInt(double v, PInt w) {
            int wsign;
            int vsign;
            if (!Double.isFinite(v)) {
                return v;
            }
            int n = v == 0.0 ? 0 : (vsign = v < 0.0 ? -1 : 1);
            int n2 = w.isZero() ? 0 : (wsign = w.isNegative() ? -1 : 1);
            if (vsign != wsign) {
                return vsign - wsign;
            }
            if (w.bitLength() <= 48) {
                return v - w.doubleValue();
            }
            return AbstractComparisonNode.compareUsingBigDecimal(v, w.getValue());
        }

        @CompilerDirectives.TruffleBoundary
        private static double compareUsingBigDecimal(double v, BigInteger w) {
            if (!Double.isFinite(v)) {
                return v;
            }
            return new BigDecimal(v).compareTo(new BigDecimal(w));
        }
    }

    @Builtin(name="__round__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RoundNode
    extends PythonBinaryBuiltinNode {
        RoundNode() {
        }

        @CompilerDirectives.TruffleBoundary
        private static double op(double x, int n) {
            float nlog2_10 = 3.3219f * (float)n;
            int b = Math.getExponent(x);
            if (nlog2_10 > (float)(52 - b)) {
                return x;
            }
            if (nlog2_10 < (float)(-(b + 2))) {
                return Math.copySign(0.0, x);
            }
            BigDecimal xx = new BigDecimal(x);
            BigDecimal rr = xx.setScale(n, RoundingMode.HALF_EVEN);
            return rr.doubleValue();
        }

        @Specialization
        double round(double x, int n) {
            if (Double.isNaN(x) || Double.isInfinite(x) || x == 0.0) {
                return x;
            }
            double d = RoundNode.op(x, n);
            if (Double.isInfinite(d)) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.ROUNDED_VALUE_TOO_LARGE);
            }
            return d;
        }

        @Specialization(guards={"!isPNone(n)"})
        Object round(VirtualFrame frame, Object x, Object n, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaDoubleNode cast, @Cached PyNumberAsSizeNode asSizeNode) {
            return this.round(FloatBuiltins.castToDoubleChecked(inliningTarget, x, cast), asSizeNode.executeLossy((Frame)frame, inliningTarget, n));
        }

        @Specialization
        Object round(Object xObj, PNone none, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaDoubleNode cast, @Cached InlinedConditionProfile nanProfile, @Cached InlinedConditionProfile infProfile, @Cached InlinedConditionProfile isLongProfile) {
            double x = FloatBuiltins.castToDoubleChecked(inliningTarget, xObj, cast);
            if (nanProfile.profile(inliningTarget, Double.isNaN(x))) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_CONVERT_S_TO_INT, "float NaN");
            }
            if (infProfile.profile(inliningTarget, Double.isInfinite(x))) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.CANNOT_CONVERT_S_TO_INT, "float infinity");
            }
            double result = this.round(x, 0);
            if (isLongProfile.profile(inliningTarget, result > 9.223372036854776E18 || result < -9.223372036854776E18)) {
                return this.factory().createInt(RoundNode.toBigInteger(result));
            }
            return (long)result;
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger toBigInteger(double d) {
            return BigDecimal.valueOf(d).toBigInteger();
        }
    }

    @Builtins(value={@Builtin(name="__rtruediv__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__truediv__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class DivNode
    extends AbstractNumericBinaryBuiltin {
        DivNode() {
        }

        @Override
        protected Object op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return left / right;
        }
    }

    @Builtins(value={@Builtin(name="__rmod__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__mod__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    public static abstract class ModNode
    extends AbstractNumericBinaryBuiltin {
        @Override
        protected Object op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return ModNode.mod(left, right);
        }

        public static double mod(double left, double right) {
            double mod = left % right;
            if (mod != 0.0) {
                if (right < 0.0 != mod < 0.0) {
                    mod += right;
                }
            } else {
                mod = right < 0.0 ? -0.0 : 0.0;
            }
            return mod;
        }
    }

    @Builtin(name="hex", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HexNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private static String makeHexNumber(double value) {
            if (Double.isNaN(value)) {
                return "nan";
            }
            if (Double.POSITIVE_INFINITY == value) {
                return "inf";
            }
            if (Double.NEGATIVE_INFINITY == value) {
                return "-inf";
            }
            if (Double.compare(value, 0.0) == 0) {
                return "0x0.0p+0";
            }
            if (Double.compare(value, -0.0) == 0) {
                return "-0x0.0p+0";
            }
            String result = Double.toHexString(value);
            int length = result.length();
            boolean start_exponent = false;
            StringBuilder sb = new StringBuilder(length + 1);
            int padding = value > 0.0 ? 17 : 18;
            for (int i = 0; i < length; ++i) {
                char c = result.charAt(i);
                if (c == 'p') {
                    for (int pad = i; pad < padding; ++pad) {
                        sb.append('0');
                    }
                    start_exponent = true;
                } else if (start_exponent) {
                    if (c != '-') {
                        sb.append('+');
                    }
                    start_exponent = false;
                }
                sb.append(c);
            }
            return sb.toString();
        }

        @Specialization
        static TruffleString doDouble(Object value, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(HexNode.makeHexNumber(FloatBuiltins.castToDoubleChecked(inliningTarget, value, cast)), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="fromhex", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class FromHexNode
    extends PythonBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private double fromHex(String arg) {
            boolean negative = false;
            Object str = arg.trim().toLowerCase();
            if (((String)str).isEmpty()) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_STRING);
            }
            if (((String)str).equals("inf") || ((String)str).equals("infinity") || ((String)str).equals("+inf") || ((String)str).equals("+infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            if (((String)str).equals("-inf") || ((String)str).equals("-infinity")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (((String)str).equals("nan") || ((String)str).equals("+nan") || ((String)str).equals("-nan")) {
                return Double.NaN;
            }
            if (((String)str).charAt(0) == '+') {
                str = ((String)str).substring(1);
            } else if (((String)str).charAt(0) == '-') {
                str = ((String)str).substring(1);
                negative = true;
            }
            if (((String)str).isEmpty()) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_STRING);
            }
            if (!((String)str).startsWith("0x")) {
                str = "0x" + (String)str;
            }
            if (negative) {
                str = "-" + (String)str;
            }
            if (((String)str).indexOf(112) == -1) {
                str = (String)str + "p0";
            }
            try {
                double result = Double.parseDouble((String)str);
                if (Double.isInfinite(result)) {
                    throw this.raise(PythonErrorType.OverflowError, ErrorMessages.HEX_VALUE_TOO_LARGE_AS_FLOAT);
                }
                return result;
            }
            catch (NumberFormatException ex) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_STRING);
            }
        }

        @Specialization(guards={"isPythonBuiltinClass(cl)"})
        public double fromhexFloat(Object cl, TruffleString arg, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            return this.fromHex(toJavaStringNode.execute((AbstractTruffleString)arg));
        }

        @Specialization(guards={"!isPythonBuiltinClass(cl)"})
        public Object fromhexO(Object cl, TruffleString arg, @Cached(value="create(T___CALL__)") LookupAndCallVarargsNode constr, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            double value = this.fromHex(toJavaStringNode.execute((AbstractTruffleString)arg));
            return constr.execute(null, cl, new Object[]{cl, value});
        }

        @Fallback
        public double fromhex(Object object, Object arg) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends AbstractNumericUnaryBuiltin {
        HashNode() {
        }

        @Override
        protected Object op(double self) {
            return PyObjectHashNode.hash(self);
        }
    }

    @Builtins(value={@Builtin(name="__rdivmod__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__divmod__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class DivModNode
    extends AbstractNumericBinaryBuiltin {
        DivModNode() {
        }

        @Override
        protected PTuple op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return this.factory().createTuple(new Object[]{Math.floor(left / right), ModNode.mod(left, right)});
        }
    }

    @Builtins(value={@Builtin(name="__rfloordiv__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__floordiv__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class FloorDivNode
    extends AbstractNumericBinaryBuiltin {
        FloorDivNode() {
        }

        @Override
        protected Object op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return Math.floor(left / right);
        }
    }

    @Builtins(value={@Builtin(name="__rpow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3, reverseOperation=true), @Builtin(name="__pow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)})
    @GenerateNodeFactory
    public static abstract class PowNode
    extends PythonTernaryBuiltinNode {
        protected abstract double executeDouble(VirtualFrame var1, double var2, double var4, PNone var6) throws UnexpectedResultException;

        protected abstract Object execute(VirtualFrame var1, double var2, double var4, PNone var6);

        public final double executeDouble(double left, double right) throws UnexpectedResultException {
            return this.executeDouble(null, left, right, PNone.NO_VALUE);
        }

        public final Object execute(double left, double right) {
            return this.execute(null, left, right, PNone.NO_VALUE);
        }

        @Specialization
        double doDI(double left, int right, PNone none) {
            return this.doOperation(left, right);
        }

        private double doSpecialCases(double left, double right) {
            if (Double.isNaN(right) && left == 1.0) {
                return 1.0;
            }
            if (Double.isInfinite(right) && (left == 1.0 || left == -1.0)) {
                return 1.0;
            }
            if (left == 0.0 && right < 0.0 && Double.isFinite(right)) {
                throw this.raise(PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            return 0.0;
        }

        private double doOperation(double left, double right) {
            if (this.doSpecialCases(left, right) == 1.0) {
                return 1.0;
            }
            return Math.pow(left, right);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        double doDD(VirtualFrame frame, double left, double right, PNone none, @Cached.Shared(value="powCall") @Cached(value="create(Pow)") LookupAndCallTernaryNode callPow) throws UnexpectedResultException {
            if (this.doSpecialCases(left, right) == 1.0) {
                return 1.0;
            }
            if (left < 0.0 && Double.isFinite(left) && Double.isFinite(right) && right % 1.0 != 0.0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(callPow.execute(frame, this.factory().createComplex(left, 0.0), this.factory().createComplex(right, 0.0), none));
            }
            return Math.pow(left, right);
        }

        @Specialization(replaces={"doDD"})
        Object doDDToComplex(VirtualFrame frame, double left, double right, PNone none, @Cached.Shared(value="powCall") @Cached(value="create(Pow)") LookupAndCallTernaryNode callPow) {
            if (this.doSpecialCases(left, right) == 1.0) {
                return 1.0;
            }
            if (left < 0.0 && Double.isFinite(left) && Double.isFinite(right) && right % 1.0 != 0.0) {
                return callPow.execute(frame, this.factory().createComplex(left, 0.0), this.factory().createComplex(right, 0.0), none);
            }
            return Math.pow(left, right);
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object left, Object right, Object mod, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode castToJavaDoubleNode, @Cached.Shared(value="powCall") @Cached(value="create(Pow)") LookupAndCallTernaryNode callPow) {
            double rightDouble;
            double leftDouble;
            if (!(mod instanceof PNone)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.POW_3RD_ARG_NOT_ALLOWED_UNLESS_INTEGERS);
            }
            try {
                leftDouble = castToJavaDoubleNode.execute(inliningTarget, left);
                rightDouble = castToJavaDoubleNode.execute(inliningTarget, right);
            }
            catch (CannotCastException e) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return this.doDDToComplex(frame, leftDouble, rightDouble, PNone.NONE, callPow);
        }

        public static PowNode create() {
            return FloatBuiltinsFactory.PowNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class MulNode
    extends AbstractNumericBinaryBuiltin {
        MulNode() {
        }

        @Override
        protected Object op(double a, double b) {
            return a * b;
        }
    }

    @Builtins(value={@Builtin(name="__rsub__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__sub__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class SubNode
    extends AbstractNumericBinaryBuiltin {
        SubNode() {
        }

        @Override
        protected Object op(double a, double b) {
            return a - b;
        }
    }

    @Builtins(value={@Builtin(name="__radd__", minNumOfPositionalArgs=2), @Builtin(name="__add__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class AddNode
    extends AbstractNumericBinaryBuiltin {
        AddNode() {
        }

        @Override
        protected Object op(double a, double b) {
            return a + b;
        }
    }

    @Builtin(name="__float__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FloatNode
    extends AbstractNumericUnaryBuiltin {
        FloatNode() {
        }

        @Override
        protected Object op(double self) {
            return self;
        }
    }

    @Builtins(value={@Builtin(name="__int__", minNumOfPositionalArgs=1), @Builtin(name="__trunc__", minNumOfPositionalArgs=1)})
    @GenerateNodeFactory
    static abstract class IntNode
    extends PythonUnaryBuiltinNode {
        IntNode() {
        }

        @Specialization
        static Object doDouble(Object self, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast));
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BoolNode
    extends AbstractNumericUnaryBuiltin {
        BoolNode() {
        }

        @Override
        protected Object op(double self) {
            return self != 0.0;
        }
    }

    @Builtin(name="__abs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AbsNode
    extends AbstractNumericUnaryBuiltin {
        AbsNode() {
        }

        @Override
        protected Object op(double arg) {
            return Math.abs(arg);
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FloatBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        TruffleString formatPF(Object self, TruffleString formatString, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            return this.doFormat(FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast), formatString);
        }

        @CompilerDirectives.TruffleBoundary
        private TruffleString doFormat(double self, TruffleString formatString) {
            InternalFormat.Spec spec = InternalFormat.fromText(this.getRaiseNode(), formatString, '\uffff', '>');
            FloatFormatter formatter = new FloatFormatter(this.getRaiseNode(), FormattingUtils.validateForFloat(this.getRaiseNode(), spec, "float"));
            formatter.format(self);
            return formatter.pad().getResult();
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        ReprNode() {
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class StrNode
    extends AbstractNumericUnaryBuiltin {
        public static final InternalFormat.Spec spec = new InternalFormat.Spec(' ', '>', '\uffff', false, -1, '\uffff', 0, 'r');

        protected TruffleString op(double self) {
            FloatFormatter f = new FloatFormatter(this.getRaiseNode(), spec);
            f.setMinFracDigits(1);
            return StrNode.doFormat(self, f);
        }

        @CompilerDirectives.TruffleBoundary
        public static TruffleString doFormat(double d, FloatFormatter f) {
            return f.format(d).getResult();
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractNumericBinaryBuiltin
    extends PythonBinaryBuiltinNode {
        AbstractNumericBinaryBuiltin() {
        }

        protected abstract Object op(double var1, double var3);

        @Specialization
        Object doDD(double a, double b) {
            return this.op(a, b);
        }

        @Specialization
        Object doDI(double a, int b) {
            return this.op(a, b);
        }

        @Specialization(replaces={"doDD", "doDI"})
        Object doOther(Object a, Object b, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            double bDouble;
            double aDouble;
            try {
                aDouble = cast.execute(inliningTarget, a);
                bDouble = cast.execute(inliningTarget, b);
            }
            catch (CannotCastException e) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return this.op(aDouble, bDouble);
        }

        protected void raiseDivisionByZero(boolean cond) {
            if (cond) {
                throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractNumericUnaryBuiltin
    extends PythonUnaryBuiltinNode {
        AbstractNumericUnaryBuiltin() {
        }

        protected abstract Object op(double var1);

        @Specialization
        Object doDouble(double num) {
            return this.op(num);
        }

        @Specialization(replaces={"doDouble"})
        Object doOther(Object object, @Bind(value="this") Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            return this.op(FloatBuiltins.castToDoubleChecked(inliningTarget, object, cast));
        }
    }
}

