/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.KeywordsStorage;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary(value=InteropLibrary.class)
public class PDict
extends PHashingCollection {
    public PDict(PythonLanguage lang) {
        this((Object)PythonBuiltinClassType.PDict, PythonBuiltinClassType.PDict.getInstanceShape(lang));
    }

    public PDict(Object cls, Shape instanceShape, HashingStorage dictStorage) {
        super(PDict.ensurePBCT(cls), instanceShape, dictStorage);
    }

    private static Object ensurePBCT(Object cls) {
        if (cls instanceof PythonBuiltinClass && ((PythonBuiltinClass)cls).getType() == PythonBuiltinClassType.PDict) {
            return PythonBuiltinClassType.PDict;
        }
        return cls;
    }

    public PDict(Object cls, Shape instanceShape) {
        this(cls, instanceShape, EmptyStorage.INSTANCE);
    }

    public PDict(Object cls, Shape instanceShape, PKeyword[] keywords) {
        this(cls, instanceShape, keywords != null ? KeywordsStorage.create(keywords) : EmptyStorage.INSTANCE);
    }

    public Object getItem(Object key) {
        return HashingStorageNodes.HashingStorageGetItem.executeUncached(this.storage, key);
    }

    public void setItem(Object key, Object value) {
        this.storage = HashingStorageNodes.HashingStorageSetItem.executeUncached(this.storage, key, value);
    }

    public void delItem(Object key) {
        HashingStorageNodes.HashingStorageDelItem.executeUncached(this.storage, key, this);
    }

    public static HashingStorage createNewStorage(int expectedSize) {
        HashingStorage newDictStorage = expectedSize == 0 ? EmptyStorage.INSTANCE : EconomicMapStorage.create(expectedSize);
        return newDictStorage;
    }

    public void update(PDict other) {
        HashingStorageNodes.HashingStorageAddAllToOther.executeUncached(other.getDictStorage(), this);
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "PDict<" + this.storage.getClass().getSimpleName() + ">";
    }

    @ExportMessage
    static boolean hasHashEntries(PDict self) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static long getHashSize(PDict self, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        boolean mustRelease = gil.acquire();
        try {
            long l = lenNode.execute(inliningTarget, self.getDictStorage());
            return l;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage.Repeat(value={@ExportMessage, @ExportMessage(name="isHashEntryModifiable"), @ExportMessage(name="isHashEntryRemovable")})
    static boolean isHashEntryReadable(PDict self, Object key, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Exclusive @Cached PForeignToPTypeNode convertNode) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = getItem.hasKey(null, inliningTarget, self.getDictStorage(), convertNode.executeConvert(key));
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static Object readHashValue(PDict self, Object key, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Exclusive @Cached PForeignToPTypeNode convertNode) throws UnknownKeyException {
        Object value = null;
        boolean mustRelease = gil.acquire();
        try {
            value = getItem.execute(null, inliningTarget, self.getDictStorage(), convertNode.executeConvert(key));
        }
        finally {
            gil.release(mustRelease);
        }
        if (value == null) {
            throw UnknownKeyException.create((Object)key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static boolean isHashEntryInsertable(PDict self, Object key, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached PyObjectHashNode hashNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Exclusive @Cached PForeignToPTypeNode convertNode) {
        boolean mustRelease = gil.acquire();
        try {
            Object pKey = convertNode.executeConvert(key);
            if (getItem.hasKey(null, inliningTarget, self.getDictStorage(), pKey)) {
                boolean bl = false;
                return bl;
            }
            try {
                hashNode.execute(null, inliningTarget, pKey);
            }
            catch (AbstractTruffleException e) {
                boolean bl = false;
                gil.release(mustRelease);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    static void writeHashEntry(PDict self, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached.Exclusive @Cached PForeignToPTypeNode convertNodeKey, @Cached.Exclusive @Cached PForeignToPTypeNode convertNodeValue) throws UnsupportedTypeException {
        boolean mustRelease = gil.acquire();
        Object pKey = convertNodeKey.executeConvert(key);
        try {
            HashingStorage newStorage = setItem.execute(null, inliningTarget, self.getDictStorage(), pKey, convertNodeValue.executeConvert(value));
            self.setDictStorage(newStorage);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile);
            throw UnsupportedTypeException.create((Object[])new Object[]{pKey}, (String)"keys for Python arrays must be hashable");
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static void removeHashEntry(PDict self, Object key, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached.Exclusive @Cached PForeignToPTypeNode convertNode) throws UnknownKeyException {
        boolean mustRelease = gil.acquire();
        try {
            Object pKey = convertNode.executeConvert(key);
            Object found = delItem.executePop(null, inliningTarget, self.getDictStorage(), pKey, self);
            if (found == null) {
                throw UnknownKeyException.create((Object)key);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static Object getHashEntriesIterator(PDict self, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
        boolean mustRelease = gil.acquire();
        try {
            Object dictItems = callMethod.execute(null, inliningTarget, self, SpecialMethodNames.T_ITEMS, new Object[0]);
            Object object = getIter.execute(null, inliningTarget, dictItems);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static Object getHashKeysIterator(PDict self, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
        boolean mustRelease = gil.acquire();
        try {
            Object dictKeys = callMethod.execute(null, inliningTarget, self, SpecialMethodNames.T_KEYS, new Object[0]);
            Object object = getIter.execute(null, inliningTarget, dictKeys);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static Object getHashValuesIterator(PDict self, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
        boolean mustRelease = gil.acquire();
        try {
            Object dictValues = callMethod.execute(null, inliningTarget, self, SpecialMethodNames.T_VALUES, new Object[0]);
            Object object = getIter.execute(null, inliningTarget, dictValues);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }
}

