/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictReprBuiltinFactory;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictItemsView, PythonBuiltinClassType.PDictValuesView, PythonBuiltinClassType.PDict})
public final class DictReprBuiltin
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DictReprBuiltinFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T_ELLIPSIS = PythonUtils.tsLiteral("{...}");
        private static final TruffleString T_COLONSPACE = PythonUtils.tsLiteral(": ");
        private static final TruffleString T_LPAREN_BRACKET = PythonUtils.tsLiteral("([");
        private static final TruffleString T_RPAREN_BRACKET = PythonUtils.tsLiteral("])");

        ReprNode() {
        }

        public abstract TruffleString execute(VirtualFrame var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public static TruffleString repr(PDict dict, @Bind(value="this") Node inliningTarget, @Cached(value="create(3)") ForEachDictRepr consumerNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            PythonContext ctxt = PythonContext.get(forEachNode);
            if (!ctxt.reprEnter(dict)) {
                return T_ELLIPSIS;
            }
            try {
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LBRACE);
                HashingStorage dictStorage = dict.getDictStorage();
                forEachNode.execute(null, inliningTarget, dictStorage, consumerNode, new ReprState(dict, dictStorage, sb));
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RBRACE);
                TruffleString truffleString = toStringNode.execute(sb);
                return truffleString;
            }
            finally {
                ctxt.reprLeave(dict);
            }
        }

        @Specialization
        public static TruffleString repr(PDictView.PDictKeysView view, @Bind(value="this") Node inliningTarget, @Cached(value="create(3)") ForEachKeyRepr consumerNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            return ReprNode.viewRepr(inliningTarget, view, PythonBuiltinClassType.PDictKeysView.getName(), forEachNode, consumerNode, appendStringNode, toStringNode);
        }

        @Specialization
        public static TruffleString repr(PDictView.PDictValuesView view, @Bind(value="this") Node inliningTarget, @Cached(value="create(3)") ForEachValueRepr consumerNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            return ReprNode.viewRepr(inliningTarget, view, PythonBuiltinClassType.PDictValuesView.getName(), forEachNode, consumerNode, appendStringNode, toStringNode);
        }

        @Specialization
        public static TruffleString repr(PDictView.PDictItemsView view, @Bind(value="this") Node inliningTarget, @Cached(value="create(3)") ForEachItemRepr consumerNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            return ReprNode.viewRepr(inliningTarget, view, PythonBuiltinClassType.PDictItemsView.getName(), forEachNode, consumerNode, appendStringNode, toStringNode);
        }

        private static TruffleString viewRepr(Node inliningTarget, PDictView view, TruffleString type, HashingStorageNodes.HashingStorageForEach forEachNode, AbstractForEachRepr consumerNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)type);
            appendStringNode.execute(sb, (AbstractTruffleString)T_LPAREN_BRACKET);
            HashingStorage dictStorage = view.getWrappedDict().getDictStorage();
            forEachNode.execute(null, inliningTarget, dictStorage, consumerNode, new ReprState(view, dictStorage, sb));
            appendStringNode.execute(sb, (AbstractTruffleString)T_RPAREN_BRACKET);
            return toStringNode.execute(sb);
        }

        @CompilerDirectives.ValueType
        protected static final class ReprState {
            private final Object self;
            private final HashingStorage dictStorage;
            private final TruffleStringBuilder result;
            private final int initialLength;

            ReprState(Object self, HashingStorage dictStorage, TruffleStringBuilder result) {
                this.self = self;
                this.dictStorage = dictStorage;
                this.result = result;
                this.initialLength = result.byteLength();
            }
        }

        static abstract class AbstractForEachRepr
        extends HashingStorageNodes.HashingStorageForEachCallback<ReprState> {
            private final int limit;

            AbstractForEachRepr(int limit) {
                this.limit = limit;
            }

            protected final int getLimit() {
                return this.limit;
            }

            @Override
            public abstract ReprState execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, ReprState var5);

            protected static TruffleString getReprString(Node inliningTarget, Object obj, ReprState s, LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode reprNode, CastToTruffleStringNode castStr, PRaiseNode.Lazy raiseNode) {
                Object reprObj = s == null || obj != s.self ? reprNode.executeObject(obj, SpecialMethodNames.T___REPR__) : T_ELLIPSIS;
                try {
                    return castStr.execute(inliningTarget, reprObj);
                }
                catch (CannotCastException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_STRING, "__repr__", reprObj);
                }
            }

            protected static void appendSeparator(Node inliningTarget, ReprState s, InlinedConditionProfile lengthCheck, TruffleStringBuilder.AppendStringNode appendStringNode) {
                if (lengthCheck.profile(inliningTarget, s.result.byteLength() > s.initialLength)) {
                    appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                }
            }
        }

        static abstract class ForEachDictRepr
        extends AbstractForEachRepr {
            public ForEachDictRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState dict(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind(value="this") Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode keyReprNode, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode valueReprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode.Lazy raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                Object key = itKey.execute(inliningTarget, storage, it);
                TruffleString keyReprString = ForEachDictRepr.getReprString(inliningTarget, key, null, keyReprNode, castStr, raiseNode);
                TruffleString valueReprString = ForEachDictRepr.getReprString(inliningTarget, getItem.execute(frame, inliningTarget, s.dictStorage, key), s, valueReprNode, castStr, raiseNode);
                ForEachDictRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                appendStringNode.execute(s.result, (AbstractTruffleString)keyReprString);
                appendStringNode.execute(s.result, (AbstractTruffleString)T_COLONSPACE);
                appendStringNode.execute(s.result, (AbstractTruffleString)valueReprString);
                return s;
            }
        }

        static abstract class ForEachItemRepr
        extends AbstractForEachRepr {
            public ForEachItemRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState dict(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind(value="this") Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode keyReprNode, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode valueReprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode.Lazy raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                ForEachItemRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_LPAREN);
                Object key = itKey.execute(inliningTarget, storage, it);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachItemRepr.getReprString(inliningTarget, key, null, keyReprNode, castStr, raiseNode));
                appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachItemRepr.getReprString(inliningTarget, getItem.execute(frame, inliningTarget, s.dictStorage, key), s, valueReprNode, castStr, raiseNode));
                appendStringNode.execute(s.result, (AbstractTruffleString)StringLiterals.T_RPAREN);
                return s;
            }
        }

        static abstract class ForEachValueRepr
        extends AbstractForEachRepr {
            public ForEachValueRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState dict(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind(value="this") Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode reprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode.Lazy raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                ForEachValueRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                Object key = itKey.execute(inliningTarget, storage, it);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachValueRepr.getReprString(inliningTarget, getItem.execute(frame, inliningTarget, s.dictStorage, key), s, reprNode, castStr, raiseNode));
                return s;
            }
        }

        static abstract class ForEachKeyRepr
        extends AbstractForEachRepr {
            public ForEachKeyRepr(int limit) {
                super(limit);
            }

            @Specialization
            public static ReprState append(Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ReprState s, @Bind(value="this") Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode reprNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode.Lazy raiseNode, @Cached InlinedConditionProfile lengthCheck, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
                ForEachKeyRepr.appendSeparator(inliningTarget, s, lengthCheck, appendStringNode);
                appendStringNode.execute(s.result, (AbstractTruffleString)ForEachKeyRepr.getReprString(inliningTarget, itKey.execute(inliningTarget, storage, it), null, reprNode, castStr, raiseNode));
                return s;
            }
        }
    }
}

