/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.complex;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CoerceToComplexNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.ComplexFormatter;
import com.oracle.graal.python.runtime.formatting.FormattingUtils;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PComplex})
public final class ComplexBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ComplexBuiltinsFactory.getFactories();
    }

    @Builtin(name="conjugate", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ConjugateNode
    extends PythonUnaryBuiltinNode {
        ConjugateNode() {
        }

        @Specialization
        PComplex hash(PComplex self) {
            return this.factory().createComplex(self.getReal(), -self.getImag());
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long doPComplex(PComplex self) {
            return HashNode.complexHash(self.getReal(), self.getImag());
        }

        @Specialization
        static long doNative(PythonAbstractNativeObject self, @Cached CStructAccess.ReadDoubleNode read) {
            double real = read.readFromObj(self, CFields.PyComplexObject__cval__real);
            double imag = read.readFromObj(self, CFields.PyComplexObject__cval__imag);
            return HashNode.complexHash(real, imag);
        }

        private static long complexHash(double real, double imag) {
            long realHash = PyObjectHashNode.hash(real);
            long imagHash = PyObjectHashNode.hash(imag);
            return realHash + 1000003L * imagHash;
        }
    }

    @Builtin(name="imag", minNumOfPositionalArgs=1, isGetter=true, doc="the imaginary part of a complex number")
    @GenerateNodeFactory
    static abstract class ImagNode
    extends PythonBuiltinNode {
        ImagNode() {
        }

        @Specialization
        static double get(PComplex self) {
            return self.getImag();
        }
    }

    @Builtin(name="real", minNumOfPositionalArgs=1, isGetter=true, doc="the real part of a complex number")
    @GenerateNodeFactory
    static abstract class RealNode
    extends PythonBuiltinNode {
        RealNode() {
        }

        @Specialization
        static double get(PComplex self) {
            return self.getReal();
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetNewArgsNode
    extends PythonUnaryBuiltinNode {
        GetNewArgsNode() {
        }

        @Specialization
        PTuple get(PComplex self) {
            return this.factory().createTuple(new Object[]{self.getReal(), self.getImag()});
        }
    }

    @Builtin(name="__pos__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class PosNode
    extends PythonUnaryBuiltinNode {
        PosNode() {
        }

        @Specialization
        PComplex pos(PComplex self) {
            return this.factory().createComplex(self.getReal(), self.getImag());
        }
    }

    @Builtin(name="__neg__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class NegNode
    extends PythonUnaryBuiltinNode {
        NegNode() {
        }

        @Specialization
        PComplex neg(PComplex self) {
            return this.factory().createComplex(-self.getReal(), -self.getImag());
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BoolNode
    extends PythonUnaryBuiltinNode {
        BoolNode() {
        }

        @Specialization
        static boolean bool(PComplex self) {
            return self.getReal() != 0.0 || self.getImag() != 0.0;
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ComplexBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        TruffleString format(PComplex self, TruffleString formatString) {
            InternalFormat.Spec spec = InternalFormat.fromText(this.getRaiseNode(), formatString, '\uffff', '>');
            this.validateSpec(spec);
            return FormatNode.doFormat(this.getRaiseNode(), self, spec);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString doFormat(PRaiseNode raiseNode, PComplex self, InternalFormat.Spec spec) {
            ComplexFormatter formatter = new ComplexFormatter(raiseNode, FormattingUtils.validateForFloat(raiseNode, spec, "complex"));
            formatter.format(self);
            return formatter.pad().getResult();
        }

        private void validateSpec(InternalFormat.Spec spec) {
            if (spec.getFill(' ') == '0') {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.ZERO_PADDING_NOT_ALLOWED_FOR_COMPLEX_FMT);
            }
            char align = spec.getAlign('>');
            if (align == '=') {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.S_ALIGNMENT_FLAG_NOT_ALLOWED_FOR_COMPLEX_FMT, Character.valueOf(align));
            }
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends ReprNode {
        StrNode() {
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        TruffleString repr(PComplex self) {
            return ReprNode.repr(self, this.getRaiseNode());
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString repr(PComplex self, PRaiseNode raiseNode) {
            ComplexFormatter formatter = new ComplexFormatter(raiseNode, new InternalFormat.Spec(-1, '\uffff'));
            formatter.format(self);
            return formatter.pad().getResult();
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        NeNode() {
        }

        @Specialization
        static boolean doComplex(PComplex left, PComplex right) {
            return left.notEqual(right);
        }

        @Specialization
        static boolean doComplex(PComplex left, long right, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile longFitsToDoubleProfile) {
            return left.getImag() != 0.0 || FloatBuiltins.EqNode.compareDoubleToLong(inliningTarget, left.getReal(), right, longFitsToDoubleProfile) != 0.0;
        }

        @Specialization
        static boolean doComplex(PComplex left, PInt right) {
            return left.getImag() != 0.0 || FloatBuiltins.EqNode.compareDoubleToLargeInt(left.getReal(), right) != 0.0;
        }

        @Specialization
        static boolean doComplex(PComplex left, double right) {
            return left.getImag() != 0.0 || left.getReal() != right;
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        LeNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        LtNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        GtNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        GeNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        @Specialization
        static boolean doComplex(PComplex left, PComplex right) {
            return left.equals(right);
        }

        @Specialization
        static boolean doComplexInt(PComplex left, long right, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile longFitsToDoubleProfile) {
            return left.getImag() == 0.0 && FloatBuiltins.EqNode.compareDoubleToLong(inliningTarget, left.getReal(), right, longFitsToDoubleProfile) == 0.0;
        }

        @Specialization
        static boolean doComplexInt(PComplex left, PInt right) {
            return left.getImag() == 0.0 && FloatBuiltins.EqNode.compareDoubleToLargeInt(left.getReal(), right) == 0.0;
        }

        @Specialization
        static boolean doComplexInt(PComplex left, double right) {
            return left.getImag() == 0.0 && left.getReal() == right;
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__rpow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3, reverseOperation=true), @Builtin(name="__pow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class PowerNode
    extends PythonTernaryBuiltinNode {
        PowerNode() {
        }

        static boolean isSmallPositive(long l) {
            return l > 0L && l <= 100L;
        }

        static boolean isSmallNegative(long l) {
            return l <= 0L && l >= -100L;
        }

        @Specialization(guards={"isSmallPositive(right)"})
        PComplex doComplexLongSmallPos(PComplex left, long right, PNone mod) {
            return this.checkOverflow(this.complexToSmallPositiveIntPower(left, right));
        }

        @Specialization(guards={"isSmallNegative(right)"})
        PComplex doComplexLongSmallNeg(PComplex left, long right, PNone mod) {
            return this.checkOverflow(DivNode.doubleDivComplex(1.0, this.complexToSmallPositiveIntPower(left, -right), this.factory()));
        }

        @Specialization(guards={"!isSmallPositive(right) || !isSmallNegative(right)"})
        PComplex doComplexLong(PComplex left, long right, PNone mod) {
            return this.checkOverflow(this.complexToComplexPower(left, this.factory().createComplex(right, 0.0)));
        }

        @Specialization
        PComplex doComplexComplex(PComplex left, PComplex right, PNone mod) {
            return this.checkOverflow(this.complexToComplexPower(left, right));
        }

        @Specialization
        PComplex doGeneric(VirtualFrame frame, Object left, Object right, PNone mod, @Cached CoerceToComplexNode coerceLeft, @Cached CoerceToComplexNode coerceRight) {
            return this.checkOverflow(this.complexToComplexPower(coerceLeft.execute(frame, left), coerceRight.execute(frame, right)));
        }

        @Specialization(guards={"!isPNone(mod)"})
        Object doGeneric(Object left, Object right, Object mod) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.COMPLEX_MODULO);
        }

        private PComplex complexToSmallPositiveIntPower(PComplex x, long n) {
            PComplex r = this.factory().createComplex(1.0, 0.0);
            PComplex p = x;
            for (long mask = 1L; mask > 0L && n >= mask; mask <<= 1) {
                if ((n & mask) != 0L) {
                    r = MulNode.multiply(r, p, this.factory());
                }
                p = MulNode.multiply(p, p, this.factory());
            }
            return r;
        }

        @CompilerDirectives.TruffleBoundary
        private PComplex complexToComplexPower(PComplex a, PComplex b) {
            if (b.getReal() == 0.0 && b.getImag() == 0.0) {
                return this.factory().createComplex(1.0, 0.0);
            }
            if (a.getReal() == 0.0 && a.getImag() == 0.0) {
                if (b.getImag() != 0.0 || b.getReal() < 0.0) {
                    throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.COMPLEX_ZERO_TO_NEGATIVE_POWER);
                }
                return this.factory().createComplex(0.0, 0.0);
            }
            double vabs = Math.hypot(a.getReal(), a.getImag());
            double len = Math.pow(vabs, b.getReal());
            double at = Math.atan2(a.getImag(), a.getReal());
            double phase = at * b.getReal();
            if (b.getImag() != 0.0) {
                len /= Math.exp(at * b.getImag());
                phase += b.getImag() * Math.log(vabs);
            }
            return this.factory().createComplex(len * Math.cos(phase), len * Math.sin(phase));
        }

        private PComplex checkOverflow(PComplex result) {
            if (Double.isInfinite(result.getReal()) || Double.isInfinite(result.getImag())) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.COMPLEX_EXPONENTIATION);
            }
            return result;
        }
    }

    @Builtins(value={@Builtin(name="__rsub__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__sub__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class SubNode
    extends PythonBinaryBuiltinNode {
        SubNode() {
        }

        @Specialization
        PComplex doComplexDouble(PComplex left, double right) {
            return this.factory().createComplex(left.getReal() - right, left.getImag());
        }

        @Specialization
        PComplex doComplex(PComplex left, PComplex right) {
            return this.factory().createComplex(left.getReal() - right.getReal(), left.getImag() - right.getImag());
        }

        @Specialization
        PComplex doComplex(PComplex left, long right) {
            return this.factory().createComplex(left.getReal() - (double)right, left.getImag());
        }

        @Specialization
        PComplex doComplexDouble(double left, PComplex right) {
            return this.factory().createComplex(left - right.getReal(), -right.getImag());
        }

        @Specialization
        PComplex doComplex(long left, PComplex right) {
            return this.factory().createComplex((double)left - right.getReal(), -right.getImag());
        }

        @Fallback
        static PNotImplemented doComplex(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        MulNode() {
        }

        @Specialization
        PComplex doComplexDouble(PComplex left, double right) {
            return this.factory().createComplex(left.getReal() * right, left.getImag() * right);
        }

        @Specialization
        PComplex doComplex(PComplex left, PComplex right) {
            return MulNode.multiply(left, right, this.factory());
        }

        @Specialization
        PComplex doComplexLong(PComplex left, long right) {
            return this.doComplexDouble(left, right);
        }

        @Specialization
        PComplex doComplexPInt(PComplex left, PInt right) {
            return this.doComplexDouble(left, right.doubleValue());
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        static PComplex multiply(PComplex left, PComplex right, PythonObjectFactory factory) {
            double newReal = left.getReal() * right.getReal() - left.getImag() * right.getImag();
            double newImag = left.getReal() * right.getImag() + left.getImag() * right.getReal();
            return factory.createComplex(newReal, newImag);
        }
    }

    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class RDivNode
    extends PythonBinaryBuiltinNode {
        RDivNode() {
        }

        @Fallback
        static PNotImplemented doComplex(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__rtruediv__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__truediv__", minNumOfPositionalArgs=2)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class DivNode
    extends PythonBinaryBuiltinNode {
        public abstract PComplex executeComplex(VirtualFrame var1, Object var2, Object var3);

        @NeverDefault
        public static DivNode create() {
            return ComplexBuiltinsFactory.DivNodeFactory.create();
        }

        @Specialization
        PComplex doComplexDouble(PComplex left, double right) {
            double opNormSq = right * right;
            double realPart = left.getReal() * right;
            double imagPart = left.getImag() * right;
            return this.factory().createComplex(realPart / opNormSq, imagPart / opNormSq);
        }

        @Specialization
        PComplex doComplexInt(PComplex left, long right) {
            double opNormSq = right * right;
            double realPart = left.getReal() * (double)right;
            double imagPart = left.getImag() * (double)right;
            return this.factory().createComplex(realPart / opNormSq, imagPart / opNormSq);
        }

        @Specialization
        PComplex doComplexPInt(PComplex left, PInt right) {
            return this.doComplexDouble(left, right.doubleValue());
        }

        @Specialization
        PComplex doComplex(PComplex left, PComplex right, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile topConditionProfile, @Cached InlinedConditionProfile zeroDivisionProfile) {
            double imag;
            double real;
            double absRightImag;
            double absRightReal = right.getReal() < 0.0 ? -right.getReal() : right.getReal();
            if (topConditionProfile.profile(inliningTarget, absRightReal >= (absRightImag = right.getImag() < 0.0 ? -right.getImag() : right.getImag()))) {
                if (zeroDivisionProfile.profile(inliningTarget, absRightReal == 0.0)) {
                    throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_BY_ZERO, "complex");
                }
                double ratio = right.getImag() / right.getReal();
                double denom = right.getReal() + right.getImag() * ratio;
                real = (left.getReal() + left.getImag() * ratio) / denom;
                imag = (left.getImag() - left.getReal() * ratio) / denom;
            } else {
                double ratio = right.getReal() / right.getImag();
                double denom = right.getReal() * ratio + right.getImag();
                real = (left.getReal() * ratio + left.getImag()) / denom;
                imag = (left.getImag() * ratio - left.getReal()) / denom;
            }
            return this.factory().createComplex(real, imag);
        }

        @Specialization
        PComplex doComplexDouble(double left, PComplex right) {
            return DivNode.doubleDivComplex(left, right, this.factory());
        }

        @Specialization
        PComplex doComplexInt(long left, PComplex right) {
            double oprealSq = right.getReal() * right.getReal();
            double opimagSq = right.getImag() * right.getImag();
            double realPart = right.getReal() * (double)left;
            double imagPart = right.getImag() * (double)left;
            double denom = oprealSq + opimagSq;
            return this.factory().createComplex(realPart / denom, -imagPart / denom);
        }

        @Specialization
        PComplex doComplexPInt(PInt left, PComplex right) {
            return this.doComplexDouble(left.doubleValue(), right);
        }

        @Fallback
        static PNotImplemented doComplex(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        static PComplex doubleDivComplex(double left, PComplex right, PythonObjectFactory factory) {
            double oprealSq = right.getReal() * right.getReal();
            double opimagSq = right.getImag() * right.getImag();
            double realPart = right.getReal() * left;
            double imagPart = right.getImag() * left;
            double denom = oprealSq + opimagSq;
            return factory.createComplex(realPart / denom, -imagPart / denom);
        }
    }

    @Builtins(value={@Builtin(name="__radd__", minNumOfPositionalArgs=2), @Builtin(name="__add__", minNumOfPositionalArgs=2)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        AddNode() {
        }

        @Specialization
        PComplex doComplexLong(PComplex left, long right) {
            return this.factory().createComplex(left.getReal() + (double)right, left.getImag());
        }

        @Specialization
        PComplex doComplexPInt(PComplex left, PInt right) {
            return this.factory().createComplex(left.getReal() + right.doubleValue(), left.getImag());
        }

        @Specialization
        PComplex doComplexDouble(PComplex left, double right) {
            PComplex result = this.factory().createComplex(left.getReal() + right, left.getImag());
            return result;
        }

        @Specialization
        PComplex doComplex(PComplex left, PComplex right) {
            return this.factory().createComplex(left.getReal() + right.getReal(), left.getImag() + right.getImag());
        }

        @Fallback
        static PNotImplemented doComplex(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__abs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AbsNode
    extends PythonUnaryBuiltinNode {
        private static final long MASK_NON_SIGN_LONG = Long.MAX_VALUE;

        public abstract double executeDouble(Object var1);

        @Specialization
        double abs(PComplex c) {
            double scaledY;
            int expY;
            double x = c.getReal();
            double y = c.getImag();
            if (Double.isInfinite(x) || Double.isInfinite(y)) {
                return Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(x) || Double.isNaN(y)) {
                return Double.NaN;
            }
            int expX = AbsNode.getExponent(x);
            if (expX > (expY = AbsNode.getExponent(y)) + 27) {
                return AbsNode.abs(x);
            }
            if (expY > expX + 27) {
                return AbsNode.abs(y);
            }
            int middleExp = (expX + expY) / 2;
            double scaledX = AbsNode.scalb(x, -middleExp);
            double scaledH = Math.sqrt(scaledX * scaledX + (scaledY = AbsNode.scalb(y, -middleExp)) * scaledY);
            double r = AbsNode.scalb(scaledH, middleExp);
            if (Double.isInfinite(r)) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.ABSOLUTE_VALUE_TOO_LARGE);
            }
            return r;
        }

        static double abs(double x) {
            return Double.longBitsToDouble(Long.MAX_VALUE & Double.doubleToRawLongBits(x));
        }

        static double scalb(double d, int n) {
            if (n > -1023 && n < 1024) {
                return d * Double.longBitsToDouble((long)(n + 1023) << 52);
            }
            if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
                return d;
            }
            if (n < -2098) {
                return d > 0.0 ? 0.0 : -0.0;
            }
            if (n > 2097) {
                return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            long bits = Double.doubleToRawLongBits(d);
            long sign = bits & Long.MIN_VALUE;
            int exponent = (int)(bits >>> 52) & 0x7FF;
            long mantissa = bits & 0xFFFFFFFFFFFFFL;
            int scaledExponent = exponent + n;
            if (n < 0) {
                if (scaledExponent > 0) {
                    return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
                }
                if (scaledExponent > -53) {
                    long mostSignificantLostBit = (mantissa |= 0x10000000000000L) & 1L << -scaledExponent;
                    mantissa >>>= 1 - scaledExponent;
                    if (mostSignificantLostBit != 0L) {
                        ++mantissa;
                    }
                    return Double.longBitsToDouble(sign | mantissa);
                }
                return sign == 0L ? 0.0 : -0.0;
            }
            if (exponent == 0) {
                while (mantissa >>> 52 != 1L) {
                    mantissa <<= 1;
                    --scaledExponent;
                }
                mantissa &= 0xFFFFFFFFFFFFFL;
                if (++scaledExponent < 2047) {
                    return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
                }
                return sign == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (scaledExponent < 2047) {
                return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
            }
            return sign == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }

        static int getExponent(double d) {
            return (int)(Double.doubleToRawLongBits(d) >>> 52 & 0x7FFL) - 1023;
        }

        @NeverDefault
        public static AbsNode create() {
            return ComplexBuiltinsFactory.AbsNodeFactory.create();
        }
    }
}

