/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyData;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyLegacyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyMemberAccessNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyObjectBuiltins;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyMode;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyTypeExtra;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIFunctionPointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.frame.GetCurrentFrameRef;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;

public abstract class GraalHPyNodes {
    protected static Object callBuiltinFunction(GraalHPyContext graalHPyContext, TruffleString func, Object[] pythonArguments, ReadAttributeFromObjectNode readAttr, CallNode callNode) {
        Object builtinFunction = readAttr.execute(graalHPyContext.getContext().getBuiltins(), func);
        return callNode.execute(builtinFunction, pythonArguments, PKeyword.EMPTY_KEYWORDS);
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyReadCallFunctionNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, GraalHPyContext var2, Object var3);

        @Specialization
        static Object doIt(GraalHPyContext context, Object def, @CachedLibrary(limit="2") InteropLibrary resultLib, @Cached PCallHPyFunction callHelperFunctionNode, @Cached HPyAttachFunctionTypeNode attachFunctionTypeNode) {
            Object methodFunctionPointer = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_CALL_FUNCTION_GET_IMPL, def);
            if (resultLib.isNull(methodFunctionPointer)) {
                return null;
            }
            if (context.getCurrentMode() != HPyMode.MODE_UNIVERSAL || !resultLib.isExecutable(methodFunctionPointer)) {
                GraalHPyDef.HPySlotWrapper slotWrapper = GraalHPyDef.HPySlot.HPY_TP_CALL.getSignatures()[0];
                methodFunctionPointer = attachFunctionTypeNode.execute(context, methodFunctionPointer, slotWrapper.getLLVMFunctionType());
            }
            return methodFunctionPointer;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=true)
    public static abstract class HPyFieldStoreNode
    extends Node {
        public abstract int execute(Node var1, PythonObject var2, Object var3, Object var4);

        @Specialization
        static int doHandle(Node inliningTarget, PythonObject owner, GraalHPyHandle hpyFieldObject, Object referent, @Cached.Shared @Cached InlinedConditionProfile nullHandleProfile) {
            int idx = hpyFieldObject.getFieldId();
            if (nullHandleProfile.profile(inliningTarget, referent == GraalHPyHandle.NULL_HANDLE_DELEGATE && idx == 0)) {
                return 0;
            }
            return GraalHPyData.setHPyField(owner, referent, idx);
        }

        @Specialization(replaces={"doHandle"})
        static int doGeneric(Node inliningTarget, PythonObject owner, Object hpyFieldObject, Object referent, @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached InlinedConditionProfile nullHandleProfile) {
            int idx;
            if (lib.isNull(hpyFieldObject)) {
                idx = 0;
            } else if (hpyFieldObject instanceof GraalHPyHandle) {
                idx = ((GraalHPyHandle)hpyFieldObject).getFieldId();
            } else {
                if (hpyFieldObject instanceof Long) {
                    try {
                        idx = PInt.intValueExact((Long)hpyFieldObject);
                    }
                    catch (OverflowException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                }
                try {
                    idx = PInt.intValueExact(lib.asPointer(hpyFieldObject));
                }
                catch (OverflowException | InteropException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            if (!nullHandleProfile.profile(inliningTarget, referent == GraalHPyHandle.NULL_HANDLE_DELEGATE && idx == 0)) {
                idx = GraalHPyData.setHPyField(owner, referent, idx);
            }
            return idx;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=true)
    public static abstract class HPyFieldLoadNode
    extends Node {
        public abstract Object execute(Node var1, PythonObject var2, Object var3);

        @Specialization
        static Object doHandle(PythonObject owner, GraalHPyHandle handle) {
            return handle.getDelegate();
        }

        @Specialization(replaces={"doHandle"})
        static Object doGeneric(Node inliningTarget, PythonObject owner, Object hpyFieldPtr, @CachedLibrary(limit="3") InteropLibrary lib, @Cached InlinedExactClassProfile fieldTypeProfile) {
            Object referent;
            Object hpyFieldObject = fieldTypeProfile.profile(inliningTarget, hpyFieldPtr);
            if (hpyFieldObject instanceof GraalHPyHandle) {
                referent = ((GraalHPyHandle)hpyFieldObject).getDelegate();
            } else {
                int idx;
                if (hpyFieldObject instanceof Long) {
                    try {
                        idx = PInt.intValueExact((Long)hpyFieldObject);
                    }
                    catch (OverflowException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                }
                try {
                    idx = PInt.intValueExact(lib.asPointer(hpyFieldObject));
                }
                catch (OverflowException | InteropException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (idx == 0) {
                    return GraalHPyHandle.NULL_HANDLE_DELEGATE;
                }
                referent = GraalHPyData.getHPyField(owner, idx);
            }
            return referent;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyPackKeywordArgsNode
    extends Node {
        public abstract PKeyword[] execute(Node var1, Object[] var2, PTuple var3);

        @Specialization
        static PKeyword[] doPTuple(Node inliningTarget, Object[] kwvalues, PTuple kwnames, @Cached PyTupleSizeNode sizeNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached InlinedLoopConditionProfile loopProfile) {
            int nkw = sizeNode.execute(inliningTarget, kwnames);
            loopProfile.profileCounted(inliningTarget, (long)nkw);
            if (nkw == 0) {
                return PKeyword.EMPTY_KEYWORDS;
            }
            PKeyword[] result = new PKeyword[nkw];
            SequenceStorage storage = kwnames.getSequenceStorage();
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < nkw)) {
                TruffleString name = (TruffleString)getItemNode.execute(inliningTarget, storage, i);
                result[i] = new PKeyword(name, kwvalues[i]);
                ++i;
            }
            return result;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class RecursiveExceptionMatches
    extends Node {
        abstract int execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization
        int tuple(GraalHPyContext context, Object err, PTuple exc, @Cached RecursiveExceptionMatches recExcMatch, @Cached PythonAbstractObject.PInteropSubscriptNode getItemNode, @Cached LoopConditionProfile loopProfile) {
            int len = exc.getSequenceStorage().length();
            int i = 0;
            while (loopProfile.profile(i < len)) {
                Object e = getItemNode.execute(exc, i);
                if (recExcMatch.execute(context, err, e) != 0) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }

        @Specialization(guards={"!isPTuple(exc)", "isTupleSubtype(inliningTarget, exc, getClassNode, isSubtypeNode)"})
        int subtuple(GraalHPyContext context, Object err, Object exc, @Bind(value="this") Node inliningTarget, @Cached RecursiveExceptionMatches recExcMatch, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached ReadAttributeFromObjectNode readAttr, @Cached CallNode callNode, @Cached CastToJavaIntExactNode cast, @Cached PythonAbstractObject.PInteropSubscriptNode getItemNode, @Cached LoopConditionProfile loopProfile) {
            int len = cast.execute(inliningTarget, GraalHPyNodes.callBuiltinFunction(context, BuiltinNames.T_LEN, new Object[]{exc}, readAttr, callNode));
            int i = 0;
            while (loopProfile.profile(i < len)) {
                Object e = getItemNode.execute(exc, i);
                if (recExcMatch.execute(context, err, e) != 0) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }

        @Specialization(guards={"!isPTuple(exc)", "!isTupleSubtype(inliningTarget, exc, getClassNode, isSubtypeNode)"})
        int others(GraalHPyContext context, Object err, Object exc, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached ReadAttributeFromObjectNode readAttr, @Cached CallNode callNode, @Cached PyObjectIsTrueNode isTrueNode, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached IsNode isNode, @Cached BranchProfile isBaseExceptionProfile, @Cached ConditionProfile isExceptionProfile) {
            Object isInstance = GraalHPyNodes.callBuiltinFunction(context, BuiltinNames.T_ISINSTANCE, new Object[]{err, PythonBuiltinClassType.PBaseException}, readAttr, callNode);
            Object e = err;
            if (isTrueNode.execute(null, inliningTarget, isInstance)) {
                isBaseExceptionProfile.enter();
                e = getClassNode.execute(inliningTarget, err);
            }
            if (isExceptionProfile.profile(RecursiveExceptionMatches.isExceptionClass(context, inliningTarget, e, isTypeNode, readAttr, callNode, isTrueNode) && RecursiveExceptionMatches.isExceptionClass(context, inliningTarget, exc, isTypeNode, readAttr, callNode, isTrueNode))) {
                return RecursiveExceptionMatches.isSubClass(context, inliningTarget, e, exc, readAttr, callNode, isTrueNode) ? 1 : 0;
            }
            return isNode.execute(exc, e) ? 1 : 0;
        }

        protected boolean isTupleSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PTuple);
        }

        static boolean isSubClass(GraalHPyContext graalHPyContext, Node inliningTarget, Object derived, Object cls, ReadAttributeFromObjectNode readAttr, CallNode callNode, PyObjectIsTrueNode isTrueNode) {
            return isTrueNode.execute(null, inliningTarget, GraalHPyNodes.callBuiltinFunction(graalHPyContext, BuiltinNames.T_ISSUBCLASS, new Object[]{derived, cls}, readAttr, callNode));
        }

        private static boolean isExceptionClass(GraalHPyContext nativeContext, Node inliningTarget, Object obj, TypeNodes.IsTypeNode isTypeNode, ReadAttributeFromObjectNode readAttr, CallNode callNode, PyObjectIsTrueNode isTrueNode) {
            return isTypeNode.execute(inliningTarget, obj) && RecursiveExceptionMatches.isSubClass(nativeContext, inliningTarget, obj, (Object)PythonBuiltinClassType.PBaseException, readAttr, callNode, isTrueNode);
        }
    }

    @GenerateUncached
    public static abstract class HPyAttachJNIFunctionTypeNode
    extends HPyAttachFunctionTypeNode {
        @Specialization
        static GraalHPyJNIFunctionPointer doGeneric(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
            if (!interopLibrary.isPointer(pointerObject)) {
                interopLibrary.toNative(pointerObject);
            }
            try {
                return new GraalHPyJNIFunctionPointer(interopLibrary.asPointer(pointerObject), llvmFunctionType, hpyContext.getCurrentMode());
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    @GenerateUncached
    public static abstract class HPyAttachNFIFunctionTypeNode
    extends HPyAttachFunctionTypeNode {
        private static final String J_NFI_LANGUAGE = "nfi";

        @Specialization(guards={"isSingleContext()", "llvmFunctionType == cachedType"}, limit="3")
        static Object doCachedSingleContext(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @Cached(value="llvmFunctionType") GraalHPyContext.LLVMType cachedType, @Cached(value="getNFISignature(hpyContext, llvmFunctionType)") Object nfiSignature, @CachedLibrary(value="nfiSignature") SignatureLibrary signatureLibrary) {
            return signatureLibrary.bind(nfiSignature, pointerObject);
        }

        @Specialization(guards={"llvmFunctionType == cachedType"}, limit="3", replaces={"doCachedSingleContext"})
        static Object doCached(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @Cached(value="llvmFunctionType") GraalHPyContext.LLVMType cachedType, @Cached(value="getNFISignatureCallTarget(hpyContext, llvmFunctionType)") CallTarget nfiSignatureCt, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
            return signatureLibrary.bind(nfiSignatureCt.call(new Object[0]), pointerObject);
        }

        @Specialization(replaces={"doCachedSingleContext", "doCached"})
        static Object doGeneric(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
            return signatureLibrary.bind(HPyAttachNFIFunctionTypeNode.getNFISignature(hpyContext, llvmFunctionType), pointerObject);
        }

        @CompilerDirectives.TruffleBoundary
        static Object getNFISignature(GraalHPyContext hpyContext, GraalHPyContext.LLVMType llvmFunctionType) {
            return hpyContext.getContext().getEnv().parseInternal(HPyAttachNFIFunctionTypeNode.getNFISignatureSource(llvmFunctionType), new String[0]).call(new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        static CallTarget getNFISignatureCallTarget(GraalHPyContext hpyContext, GraalHPyContext.LLVMType llvmFunctionType) {
            return hpyContext.getContext().getEnv().parseInternal(HPyAttachNFIFunctionTypeNode.getNFISignatureSource(llvmFunctionType), new String[0]);
        }

        @CompilerDirectives.TruffleBoundary
        static Source getNFISignatureSource(GraalHPyContext.LLVMType llvmFunctionType) {
            return Source.newBuilder((String)J_NFI_LANGUAGE, (CharSequence)HPyAttachNFIFunctionTypeNode.getNFISignatureSourceString(llvmFunctionType), (String)llvmFunctionType.name()).build();
        }

        private static String getNFISignatureSourceString(GraalHPyContext.LLVMType llvmFunctionType) {
            switch (llvmFunctionType) {
                case HPyModule_init: {
                    return "(POINTER): POINTER";
                }
                case HPyFunc_noargs: 
                case HPyFunc_unaryfunc: 
                case HPyFunc_getiterfunc: 
                case HPyFunc_iternextfunc: 
                case HPyFunc_reprfunc: {
                    return "(POINTER, POINTER): POINTER";
                }
                case HPyFunc_binaryfunc: 
                case HPyFunc_o: 
                case HPyFunc_getter: 
                case HPyFunc_getattrfunc: 
                case HPyFunc_getattrofunc: {
                    return "(POINTER, POINTER, POINTER): POINTER";
                }
                case HPyFunc_varargs: {
                    return "(POINTER, POINTER, POINTER, SINT64): POINTER";
                }
                case HPyFunc_keywords: {
                    return "(POINTER, POINTER, POINTER, SINT64, POINTER): POINTER";
                }
                case HPyFunc_ternaryfunc: 
                case HPyFunc_descrgetfunc: {
                    return "(POINTER, POINTER, POINTER, POINTER): POINTER";
                }
                case HPyFunc_inquiry: {
                    return "(POINTER, POINTER): SINT32";
                }
                case HPyFunc_lenfunc: 
                case HPyFunc_hashfunc: {
                    return "(POINTER, POINTER): SINT64";
                }
                case HPyFunc_ssizeargfunc: {
                    return "(POINTER, POINTER, SINT64): POINTER";
                }
                case HPyFunc_ssizessizeargfunc: {
                    return "(POINTER, POINTER, SINT64, SINT64): POINTER";
                }
                case HPyFunc_ssizeobjargproc: {
                    return "(POINTER, POINTER, SINT64, POINTER): SINT32";
                }
                case HPyFunc_initproc: {
                    return "(POINTER, POINTER, POINTER, SINT64, POINTER): SINT32";
                }
                case HPyFunc_ssizessizeobjargproc: {
                    return "(POINTER, POINTER, SINT64, SINT64, POINTER): SINT32";
                }
                case HPyFunc_objobjargproc: 
                case HPyFunc_setter: 
                case HPyFunc_descrsetfunc: 
                case HPyFunc_setattrfunc: 
                case HPyFunc_setattrofunc: {
                    return "(POINTER, POINTER, POINTER, POINTER): SINT32";
                }
                case HPyFunc_freefunc: {
                    return "(POINTER, POINTER): VOID";
                }
                case HPyFunc_richcmpfunc: {
                    return "(POINTER, POINTER, POINTER, SINT32): POINTER";
                }
                case HPyFunc_objobjproc: {
                    return "(POINTER, POINTER, POINTER): SINT32";
                }
                case HPyFunc_getbufferproc: {
                    return "(POINTER, POINTER, POINTER, SINT32): SINT32";
                }
                case HPyFunc_releasebufferproc: {
                    return "(POINTER, POINTER, POINTER): VOID";
                }
                case HPyFunc_destroyfunc: {
                    return "(POINTER): VOID";
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    static abstract class HPyAttachFunctionTypeNode
    extends PNodeWithContext {
        HPyAttachFunctionTypeNode() {
        }

        public abstract Object execute(GraalHPyContext var1, Object var2, GraalHPyContext.LLVMType var3);

        @NeverDefault
        public static HPyAttachFunctionTypeNode create() {
            PythonLanguage language = PythonLanguage.get(null);
            if (language.getEngineOption(PythonOptions.HPyBackend) == PythonOptions.HPyBackendMode.JNI) {
                return GraalHPyNodesFactory.HPyAttachJNIFunctionTypeNodeGen.create();
            }
            assert (language.getEngineOption(PythonOptions.HPyBackend) == PythonOptions.HPyBackendMode.NFI);
            return GraalHPyNodesFactory.HPyAttachNFIFunctionTypeNodeGen.create();
        }

        public static HPyAttachFunctionTypeNode getUncached() {
            PythonLanguage language = PythonLanguage.get(null);
            if (language.getEngineOption(PythonOptions.HPyBackend) == PythonOptions.HPyBackendMode.JNI) {
                return GraalHPyNodesFactory.HPyAttachJNIFunctionTypeNodeGen.getUncached();
            }
            assert (language.getEngineOption(PythonOptions.HPyBackend) == PythonOptions.HPyBackendMode.NFI);
            return GraalHPyNodesFactory.HPyAttachNFIFunctionTypeNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class HPyGetNativeSpacePointerNode
    extends Node {
        public abstract Object execute(Object var1);

        @Specialization
        static Object doPythonObject(PythonObject object) {
            return GraalHPyData.getHPyNativeSpace(object);
        }

        @Fallback
        Object doOther(Object object) {
            return PythonContext.get(this).getNativeNull();
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class HPyTypeGetNameNode
    extends Node {
        public abstract Object execute(Object var1);

        @Specialization(guards={"tpName != null"})
        static Object doPythonClass(PythonClass clazz, @Bind(value="clazz.getTpName()") Object tpName) {
            return tpName;
        }

        @Fallback
        static Object doOther(Object type, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetNameNode getName, @Cached ReadAttributeFromObjectNode readModuleNameNode, @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode, @Cached TruffleStringBuilder.AppendStringNode appendNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleString name;
            PythonClass pythonClass;
            TruffleString baseName = getName.execute(inliningTarget, type);
            if (type instanceof PythonClass && (pythonClass = (PythonClass)type).isHPyType()) {
                Object moduleName = readModuleNameNode.execute(type, SpecialAttributeNames.T___MODULE__);
                if (moduleName instanceof TruffleString) {
                    TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                    appendNode.execute(sb, (AbstractTruffleString)((TruffleString)moduleName));
                    appendNode.execute(sb, (AbstractTruffleString)StringLiterals.T_DOT);
                    appendNode.execute(sb, (AbstractTruffleString)baseName);
                    name = toStringNode.execute(sb);
                } else {
                    name = baseName;
                }
            } else {
                name = baseName;
            }
            byte[] result = encodeNativeStringNode.execute(StandardCharsets.UTF_8, name, StringLiterals.T_STRICT);
            return new CArrayWrappers.CByteArrayWrapper(result);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HPyTypeSplitNameNode
    extends Node {
        HPyTypeSplitNameNode() {
        }

        public abstract TruffleString[] execute(Node var1, TruffleString var2);

        @Specialization
        static TruffleString[] doGeneric(TruffleString specNameUtf8, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.LastIndexOfCodePointNode indexOfCodepointNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleString.CodePointLengthNode lengthNode) {
            int length;
            TruffleString specName = switchEncodingNode.execute((AbstractTruffleString)specNameUtf8, PythonUtils.TS_ENCODING);
            int firstDotIdx = indexOfCodepointNode.execute((AbstractTruffleString)specName, 46, length = lengthNode.execute((AbstractTruffleString)specName, PythonUtils.TS_ENCODING), 0, PythonUtils.TS_ENCODING);
            if (firstDotIdx > -1) {
                TruffleString left = substringNode.execute((AbstractTruffleString)specName, 0, firstDotIdx, PythonUtils.TS_ENCODING, false);
                TruffleString right = substringNode.execute((AbstractTruffleString)specName, firstDotIdx + 1, length - firstDotIdx - 1, PythonUtils.TS_ENCODING, false);
                return new TruffleString[]{left, right};
            }
            return new TruffleString[]{null, specName};
        }
    }

    @ImportStatic(value={SpecialMethodSlot.class})
    @GenerateUncached
    static abstract class HPyCreateTypeFromSpecNode
    extends Node {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(HPyCreateTypeFromSpecNode.class);
        static final TruffleString T_PYTRUFFLE_CREATETYPE = PythonUtils.tsLiteral("PyTruffle_CreateType");

        HPyCreateTypeFromSpecNode() {
        }

        abstract Object execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization
        Object doGeneric(GraalHPyContext context, Object typeSpec, Object typeSpecParamArray, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary ptrLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached HPyTypeSplitNameNode splitName, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached PythonObjectFactory factory, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached TypeNodes.HasSameConstructorNode hasSameConstructorNode, @Cached PCallHPyFunction callHelperFunctionNode, @Cached PCallHPyFunction callMallocNode, @Cached CStructAccess.ReadI64Node getMetaSizeNode, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached WriteAttributeToObjectNode writeAttributeToObjectNode, @Cached PyObjectCallMethodObjArgs callCreateTypeNode, @Cached CastToJavaIntLossyNode castToJavaIntNode, @Cached HPyCreateFunctionNode addFunctionNode, @Cached HPyAddMemberNode addMemberNode, @Cached HPyCreateSlotNode addSlotNode, @Cached HPyCreateLegacySlotNode createLegacySlotNode, @Cached HPyCreateGetSetDescriptorNode createGetSetDescriptorNode, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached ReadAttributeFromObjectNode readHPyTypeFlagsNode, @Cached(parameters={"New"}) LookupCallableSlotInMRONode lookupNewNode, @Cached HPyAsPythonObjectNode hPyAsPythonObjectNode, @Cached PRaiseNode raiseNode) {
            try {
                long baseFlags;
                HPyProperty property;
                TruffleString value;
                HPyTypeSpecParam[] typeSpecParams;
                PDict namespace;
                Object specNamePtr = ptrLib.readMember(typeSpec, "name");
                Object tpName = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_TYPE_NAME, specNamePtr);
                TruffleString specName = fromCharPointerNode.execute(specNamePtr, false);
                TruffleString[] names = splitName.execute(inliningTarget, specName);
                assert (names.length == 2);
                Object doc = ptrLib.readMember(typeSpec, "doc");
                if (!ptrLib.isNull(doc)) {
                    TruffleString docString = castToTruffleStringNode.execute(inliningTarget, fromCharPointerNode.execute(doc));
                    namespace = factory.createDict(new PKeyword[]{new PKeyword(SpecialAttributeNames.T___DOC__, docString)});
                } else {
                    namespace = factory.createDict();
                }
                try {
                    typeSpecParams = HPyCreateTypeFromSpecNode.extractTypeSpecParams(inliningTarget, context, typeSpecParamArray, ptrLib, castToJavaIntNode, callHelperFunctionNode, hPyAsPythonObjectNode);
                }
                catch (OverflowException | InteropException e) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.FAILED_TO_EXTRACT_BASES_FROM_TYPE_SPEC_PARAMS, specName);
                }
                PTuple bases = HPyCreateTypeFromSpecNode.extractBases(typeSpecParams, factory);
                Object metatype = HPyCreateTypeFromSpecNode.getMetatype(typeSpecParams, raiseNode);
                if (metatype != null) {
                    if (!isTypeNode.execute(inliningTarget, metatype)) {
                        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_METACLASS_IS_NOT_A_TYPE, metatype);
                    }
                    if (!hasSameConstructorNode.execute(inliningTarget, metatype, (Object)PythonBuiltinClassType.PythonClass)) {
                        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_METACLASS_WITH_CUSTOM_CONS_NOT_SUPPORTED);
                    }
                }
                PythonModule pythonCextModule = PythonContext.get(this).lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__);
                PythonClass newType = (PythonClass)callCreateTypeNode.execute(null, inliningTarget, pythonCextModule, T_PYTRUFFLE_CREATETYPE, names[1], bases, namespace, metatype != null ? metatype : PythonBuiltinClassType.PythonClass);
                long metaBasicSize = 0L;
                Object destroyFunc = null;
                if (metatype instanceof PythonClass) {
                    PythonClass metaclass = (PythonClass)metatype;
                    metaBasicSize = metaclass.getBasicSize();
                    destroyFunc = metaclass.getHPyDestroyFunc();
                } else if (metatype instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject nativeObject = (PythonAbstractNativeObject)metatype;
                    metaBasicSize = getMetaSizeNode.readFromObj(nativeObject, CFields.PyTypeObject__tp_basicsize);
                }
                if (metaBasicSize > 0L) {
                    Object dataPtr = callMallocNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_CALLOC, metaBasicSize, 1L);
                    GraalHPyData.setHPyNativeSpace(newType, dataPtr);
                    if (destroyFunc != null) {
                        context.createHandleReference(newType, dataPtr, destroyFunc != PNone.NO_VALUE ? destroyFunc : null);
                    }
                }
                if ((value = names[0]) != null) {
                    writeAttributeToObjectNode.execute((Object)newType, SpecialAttributeNames.T___MODULE__, (Object)value);
                }
                long flags = HPyCreateTypeFromSpecNode.castToLong(valueLib, ptrLib.readMember(typeSpec, "flags"));
                int builtinShape = HPyCreateTypeFromSpecNode.castToInt(valueLib, callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_TYPE_SPEC_GET_BUILTIN_SHAPE, typeSpec));
                if (!GraalHPyDef.isValidBuiltinShape(builtinShape)) {
                    throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.HPY_INVALID_BUILTIN_SHAPE, builtinShape);
                }
                long basicSize = HPyCreateTypeFromSpecNode.castToLong(valueLib, ptrLib.readMember(typeSpec, "basicsize"));
                long itemSize = HPyCreateTypeFromSpecNode.castToLong(valueLib, ptrLib.readMember(typeSpec, "itemsize"));
                newType.setHPyTypeExtra(new HPyTypeExtra(flags, basicSize, itemSize, tpName, builtinShape));
                newType.makeStaticBase(dylib);
                boolean seenNew = false;
                boolean needsTpTraverse = (flags & 0x4000L) != 0L;
                Object defines = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_TYPE_SPEC_GET_DEFINES, typeSpec);
                if (!ptrLib.isNull(defines)) {
                    if (!ptrLib.hasArrayElements(defines)) {
                        return raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.FIELD_DEFINES_DID_NOT_RETURN_ARRAY, specName);
                    }
                    int nDefines = PInt.intValueExact(ptrLib.getArraySize(defines));
                    for (long i = 0L; i < (long)nDefines; ++i) {
                        Object moduleDefine = ptrLib.readArrayElement(defines, i);
                        property = null;
                        int kind = castToJavaIntNode.execute(inliningTarget, callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_KIND, moduleDefine));
                        switch (kind) {
                            case 2: {
                                Object methodDef = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_METH, moduleDefine);
                                PBuiltinFunction fun = addFunctionNode.execute(context, newType, methodDef);
                                property = new HPyProperty(fun.getName(), fun);
                                break;
                            }
                            case 1: {
                                Object slotDef = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_SLOT, moduleDefine);
                                Object addSlotResult = addSlotNode.execute(context, newType, slotDef);
                                if (GraalHPyDef.HPySlot.HPY_TP_TRAVERSE.equals(addSlotResult)) {
                                    needsTpTraverse = false;
                                } else if (addSlotResult instanceof HPyProperty) {
                                    property = (HPyProperty)addSlotResult;
                                }
                                if (property == null || !SpecialMethodNames.T___NEW__.equals(property.key)) break;
                                seenNew = true;
                                break;
                            }
                            case 3: {
                                Object memberDef = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_MEMBER, moduleDefine);
                                property = addMemberNode.execute(context, newType, memberDef);
                                break;
                            }
                            case 4: {
                                Object getsetDef = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_GETSET, moduleDefine);
                                GetSetDescriptor getSetDescriptor = createGetSetDescriptorNode.execute(context, newType, getsetDef);
                                property = new HPyProperty(getSetDescriptor.getName(), getSetDescriptor);
                                break;
                            }
                            default: {
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.severe(PythonUtils.formatJString("unknown definition kind: %d", kind));
                                }
                                assert (false);
                                break;
                            }
                        }
                        if (property == null) continue;
                        property.write(writeAttributeToObjectNode, readAttributeFromObjectNode, newType);
                    }
                }
                if (newType.getHPyVectorcallOffset() != Long.MIN_VALUE && newType.getHPyDefaultCallFunc() != null) {
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_HAVE_CALL_AND_VECTORCALLOFFSET);
                }
                if (needsTpTraverse) {
                    throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TRAVERSE_FUNCTION_NEEDED);
                }
                Object legacySlots = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_TYPE_SPEC_GET_LEGECY_SLOTS, typeSpec);
                if (!ptrLib.isNull(legacySlots)) {
                    if (builtinShape != -1) {
                        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_SPECIFY_LEG_SLOTS_WO_SETTING_LEG);
                    }
                    int nLegacySlots = PInt.intValueExact(ptrLib.getArraySize(legacySlots));
                    for (int i = 0; i < nLegacySlots; ++i) {
                        Object legacySlotDef = ptrLib.readArrayElement(legacySlots, (long)i);
                        property = createLegacySlotNode.execute(context, newType, legacySlotDef);
                        if (property == null) continue;
                        property.write(writeAttributeToObjectNode, readAttributeFromObjectNode, newType);
                    }
                }
                Object baseClass = getBaseClassNode.execute(inliningTarget, newType);
                if (!(seenNew || basicSize <= 0L && newType.getHPyDefaultCallFunc() == null)) {
                    Object inheritedConstructor = null;
                    inheritedConstructor = lookupNewNode.execute(baseClass);
                    PBuiltinFunction constructorDecorator = GraalHPyObjectBuiltins.HPyObjectNewNode.createBuiltinFunction(PythonLanguage.get(raiseNode), inheritedConstructor, builtinShape);
                    writeAttributeToObjectNode.execute((Object)newType, SpecialMethodNames.T___NEW__, (Object)constructorDecorator);
                }
                if (baseClass instanceof PythonClass) {
                    PythonClass pythonBaseClass = (PythonClass)baseClass;
                    baseFlags = pythonBaseClass.getFlags();
                } else {
                    Object baseFlagsObj = readHPyTypeFlagsNode.execute(baseClass, GraalHPyDef.TYPE_HPY_FLAGS);
                    baseFlags = baseFlagsObj != PNone.NO_VALUE ? (Long)baseFlagsObj : 0L;
                }
                int baseBuiltinShape = GraalHPyDef.getBuiltinShapeFromHiddenAttribute(baseClass);
                HPyCreateTypeFromSpecNode.checkInheritanceConstraints(flags, baseFlags, builtinShape, baseBuiltinShape > -1, raiseNode);
                return newType;
            }
            catch (CannotCastException | InteropException e) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.COULD_NOT_CREATE_TYPE_FROM_SPEC_BECAUSE, e);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.COULD_NOT_CREATE_TYPE_FROM_SPEC_TOO_MANY);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static HPyTypeSpecParam[] extractTypeSpecParams(Node inliningTarget, GraalHPyContext context, Object typeSpecParamArray, InteropLibrary ptrLib, CastToJavaIntLossyNode castToJavaIntNode, PCallHPyFunction callHelperFunctionNode, HPyAsPythonObjectNode asPythonObjectNode) throws InteropException, OverflowException {
            if (ptrLib.isNull(typeSpecParamArray)) {
                return null;
            }
            int nSpecParam = PInt.intValueExact(ptrLib.getArraySize(typeSpecParamArray));
            HPyTypeSpecParam[] result = new HPyTypeSpecParam[nSpecParam];
            for (int i = 0; i < nSpecParam; ++i) {
                Object specParam = ptrLib.readArrayElement(typeSpecParamArray, (long)i);
                int specParamKind = castToJavaIntNode.execute(inliningTarget, callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_TYPE_SPEC_PARAM_GET_KIND, specParam));
                Object specParamObject = asPythonObjectNode.execute(callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_TYPE_SPEC_PARAM_GET_OBJECT, specParam));
                result[i] = new HPyTypeSpecParam(specParamKind, specParamObject);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private static PTuple extractBases(HPyTypeSpecParam[] typeSpecParams, PythonObjectFactory factory) {
            if (typeSpecParams == null) {
                return factory.createEmptyTuple();
            }
            ArrayList<Object> basesList = new ArrayList<Object>();
            block5: for (HPyTypeSpecParam typeSpecParam : typeSpecParams) {
                switch (typeSpecParam.kind()) {
                    case 1: {
                        assert (PGuards.isClassUncached(typeSpecParam.object())) : "base object is not a Python class";
                        basesList.add(typeSpecParam.object());
                        continue block5;
                    }
                    case 2: {
                        assert (PGuards.isPTuple(typeSpecParam.object())) : "type spec param claims to be a tuple but isn't";
                        return (PTuple)typeSpecParam.object();
                    }
                    case 3: {
                        continue block5;
                    }
                    default: {
                        assert (false) : "unknown type spec param kind";
                        continue block5;
                    }
                }
            }
            return factory.createTuple(basesList.toArray());
        }

        @CompilerDirectives.TruffleBoundary
        private static Object getMetatype(HPyTypeSpecParam[] typeSpecParams, PRaiseNode raiseNode) {
            Object result = null;
            if (typeSpecParams != null) {
                for (HPyTypeSpecParam typeSpecParam : typeSpecParams) {
                    if (typeSpecParam.kind() != 3) continue;
                    if (result != null) {
                        throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.HPY_METACLASS_SPECIFIED_MULTIPLE_TIMES);
                    }
                    result = typeSpecParam.object();
                    if (TypeNodes.IsTypeNode.executeUncached(result)) continue;
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_METACLASS_IS_NOT_A_TYPE, result);
                }
            }
            return result;
        }

        private static void checkInheritanceConstraints(long flags, long baseFlags, int builtinShape, boolean baseIsPure, PRaiseNode raiseNode) {
            assert (GraalHPyDef.isValidBuiltinShape(builtinShape));
            if (builtinShape == -1 && baseIsPure) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.LEG_TYPE_SHOULDNT_INHERIT_MEM_LAYOUT_FROM_PURE_TYPE);
            }
        }

        private static long castToLong(InteropLibrary lib, Object value) throws OverflowException {
            if (lib.fitsInLong(value)) {
                try {
                    return lib.asLong(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw OverflowException.INSTANCE;
        }

        private static int castToInt(InteropLibrary lib, Object value) {
            if (lib.fitsInInt(value)) {
                try {
                    return lib.asInt(value);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @CompilerDirectives.ValueType
    record HPyTypeSpecParam(int kind, Object object) {
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HPyLongFromLong
    extends Node {
        HPyLongFromLong() {
        }

        public abstract Object execute(Node var1, int var2, boolean var3);

        public abstract Object execute(Node var1, long var2, boolean var4);

        public abstract Object execute(Node var1, Object var2, boolean var3);

        @Specialization(guards={"signed"})
        static int doSignedInt(int n, boolean signed) {
            return n;
        }

        @Specialization(guards={"!signed"})
        static long doUnsignedInt(int n, boolean signed) {
            if (n < 0) {
                return (long)n & 0xFFFFFFFFL;
            }
            return n;
        }

        @Specialization(guards={"signed"})
        static long doSignedLong(long n, boolean signed) {
            return n;
        }

        @Specialization(guards={"!signed", "n >= 0"})
        static long doUnsignedLongPositive(long n, boolean signed) {
            return n;
        }

        @Specialization(guards={"!signed", "n < 0"})
        static Object doUnsignedLongNegative(long n, boolean signed, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return factory.createInt(HPyLongFromLong.convertToBigInteger(n));
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger convertToBigInteger(long n) {
            return BigInteger.valueOf(n).add(BigInteger.ONE.shiftLeft(64));
        }

        @Specialization
        static Object doPointer(PythonNativeObject n, boolean signed, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return factory.createNativeVoidPtr(n.getPtr());
        }
    }

    public static abstract class HPyReleaseBufferProcToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConversion(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPyGetBufferProcToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConversion(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode, @Cached CExtCommonNodes.AsNativePrimitiveNode asIntNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
            dest[destOffset + 2] = asIntNode.execute(args[argsOffset + 2], 1, 4, true);
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPyRichcmptFuncArgsCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(dest[destOffset]);
            closeSecondHandleNode.execute(dest[destOffset + 1]);
        }
    }

    public static abstract class HPyRichcmpFuncArgsToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asHandleNode.execute(args[argsOffset + 1]);
            dest[destOffset + 2] = args[argsOffset + 2];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyRichcmptFuncArgsCloseNodeGen.create();
        }
    }

    public static abstract class HPySSizeObjArgProcCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(dest[destOffset]);
            closeSecondHandleNode.execute(dest[destOffset + 2]);
        }
    }

    public static abstract class HPySSizeObjArgProcToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asSsizeTNode.execute(args[argsOffset + 1], 1, 8);
            dest[destOffset + 2] = asHandleNode.execute(args[argsOffset + 2]);
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySSizeObjArgProcCloseNodeGen.create();
        }
    }

    public static abstract class HPySSizeArgFuncToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization(guards={"isArity(args.length, argsOffset, 2)"})
        static void doHandleSsizeT(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asSsizeTNode.execute(args[argsOffset + 1], 1, 8);
        }

        @Specialization(guards={"isArity(args.length, argsOffset, 3)"})
        static void doHandleSsizeTSsizeT(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asSsizeTNode.execute(args[argsOffset + 1], 1, 8);
            dest[destOffset + 2] = asSsizeTNode.execute(args[argsOffset + 2], 1, 8);
        }

        @Specialization(replaces={"doHandleSsizeT", "doHandleSsizeTSsizeT"})
        static void doGeneric(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            for (int i = 1; i < args.length - argsOffset; ++i) {
                dest[destOffset + i] = asSsizeTNode.execute(args[argsOffset + i], 1, 8);
            }
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }

        static boolean isArity(int len, int off, int expected) {
            return len - off == expected;
        }
    }

    public static abstract class HPyLegacyGetSetSetterDecrefNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Cached CExtNodes.SubRefCntNode subRefCntNode) {
            subRefCntNode.dec(dest[destOffset + 1]);
        }
    }

    public static abstract class HPyGetSetSetterHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(dest[destOffset]);
            closeSecondHandleNode.execute(dest[destOffset + 1]);
        }
    }

    public static abstract class HPyGetSetSetterToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode) {
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asHandleNode.execute(args[argsOffset + 1]);
            dest[destOffset + 2] = args[argsOffset + 2];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyGetSetSetterHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPyGetSetGetterToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode selfAsHandleNode) {
            dest[destOffset] = selfAsHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPyAllHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization(guards={"dest.length == destOffset"})
        static void cached0(Object[] dest, int destOffset) {
        }

        @Specialization(guards={"dest.length == cachedLength", "isLeArgsOffsetPlus(cachedLength, destOffset, 8)"}, limit="1", replaces={"cached0"})
        @ExplodeLoop
        static void cachedLoop(Object[] dest, int destOffset, @Cached(value="dest.length") int cachedLength, @Cached HPyCloseHandleNode closeHandleNode) {
            CompilerAsserts.partialEvaluationConstant((int)destOffset);
            for (int i = 0; i < cachedLength - destOffset; ++i) {
                closeHandleNode.execute(dest[destOffset + i]);
            }
        }

        @Specialization(replaces={"cached0", "cachedLoop"})
        static void uncached(Object[] dest, int destOffset, @Cached HPyCloseHandleNode closeHandleNode) {
            int len = dest.length;
            for (int i = 0; i < len - destOffset; ++i) {
                closeHandleNode.execute(dest[destOffset + i]);
            }
        }

        static boolean isLeArgsOffsetPlus(int len, int off, int plus) {
            return len < plus + off;
        }
    }

    public static abstract class HPyAllAsHandleNode
    extends HPyConvertArgsToSulongNode {
        static boolean isArgsOffsetPlus(int len, int off, int plus) {
            return len == off + plus;
        }

        static boolean isLeArgsOffsetPlus(int len, int off, int plus) {
            return len < plus + off;
        }

        @Specialization(guards={"args.length == argsOffset"})
        static void cached0(Object[] args, int argsOffset, Object[] dest, int destOffset) {
        }

        @Specialization(guards={"args.length == cachedLength", "isLeArgsOffsetPlus(cachedLength, argsOffset, 8)"}, limit="1", replaces={"cached0"})
        @ExplodeLoop
        static void cachedLoop(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached(value="args.length") int cachedLength, @Cached HPyAsHandleNode toSulongNode) {
            CompilerAsserts.partialEvaluationConstant((int)destOffset);
            for (int i = 0; i < cachedLength - argsOffset; ++i) {
                dest[destOffset + i] = toSulongNode.execute(args[argsOffset + i]);
            }
        }

        @Specialization(replaces={"cached0", "cachedLoop"})
        static void uncached(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode toSulongNode) {
            int len = args.length;
            for (int i = 0; i < len - argsOffset; ++i) {
                dest[destOffset + i] = toSulongNode.execute(args[argsOffset + i]);
            }
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyAllHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPyKeywordsHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(dest[destOffset]);
            closeSecondHandleNode.execute(dest[destOffset + 3]);
        }
    }

    public static abstract class HPyKeywordsToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode selfAsHandleNode, @Cached HPyAsHandleNode kwAsHandleNode) {
            dest[destOffset] = selfAsHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
            dest[destOffset + 2] = args[argsOffset + 2];
            dest[destOffset + 3] = kwAsHandleNode.execute(args[argsOffset + 3]);
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyKeywordsHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPySelfHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Cached HPyCloseHandleNode closeHandleNode) {
            closeHandleNode.execute(dest[destOffset]);
        }
    }

    public static abstract class HPyVarargsHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeHandleNode) {
            closeHandleNode.execute(dest[destOffset]);
        }
    }

    public static abstract class HPyVarargsToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode selfAsHandleNode) {
            dest[destOffset] = selfAsHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
            dest[destOffset + 2] = args[argsOffset + 2];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyVarargsHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPyCloseArgHandlesNode
    extends PNodeWithContext {
        public abstract void executeInto(VirtualFrame var1, Object[] var2, int var3);
    }

    public static abstract class HPyConvertArgsToSulongNode
    extends PNodeWithContext {
        public abstract void executeInto(VirtualFrame var1, Object[] var2, int var3, Object[] var4, int var5);

        abstract HPyCloseArgHandlesNode createCloseHandleNode();
    }

    @GenerateUncached
    public static abstract class HPyAsNativeInt64Node
    extends CExtToNativeNode {
        @Specialization
        Object doGeneric(Object value, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(value, 1, 8);
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class HPyAsHandleNode
    extends CExtToNativeNode {
        protected static final byte HANDLE = 0;
        protected static final byte GLOBAL = 1;
        protected static final byte FIELD = 2;

        @Override
        public final GraalHPyHandle execute(Object object) {
            return this.execute(object, 0, 0);
        }

        public final GraalHPyHandle executeGlobal(Object object, int id) {
            return this.execute(object, id, 1);
        }

        public final GraalHPyHandle executeField(Object object, int id) {
            return this.execute(object, id, 2);
        }

        protected abstract GraalHPyHandle execute(Object var1, int var2, int var3);

        @Specialization(guards={"isNoValue(object)"})
        static GraalHPyHandle doNoValue(PNone object, int id, int type) {
            return GraalHPyHandle.NULL_HANDLE;
        }

        @Specialization(guards={"!isNoValue(object)", "type == HANDLE"})
        GraalHPyHandle doObject(Object object, int id, int type) {
            return this.getContext().getHPyContext().createHandle(object);
        }

        @Specialization(guards={"!isNoValue(object)", "type == GLOBAL"})
        static GraalHPyHandle doGlobal(Object object, int id, int type) {
            return GraalHPyHandle.createGlobal(object, id);
        }

        @Specialization(guards={"!isNoValue(object)", "type == FIELD"})
        GraalHPyHandle doField(Object object, int id, int type) {
            return this.getContext().getHPyContext().createField(object, id);
        }
    }

    public static final class HPyDummyToJavaNode
    extends CExtToJavaNode {
        private static final HPyDummyToJavaNode UNCACHED = new HPyDummyToJavaNode();

        public static HPyDummyToJavaNode create() {
            return new HPyDummyToJavaNode();
        }

        public static HPyDummyToJavaNode getUncached() {
            return UNCACHED;
        }

        @Override
        public Object execute(Object object) {
            return object;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this != UNCACHED;
        }
    }

    @GenerateUncached
    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyAsPythonObjectNode
    extends CExtToJavaNode {
        public abstract Object execute(long var1);

        @Specialization
        static Object doHandle(GraalHPyHandle handle) {
            return handle.getDelegate();
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static Object doNullLong(long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        Object doLong(long bits) {
            return this.getContext().getHPyContext().getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        }

        @Specialization(guards={"isBoxedDouble(bits)"})
        static double doLongDouble(long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"isBoxedInt(bits)"})
        static int doLongInt(long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }

        static long asPointer(Object handle, InteropLibrary lib) {
            try {
                return lib.asPointer(handle);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static Object doNullOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        Object doOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return this.getContext().getHPyContext().getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedDouble(bits)"})
        static double doOtherDouble(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedInt(bits)"})
        static int doOtherInt(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }

        @Specialization(replaces={"doHandle", "doNullLong", "doLong", "doLongDouble", "doLongInt", "doNullOther", "doOther", "doOtherDouble", "doOtherInt"})
        Object doGeneric(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib) {
            long bits;
            if (value instanceof GraalHPyHandle) {
                return ((GraalHPyHandle)value).getDelegate();
            }
            if (value instanceof Long) {
                bits = (Long)value;
            } else {
                lib.toNative(value);
                try {
                    bits = lib.asPointer(value);
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                }
            }
            if (GraalHPyBoxing.isBoxedNullHandle(bits)) {
                return GraalHPyHandle.NULL_HANDLE_DELEGATE;
            }
            if (GraalHPyBoxing.isBoxedInt(bits)) {
                return GraalHPyBoxing.unboxInt(bits);
            }
            if (GraalHPyBoxing.isBoxedDouble(bits)) {
                return GraalHPyBoxing.unboxDouble(bits);
            }
            assert (GraalHPyBoxing.isBoxedHandle(bits));
            return this.getContext().getHPyContext().getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        }
    }

    @GenerateUncached
    public static abstract class HPyCloseAndGetHandleNode
    extends HPyWithContextNode {
        public abstract Object execute(Object var1);

        public abstract Object execute(long var1);

        @Specialization(guards={"!handle.isAllocated()"})
        static Object doHandle(GraalHPyHandle handle) {
            return handle.getDelegate();
        }

        @Specialization(guards={"handle.isAllocated()"})
        Object doHandleAllocated(GraalHPyHandle handle) {
            handle.closeAndInvalidate(this.getContext().getHPyContext());
            return handle.getDelegate();
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static Object doNullLong(long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        Object doLong(long bits) {
            int id = GraalHPyBoxing.unboxHandle(bits);
            assert (GraalHPyHandle.isAllocated(id));
            GraalHPyContext context = this.getContext().getHPyContext();
            Object delegate = context.getObjectForHPyHandle(id);
            context.releaseHPyHandleForObject(id);
            return delegate;
        }

        @Specialization(guards={"isBoxedDouble(bits)"})
        static double doLongDouble(long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"isBoxedInt(bits)"})
        static int doLongInt(long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }

        static long asPointer(Object handle, InteropLibrary lib) {
            try {
                return lib.asPointer(handle);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static Object doNullOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        Object doOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return this.doLong(bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedDouble(bits)"})
        static double doOtherDouble(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedInt(bits)"})
        static int doOtherInt(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }
    }

    @GenerateUncached
    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyCloseHandleNode
    extends HPyWithContextNode {
        public abstract void execute(Object var1);

        @Specialization(guards={"!handle.isAllocated()"})
        static void doHandle(GraalHPyHandle handle) {
        }

        @Specialization(guards={"handle.isAllocated()"})
        void doHandleAllocated(GraalHPyHandle handle) {
            handle.closeAndInvalidate(this.getContext().getHPyContext());
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static void doNullLong(long bits) {
        }

        @Specialization(guards={"!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        void doLong(long bits) {
            int id = GraalHPyBoxing.unboxHandle(bits);
            assert (GraalHPyHandle.isAllocated(id));
            this.getContext().getHPyContext().releaseHPyHandleForObject(id);
        }

        @Specialization(guards={"!isBoxedHandle(bits)"})
        static void doLongDouble(long bits) {
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static void doNullOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        void doOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            this.doLong(bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedHandle(bits)"})
        static void doOtherDouble(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
        }
    }

    @GenerateUncached
    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyEnsureHandleNode
    extends HPyWithContextNode {
        public abstract GraalHPyHandle execute(Object var1);

        @Specialization
        static GraalHPyHandle doHandle(GraalHPyHandle handle) {
            return handle;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        GraalHPyHandle doOtherBoxedHandle(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return this.doLong(bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static GraalHPyHandle doOtherNull(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyHandle.NULL_HANDLE;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedInt(bits) || isBoxedDouble(bits)"})
        GraalHPyHandle doOtherBoxedPrimitive(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return this.doBoxedPrimitive(bits);
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static GraalHPyHandle doLongNull(long bits) {
            return GraalHPyHandle.NULL_HANDLE;
        }

        @Specialization(guards={"isBoxedHandle(bits)"}, replaces={"doLongNull"})
        GraalHPyHandle doLong(long bits) {
            GraalHPyContext context = this.getContext().getHPyContext();
            return context.createHandle(context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits)));
        }

        @Specialization(guards={"isBoxedInt(bits) || isBoxedDouble(bits)"})
        GraalHPyHandle doBoxedPrimitive(long bits) {
            Number delegate;
            if (GraalHPyBoxing.isBoxedInt(bits)) {
                delegate = GraalHPyBoxing.unboxInt(bits);
            } else if (GraalHPyBoxing.isBoxedDouble(bits)) {
                delegate = GraalHPyBoxing.unboxDouble(bits);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return this.getContext().getHPyContext().createHandle(delegate);
        }
    }

    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyWithContextNode
    extends PNodeWithContext {
        static long asPointer(Object handle, InteropLibrary lib) {
            try {
                return lib.asPointer(handle);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    @GenerateUncached
    public static abstract class HPyAsContextNode
    extends CExtToJavaNode {
        @Specialization
        static GraalHPyContext doHandle(GraalHPyNativeContext hpyContext) {
            return hpyContext.context;
        }

        @Specialization
        GraalHPyContext doInt(int handle) {
            return this.getContext().getHPyContext();
        }

        @Specialization
        GraalHPyContext doLong(long handle) {
            return this.getContext().getHPyContext();
        }

        @Specialization(guards={"interopLibrary.isPointer(handle)"}, limit="2")
        static GraalHPyContext doPointer(Object handle, @CachedLibrary(value="handle") InteropLibrary interopLibrary) {
            return PythonContext.get((Node)interopLibrary).getHPyContext();
        }
    }

    @GenerateUncached
    public static abstract class HPyCreateLegacySlotNode
    extends PNodeWithContext {
        public abstract HPyProperty execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization
        static HPyProperty doIt(GraalHPyContext context, Object enclosingType, Object slotDef, @CachedLibrary(limit="3") InteropLibrary resultLib, @Cached CExtNodes.CreateMethodNode legacyMethodNode, @Cached HPyCreateLegacyMemberNode createLegacyMemberNode, @Cached HPyAddLegacyGetSetDefNode legacyGetSetNode, @Cached WriteAttributeToObjectNode writeAttributeToObjectNode, @Cached ReadAttributeFromObjectNode readAttributeToObjectNode, @Cached PCallHPyFunction callHelperFunctionNode, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            int slotId;
            assert (HPyCreateLegacySlotNode.checkLayout(slotDef)) : "invalid layout of legacy slot definition";
            Object slotObj = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_LEGACY_SLOT_GET_SLOT, slotDef);
            if (resultLib.fitsInInt(slotObj)) {
                try {
                    slotId = resultLib.asInt(slotObj);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.FIELD_SLOT_S_ISNT_INT, slotDef);
            }
            GraalHPyLegacyDef.HPyLegacySlot slot = GraalHPyLegacyDef.HPyLegacySlot.fromValue(slotId);
            if (slot == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_SLOT_VALUE, slotId);
            }
            switch (slot) {
                case Py_tp_members: {
                    Object memberDefArrayPtr = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_LEGACY_SLOT_GET_MEMBERS, slotDef);
                    try {
                        int nLegacyMemberDefs = PInt.intValueExact(resultLib.getArraySize(memberDefArrayPtr));
                        for (int i = 0; i < nLegacyMemberDefs; ++i) {
                            Object legacyMemberDef = resultLib.readArrayElement(memberDefArrayPtr, (long)i);
                            HPyProperty property = createLegacyMemberNode.execute(enclosingType, legacyMemberDef);
                            property.write(writeAttributeToObjectNode, readAttributeToObjectNode, enclosingType);
                        }
                        break;
                    }
                    catch (OverflowException | InteropException e) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.ERR_WHEN_READING_LEGACY_MEYHOD_FOR_TYPE, enclosingType);
                    }
                }
                case Py_tp_methods: {
                    PBuiltinFunction method;
                    Object methodDefArrayPtr = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_LEGACY_SLOT_GET_METHODS, slotDef);
                    int i = 0;
                    while ((method = legacyMethodNode.execute(methodDefArrayPtr, i)) != null) {
                        writeAttributeToObjectNode.execute(enclosingType, method.getName(), (Object)method);
                        ++i;
                    }
                    break;
                }
                case Py_tp_getset: {
                    Object getSetDefArrayPtr = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_LEGACY_SLOT_GET_DESCRS, slotDef);
                    try {
                        int nLegacyMemberDefs = PInt.intValueExact(resultLib.getArraySize(getSetDefArrayPtr));
                        for (int i = 0; i < nLegacyMemberDefs; ++i) {
                            Object legacyMethodDef = resultLib.readArrayElement(getSetDefArrayPtr, (long)i);
                            GetSetDescriptor getSetDescriptor = legacyGetSetNode.execute(context, enclosingType, legacyMethodDef);
                            writeAttributeToObjectNode.execute(enclosingType, getSetDescriptor.getName(), (Object)getSetDescriptor);
                        }
                        break;
                    }
                    catch (OverflowException | InteropException e) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.ERR_WHEN_READING_LEGACY_MEYHOD_FOR_TYPE, enclosingType);
                    }
                }
                default: {
                    TruffleString attributeKey = slot.getAttributeKey();
                    if (attributeKey != null) {
                        if (HPyProperty.keyExists(readAttributeToObjectNode, enclosingType, attributeKey)) break;
                        Object pfuncPtr = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_LEGACY_SLOT_GET_PFUNC, slotDef);
                        PBuiltinFunction method = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(attributeKey, pfuncPtr, enclosingType, 0, slot.getSignature(), PythonLanguage.get(raiseNode), factory, true);
                        writeAttributeToObjectNode.execute(enclosingType, attributeKey, (Object)method);
                        break;
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)PythonUtils.formatJString("support for legacy slot %s not yet implemented", slot.name()));
                }
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean checkLayout(Object slotDef) {
            String[] members = new String[]{"slot", "pfunc"};
            InteropLibrary lib = InteropLibrary.getUncached((Object)slotDef);
            for (String member : members) {
                if (lib.isMemberReadable(slotDef, member)) continue;
                return false;
            }
            return true;
        }
    }

    @GenerateUncached
    public static abstract class HPyCreateSlotNode
    extends PNodeWithContext {
        public abstract Object execute(GraalHPyContext var1, PythonClass var2, Object var3);

        @Specialization
        static Object doIt(GraalHPyContext context, PythonClass enclosingType, Object slotDef, @Bind(value="this") Node inliningTarget, @Cached HPyReadSlotNode readSlotNode, @Cached PythonObjectFactory factory, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PRaiseNode raiseNode) {
            assert (enclosingType.isHPyType());
            HPySlotData slotData = readSlotNode.execute(inliningTarget, context, slotDef);
            GraalHPyDef.HPySlot slot = slotData.slot;
            HPyProperty property = null;
            Object[] methodNames = slot.getAttributeKeys();
            GraalHPyDef.HPySlotWrapper[] slotWrappers = slot.getSignatures();
            if (GraalHPyDef.HPySlot.HPY_TP_DESTROY.equals((Object)slot)) {
                enclosingType.setHPyDestroyFunc(slotData.impl());
            } else {
                if (GraalHPyDef.HPySlot.HPY_TP_TRAVERSE.equals((Object)slot)) {
                    assert (methodNames.length == 0);
                    return GraalHPyDef.HPySlot.HPY_TP_TRAVERSE;
                }
                for (int i = 0; i < methodNames.length; ++i) {
                    Object methodName;
                    TruffleString methodNameStr;
                    if (methodNames[i] instanceof HiddenKey) {
                        methodNameStr = fromJavaStringNode.execute(((HiddenKey)methodNames[i]).getName(), PythonUtils.TS_ENCODING);
                        methodName = methodNames[i];
                    } else {
                        methodName = methodNameStr = (TruffleString)methodNames[i];
                    }
                    GraalHPyDef.HPySlotWrapper slotWrapper = slotWrappers[i];
                    PythonClass enclosingTypeForFun = GraalHPyDef.HPySlot.HPY_TP_NEW.equals((Object)slot) ? null : enclosingType;
                    PythonLanguage language = PythonLanguage.get(raiseNode);
                    PBuiltinFunction function = HPyExternalFunctionNodes.createWrapperFunction(language, context, slotWrapper, methodNameStr, slotData.impl(), (Object)enclosingTypeForFun, factory);
                    property = new HPyProperty(methodName, function, property);
                }
            }
            if (GraalHPyDef.HPySlot.HPY_TP_CALL.equals((Object)slot)) {
                if (enclosingType.getItemSize() > 0L) {
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_USE_CALL_WITH_VAR_OBJECTS);
                }
                if (enclosingType.getBuiltinShape() == -1 && enclosingType.getBasicSize() == 0L) {
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_USE_CALL_WITH_LEGACY);
                }
                enclosingType.setHPyDefaultCallFunc(slotData.impl());
            }
            return property;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyReadSlotNode
    extends PNodeWithContext {
        public abstract HPySlotData execute(Node var1, GraalHPyContext var2, Object var3);

        @Specialization(limit="1")
        static HPySlotData doIt(Node inliningTarget, GraalHPyContext context, Object slotDef, @CachedLibrary(value="slotDef") InteropLibrary interopLibrary, @CachedLibrary(limit="2") InteropLibrary resultLib, @Cached PCallHPyFunction callHelperFunctionNode, @Cached HPyAttachFunctionTypeNode attachFunctionTypeNode) {
            Object methodFunctionPointer;
            int slotNr;
            assert (HPyReadSlotNode.checkLayout(slotDef));
            Object slotObj = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_SLOT_GET_SLOT, slotDef);
            if (resultLib.fitsInInt(slotObj)) {
                try {
                    slotNr = resultLib.asInt(slotObj);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.FIELD_SLOT_S_ISNT_INT, slotDef);
            }
            GraalHPyDef.HPySlot slot = GraalHPyDef.HPySlot.fromValue(slotNr);
            if (slot == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_SLOT_VALUE, slotNr);
            }
            try {
                methodFunctionPointer = interopLibrary.readMember(slotDef, "impl");
                if (context.getCurrentMode() != HPyMode.MODE_UNIVERSAL || !resultLib.isExecutable(methodFunctionPointer)) {
                    methodFunctionPointer = attachFunctionTypeNode.execute(context, methodFunctionPointer, slot.getSignatures()[0].getLLVMFunctionType());
                }
            }
            catch (UnknownIdentifierException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_STRUCT_MEMBER, e.getUnknownIdentifier());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_ACCESS_STRUCT_MEMBER_FLAGS_OR_METH);
            }
            return new HPySlotData(slot, methodFunctionPointer);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean checkLayout(Object slotDef) {
            String[] members = new String[]{"slot", "impl", "cpy_trampoline"};
            InteropLibrary lib = InteropLibrary.getUncached((Object)slotDef);
            for (String member : members) {
                if (lib.isMemberReadable(slotDef, member)) continue;
                return false;
            }
            return true;
        }
    }

    @GenerateUncached
    public static abstract class HPyCreateGetSetDescriptorNode
    extends PNodeWithContext {
        public abstract GetSetDescriptor execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization(limit="1")
        static GetSetDescriptor doIt(GraalHPyContext context, Object type, Object memberDef, @CachedLibrary(value="memberDef") InteropLibrary memberDefLib, @CachedLibrary(limit="2") InteropLibrary valueLib, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached HPyAttachFunctionTypeNode attachFunctionTypeNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToDynamicObjectNode writeDocNode, @Cached PRaiseNode raiseNode) {
            assert (memberDefLib.hasMembers(memberDef));
            assert (memberDefLib.isMemberReadable(memberDef, "name"));
            assert (memberDefLib.isMemberReadable(memberDef, "getter_impl"));
            assert (memberDefLib.isMemberReadable(memberDef, "setter_impl"));
            assert (memberDefLib.isMemberReadable(memberDef, "doc"));
            assert (memberDefLib.isMemberReadable(memberDef, "closure"));
            try {
                Object setterFunctionPtr;
                boolean hasSetter;
                boolean hasGetter;
                TruffleString name = fromCharPointerNode.execute(memberDefLib.readMember(memberDef, "name"));
                PNone memberDoc = PNone.NONE;
                Object docCharPtr = memberDefLib.readMember(memberDef, "doc");
                if (!valueLib.isNull(docCharPtr)) {
                    memberDoc = fromCharPointerNode.execute(docCharPtr, false);
                }
                Object closurePtr = memberDefLib.readMember(memberDef, "closure");
                Object getterFunctionPtr = memberDefLib.readMember(memberDef, "getter_impl");
                boolean bl = hasGetter = !valueLib.isNull(getterFunctionPtr);
                if (hasGetter && (context.getCurrentMode() != HPyMode.MODE_UNIVERSAL || !valueLib.isExecutable(getterFunctionPtr))) {
                    getterFunctionPtr = attachFunctionTypeNode.execute(context, getterFunctionPtr, GraalHPyContext.LLVMType.HPyFunc_getter);
                }
                boolean bl2 = hasSetter = !valueLib.isNull(setterFunctionPtr = memberDefLib.readMember(memberDef, "setter_impl"));
                if (hasSetter && (context.getCurrentMode() != HPyMode.MODE_UNIVERSAL || !valueLib.isExecutable(setterFunctionPtr))) {
                    setterFunctionPtr = attachFunctionTypeNode.execute(context, setterFunctionPtr, GraalHPyContext.LLVMType.HPyFunc_setter);
                }
                PBuiltinFunction getterObject = hasGetter ? HPyExternalFunctionNodes.HPyGetSetDescriptorGetterRootNode.createFunction(context, type, name, getterFunctionPtr, closurePtr) : null;
                PBuiltinFunction setterObject = hasSetter ? HPyExternalFunctionNodes.HPyGetSetDescriptorSetterRootNode.createFunction(context, type, name, setterFunctionPtr, closurePtr) : null;
                GetSetDescriptor getSetDescriptor = factory.createGetSetDescriptor(getterObject, setterObject, name, type, !hasSetter);
                writeDocNode.execute((Object)getSetDescriptor, SpecialAttributeNames.T___DOC__, (Object)memberDoc);
                return getSetDescriptor;
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.CANNOT_READ_FIELD_NAME_FROM_MEMBER_DEF);
            }
        }
    }

    @GenerateUncached
    public static abstract class HPyAddMemberNode
    extends PNodeWithContext {
        public abstract HPyProperty execute(GraalHPyContext var1, PythonClass var2, Object var3);

        @Specialization(limit="1")
        static HPyProperty doIt(GraalHPyContext context, PythonClass enclosingType, Object memberDef, @CachedLibrary(value="memberDef") InteropLibrary interopLibrary, @CachedLibrary(limit="2") InteropLibrary valueLib, @Cached PCallHPyFunction callHelperNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.EqualNode equalNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToDynamicObjectNode writeDocNode, @Cached PRaiseNode raiseNode) {
            assert (interopLibrary.hasMembers(memberDef));
            assert (interopLibrary.isMemberReadable(memberDef, "name"));
            assert (interopLibrary.isMemberReadable(memberDef, "type"));
            assert (interopLibrary.isMemberReadable(memberDef, "offset"));
            assert (interopLibrary.isMemberReadable(memberDef, "readonly"));
            assert (interopLibrary.isMemberReadable(memberDef, "doc"));
            try {
                TruffleString name = switchEncodingNode.execute((AbstractTruffleString)fromCharPointerNode.execute(interopLibrary.readMember(memberDef, "name")), PythonUtils.TS_ENCODING);
                PNone memberDoc = PNone.NONE;
                Object doc = interopLibrary.readMember(memberDef, "doc");
                if (!valueLib.isNull(doc)) {
                    memberDoc = fromCharPointerNode.execute(doc, false);
                }
                int type = valueLib.asInt(callHelperNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_MEMBER_GET_TYPE, memberDef));
                boolean readOnly = valueLib.asInt(interopLibrary.readMember(memberDef, "readonly")) != 0;
                int offset = valueLib.asInt(interopLibrary.readMember(memberDef, "offset"));
                if (equalNode.execute((AbstractTruffleString)SpecialAttributeNames.T___VECTORCALLOFFSET__, (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) {
                    enclosingType.setHPyVectorcallOffset(offset);
                }
                PythonLanguage language = PythonLanguage.get(raiseNode);
                PBuiltinFunction getterObject = GraalHPyMemberAccessNodes.HPyReadMemberNode.createBuiltinFunction(language, name, type, offset);
                PBuiltinFunction setterObject = null;
                if (!readOnly) {
                    setterObject = GraalHPyMemberAccessNodes.HPyWriteMemberNode.createBuiltinFunction(language, name, type, offset);
                }
                GetSetDescriptor memberDescriptor = factory.createMemberDescriptor(getterObject, setterObject, name, enclosingType);
                writeDocNode.execute((Object)memberDescriptor, SpecialAttributeNames.T___DOC__, (Object)memberDoc);
                return new HPyProperty(name, memberDescriptor);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.CANNOT_READ_FIELD_NAME_FROM_MEMBER_DEF);
            }
        }
    }

    @GenerateUncached
    public static abstract class HPyCreateLegacyMemberNode
    extends PNodeWithContext {
        public abstract HPyProperty execute(Object var1, Object var2);

        @Specialization(limit="1")
        static HPyProperty doIt(Object enclosingType, Object memberDef, @CachedLibrary(value="memberDef") InteropLibrary interopLibrary, @CachedLibrary(limit="2") InteropLibrary valueLib, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToDynamicObjectNode writeDocNode, @Cached PRaiseNode raiseNode) {
            assert (interopLibrary.hasMembers(memberDef));
            assert (interopLibrary.isMemberReadable(memberDef, "name"));
            assert (interopLibrary.isMemberReadable(memberDef, "type"));
            assert (interopLibrary.isMemberReadable(memberDef, "offset"));
            assert (interopLibrary.isMemberReadable(memberDef, "flags"));
            assert (interopLibrary.isMemberReadable(memberDef, "doc"));
            try {
                TruffleString name = fromCharPointerNode.execute(interopLibrary.readMember(memberDef, "name"));
                PNone memberDoc = PNone.NONE;
                Object doc = interopLibrary.readMember(memberDef, "doc");
                if (!valueLib.isNull(doc)) {
                    memberDoc = fromCharPointerNode.execute(doc, false);
                }
                int flags = valueLib.asInt(interopLibrary.readMember(memberDef, "flags"));
                int type = valueLib.asInt(interopLibrary.readMember(memberDef, "type"));
                int offset = valueLib.asInt(interopLibrary.readMember(memberDef, "offset"));
                PythonLanguage language = PythonLanguage.get(raiseNode);
                PBuiltinFunction getterObject = GraalHPyMemberAccessNodes.HPyReadMemberNode.createBuiltinFunction(language, name, type, offset);
                PBuiltinFunction setterObject = null;
                if ((flags & 1) == 0) {
                    setterObject = GraalHPyMemberAccessNodes.HPyWriteMemberNode.createBuiltinFunction(language, name, type, offset);
                }
                GetSetDescriptor memberDescriptor = factory.createMemberDescriptor(getterObject, setterObject, name, enclosingType);
                writeDocNode.execute((Object)memberDescriptor, SpecialAttributeNames.T___DOC__, (Object)memberDoc);
                return new HPyProperty(name, memberDescriptor);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.CANNOT_READ_FIELD_NAME_FROM_MEMBER_DEF);
            }
        }
    }

    @CompilerDirectives.ValueType
    record HPySlotData(GraalHPyDef.HPySlot slot, Object impl) {
    }

    @CompilerDirectives.ValueType
    static final class HPyProperty {
        final Object key;
        final Object value;
        final HPyProperty next;

        HPyProperty(Object key, Object value, HPyProperty next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        HPyProperty(Object key, Object value) {
            this(key, value, null);
        }

        void write(WriteAttributeToObjectNode writeAttributeToObjectNode, ReadAttributeFromObjectNode readAttributeFromObjectNode, Object enclosingType) {
            HPyProperty prop = this;
            while (prop != null) {
                if (!HPyProperty.keyExists(readAttributeFromObjectNode, enclosingType, prop.key)) {
                    writeAttributeToObjectNode.execute(enclosingType, prop.key, prop.value);
                }
                prop = prop.next;
            }
        }

        static boolean keyExists(ReadAttributeFromObjectNode readAttributeFromObjectNode, Object enclosingType, Object key) {
            return readAttributeFromObjectNode.execute(enclosingType, key) != PNone.NO_VALUE;
        }
    }

    @GenerateUncached
    public static abstract class HPyAddLegacyGetSetDefNode
    extends PNodeWithContext {
        public abstract GetSetDescriptor execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization(limit="1")
        static GetSetDescriptor doGeneric(GraalHPyContext context, Object owner, Object legacyGetSetDef, @CachedLibrary(value="legacyGetSetDef") InteropLibrary interopLibrary, @CachedLibrary(limit="2") InteropLibrary resultLib, @Bind(value="this") Node inliningTarget, @Cached PCallHPyFunction callGetNameNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToDynamicObjectNode writeDocNode, @Cached PRaiseNode raiseNode) {
            Object closurePtr;
            boolean hasSetter;
            Object setterFunPtr;
            boolean hasGetter;
            Object getterFunPtr;
            assert (HPyAddLegacyGetSetDefNode.checkLayout(legacyGetSetDef)) : "provided pointer has unexpected structure";
            TruffleString getSetDescrName = castToTruffleStringNode.execute(inliningTarget, callGetNameNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_LEGACY_GETSETDEF_GET_NAME, legacyGetSetDef));
            PNone getSetDescrDoc = PNone.NONE;
            try {
                Object getSetDocPtr = interopLibrary.readMember(legacyGetSetDef, "doc");
                if (!resultLib.isNull(getSetDocPtr)) {
                    getSetDescrDoc = fromCharPointerNode.execute(getSetDocPtr, false);
                }
            }
            catch (UnknownIdentifierException | UnsupportedMessageException getSetDocPtr) {
                // empty catch block
            }
            try {
                getterFunPtr = interopLibrary.readMember(legacyGetSetDef, "get");
                hasGetter = !resultLib.isNull(getterFunPtr);
                setterFunPtr = interopLibrary.readMember(legacyGetSetDef, "set");
                hasSetter = !resultLib.isNull(setterFunPtr);
                closurePtr = interopLibrary.readMember(legacyGetSetDef, "closure");
            }
            catch (UnknownIdentifierException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_STRUCT_MEMBER, e.getUnknownIdentifier());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_ACCESS_STRUCT_MEMBER_FLAGS_OR_METH);
            }
            PythonLanguage lang = PythonLanguage.get(raiseNode);
            PBuiltinFunction getterObject = hasGetter ? HPyExternalFunctionNodes.HPyLegacyGetSetDescriptorGetterRoot.createLegacyFunction(context, lang, owner, getSetDescrName, getterFunPtr, closurePtr) : null;
            PBuiltinFunction setterObject = hasSetter ? HPyExternalFunctionNodes.HPyLegacyGetSetDescriptorSetterRoot.createLegacyFunction(context, lang, owner, getSetDescrName, setterFunPtr, closurePtr) : null;
            GetSetDescriptor getSetDescriptor = factory.createGetSetDescriptor(getterObject, setterObject, getSetDescrName, owner, hasSetter);
            writeDocNode.execute((Object)getSetDescriptor, SpecialAttributeNames.T___DOC__, (Object)getSetDescrDoc);
            return getSetDescriptor;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean checkLayout(Object methodDef) {
            String[] members = new String[]{"name", "get", "set", "doc", "closure"};
            InteropLibrary lib = InteropLibrary.getUncached((Object)methodDef);
            for (String member : members) {
                if (lib.isMemberReadable(methodDef, member)) continue;
                return false;
            }
            return true;
        }
    }

    @GenerateUncached
    public static abstract class HPyCreateFunctionNode
    extends PNodeWithContext {
        public abstract PBuiltinFunction execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization(limit="1")
        static PBuiltinFunction doIt(GraalHPyContext context, Object enclosingType, Object methodDef, @CachedLibrary(value="methodDef") InteropLibrary interopLibrary, @CachedLibrary(limit="2") InteropLibrary resultLib, @Bind(value="this") Node inliningTarget, @Cached PCallHPyFunction callHelperFunctionNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached HPyAttachFunctionTypeNode attachFunctionTypeNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToDynamicObjectNode writeAttributeToDynamicObjectNode, @Cached PRaiseNode raiseNode) {
            Object methodFunctionPointer;
            GraalHPyDef.HPyFuncSignature signature;
            assert (HPyCreateFunctionNode.checkLayout(methodDef));
            TruffleString methodName = castToTruffleStringNode.execute(inliningTarget, callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_GET_ML_NAME, methodDef));
            PNone methodDoc = PNone.NONE;
            try {
                Object doc = interopLibrary.readMember(methodDef, "doc");
                if (!resultLib.isNull(doc)) {
                    methodDoc = fromCharPointerNode.execute(doc, false);
                }
            }
            catch (UnknownIdentifierException | UnsupportedMessageException doc) {
                // empty catch block
            }
            try {
                Object methodSignatureObj = callHelperFunctionNode.call(context, GraalHPyNativeSymbol.GRAAL_HPY_METH_GET_SIGNATURE, methodDef);
                if (!resultLib.fitsInInt(methodSignatureObj)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.SIG_OF_S_IS_NOT_INT, methodName);
                }
                signature = GraalHPyDef.HPyFuncSignature.fromValue(resultLib.asInt(methodSignatureObj));
                if (signature == null) {
                    throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNSUPPORTED_HYPMETH_SIG);
                }
                methodFunctionPointer = interopLibrary.readMember(methodDef, "impl");
                if (context.getCurrentMode() != HPyMode.MODE_UNIVERSAL || !resultLib.isExecutable(methodFunctionPointer)) {
                    methodFunctionPointer = attachFunctionTypeNode.execute(context, methodFunctionPointer, signature.getLLVMFunctionType());
                }
            }
            catch (UnknownIdentifierException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_STRUCT_MEMBER, e.getUnknownIdentifier());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_ACCESS_STRUCT_MEMBER_FLAGS_OR_METH);
            }
            PBuiltinFunction function = HPyExternalFunctionNodes.createWrapperFunction(PythonLanguage.get(raiseNode), context, signature, methodName, methodFunctionPointer, enclosingType, factory);
            writeAttributeToDynamicObjectNode.execute((Object)function.getStorage(), SpecialAttributeNames.T___DOC__, (Object)methodDoc);
            return function;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean checkLayout(Object methodDef) {
            String[] members = new String[]{"name", "doc", "impl", "cpy_trampoline", "signature"};
            InteropLibrary lib = InteropLibrary.getUncached((Object)methodDef);
            for (String member : members) {
                if (lib.isMemberReadable(methodDef, member)) continue;
                return false;
            }
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GraalHPyModuleExecNode
    extends Node {
        public abstract void execute(Node var1, GraalHPyContext var2, PythonModule var3);

        @Specialization
        static void doGeneric(Node node, GraalHPyContext hpyContext, PythonModule module, @Cached HPyExternalFunctionNodes.HPyCheckPrimitiveResultNode checkFunctionResultNode, @Cached HPyAsHandleNode asHandleNode, @CachedLibrary(limit="1") InteropLibrary lib) {
            Object execSlotsObj = module.getNativeModuleDef();
            if (execSlotsObj instanceof LinkedList) {
                LinkedList execSlots = (LinkedList)execSlotsObj;
                for (Object execSlot : execSlots) {
                    GraalHPyModuleExecNode.callExec(node, hpyContext, execSlot, module, checkFunctionResultNode, asHandleNode, lib);
                }
            }
        }

        static void callExec(Node node, GraalHPyContext hPyContext, Object callable, PythonModule module, HPyExternalFunctionNodes.HPyCheckPrimitiveResultNode checkFunctionResultNode, HPyAsHandleNode asHandleNode, InteropLibrary lib) {
            PythonLanguage language = PythonLanguage.get(node);
            PythonContext ctx = hPyContext.getContext();
            PythonContext.PythonThreadState pythonThreadState = ctx.getThreadState(language);
            GraalHPyHandle hModule = asHandleNode.execute(module);
            try {
                checkFunctionResultNode.execute(pythonThreadState, StringLiterals.T_EXEC, lib.execute(callable, new Object[]{hPyContext.getBackend(), hModule}));
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_FAILED, StringLiterals.T_EXEC, e);
            }
            catch (ArityException e) {
                throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_EXPECTED_ARGS, StringLiterals.T_EXEC, e.getExpectedMinArity(), e.getActualArity());
            }
            finally {
                hModule.closeAndInvalidate(hPyContext);
            }
        }
    }

    @GenerateUncached
    public static abstract class GraalHPyModuleCreate
    extends Node {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyModuleCreate.class);
        private static final TruffleString CREATE = PythonUtils.tsLiteral("create");

        public abstract Object execute(GraalHPyContext var1, TruffleString var2, Object var3, Object var4);

        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, TruffleString mName, Object spec, Object moduleDefPtr, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached PCallHPyFunction callFromHPyModuleDefNode, @Cached PCallHPyFunction callGetterNode, @CachedLibrary(limit="3") InteropLibrary ptrLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached CastToJavaIntLossyNode castToJavaIntNode, @Cached WriteAttributeToObjectNode writeAttrNode, @Cached WriteAttributeToDynamicObjectNode writeAttrToMethodNode, @Cached HPyCreateFunctionNode addFunctionNode, @Cached CExtNodes.CreateMethodNode addLegacyMethodNode, @Cached HPyReadSlotNode readSlotNode, @Cached HPyExternalFunctionNodes.HPyCheckHandleResultNode checkFunctionResultNode, @Cached HPyAsHandleNode asHandleNode, @CachedLibrary(limit="1") InteropLibrary createLib, @Cached PRaiseNode raiseNode) {
            int i;
            Object module;
            int nModuleGlobals;
            int nModuleDefines;
            TruffleString mDoc;
            Object moduleDef = callFromHPyModuleDefNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_FROM_HPY_MODULE_DEF, moduleDefPtr);
            assert (GraalHPyModuleCreate.checkLayout(moduleDef));
            try {
                Object docPtr = ptrLib.readMember(moduleDef, "doc");
                mDoc = !ptrLib.isNull(docPtr) ? fromCharPointerNode.execute(docPtr) : null;
                Object sizeObj = ptrLib.readMember(moduleDef, "size");
                long size = valueLib.asLong(sizeObj);
                if (size < 0L) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, PythonUtils.tsLiteral("HPy does not permit HPyModuleDef.size < 0"));
                }
                if (size > 0L) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, PythonUtils.tsLiteral("Module state is not supported yet in HPy, set HPyModuleDef.size = 0 if module state is not needed"));
                }
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.CANNOT_CREATE_MODULE_FROM_DEFINITION, e);
            }
            Object moduleDefinesPtr = callGetterNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_MODULE_GET_DEFINES, moduleDef);
            try {
                if (ptrLib.isNull(moduleDefinesPtr)) {
                    nModuleDefines = 0;
                } else {
                    if (!ptrLib.hasArrayElements(moduleDefinesPtr)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.FIELD_S_DID_NOT_RETURN_AN_ARRAY, "defines");
                    }
                    nModuleDefines = PInt.intValueExact(ptrLib.getArraySize(moduleDefinesPtr));
                }
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            catch (OverflowException ex) {
                throw CompilerDirectives.shouldNotReachHere((String)"Count of HPy module defines exceeds maximum");
            }
            int nMethodDefs = 0;
            Object[] methodDefs = new Object[nModuleDefines];
            LinkedList<Object> executeSlots = new LinkedList<Object>();
            Object createFunction = null;
            try {
                block18: for (int i2 = 0; i2 < nModuleDefines; ++i2) {
                    Object moduleDefine = ptrLib.readArrayElement(moduleDefinesPtr, (long)i2);
                    int kind = castToJavaIntNode.execute(inliningTarget, callGetterNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_KIND, moduleDefine));
                    switch (kind) {
                        case 2: {
                            methodDefs[nMethodDefs++] = moduleDefine;
                            continue block18;
                        }
                        case 1: {
                            Object slotDef = callGetterNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_SLOT, moduleDefine);
                            HPySlotData slotData = readSlotNode.execute(inliningTarget, hpyContext, slotDef);
                            switch (slotData.slot) {
                                case HPY_MOD_CREATE: {
                                    if (createFunction != null) {
                                        throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.MODULE_HAS_MULTIPLE_CREATE_SLOTS, mName);
                                    }
                                    createFunction = slotData.impl;
                                    assert (createLib.isExecutable(createFunction));
                                    continue block18;
                                }
                                case HPY_MOD_EXEC: {
                                    if (createFunction != null) {
                                        throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.HPY_DEFINES_CREATE_AND_OTHER_SLOTS, mName);
                                    }
                                    Object execFunction = slotData.impl;
                                    assert (InteropLibrary.getUncached().isExecutable(execFunction));
                                    executeSlots.add(execFunction);
                                    continue block18;
                                }
                                default: {
                                    throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.MODULE_USES_UNKNOW_SLOT_ID, new Object[]{mName, slotData.slot});
                                }
                            }
                        }
                        case 3: 
                        case 4: {
                            LOGGER.warning("get/set definitions are not supported for modules");
                            continue block18;
                        }
                        default: {
                            if (LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.severe(PythonUtils.formatJString("unknown definition kind: %d", kind));
                            }
                            assert (false);
                            continue block18;
                        }
                    }
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            Object legacyMethods = callGetterNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_MODULE_GET_LEGACY_METHODS, moduleDef);
            boolean hasLegacyMethods = !ptrLib.isNull(legacyMethods);
            try {
                int globalStartIdx = hpyContext.getEndIndexOfGlobalTable();
                nModuleGlobals = ptrLib.asInt(callGetterNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_MODULE_INIT_GLOBALS, moduleDef, globalStartIdx));
                hpyContext.initBatchGlobals(globalStartIdx, nModuleGlobals);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            if (createFunction != null) {
                if (hasLegacyMethods || mDoc != null || nModuleGlobals != 0) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.HPY_DEFINES_CREATE_AND_NON_DEFAULT);
                }
                module = GraalHPyModuleCreate.callCreate(inliningTarget, createFunction, hpyContext, spec, checkFunctionResultNode, asHandleNode, createLib);
                if (module instanceof PythonModule) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.HPY_MOD_CREATE_RETURNED_BUILTIN_MOD);
                }
            } else {
                PythonModule pmodule = factory.createPythonModule(mName);
                pmodule.setNativeModuleDef(executeSlots);
                module = pmodule;
            }
            for (i = 0; i < nMethodDefs; ++i) {
                Object methodDef = callGetterNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_DEF_GET_METH, methodDefs[i]);
                PBuiltinFunction fun = addFunctionNode.execute(hpyContext, null, methodDef);
                PBuiltinMethod method = factory.createBuiltinMethod(module, fun);
                writeAttrToMethodNode.execute((Object)method, SpecialAttributeNames.T___MODULE__, (Object)mName);
                writeAttrNode.execute(module, fun.getName(), (Object)method);
            }
            if (hasLegacyMethods) {
                PBuiltinFunction fun;
                if (!ptrLib.hasArrayElements(legacyMethods)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.FIELD_S_DID_NOT_RETURN_AN_ARRAY, "legacyMethods");
                }
                i = 0;
                while ((fun = addLegacyMethodNode.execute(legacyMethods, i)) != null) {
                    PBuiltinMethod method = factory.createBuiltinMethod(module, fun);
                    writeAttrToMethodNode.execute((Object)method.getStorage(), SpecialAttributeNames.T___MODULE__, (Object)mName);
                    writeAttrNode.execute(module, fun.getName(), (Object)method);
                    ++i;
                }
            }
            if (mDoc != null) {
                writeAttrNode.execute(module, SpecialAttributeNames.T___DOC__, (Object)mDoc);
            }
            return module;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean checkLayout(Object moduleDef) {
            String[] members = new String[]{"doc", "size", "legacy_methods", "defines"};
            InteropLibrary lib = InteropLibrary.getUncached((Object)moduleDef);
            for (String member : members) {
                if (lib.isMemberReadable(moduleDef, member)) continue;
                return false;
            }
            return true;
        }

        static Object callCreate(Node inliningTarget, Object callable, GraalHPyContext hPyContext, Object spec, HPyExternalFunctionNodes.HPyCheckFunctionResultNode checkFunctionResultNode, HPyAsHandleNode asHandleNode, InteropLibrary lib) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext ctx = hPyContext.getContext();
            PythonContext.PythonThreadState pythonThreadState = ctx.getThreadState(language);
            GraalHPyHandle hSpec = asHandleNode.execute(spec);
            try {
                Object object = checkFunctionResultNode.execute(pythonThreadState, CREATE, lib.execute(callable, new Object[]{hPyContext.getBackend(), hSpec}));
                return object;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_FAILED, CREATE, e);
            }
            catch (ArityException e) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_EXPECTED_ARGS, CREATE, e.getExpectedMinArity(), e.getActualArity());
            }
            finally {
                hSpec.closeAndInvalidate(hPyContext);
            }
        }
    }

    public static abstract class HPyFromCharPointerNode
    extends Node {
        public final TruffleString execute(GraalHPyContext hpyContext, Object charPtr, boolean copy) {
            return this.execute(hpyContext, charPtr, -1, TruffleString.Encoding.UTF_8, copy);
        }

        public final TruffleString execute(GraalHPyContext hpyContext, Object charPtr, TruffleString.Encoding encoding) {
            return this.execute(hpyContext, charPtr, -1, encoding, true);
        }

        public abstract TruffleString execute(GraalHPyContext var1, Object var2, int var3, TruffleString.Encoding var4, boolean var5);

        public abstract TruffleString execute(GraalHPyContext var1, long var2, int var4, TruffleString.Encoding var5, boolean var6);

        public static HPyFromCharPointerNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createFromCharPointerNode();
        }

        public static HPyFromCharPointerNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedFromCharPointerNode();
        }
    }

    @GenerateUncached
    public static abstract class HPyRaiseNode
    extends Node {
        public final int raiseInt(Frame frame, GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(frame, nativeContext, errorValue, errType, format, arguments);
        }

        public final Object raise(Frame frame, GraalHPyContext nativeContext, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.execute(frame, nativeContext, errorValue, errType, format, arguments);
        }

        public final int raiseIntWithoutFrame(GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(null, nativeContext, errorValue, errType, format, arguments);
        }

        public final Object raiseWithoutFrame(GraalHPyContext nativeContext, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.execute(null, nativeContext, errorValue, errType, format, arguments);
        }

        public static int raiseIntUncached(GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return GraalHPyNodesFactory.HPyRaiseNodeGen.getUncached().raiseIntWithoutFrame(nativeContext, errorValue, errType, format, arguments);
        }

        public abstract Object execute(Frame var1, GraalHPyContext var2, Object var3, PythonBuiltinClassType var4, TruffleString var5, Object[] var6);

        public abstract int executeInt(Frame var1, GraalHPyContext var2, int var3, PythonBuiltinClassType var4, TruffleString var5, Object[] var6);

        @Specialization
        static int doInt(Frame frame, GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached HPyTransformExceptionToNativeNode transformExceptionToNativeNode) {
            try {
                throw raiseNode.execute(raiseNode, errType, PNone.NO_VALUE, format, arguments);
            }
            catch (PException p) {
                transformExceptionToNativeNode.execute(frame, nativeContext, p);
                return errorValue;
            }
        }

        @Specialization
        static Object doObject(Frame frame, GraalHPyContext nativeContext, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached HPyTransformExceptionToNativeNode transformExceptionToNativeNode) {
            try {
                throw raiseNode.execute(raiseNode, errType, PNone.NO_VALUE, format, arguments);
            }
            catch (PException p) {
                transformExceptionToNativeNode.execute(frame, nativeContext, p);
                return errorValue;
            }
        }
    }

    @GenerateUncached
    public static abstract class HPyTransformExceptionToNativeNode
    extends Node {
        public abstract void execute(Frame var1, GraalHPyContext var2, PException var3);

        public final void execute(GraalHPyContext nativeContext, PException e) {
            this.execute(null, nativeContext, e);
        }

        public final void execute(PException e) {
            this.execute(null, PythonContext.get(this).getHPyContext(), e);
        }

        public static void executeUncached(GraalHPyContext nativeContext, PException e) {
            GraalHPyNodesFactory.HPyTransformExceptionToNativeNodeGen.getUncached().execute(nativeContext, e);
        }

        public static void executeUncached(PException e) {
            GraalHPyNodesFactory.HPyTransformExceptionToNativeNodeGen.getUncached().execute(PythonContext.get(null).getHPyContext(), e);
        }

        @Specialization
        static void setCurrentException(Frame frame, GraalHPyContext nativeContext, PException e, @Bind(value="this") Node inliningTarget, @Cached GetCurrentFrameRef getCurrentFrameRef, @Cached PythonContext.GetThreadStateNode getThreadStateNode) {
            getCurrentFrameRef.execute(frame, inliningTarget).markAsEscaped();
            getThreadStateNode.setCurrentException(inliningTarget, nativeContext.getContext(), e);
        }
    }

    @GenerateUncached
    public static abstract class PCallHPyFunction
    extends PNodeWithContext {
        public final Object call(GraalHPyContext context, GraalHPyNativeSymbol name, Object ... args) {
            return this.execute(context, name, args);
        }

        public abstract Object execute(GraalHPyContext var1, GraalHPyNativeSymbol var2, Object[] var3);

        @Specialization
        static Object doIt(GraalHPyContext context, GraalHPyNativeSymbol name, Object[] args, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached CExtCommonNodes.ImportCExtSymbolNode importCExtSymbolNode, @Cached CExtCommonNodes.EnsureTruffleStringNode ensureTruffleStringNode, @Cached PRaiseNode raiseNode) {
            try {
                return ensureTruffleStringNode.execute(interopLibrary.execute(importCExtSymbolNode.execute(context, name), args));
            }
            catch (ArityException | UnsupportedTypeException e) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, (Exception)e);
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CAPI_SYM_NOT_CALLABLE, name);
            }
        }
    }

    public static abstract class HPyCallHelperFunctionNode
    extends Node {
        public final Object call(GraalHPyContext context, GraalHPyNativeSymbol name, Object ... args) {
            return this.execute(context, name, args);
        }

        protected abstract Object execute(GraalHPyContext var1, GraalHPyNativeSymbol var2, Object[] var3);

        public static HPyCallHelperFunctionNode create(GraalHPyContext context) {
            return context.getBackend().createCallHelperFunctionNode();
        }

        public static HPyCallHelperFunctionNode getUncached(GraalHPyContext context) {
            return context.getBackend().getUncachedCallHelperFunctionNode();
        }
    }
}

