/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonReplacingNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.TruffleObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetNativeWrapperNode;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.NativeObjectReferenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.HandleStack;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import sun.misc.Unsafe;

public class CApiTransitions {
    private static final int GCALot = Integer.getInteger("python.GCALot", 0);
    private static final int GCALotWait = Integer.getInteger("python.GCALotWait", 0);
    private static long GCALotTotalCounter = 0L;
    private static int GCALotCounter = 0;
    private static final TruffleLogger LOGGER = CApiContext.getLogger(CApiTransitions.class);
    private static final InteropLibrary LIB = InteropLibrary.getUncached();
    private static final Unsafe UNSAFE = PythonUtils.initUnsafe();
    private static final int TP_REFCNT_OFFSET = 0;

    private static HandleContext getContext() {
        return PythonContext.get(null).nativeContext;
    }

    @CompilerDirectives.TruffleBoundary
    public static void registerNativeSequenceStorage(NativeSequenceStorage storage) {
        assert (PythonContext.get(null).ownsGil());
        NativeStorageReference ref = new NativeStorageReference(storage);
        storage.setReference(ref);
        CApiTransitions.getContext().nativeStorageReferences.add(ref);
    }

    @CompilerDirectives.TruffleBoundary
    public static void pollReferenceQueue() {
        HandleContext context = CApiTransitions.getContext();
        if (!context.referenceQueuePollActive) {
            try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
                ReferenceQueue<Object> queue = context.referenceQueue;
                int count = 0;
                long start = 0L;
                NativeObjectReferenceArrayWrapper referencesToBeFreed = CApiTransitions.getContext().referencesToBeFreed;
                while (true) {
                    Reference<Object> entry;
                    if ((entry = queue.poll()) == null) {
                        if (count > 0) {
                            assert (context.referenceQueuePollActive);
                            if (!referencesToBeFreed.isEmpty()) {
                                LOGGER.fine(() -> PythonUtils.formatJString("releasing %d NativeObjectReference instances", referencesToBeFreed.getArraySize()));
                                Object array = CStructAccessFactory.AllocateNodeGen.getUncached().alloc(referencesToBeFreed.getArraySize() * 8L);
                                CStructAccessFactory.WriteLongNodeGen.getUncached().writeLongArray(array, referencesToBeFreed.getArray(), (int)referencesToBeFreed.getArraySize(), 0, 0);
                                CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_BULK_DEALLOC, array, referencesToBeFreed.getArraySize());
                                CStructAccessFactory.FreeNodeGen.getUncached().free(array);
                                referencesToBeFreed.reset();
                            }
                            context.referenceQueuePollActive = false;
                            LOGGER.fine("collected " + count + " references from native reference queue in " + (System.nanoTime() - start) / 1000000L + "ms");
                        }
                        return;
                    }
                    if (count == 0) {
                        assert (!context.referenceQueuePollActive);
                        context.referenceQueuePollActive = true;
                        start = System.nanoTime();
                    } else assert (context.referenceQueuePollActive);
                    ++count;
                    if (entry instanceof PythonObjectReference) {
                        PythonObjectReference reference = (PythonObjectReference)entry;
                        LOGGER.finer(() -> PythonUtils.formatJString("releasing PythonObjectReference %s", reference));
                        if (HandlePointerConverter.pointsToPyHandleSpace(reference.pointer)) {
                            int index = HandlePointerConverter.pointerToHandleIndex(reference.pointer);
                            assert (context.nativeHandles.get(index) != null);
                            context.nativeHandles.set(index, null);
                            context.nativeHandlesFreeStack.push(index);
                            continue;
                        }
                        assert (CApiTransitions.nativeLookupGet(context, reference.pointer) != null) : Long.toHexString(reference.pointer);
                        CApiTransitions.nativeLookupRemove(context, reference.pointer);
                        continue;
                    }
                    if (entry instanceof NativeObjectReference) {
                        NativeObjectReference reference = (NativeObjectReference)entry;
                        LOGGER.finer(() -> PythonUtils.formatJString("releasing NativeObjectReference %s", reference));
                        CApiTransitions.nativeLookupRemove(context, reference.pointer);
                        if (CApiTransitions.subNativeRefCount(reference.pointer, 10L) != 0L) continue;
                        referencesToBeFreed.add(reference.pointer);
                        continue;
                    }
                    if (!(entry instanceof NativeStorageReference)) continue;
                    NativeStorageReference reference = (NativeStorageReference)entry;
                    LOGGER.finer(() -> PythonUtils.formatJString("releasing NativeStorageReference %s", reference));
                    context.nativeStorageReferences.remove(entry);
                    if (reference.type == SequenceStorage.ListStorageType.Generic) {
                        CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_PY_TRUFFLE_OBJECT_ARRAY_RELEASE, reference.ptr, reference.size);
                    }
                    CStructAccessFactory.FreeNodeGen.getUncached().free(reference.ptr);
                }
            }
        }
    }

    public static void maybeGCALot() {
        if (GCALot != 0) {
            CApiTransitions.maybeGC();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void maybeGC() {
        if (++GCALotTotalCounter >= (long)GCALotWait && ++GCALotCounter >= GCALot) {
            LOGGER.info("GC A Lot - calling System.gc (opportunities=" + GCALotTotalCounter + ")");
            GCALotCounter = 0;
            System.gc();
            CApiTransitions.pollReferenceQueue();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object lookupNative(long pointer) {
        CApiTransitions.log(pointer);
        IdReference<?> reference = CApiTransitions.nativeLookupGet(CApiTransitions.getContext(), pointer);
        if (reference != null) {
            return CApiTransitions.logResult(reference.get());
        }
        return CApiTransitions.logResult(null);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupGet(HandleContext context, long pointer) {
        return context.nativeLookup.get(pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupPut(HandleContext context, long pointer, IdReference<?> value) {
        return context.nativeLookup.put(pointer, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupRemove(HandleContext context, long pointer) {
        return context.nativeLookup.remove(pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static void firstToNative(PythonNativeWrapper obj) {
        try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
            assert (!obj.isNative());
            CApiTransitions.log(obj);
            obj.setNativePointer(CApiTransitions.logResult(HandleFactory.create(obj)));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void firstToNative(PythonNativeWrapper obj, long ptr) {
        try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
            if (!obj.isNative()) {
                CApiTransitions.logVoid(obj, ptr);
                obj.setNativePointer(ptr);
                CApiTransitions.pollReferenceQueue();
                CApiTransitions.nativeLookupPut(CApiTransitions.getContext(), ptr, new PythonObjectReference(obj, ptr));
            }
        }
    }

    public static void firstToNativeManaged(Object delegate, Object pointer) {
        CApiTransitions.getContext().managedNativeLookup.put(pointer, new WeakReference<Object>(delegate));
    }

    private static void log(Object ... args) {
        if (LOGGER.isLoggable(Level.FINER)) {
            CompilerAsserts.neverPartOfCompilation();
            StackTraceElement element = new RuntimeException().getStackTrace()[1];
            StringBuilder str = new StringBuilder();
            String className = element.getClassName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            str.append(className).append(".").append(element.getMethodName()).append(": ");
            for (int i = 0; i < args.length; ++i) {
                Object a = args[i];
                str.append(i == 0 ? "" : ", ");
                CApiTransitions.format(str, a);
            }
            LOGGER.finer(str.toString());
        }
    }

    private static void logVoid(Object ... args) {
        CApiTransitions.log(args);
    }

    private static void format(StringBuilder str, Object a) {
        if (a instanceof Long) {
            str.append(String.format("0x%x", (long)((Long)a)));
        } else if (a instanceof Integer) {
            str.append(String.format("0x%x", (int)((Integer)a)));
        } else {
            str.append(a);
        }
    }

    private static <T> T logResult(T value) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            CompilerAsserts.neverPartOfCompilation();
            StackTraceElement element = new RuntimeException().getStackTrace()[1];
            StringBuilder str = new StringBuilder("    ==> <").append(element.getLineNumber()).append("> ");
            CApiTransitions.format(str, value);
            LOGGER.finest(str.toString());
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static long incRef(PythonNativeWrapper nativeWrapper, long value) {
        assert (value > 0L);
        long refCount = nativeWrapper.getRefCount();
        nativeWrapper.setRefCount(refCount + value);
        assert (refCount >= 9L) : "invalid refcnt " + refCount + " during incRef in " + Long.toHexString(nativeWrapper.getNativePointer());
        if (refCount == 10L && nativeWrapper.ref != null) {
            nativeWrapper.ref.strongReference = nativeWrapper;
        }
        return refCount;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static long decRef(PythonNativeWrapper nativeWrapper, long value) {
        assert (value > 0L);
        long refCount = nativeWrapper.getRefCount() - value;
        nativeWrapper.setRefCount(refCount);
        assert (refCount >= 9L) : "invalid refcnt " + refCount + " during decRef in " + Long.toHexString(nativeWrapper.getNativePointer());
        if (refCount == 10L && nativeWrapper.ref != null) {
            nativeWrapper.ref.strongReference = null;
        }
        return refCount;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void setRefCount(PythonNativeWrapper nativeWrapper, long value) {
        long refCnt = nativeWrapper.getRefCount();
        if (value < refCnt) {
            CApiTransitions.decRef(nativeWrapper, refCnt - value);
        } else if (value > refCnt) {
            CApiTransitions.incRef(nativeWrapper, value - refCnt);
        }
    }

    private static long addNativeRefCount(long pointer, long refCntDelta) {
        long refCount = UNSAFE.getLong(pointer + 0L);
        assert ((refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        assert (refCount + refCntDelta > 0L) : String.format("refcnt reached zero during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        LOGGER.finest(() -> PythonUtils.formatJString("addNativeRefCount %x %x %d + %d", pointer, refCount, refCount, refCntDelta));
        UNSAFE.putLong(pointer + 0L, refCount + refCntDelta);
        return refCount + refCntDelta;
    }

    private static long subNativeRefCount(long pointer, long refCntDelta) {
        long refCount = UNSAFE.getLong(pointer + 0L);
        assert ((refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        assert (refCount - refCntDelta >= 0L) : String.format("refcnt below zero during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        LOGGER.finest(() -> PythonUtils.formatJString("subNativeRefCount %x %x %d + %d", pointer, refCount, refCount, refCntDelta));
        UNSAFE.putLong(pointer + 0L, refCount - refCntDelta);
        return refCount - refCntDelta;
    }

    private static Object createAbstractNativeObject(Object obj, boolean transfer, long pointer) {
        assert (CApiTransitions.isBackendPointerObject(obj)) : obj.getClass();
        CApiTransitions.pollReferenceQueue();
        PythonAbstractNativeObject result = new PythonAbstractNativeObject(obj);
        NativeObjectReference ref = new NativeObjectReference(result, pointer);
        CApiTransitions.nativeLookupPut(CApiTransitions.getContext(), pointer, ref);
        long refCntDelta = 10L - (long)(transfer ? 1 : 0);
        CApiTransitions.addNativeRefCount(pointer, refCntDelta);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isBackendPointerObject(Object obj) {
        return obj != null && (obj.getClass().toString().contains("LLVMPointerImpl") || obj.getClass().toString().contains("NFIPointer") || obj.getClass().toString().contains("PointerContainer"));
    }

    @CompilerDirectives.TruffleBoundary
    public static PythonNativeWrapper nativeToPythonWrapper(Object obj) {
        long pointer;
        if (obj instanceof PythonNativeWrapper) {
            return (PythonNativeWrapper)obj;
        }
        if (obj instanceof PythonAbstractNativeObject) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (obj instanceof Long) {
            pointer = (Long)obj;
        } else {
            if (!LIB.isPointer(obj)) {
                throw CompilerDirectives.shouldNotReachHere((String)("not a pointer: " + obj));
            }
            try {
                pointer = LIB.asPointer(obj);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        if (pointer == 0L) {
            return null;
        }
        assert (PythonContext.get(null).ownsGil());
        if (HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
            PythonNativeWrapper wrapper;
            PythonObjectReference reference = CApiTransitions.getContext().nativeHandles.get(HandlePointerConverter.pointerToHandleIndex(pointer));
            if (reference == null || (wrapper = (PythonNativeWrapper)reference.get()) == null) {
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            return wrapper;
        }
        IdReference<?> lookup = CApiTransitions.nativeLookupGet(CApiTransitions.getContext(), pointer);
        if (lookup != null) {
            Object ref = lookup.get();
            if (ref == null) {
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            if (ref instanceof PythonNativeWrapper) {
                return (PythonNativeWrapper)ref;
            }
        }
        return null;
    }

    public static final class HandleContext {
        private static final int DEFAULT_CAPACITY = 10;
        public final NativeObjectReferenceArrayWrapper referencesToBeFreed = new NativeObjectReferenceArrayWrapper();
        public final HashMap<Long, IdReference<?>> nativeLookup = new HashMap();
        public final WeakHashMap<Object, WeakReference<Object>> managedNativeLookup = new WeakHashMap();
        public final ArrayList<PythonObjectReference> nativeHandles = new ArrayList(10);
        public final HandleStack nativeHandlesFreeStack = new HandleStack(10);
        public final Set<NativeStorageReference> nativeStorageReferences = new HashSet<NativeStorageReference>();
        public final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
        volatile boolean referenceQueuePollActive = false;
    }

    public static final class NativeStorageReference
    extends IdReference<NativeSequenceStorage> {
        private final SequenceStorage.ListStorageType type;
        private Object ptr;
        private int size;

        public NativeStorageReference(NativeSequenceStorage storage) {
            super(storage);
            this.type = storage.getElementType();
            this.ptr = storage.getPtr();
            this.size = storage.length();
            LOGGER.finer(() -> PythonUtils.formatJString("new NativeStorageReference<%s>", this.ptr));
        }

        public Object getPtr() {
            return this.ptr;
        }

        public void setPtr(Object ptr) {
            this.ptr = ptr;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    public static final class PythonObjectReference
    extends IdReference<PythonNativeWrapper> {
        PythonNativeWrapper strongReference;
        private final long pointer;

        public PythonObjectReference(PythonNativeWrapper referent, long pointer) {
            super(referent);
            this.pointer = pointer;
            this.strongReference = referent.getRefCount() > 10L ? referent : null;
            LOGGER.finer(() -> PythonUtils.formatJString("new %s PythonObjectReference<%s> to %s", this.strongReference == null ? "weak" : "strong", Long.toHexString(pointer), referent));
            referent.ref = this;
        }

        public String toString() {
            return "PythonObjectReference<" + (this.strongReference == null ? "" : "strong,") + Long.toHexString(this.pointer) + ">";
        }
    }

    public static final class HandlePointerConverter {
        private static final long HANDLE_BASE = Long.MIN_VALUE;
        private static final int HANDLE_SHIFT = 3;

        public static long handleIndexToPointer(int idx) {
            return (long)idx << 3 | Long.MIN_VALUE;
        }

        public static int pointerToHandleIndex(long pointer) {
            return (int)((pointer & Long.MAX_VALUE) >>> 3);
        }

        public static boolean pointsToPyHandleSpace(long pointer) {
            return (pointer & Long.MIN_VALUE) != 0L;
        }
    }

    public static abstract class IdReference<T>
    extends WeakReference<T> {
        public IdReference(T referent) {
            super(referent, CApiTransitions.getContext().referenceQueue);
        }
    }

    public static final class NativeObjectReference
    extends IdReference<PythonAbstractNativeObject> {
        final Object object;
        final long pointer;

        public NativeObjectReference(PythonAbstractNativeObject referent, long pointer) {
            super(referent);
            this.object = referent.object;
            this.pointer = pointer;
            referent.ref = this;
            assert ((pointer & 7L) == 0L);
            LOGGER.finer(() -> PythonUtils.formatJString("new NativeObjectReference<%s> to %s", Long.toHexString(pointer), referent));
        }

        public String toString() {
            return "NativeObjectReference<" + (this.get() == null ? "freed," : "") + Long.toHexString(this.pointer) + ">";
        }
    }

    public static final class HandleFactory {
        public static long create(PythonNativeWrapper wrapper) {
            long pointer;
            int idx;
            CompilerAsserts.neverPartOfCompilation();
            assert (!(wrapper instanceof TruffleObjectNativeWrapper));
            assert (PythonContext.get(null).ownsGil());
            CApiTransitions.pollReferenceQueue();
            HandleContext handleContext = CApiTransitions.getContext();
            int n = idx = GCALot != 0 ? -1 : handleContext.nativeHandlesFreeStack.pop();
            if (idx == -1) {
                pointer = HandlePointerConverter.handleIndexToPointer(handleContext.nativeHandles.size());
                handleContext.nativeHandles.add(new PythonObjectReference(wrapper, pointer));
            } else {
                assert (idx >= 0);
                pointer = HandlePointerConverter.handleIndexToPointer(idx);
                handleContext.nativeHandles.set(idx, new PythonObjectReference(wrapper, pointer));
            }
            return pointer;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class NativePtrToPythonNode
    extends PNodeWithContext {
        public abstract Object execute(long var1, boolean var3);

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(long object, boolean stealing) {
            return CApiTransitionsFactory.NativePtrToPythonNodeGen.getUncached().execute(object, stealing);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        Object doNonWrapper(long pointer, boolean stealing, @Bind(value="$node") Node inliningTarget, @Cached InlinedConditionProfile isZeroProfile, @Cached InlinedConditionProfile createNativeProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile isNativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile, @Cached InlinedConditionProfile isPrimitiveProfile) {
            PythonNativeWrapper wrapper;
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            if (isZeroProfile.profile(inliningTarget, pointer == 0L)) {
                return PNone.NO_VALUE;
            }
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                PythonObjectReference reference = nativeContext.nativeHandles.get(HandlePointerConverter.pointerToHandleIndex(pointer));
                if (reference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was freed: " + Long.toHexString(pointer)));
                }
                wrapper = (PythonNativeWrapper)reference.get();
                if (wrapper != null) return NativePtrToPythonNode.handleWrapper(inliningTarget, isPrimitiveProfile, stealing, wrapper);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (!isNativeProfile.profile(inliningTarget, lookup != null)) return CApiTransitions.createAbstractNativeObject(pointer, stealing, pointer);
            Object ref = lookup.get();
            if (createNativeProfile.profile(inliningTarget, ref == null)) {
                LOGGER.fine(() -> "re-creating collected PythonAbstractNativeObject reference" + Long.toHexString(pointer));
                return CApiTransitions.createAbstractNativeObject(pointer, stealing, pointer);
            }
            if (isNativeWrapperProfile.profile(inliningTarget, ref instanceof PythonNativeWrapper)) {
                wrapper = (PythonNativeWrapper)ref;
                return NativePtrToPythonNode.handleWrapper(inliningTarget, isPrimitiveProfile, stealing, wrapper);
            } else {
                PythonAbstractNativeObject result = (PythonAbstractNativeObject)ref;
                if (!stealing) return result;
                CApiTransitions.addNativeRefCount(pointer, -1L);
                return result;
            }
        }

        private static Object handleWrapper(Node node, InlinedConditionProfile isPrimitiveProfile, boolean transfer, PythonNativeWrapper wrapper) {
            if (transfer) {
                assert (wrapper.getRefCount() >= 10L);
                CApiTransitions.decRef(wrapper, 1L);
            }
            if (isPrimitiveProfile.profile(node, wrapper instanceof PrimitiveNativeWrapper)) {
                PrimitiveNativeWrapper primitive = (PrimitiveNativeWrapper)wrapper;
                if (primitive.isBool()) {
                    return primitive.getBool();
                }
                if (primitive.isInt()) {
                    return primitive.getInt();
                }
                if (primitive.isLong()) {
                    return primitive.getLong();
                }
                if (primitive.isDouble()) {
                    return primitive.getDouble();
                }
                throw CompilerDirectives.shouldNotReachHere();
            }
            return wrapper.getDelegate();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class NativeToPythonStealingNode
    extends NativeToPythonNode {
        @Specialization
        static Object dummy(Void dummy) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.NativeToPythonStealingNodeGen.getUncached().execute(obj);
        }

        @Override
        protected final boolean needsTransfer() {
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class NativeToPythonNode
    extends CExtToJavaNode {
        public abstract Object execute(PythonNativeWrapper var1);

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.NativeToPythonNodeGen.getUncached().execute(obj);
        }

        protected boolean needsTransfer() {
            return false;
        }

        @Specialization
        static Object doWrapper(PythonNativeWrapper value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile isPrimitiveProfile) {
            return NativeToPythonNode.handleWrapper(inliningTarget, isPrimitiveProfile, false, value);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization(guards={"!isNativeWrapper(value)"}, limit="3")
        Object doNonWrapper(Object value, @Bind(value="$node") Node inliningTarget, @CachedLibrary(value="value") InteropLibrary interopLibrary, @Cached InlinedConditionProfile isNullProfile, @Cached InlinedConditionProfile isZeroProfile, @Cached InlinedConditionProfile createNativeProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile isNativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile, @Cached.Exclusive @Cached InlinedConditionProfile isPrimitiveProfile) {
            PythonNativeWrapper wrapper;
            long pointer;
            assert (!(value instanceof TruffleString));
            assert (!(value instanceof PythonAbstractObject));
            assert (!(value instanceof Number));
            if (isNullProfile.profile(inliningTarget, interopLibrary.isNull(value))) {
                return PNone.NO_VALUE;
            }
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            if (!interopLibrary.isPointer(value)) {
                return NativeToPythonNode.getManagedReference(value, nativeContext);
            }
            try {
                pointer = interopLibrary.asPointer(value);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (isZeroProfile.profile(inliningTarget, pointer == 0L)) {
                return PNone.NO_VALUE;
            }
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                PythonObjectReference reference = nativeContext.nativeHandles.get(HandlePointerConverter.pointerToHandleIndex(pointer));
                if (reference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was freed: " + Long.toHexString(pointer)));
                }
                wrapper = (PythonNativeWrapper)reference.get();
                if (wrapper != null) return NativeToPythonNode.handleWrapper(inliningTarget, isPrimitiveProfile, this.needsTransfer(), wrapper);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (!isNativeProfile.profile(inliningTarget, lookup != null)) return CApiTransitions.createAbstractNativeObject(value, this.needsTransfer(), pointer);
            Object ref = lookup.get();
            if (createNativeProfile.profile(inliningTarget, ref == null)) {
                LOGGER.fine(() -> "re-creating collected PythonAbstractNativeObject reference" + Long.toHexString(pointer));
                return CApiTransitions.createAbstractNativeObject(value, this.needsTransfer(), pointer);
            }
            if (isNativeWrapperProfile.profile(inliningTarget, ref instanceof PythonNativeWrapper)) {
                wrapper = (PythonNativeWrapper)ref;
                return NativeToPythonNode.handleWrapper(inliningTarget, isPrimitiveProfile, this.needsTransfer(), wrapper);
            } else {
                PythonAbstractNativeObject result = (PythonAbstractNativeObject)ref;
                if (!this.needsTransfer()) return result;
                CApiTransitions.addNativeRefCount(pointer, -1L);
                return result;
            }
        }

        private static Object handleWrapper(Node node, InlinedConditionProfile isPrimitiveProfile, boolean transfer, PythonNativeWrapper wrapper) {
            if (transfer) {
                assert (wrapper.getRefCount() >= 10L);
                CApiTransitions.decRef(wrapper, 1L);
            }
            if (isPrimitiveProfile.profile(node, wrapper instanceof PrimitiveNativeWrapper)) {
                PrimitiveNativeWrapper primitive = (PrimitiveNativeWrapper)wrapper;
                if (primitive.isBool()) {
                    return primitive.getBool();
                }
                if (primitive.isInt()) {
                    return primitive.getInt();
                }
                if (primitive.isLong()) {
                    return primitive.getLong();
                }
                if (primitive.isDouble()) {
                    return primitive.getDouble();
                }
                throw CompilerDirectives.shouldNotReachHere();
            }
            return wrapper.getDelegate();
        }

        @CompilerDirectives.TruffleBoundary
        private static Object getManagedReference(Object value, HandleContext nativeContext) {
            assert (value.toString().startsWith("ManagedMemoryBlock"));
            assert (PythonContext.get(null).ownsGil());
            WeakReference ref = nativeContext.managedNativeLookup.computeIfAbsent(value, o -> new WeakReference<PythonAbstractNativeObject>(new PythonAbstractNativeObject(o)));
            Object result = ref.get();
            if (result == null) {
                result = new PythonAbstractNativeObject(value);
                nativeContext.managedNativeLookup.put(value, new WeakReference<PythonAbstractNativeObject>((PythonAbstractNativeObject)result));
            }
            return result;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PythonToNativeNewRefNode
    extends PythonToNativeNode {
        @Specialization
        static Object dummy(Void dummy) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.PythonToNativeNewRefNodeGen.getUncached().execute(obj);
        }

        @Override
        protected final boolean needsTransfer() {
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class PythonToNativeNode
    extends CExtToNativeNode {
        public final long executeLong(Object obj) {
            return PythonUtils.coerceToLong(this.execute(obj), LIB);
        }

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.PythonToNativeNodeGen.getUncached().execute(obj);
        }

        @CompilerDirectives.TruffleBoundary
        public static long executeLongUncached(Object obj) {
            return CApiTransitionsFactory.PythonToNativeNodeGen.getUncached().executeLong(obj);
        }

        protected boolean needsTransfer() {
            return false;
        }

        @Specialization
        Object doNative(PythonAbstractNativeObject obj, @Cached CExtNodes.PCallCapiFunction callAddRef) {
            if (this.needsTransfer()) {
                callAddRef.call(NativeCAPISymbol.FUN_ADDREF, obj.object, 1);
            }
            return obj.getPtr();
        }

        @Specialization
        static Object doNative(PythonNativePointer obj) {
            return obj.getPtr();
        }

        @Specialization
        Object doNative(DescriptorDeleteMarker obj) {
            return this.getContext().getNativeNull().getPtr();
        }

        static boolean isOther(Object obj) {
            return !(obj instanceof PythonAbstractNativeObject) && !(obj instanceof PythonNativePointer) && !(obj instanceof DescriptorDeleteMarker);
        }

        @Specialization(guards={"isOther(obj)"})
        static Object doOther(Object obj, @Bind(value="needsTransfer()") boolean needsTransfer, @Bind(value="this") Node inliningTarget, @Cached GetNativeWrapperNode getWrapper, @Cached InlinedConditionProfile isReplacementProfile, @Cached InlinedConditionProfile needsReplacementProfile, @CachedLibrary(limit="3") InteropLibrary lib) {
            CApiTransitions.pollReferenceQueue();
            PythonNativeWrapper wrapper = getWrapper.execute(obj);
            if (needsTransfer) {
                CApiTransitions.incRef(wrapper, 1L);
            }
            if (isReplacementProfile.profile(inliningTarget, wrapper instanceof PythonReplacingNativeWrapper)) {
                Object replacement = ((PythonReplacingNativeWrapper)wrapper).getReplacement();
                if (needsReplacementProfile.profile(inliningTarget, replacement == null)) {
                    lib.toNative((Object)wrapper);
                    replacement = ((PythonReplacingNativeWrapper)wrapper).getReplacement();
                }
                assert (replacement != null);
                return replacement;
            }
            if (!lib.isPointer((Object)wrapper)) {
                lib.toNative((Object)wrapper);
            }
            return wrapper;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CharPtrToPythonNode
    extends CExtToJavaNode {
        @Specialization
        static Object doForeign(Object value, @Bind(value="$node") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary interopLibrary, @Cached InlinedConditionProfile isNullProfile) {
            if (isNullProfile.profile(inliningTarget, interopLibrary.isNull(value))) {
                return PNone.NO_VALUE;
            }
            return CharPtrToPythonNode.nativeCharToJava(value);
        }

        @CompilerDirectives.TruffleBoundary
        public static Object nativeCharToJava(Object value) {
            CApiTransitions.log(value);
            assert (!(value instanceof Long));
            if (value instanceof String) {
                return CApiTransitions.logResult(PythonUtils.toTruffleStringUncached((String)value));
            }
            if (value instanceof TruffleString) {
                return CApiTransitions.logResult(value);
            }
            if (LIB.isPointer(value)) {
                long pointer;
                try {
                    pointer = LIB.asPointer(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
                    PythonNativeWrapper obj = HandleResolver.resolve(pointer);
                    if (obj != null) {
                        return CApiTransitions.logResult(obj.getDelegate());
                    }
                } else {
                    IdReference<?> lookup = CApiTransitions.nativeLookupGet(CApiTransitions.getContext(), pointer);
                    if (lookup != null) {
                        Object obj = lookup.get();
                        if (obj instanceof PythonAbstractNativeObject) {
                            return CApiTransitions.logResult(obj);
                        }
                        return CApiTransitions.logResult(((PythonNativeWrapper)value).getDelegate());
                    }
                }
            }
            CExtNodes.FromCharPointerNode fromCharPointerNode = CExtNodesFactory.FromCharPointerNodeGen.getUncached();
            return CApiTransitions.logResult(fromCharPointerNode.execute(value));
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class PointerContainer
    implements TruffleObject {
        private final long pointer;

        public PointerContainer(long pointer) {
            this.pointer = pointer;
        }

        @ExportMessage
        public boolean isPointer() {
            return true;
        }

        @ExportMessage
        public long asPointer() {
            return this.pointer;
        }

        @ExportMessage
        public void toNative() {
        }

        @ExportMessage
        public boolean isNull() {
            return this.pointer == 0L;
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return String.format("<0x%016x>", this.pointer);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class HandleResolverStealing
    implements TruffleObject {
        @ExportMessage
        public boolean isExecutable() {
            return true;
        }

        @ExportMessage
        public Object execute(Object[] args) {
            assert (args.length == 1);
            long pointer = (Long)args[0];
            return HandleResolverStealing.resolve(pointer);
        }

        public static PythonNativeWrapper resolve(long pointer) {
            PythonNativeWrapper wrapper = (PythonNativeWrapper)CApiTransitions.getContext().nativeHandles.get(HandlePointerConverter.pointerToHandleIndex(pointer)).get();
            assert (wrapper != null) : "reference was collected: " + Long.toHexString(pointer);
            return wrapper;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class HandleResolver
    implements TruffleObject {
        @ExportMessage
        public boolean isExecutable() {
            return true;
        }

        @ExportMessage
        public Object execute(Object[] args) {
            assert (args.length == 1);
            long pointer = (Long)args[0];
            return HandleResolver.resolve(pointer);
        }

        public static PythonNativeWrapper resolve(long pointer) {
            PythonNativeWrapper wrapper = (PythonNativeWrapper)CApiTransitions.getContext().nativeHandles.get(HandlePointerConverter.pointerToHandleIndex(pointer)).get();
            assert (wrapper != null) : "reference was collected: " + Long.toHexString(pointer);
            CApiTransitions.incRef(wrapper, 1L);
            return wrapper;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class HandleTester
    implements TruffleObject {
        @ExportMessage
        public boolean isExecutable() {
            return true;
        }

        @ExportMessage
        public Object execute(Object[] args, @CachedLibrary(limit="5") InteropLibrary lib) {
            long pointer;
            assert (args.length == 1);
            Object arg = args[0];
            assert (!(arg instanceof PythonAbstractObject));
            if (arg instanceof PythonNativeWrapper) {
                return 1;
            }
            if (arg instanceof Long) {
                pointer = (Long)arg;
            } else {
                if (!lib.isPointer(arg)) {
                    return 0;
                }
                try {
                    pointer = lib.asPointer(arg);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return HandlePointerConverter.pointsToPyHandleSpace(pointer) ? 1 : 0;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class HandleReleaser
    implements TruffleObject {
        @ExportMessage
        public boolean isExecutable() {
            return true;
        }

        @ExportMessage
        public Object execute(Object[] args, @CachedLibrary(limit="5") InteropLibrary lib) {
            long pointer;
            assert (args.length == 1);
            Object arg = args[0];
            if (arg instanceof PythonNativeWrapper || arg instanceof PythonAbstractObject) {
                return 0;
            }
            if (arg instanceof Long) {
                pointer = (Long)arg;
            } else {
                if (!lib.isPointer(arg)) {
                    return 0;
                }
                try {
                    pointer = lib.asPointer(arg);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            assert (HandlePointerConverter.pointsToPyHandleSpace(pointer));
            HandleReleaser.release(pointer);
            return 0;
        }

        public static void release(long pointer) {
            LOGGER.finer(() -> PythonUtils.formatJString("releasing handle %016x\n", pointer));
        }
    }
}

