/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonReplacingNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;

public final class PThreadState
extends PythonReplacingNativeWrapper {
    public static final String J_CUR_EXC_TYPE = "curexc_type";
    public static final String J_CUR_EXC_VALUE = "curexc_value";
    public static final String J_CUR_EXC_TRACEBACK = "curexc_traceback";
    public static final String J_EXC_TYPE = "exc_type";
    public static final String J_EXC_VALUE = "exc_value";
    public static final String J_EXC_INFO = "exc_info";
    public static final String J_EXC_TRACEBACK = "exc_traceback";
    public static final String J_DICT = "dict";
    public static final String J_PREV = "prev";
    public static final String J_RECURSION_DEPTH = "recursion_depth";
    public static final String J_OVERFLOWED = "overflowed";
    public static final String J_INTERP = "interp";
    public static final String J_USE_TRACING = "use_tracing";
    public static final String J_GILSTATE_COUNTER = "gilstate_counter";
    private final PythonContext.PythonThreadState threadState;

    private PThreadState(PythonContext.PythonThreadState threadState) {
        this.threadState = threadState;
    }

    public static PThreadState getThreadState(PythonLanguage language, PythonContext context) {
        PythonContext.PythonThreadState threadState = context.getThreadState(language);
        PThreadState nativeWrapper = threadState.getNativeWrapper();
        if (nativeWrapper == null) {
            nativeWrapper = new PThreadState(threadState);
            threadState.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    public PythonContext.PythonThreadState getThreadState() {
        return this.threadState;
    }

    @Override
    protected Object allocateReplacememtObject() {
        CApiTransitions.PythonToNativeNode toNative = CApiTransitionsFactory.PythonToNativeNodeGen.getUncached();
        Object ptr = CStructAccessFactory.AllocateNodeGen.getUncached().alloc(CStructs.PyThreadState, true);
        CStructAccess.WritePointerNode writePtrNode = CStructAccessFactory.WritePointerNodeGen.getUncached();
        Object nullValue = PythonContext.get(null).getNativeNull().getPtr();
        PDict threadStateDict = this.threadState.getDict();
        if (threadStateDict == null) {
            threadStateDict = PythonObjectFactory.getUncached().createDict();
            this.threadState.setDict(threadStateDict);
        }
        writePtrNode.write(ptr, CFields.PyThreadState__dict, toNative.execute(threadStateDict));
        writePtrNode.write(ptr, CFields.PyThreadState__interp, nullValue);
        return ptr;
    }
}

