/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIOBaseBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.BufferedIOBaseBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBufferedIOBase})
public final class BufferedIOBaseBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BufferedIOBaseBuiltinsFactory.getFactories();
    }

    @Builtin(name="write", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBuiltinNode {
        WriteNode() {
        }

        @Specialization
        Object write(Object self, Object args) {
            throw this.raise(PythonErrorType.IOUnsupportedOperation, IONodes.T_WRITE);
        }
    }

    @Builtin(name="readinto1", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer)
    @GenerateNodeFactory
    static abstract class ReadInto1Node
    extends ReadIntoGenericNode {
        ReadInto1Node() {
        }

        @Override
        protected final TruffleString getMethodName() {
            return IONodes.T_READ1;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedIOBaseBuiltinsClinicProviders.ReadInto1NodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="readinto", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer)
    @GenerateNodeFactory
    static abstract class ReadIntoNode
    extends ReadIntoGenericNode {
        ReadIntoNode() {
        }

        @Override
        protected final TruffleString getMethodName() {
            return IONodes.T_READ;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedIOBaseBuiltinsClinicProviders.ReadIntoNodeClinicProviderGen.INSTANCE;
        }
    }

    static abstract class ReadIntoGenericNode
    extends PythonBinaryClinicBuiltinNode {
        ReadIntoGenericNode() {
        }

        protected TruffleString getMethodName() {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object readinto(VirtualFrame frame, Object self, Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PyObjectCallMethodObjArgs callMethod, @Cached InlinedConditionProfile isBytes, @Cached InlinedConditionProfile oversize) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                Object data = callMethod.execute((Frame)frame, inliningTarget, self, this.getMethodName(), len);
                if (isBytes.profile(inliningTarget, !(data instanceof PBytes))) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.S_SHOULD_RETURN_BYTES, "read()");
                }
                int dataLen = bufferLib.getBufferLength(data);
                if (oversize.profile(inliningTarget, dataLen > len)) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.S_RETURNED_TOO_MUCH_DATA, "read()", len, dataLen);
                }
                bufferLib.readIntoBuffer(data, 0, buffer, 0, dataLen, bufferLib);
                Integer n = dataLen;
                return n;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract");
        }
    }

    @Builtin(name="read1", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class Read1Node
    extends PythonBuiltinNode {
        Read1Node() {
        }

        @Specialization
        Object read1(Object self, Object args) {
            throw this.raise(PythonErrorType.IOUnsupportedOperation, IONodes.T_READ1);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonBuiltinNode {
        ReadNode() {
        }

        @Specialization
        Object read(Object self, Object args) {
            throw this.raise(PythonErrorType.IOUnsupportedOperation, IONodes.T_READ);
        }
    }

    @Builtin(name="detach", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DetachNode
    extends PythonBuiltinNode {
        DetachNode() {
        }

        @Specialization
        Object detach(Object self) {
            throw this.raise(PythonErrorType.IOUnsupportedOperation, IONodes.T_DETACH);
        }
    }
}

