/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Sha256ModuleBuiltinsFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="_sha256")
public final class Sha256ModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Sha256ModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="sha256", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.SHA256Type, isPublic=false)
    @GenerateNodeFactory
    static abstract class Sha256Node
    extends PythonBuiltinNode {
        Sha256Node() {
        }

        @Specialization
        Object sha256(Object args, Object kwargs) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "_sha256.sha256");
        }
    }

    @Builtin(name="sha224", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.SHA224Type, isPublic=false)
    @GenerateNodeFactory
    static abstract class Sha224Node
    extends PythonBuiltinNode {
        Sha224Node() {
        }

        @Specialization
        Object sha224(Object args, Object kwargs) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "_sha256.sha224");
        }
    }

    @Builtin(name="sha256", minNumOfPositionalArgs=0, parameterNames={"string"}, keywordOnlyNames={"usedforsecurity"})
    @GenerateNodeFactory
    static abstract class Sha256FunctionNode
    extends PythonBuiltinNode {
        Sha256FunctionNode() {
        }

        @Specialization
        Object newDigest(VirtualFrame frame, Object buffer, Object usedForSecurity, @Bind(value="this") Node inliningTarget, @Cached HashlibModuleBuiltins.CreateDigestNode createNode) {
            return createNode.execute(frame, inliningTarget, PythonBuiltinClassType.SHA256Type, "sha256", "sha256", buffer, this);
        }
    }

    @Builtin(name="sha224", minNumOfPositionalArgs=0, parameterNames={"string"}, keywordOnlyNames={"usedforsecurity"})
    @GenerateNodeFactory
    static abstract class Sha224FunctionNode
    extends PythonBuiltinNode {
        Sha224FunctionNode() {
        }

        @Specialization
        Object newDigest(VirtualFrame frame, Object buffer, Object usedForSecurity, @Bind(value="this") Node inliningTarget, @Cached HashlibModuleBuiltins.CreateDigestNode createNode) {
            return createNode.execute(frame, inliningTarget, PythonBuiltinClassType.SHA224Type, "sha224", "sha224", buffer, this);
        }
    }
}

