/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.SimpleCDataBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.SimpleCData})
public final class SimpleCDataBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SimpleCDataBuiltinsFactory.getFactories();
    }

    static void Simple_set_value(VirtualFrame frame, CDataObject self, Object value, PRaiseNode raiseNode, StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, CFieldBuiltins.SetFuncNode setFuncNode, CDataTypeBuiltins.KeepRefNode keepRefNode) {
        StgDictObject dict = pyObjectStgDictNode.execute(self);
        if (value == null) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANT_DELETE_ATTRIBUTE);
        }
        assert (dict != null) : "Cannot be NULL for CDataObject instances";
        assert (dict.setfunc != FFIType.FieldSet.nil);
        Object result = setFuncNode.execute(frame, dict.setfunc, self.b_ptr, value, dict.size);
        keepRefNode.execute(frame, self, 0, result);
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        TruffleString Simple_repr(CDataObject self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CFieldBuiltins.GetFuncNode getFuncNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            if (!isSameTypeNode.execute(inliningTarget, clazz, (Object)PythonBuiltinClassType.SimpleCData)) {
                return simpleTruffleStringFormatNode.format("<%s object at %s>", getNameNode.execute(inliningTarget, clazz), getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self)));
            }
            StgDictObject dict = pyObjectStgDictNode.execute(self);
            TruffleString val = fromJavaStringNode.execute(ReprNode.toStringBoundary(getFuncNode.execute(dict.getfunc, self.b_ptr, self.b_size)), PythonUtils.TS_ENCODING);
            return simpleTruffleStringFormatNode.format("%s(%s)", getNameNode.execute(inliningTarget, clazz), val);
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStringBoundary(Object o) {
            return o.toString();
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class SimpleBoolNode
    extends PythonUnaryBuiltinNode {
        protected SimpleBoolNode() {
        }

        @Specialization
        static boolean Simple_bool(CDataObject self, @Bind(value="this") Node inliningTarget, @Cached PointerNodes.ReadBytesNode read) {
            byte[] bytes;
            if (self.b_ptr.isNull()) {
                return false;
            }
            for (byte b : bytes = read.execute(inliningTarget, self.b_ptr, self.b_size)) {
                if (b == 0) continue;
                return true;
            }
            return false;
        }
    }

    @Builtin(name="__ctypes_from_outparam__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class CtypesFromOutparamNode
    extends PythonUnaryBuiltinNode {
        protected CtypesFromOutparamNode() {
        }

        @Specialization
        Object Simple_from_outparm(CDataObject self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CFieldBuiltins.GetFuncNode getFuncNode) {
            if (pyTypeCheck.ctypesSimpleInstance(inliningTarget, getClassNode.execute(inliningTarget, self), getBaseClassNode, isSameTypeNode)) {
                return self;
            }
            StgDictObject dict = pyObjectStgDictNode.execute(self);
            return getFuncNode.execute(dict.getfunc, self.b_ptr, self.b_size);
        }
    }

    @Builtin(name="value", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="current value")
    @GenerateNodeFactory
    protected static abstract class SimpleValueNode
    extends PythonBinaryBuiltinNode {
        protected SimpleValueNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        Object Simple_get_value(CDataObject self, PNone value, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CFieldBuiltins.GetFuncNode getFuncNode) {
            StgDictObject dict = pyObjectStgDictNode.execute(self);
            assert (dict != null) : "Cannot be NULL for CDataObject instances";
            assert (dict.getfunc != FFIType.FieldGet.nil);
            return getFuncNode.execute(dict.getfunc, self.b_ptr, self.b_size);
        }

        @Specialization
        Object set_value(VirtualFrame frame, CDataObject self, Object value, @Cached CFieldBuiltins.SetFuncNode setFuncNode, @Cached CDataTypeBuiltins.KeepRefNode keepRefNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            SimpleCDataBuiltins.Simple_set_value(frame, self, value, this.getRaiseNode(), pyObjectStgDictNode, setFuncNode, keepRefNode);
            return PNone.NONE;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class InitNode
    extends PythonBuiltinNode {
        protected InitNode() {
        }

        @Specialization
        Object Simple_init(VirtualFrame frame, CDataObject self, Object[] args, PKeyword[] kwds, @Cached CFieldBuiltins.SetFuncNode setFuncNode, @Cached CDataTypeBuiltins.KeepRefNode keepRefNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            if (args.length > 0) {
                SimpleCDataBuiltins.Simple_set_value(frame, self, args[0], this.getRaiseNode(), pyObjectStgDictNode, setFuncNode, keepRefNode);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        protected Object newCData(Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(type, this.getRaiseNode());
            return pyCDataNewNode.execute(inliningTarget, type, dict);
        }
    }
}

