/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.codecs;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltins;
import com.oracle.graal.python.builtins.modules.codecs.CodecsRegistry;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.UnicodeDecodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.UnicodeEncodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.nio.ByteOrder;

public final class ErrorHandlers {
    private ErrorHandlers() {
    }

    public static int appendXmlCharRefReplacement(byte[] dest, int pos, int cp) {
        int digits = ErrorHandlers.getDigitCount(cp);
        dest[pos++] = 38;
        dest[pos++] = 35;
        pos += digits;
        for (int i = 0; i < digits; ++i) {
            dest[pos - i - 1] = (byte)(48 + cp % 10);
            cp /= 10;
        }
        dest[pos++] = 59;
        return pos;
    }

    public static int getXmlCharRefReplacementLength(int cp) {
        return 2 + ErrorHandlers.getDigitCount(cp) + 1;
    }

    private static int getDigitCount(int cp) {
        assert (cp >= 0 && cp <= 0x10FFFF);
        if (cp < 10) {
            return 1;
        }
        if (cp < 100) {
            return 2;
        }
        if (cp < 1000) {
            return 3;
        }
        if (cp < 10000) {
            return 4;
        }
        if (cp < 100000) {
            return 5;
        }
        if (cp < 1000000) {
            return 6;
        }
        return 7;
    }

    private static int adjustAndCheckPos(int newPos, int len, Node inliningTarget, PRaiseNode.Lazy raiseNode) {
        if (newPos < 0) {
            newPos += len;
        }
        if (newPos < 0 || newPos > len) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.POSITION_D_FROM_ERROR_HANDLER_OUT_OF_BOUNDS, newPos);
        }
        return newPos;
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class RaiseEncodeException
    extends Node {
        RaiseEncodeException() {
        }

        abstract void execute(Node var1, ErrorHandlerCache var2, TruffleString var3, TruffleString var4, int var5, int var6, TruffleString var7);

        @Specialization
        static void doIt(Node inliningTarget, ErrorHandlerCache cache, TruffleString encoding, TruffleString srcObj, int startPos, int endPos, TruffleString reason, @Cached UnicodeEncodeErrorBuiltins.MakeEncodeExceptionNode makeEncodeExceptionNode, @Cached(inline=false) PRaiseNode raiseNode) {
            cache.exceptionObject = makeEncodeExceptionNode.execute(inliningTarget, cache.exceptionObject, encoding, srcObj, startPos, endPos, reason);
            raiseNode.raiseExceptionObject(cache.exceptionObject);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CallEncodingErrorHandlerNode
    extends Node {
        CallEncodingErrorHandlerNode() {
        }

        abstract EncodingErrorHandlerResult execute(VirtualFrame var1, Node var2, ErrorHandlerCache var3, TruffleString var4, TruffleString var5, TruffleString var6, int var7, int var8, TruffleString var9);

        @Specialization
        static EncodingErrorHandlerResult doIt(VirtualFrame frame, Node inliningTarget, ErrorHandlerCache cache, TruffleString errors, TruffleString encoding, TruffleString srcObj, int startPos, int endPos, TruffleString reason, @Cached CodecsRegistry.PyCodecLookupErrorNode lookupErrorNode, @Cached UnicodeEncodeErrorBuiltins.MakeEncodeExceptionNode makeEncodeExceptionNode, @Cached(inline=false) CallNode callNode, @Cached ParseEncodingErrorHandlerResultNode parseResultNode, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached PRaiseNode.Lazy raiseNode) {
            cache.errorHandlerObject = cache.errorHandlerObject == null ? lookupErrorNode.execute(inliningTarget, errors) : cache.errorHandlerObject;
            int len = codePointLengthNode.execute((AbstractTruffleString)srcObj, PythonUtils.TS_ENCODING);
            cache.exceptionObject = makeEncodeExceptionNode.execute(inliningTarget, cache.exceptionObject, encoding, srcObj, startPos, endPos, reason);
            Object resultObj = callNode.execute((Frame)frame, cache.errorHandlerObject, new Object[]{cache.exceptionObject});
            EncodingErrorHandlerResult result = parseResultNode.execute(inliningTarget, resultObj);
            result.newPos = ErrorHandlers.adjustAndCheckPos(result.newPos, len, inliningTarget, raiseNode);
            return result;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ParseEncodingErrorHandlerResultNode
    extends Node {
        ParseEncodingErrorHandlerResultNode() {
        }

        abstract EncodingErrorHandlerResult execute(Node var1, Object var2);

        @Specialization
        static EncodingErrorHandlerResult doTuple(Node inliningTarget, PTuple result, @Cached SequenceNodes.LenNode lenNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached PyUnicodeCheckNode pyUnicodeCheckNode, @Cached PyBytesCheckNode pyBytesCheckNode, @Cached PRaiseNode.Lazy raiseNode) {
            boolean isUnicode;
            if (lenNode.execute(inliningTarget, result) != 2) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ENCODING_ERROR_HANDLER_MUST_RETURN_STR_BYTES_INT_TUPLE);
            }
            Object[] array = getObjectArrayNode.execute(inliningTarget, result);
            if (pyUnicodeCheckNode.execute(inliningTarget, array[0])) {
                isUnicode = true;
            } else if (pyBytesCheckNode.execute(inliningTarget, array[0])) {
                isUnicode = false;
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ENCODING_ERROR_HANDLER_MUST_RETURN_STR_BYTES_INT_TUPLE);
            }
            int pos = castToJavaIntExactNode.execute(inliningTarget, array[1]);
            return new EncodingErrorHandlerResult(array[0], pos, isUnicode);
        }

        @Fallback
        static EncodingErrorHandlerResult doOther(Node inliningTarget, Object result, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ENCODING_ERROR_HANDLER_MUST_RETURN_STR_BYTES_INT_TUPLE);
        }
    }

    @CompilerDirectives.ValueType
    static final class EncodingErrorHandlerResult {
        Object replacement;
        int newPos;
        boolean isUnicode;

        EncodingErrorHandlerResult(Object replacement, int newPos, boolean isUnicode) {
            this.replacement = replacement;
            this.newPos = newPos;
            this.isUnicode = isUnicode;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CallDecodingErrorHandlerNode
    extends Node {
        CallDecodingErrorHandlerNode() {
        }

        abstract DecodingErrorHandlerResult execute(VirtualFrame var1, Node var2, ErrorHandlerCache var3, TruffleString var4, TruffleString var5, Object var6, int var7, int var8, TruffleString var9);

        @Specialization
        static DecodingErrorHandlerResult doIt(VirtualFrame frame, Node inliningTarget, ErrorHandlerCache cache, TruffleString errors, TruffleString encoding, Object srcObj, int startPos, int endPos, TruffleString reason, @Cached CodecsRegistry.PyCodecLookupErrorNode lookupErrorNode, @Cached UnicodeDecodeErrorBuiltins.MakeDecodeExceptionNode makeDecodeExceptionNode, @Cached(inline=false) CallNode callNode, @Cached ParseDecodingErrorHandlerResultNode parseResultNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetObjectNode getObjectNode, @Cached PyObjectSizeNode sizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            cache.errorHandlerObject = cache.errorHandlerObject == null ? lookupErrorNode.execute(inliningTarget, errors) : cache.errorHandlerObject;
            cache.exceptionObject = makeDecodeExceptionNode.execute(inliningTarget, cache.exceptionObject, encoding, srcObj, startPos, endPos, reason);
            Object resultObj = callNode.execute((Frame)frame, cache.errorHandlerObject, new Object[]{cache.exceptionObject});
            DecodingErrorHandlerResult result = parseResultNode.execute(frame, inliningTarget, resultObj);
            result.newSrcObj = getObjectNode.execute(inliningTarget, cache.exceptionObject);
            int newSize = sizeNode.execute((Frame)frame, inliningTarget, result.newSrcObj);
            result.newPos = ErrorHandlers.adjustAndCheckPos(result.newPos, newSize, inliningTarget, raiseNode);
            return result;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ParseDecodingErrorHandlerResultNode
    extends Node {
        ParseDecodingErrorHandlerResultNode() {
        }

        abstract DecodingErrorHandlerResult execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static DecodingErrorHandlerResult doTuple(Node inliningTarget, PTuple result, @Cached SequenceNodes.LenNode lenNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached StringNodes.CastToTruffleStringCheckedNode castToTruffleStringCheckedNode, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (lenNode.execute(inliningTarget, result) != 2) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.DECODING_ERROR_HANDLER_MUST_RETURN_STR_INT_TUPLE);
            }
            Object[] array = getObjectArrayNode.execute(inliningTarget, result);
            TruffleString str = castToTruffleStringCheckedNode.cast(inliningTarget, array[0], ErrorMessages.DECODING_ERROR_HANDLER_MUST_RETURN_STR_INT_TUPLE, new Object[0]);
            int pos = castToJavaIntExactNode.execute(inliningTarget, array[1]);
            return new DecodingErrorHandlerResult(str, pos);
        }

        @Fallback
        static DecodingErrorHandlerResult doOther(Node inliningTarget, Object result, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DECODING_ERROR_HANDLER_MUST_RETURN_STR_INT_TUPLE);
        }
    }

    @CompilerDirectives.ValueType
    static final class DecodingErrorHandlerResult {
        TruffleString str;
        int newPos;
        Object newSrcObj;

        DecodingErrorHandlerResult(TruffleString str, int newPos) {
            this.str = str;
            this.newPos = newPos;
        }
    }

    static final class ErrorHandlerCache {
        ErrorHandler errorHandlerEnum = ErrorHandler.UNKNOWN;
        Object errorHandlerObject;
        PBaseException exceptionObject;

        ErrorHandlerCache() {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetStandardEncodingNode
    extends Node {
        private static final TruffleString T_CP_UTF8 = PythonUtils.tsLiteral("CP_UTF8");

        GetStandardEncodingNode() {
        }

        abstract StandardEncoding execute(Node var1, TruffleString var2);

        @Specialization
        StandardEncoding doIt(TruffleString encodingName, @Cached(inline=false) TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached(inline=false) TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached(inline=false) TruffleString.EqualNode equalNode) {
            if (getCodeRangeNode.execute((AbstractTruffleString)encodingName, PythonUtils.TS_ENCODING) != TruffleString.CodeRange.ASCII) {
                return StandardEncoding.UNKNOWN;
            }
            TruffleString asciiEncodingName = switchEncodingNode.execute((AbstractTruffleString)encodingName, TruffleString.Encoding.US_ASCII);
            int byteLength = asciiEncodingName.byteLength(TruffleString.Encoding.US_ASCII);
            if (byteLength > 9) {
                return StandardEncoding.UNKNOWN;
            }
            byte[] encoding = new byte[byteLength + 1];
            copyToByteArrayNode.execute((AbstractTruffleString)asciiEncodingName, 0, encoding, 0, byteLength, TruffleString.Encoding.US_ASCII);
            if (GetStandardEncodingNode.isAny(encoding[0], 'u', 'U') && GetStandardEncodingNode.isAny(encoding[1], 't', 'T') && GetStandardEncodingNode.isAny(encoding[2], 'f', 'F')) {
                int pos = 3;
                if (GetStandardEncodingNode.isAny(encoding[pos], '-', '_')) {
                    ++pos;
                }
                if (encoding[pos] == 56 && encoding[pos + 1] == 0) {
                    return StandardEncoding.UTF8;
                }
                if (encoding[pos] == 49 && encoding[pos + 1] == 54) {
                    return this.handleUtf16Or32(encoding, pos + 2, StandardEncoding.UTF16LE, StandardEncoding.UTF16BE);
                }
                if (encoding[pos] == 51 && encoding[pos + 1] == 50) {
                    return this.handleUtf16Or32(encoding, pos + 2, StandardEncoding.UTF32LE, StandardEncoding.UTF32BE);
                }
            } else if (equalNode.execute((AbstractTruffleString)encodingName, (AbstractTruffleString)T_CP_UTF8, PythonUtils.TS_ENCODING)) {
                return StandardEncoding.UTF8;
            }
            return StandardEncoding.UNKNOWN;
        }

        private StandardEncoding handleUtf16Or32(byte[] encoding, int pos, StandardEncoding le, StandardEncoding be) {
            if (encoding[pos] == 0) {
                return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? le : be;
            }
            if (GetStandardEncodingNode.isAny(encoding[pos], '-', '_')) {
                ++pos;
            }
            if (encoding[pos] != 0 && GetStandardEncodingNode.isAny(encoding[pos + 1], 'e', 'E') && encoding[pos + 2] == 0) {
                if (GetStandardEncodingNode.isAny(encoding[pos], 'b', 'B')) {
                    return be;
                }
                if (GetStandardEncodingNode.isAny(encoding[pos], 'l', 'L')) {
                    return le;
                }
            }
            return StandardEncoding.UNKNOWN;
        }

        private static boolean isAny(int cp, char option1, char option2) {
            return cp == option1 || cp == option2;
        }
    }

    static enum StandardEncoding {
        UNKNOWN(-1),
        UTF8(3),
        UTF16LE(2),
        UTF16BE(2),
        UTF32LE(4),
        UTF32BE(4);

        public final int byteLength;

        private StandardEncoding(int byteLength) {
            this.byteLength = byteLength;
        }
    }

    @Builtin(name="surrogateescape", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class SurrogateEscapeErrorHandlerNode
    extends ErrorHandlerBaseNode {
        SurrogateEscapeErrorHandlerNode() {
        }

        @Specialization(guards={"isEncode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doEncode(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetObjectNode getObjectNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetStartNode getStartNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetEndNode getEndNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            int start = getStartNode.execute(inliningTarget, exception);
            int end = getEndNode.execute(inliningTarget, exception);
            TruffleString src = getObjectNode.execute(inliningTarget, exception);
            if (start >= end) {
                return this.factory().createTuple(new Object[]{this.factory().createBytes(new byte[0]), end});
            }
            byte[] result = new byte[end - start];
            int pos = 0;
            for (int i = start; i < end; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)src, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                if (cp < 56448 || cp > 56575) {
                    throw this.getRaiseNode().raiseExceptionObject(exception);
                }
                result[pos++] = (byte)(cp - 56320);
            }
            return this.factory().createTuple(new Object[]{this.factory().createBytes(result), end});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDecode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doDecode(VirtualFrame frame, PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetObjectNode getObjectNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetStartNode getStartNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetEndNode getEndNode, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary accessLib, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            int start = getStartNode.execute(inliningTarget, exception);
            int end = getEndNode.execute(inliningTarget, exception);
            Object object = getObjectNode.execute(inliningTarget, exception);
            Object srcBuf = acquireLib.acquireReadonly(object, frame, this);
            TruffleStringBuilder tsb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            try {
                int v;
                int consumed;
                byte[] src = accessLib.getInternalOrCopiedByteArray(srcBuf);
                for (consumed = 0; consumed < 4 && consumed < end - start && (v = src[start + consumed] & 0xFF) >= 128; ++consumed) {
                    appendCodePointNode.execute(tsb, 56320 + v, 1, true);
                }
                if (consumed == 0) {
                    throw this.getRaiseNode().raiseExceptionObject(exception);
                }
                PTuple pTuple = this.factory().createTuple(new Object[]{toStringNode.execute(tsb), start + consumed});
                return pTuple;
            }
            finally {
                accessLib.release(srcBuf, frame, this);
            }
        }

        @Specialization(guards={"!isEncodeOrDecode(inliningTarget, o, pyObjectTypeCheck)"}, limit="1")
        Object doFallback(Object o, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck) {
            throw this.wrongExceptionType(o);
        }
    }

    @Builtin(name="surrogatepass", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class SurrogatePassErrorHandlerNode
    extends ErrorHandlerBaseNode {
        SurrogatePassErrorHandlerNode() {
        }

        @Specialization(guards={"isEncode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doEncode(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetObjectNode getObjectNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetStartNode getStartNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetEndNode getEndNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeErrorGetEncodingNode getEncodingNode, @Cached @Cached.Exclusive GetStandardEncodingNode getStandardEncodingNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            int start = getStartNode.execute(inliningTarget, exception);
            int end = getEndNode.execute(inliningTarget, exception);
            TruffleString src = getObjectNode.execute(inliningTarget, exception);
            TruffleString encodingName = getEncodingNode.execute(inliningTarget, exception);
            StandardEncoding encoding = getStandardEncodingNode.execute(inliningTarget, encodingName);
            if (encoding == StandardEncoding.UNKNOWN) {
                throw this.getRaiseNode().raiseExceptionObject(exception);
            }
            if (start >= end) {
                return this.factory().createTuple(new Object[]{this.factory().createBytes(new byte[0]), end});
            }
            byte[] result = new byte[encoding.byteLength * (end - start)];
            int pos = 0;
            for (int i = start; i < end; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)src, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                if (!SurrogatePassErrorHandlerNode.isSurrogate(cp)) {
                    throw this.getRaiseNode().raiseExceptionObject(exception);
                }
                SurrogatePassErrorHandlerNode.encodeCodepoint(encoding, result, pos, cp);
                pos += encoding.byteLength;
            }
            return this.factory().createTuple(new Object[]{this.factory().createBytes(result), end});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDecode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doDecode(VirtualFrame frame, PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetObjectNode getObjectNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetStartNode getStartNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetEndNode getEndNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetEncodingNode getEncodingNode, @Cached @Cached.Exclusive GetStandardEncodingNode getStandardEncodingNode, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary accessLib, @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            int start = getStartNode.execute(inliningTarget, exception);
            getEndNode.execute(inliningTarget, exception);
            Object object = getObjectNode.execute(inliningTarget, exception);
            TruffleString encodingName = getEncodingNode.execute(inliningTarget, exception);
            StandardEncoding encoding = getStandardEncodingNode.execute(inliningTarget, encodingName);
            if (encoding == StandardEncoding.UNKNOWN) {
                throw this.getRaiseNode().raiseExceptionObject(exception);
            }
            Object srcBuf = acquireLib.acquireReadonly(object, frame, this);
            try {
                int cp = 0;
                int srcLen = accessLib.getBufferLength(srcBuf);
                if (srcLen - start >= encoding.byteLength) {
                    cp = SurrogatePassErrorHandlerNode.decodeCodepoint(encoding, accessLib.getInternalOrCopiedByteArray(srcBuf), start);
                }
                if (!SurrogatePassErrorHandlerNode.isSurrogate(cp)) {
                    throw this.getRaiseNode().raiseExceptionObject(exception);
                }
                PTuple pTuple = this.factory().createTuple(new Object[]{fromCodePointNode.execute(cp, PythonUtils.TS_ENCODING, true), start + encoding.byteLength});
                return pTuple;
            }
            finally {
                accessLib.release(srcBuf, frame, this);
            }
        }

        @Specialization(guards={"!isEncodeOrDecode(inliningTarget, o, pyObjectTypeCheck)"}, limit="1")
        Object doFallback(Object o, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck) {
            throw this.wrongExceptionType(o);
        }

        private static void encodeCodepoint(StandardEncoding encoding, byte[] result, int pos, int cp) {
            switch (encoding) {
                case UTF8: {
                    result[pos] = (byte)(0xE0 | cp >> 12);
                    result[pos + 1] = (byte)(0x80 | cp >> 6 & 0x3F);
                    result[pos + 2] = (byte)(0x80 | cp & 0x3F);
                    break;
                }
                case UTF16LE: {
                    result[pos] = (byte)cp;
                    result[pos + 1] = (byte)(cp >> 8);
                    break;
                }
                case UTF16BE: {
                    result[pos] = (byte)(cp >> 8);
                    result[pos + 1] = (byte)cp;
                    break;
                }
                case UTF32LE: {
                    result[pos] = (byte)cp;
                    result[pos + 1] = (byte)(cp >> 8);
                    result[pos + 2] = (byte)(cp >> 16);
                    result[pos + 3] = (byte)(cp >> 24);
                    break;
                }
                case UTF32BE: {
                    result[pos] = (byte)(cp >> 24);
                    result[pos + 1] = (byte)(cp >> 16);
                    result[pos + 2] = (byte)(cp >> 8);
                    result[pos + 3] = (byte)cp;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"Unexpected encoding");
                }
            }
        }

        private static int decodeCodepoint(StandardEncoding encoding, byte[] src, int pos) {
            return switch (encoding) {
                case StandardEncoding.UTF8 -> {
                    if ((src[pos] & 0xF0) == 224 && (src[pos + 1] & 0xC0) == 128 && (src[pos + 2] & 0xC0) == 128) {
                        yield ((src[pos] & 0xF) << 12) + ((src[pos + 1] & 0x3F) << 6) + (src[pos + 2] & 0x3F);
                    }
                    yield 0;
                }
                case StandardEncoding.UTF16LE -> (src[pos + 1] & 0xFF) << 8 | src[pos] & 0xFF;
                case StandardEncoding.UTF16BE -> (src[pos] & 0xFF) << 8 | src[pos + 1] & 0xFF;
                case StandardEncoding.UTF32LE -> (src[pos + 3] & 0xFF) << 24 | (src[pos + 2] & 0xFF) << 16 | (src[pos + 1] & 0xFF) << 8 | src[pos] & 0xFF;
                case StandardEncoding.UTF32BE -> (src[pos] & 0xFF) << 24 | (src[pos + 1] & 0xFF) << 16 | (src[pos + 2] & 0xFF) << 8 | src[pos + 3] & 0xFF;
                default -> throw CompilerDirectives.shouldNotReachHere((String)"Unexpected encoding");
            };
        }

        private static boolean isSurrogate(int cp) {
            return cp >= 55296 && cp <= 57343;
        }
    }

    @Builtin(name="namereplace_errors", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class NameReplaceErrorHandlerNode
    extends ErrorHandlerBaseNode {
        NameReplaceErrorHandlerNode() {
        }

        @Specialization(guards={"isEncode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doEncode(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetObjectNode getObjectNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetStartNode getStartNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetEndNode getEndNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            int end;
            TruffleString src = getObjectNode.execute(inliningTarget, exception);
            int start = getStartNode.execute(inliningTarget, exception);
            if (start >= (end = getEndNode.execute(inliningTarget, exception))) {
                return this.factory().createTuple(new Object[]{StringLiterals.T_EMPTY_STRING, start});
            }
            TruffleStringBuilder tsb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            byte[] buf = new byte[10];
            for (int i = start; i < end; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)src, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                String name = UnicodeDataModuleBuiltins.getUnicodeName(cp);
                if (name != null) {
                    appendCodePointNode.execute(tsb, 92);
                    appendCodePointNode.execute(tsb, 78);
                    appendCodePointNode.execute(tsb, 123);
                    appendStringNode.execute(tsb, (AbstractTruffleString)fromJavaStringNode.execute(name, PythonUtils.TS_ENCODING));
                    appendCodePointNode.execute(tsb, 125);
                    continue;
                }
                int len = BytesUtils.unicodeNonAsciiEscape(cp, 0, buf, true);
                appendStringNode.execute(tsb, (AbstractTruffleString)switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(buf, 0, len, TruffleString.Encoding.US_ASCII, true), PythonUtils.TS_ENCODING));
            }
            return this.factory().createTuple(new Object[]{toStringNode.execute(tsb), end});
        }

        @Specialization(guards={"!isEncode(inliningTarget, o, pyObjectTypeCheck)"}, limit="1")
        Object doFallback(Object o, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck) {
            throw this.wrongExceptionType(o);
        }
    }

    @Builtin(name="backslashreplace_errors", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class BackslashReplaceErrorHandlerNode
    extends ErrorHandlerBaseNode {
        BackslashReplaceErrorHandlerNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDecode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doDecodeException(VirtualFrame frame, PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetObjectNode getObjectNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetStartNode getStartNode, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetEndNode getEndNode, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary accessLib, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared TruffleString.SwitchEncodingNode switchEncodingNode) {
            int start = getStartNode.execute(inliningTarget, exception);
            int end = getEndNode.execute(inliningTarget, exception);
            Object object = getObjectNode.execute(inliningTarget, exception);
            if (start >= end) {
                return this.factory().createTuple(new Object[]{StringLiterals.T_EMPTY_STRING, end});
            }
            byte[] replacement = new byte[4 * (end - start)];
            int pos = 0;
            Object srcBuf = acquireLib.acquireReadonly(object, frame, this);
            try {
                byte[] src = accessLib.getInternalOrCopiedByteArray(srcBuf);
                for (int i = start; i < end; ++i) {
                    pos = BytesUtils.byteEscape(src[i] & 0xFF, pos, replacement);
                }
            }
            finally {
                accessLib.release(srcBuf, frame, this);
            }
            TruffleString resultAscii = fromByteArrayNode.execute(replacement, TruffleString.Encoding.US_ASCII, false);
            return this.factory().createTuple(new Object[]{switchEncodingNode.execute((AbstractTruffleString)resultAscii, PythonUtils.TS_ENCODING), end});
        }

        @Specialization(guards={"isEncodeOrTranslate(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doEncodeOrTranslateException(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetObjectNode getObjectNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetStartNode getStartNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetEndNode getEndNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared TruffleString.SwitchEncodingNode switchEncodingNode) {
            int start = getStartNode.execute(inliningTarget, exception);
            int end = getEndNode.execute(inliningTarget, exception);
            TruffleString src = getObjectNode.execute(inliningTarget, exception);
            if (start >= end) {
                return this.factory().createTuple(new Object[]{StringLiterals.T_EMPTY_STRING, end});
            }
            int len = 0;
            for (int i = start; i < end; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)src, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                if (cp >= 65536) {
                    len += 10;
                    continue;
                }
                if (cp >= 256) {
                    len += 6;
                    continue;
                }
                len += 4;
            }
            byte[] replacement = new byte[len];
            int pos = 0;
            for (int i = start; i < end; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)src, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                pos = BytesUtils.unicodeNonAsciiEscape(cp, pos, replacement, true);
            }
            TruffleString resultAscii = fromByteArrayNode.execute(replacement, TruffleString.Encoding.US_ASCII, false);
            return this.factory().createTuple(new Object[]{switchEncodingNode.execute((AbstractTruffleString)resultAscii, PythonUtils.TS_ENCODING), end});
        }

        @Specialization(guards={"isNeither(inliningTarget, o, pyObjectTypeCheck)"}, limit="1")
        Object doFallback(Object o, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck) {
            throw this.wrongExceptionType(o);
        }
    }

    @Builtin(name="xmlcharrefreplace_errors", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class XmlCharRefReplaceErrorHandlerNode
    extends ErrorHandlerBaseNode {
        XmlCharRefReplaceErrorHandlerNode() {
        }

        @Specialization(guards={"isEncode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doEncode(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetObjectNode getObjectNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetStartNode getStartNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetEndNode getEndNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            TruffleString src = getObjectNode.execute(inliningTarget, exception);
            int start = getStartNode.execute(inliningTarget, exception);
            int end = getEndNode.execute(inliningTarget, exception);
            int replacementLength = 0;
            for (int i = start; i < end; ++i) {
                replacementLength += ErrorHandlers.getXmlCharRefReplacementLength(codePointAtIndexNode.execute((AbstractTruffleString)src, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT));
            }
            byte[] replacement = new byte[replacementLength];
            int pos = 0;
            for (int i = start; i < end; ++i) {
                pos = ErrorHandlers.appendXmlCharRefReplacement(replacement, pos, codePointAtIndexNode.execute((AbstractTruffleString)src, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT));
            }
            TruffleString resultAscii = fromByteArrayNode.execute(replacement, TruffleString.Encoding.US_ASCII, false);
            return this.factory().createTuple(new Object[]{switchEncodingNode.execute((AbstractTruffleString)resultAscii, PythonUtils.TS_ENCODING), end});
        }

        @Specialization(guards={"!isEncode(inliningTarget, o, pyObjectTypeCheck)"}, limit="1")
        Object doFallback(Object o, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck) {
            throw this.wrongExceptionType(o);
        }
    }

    @Builtin(name="replace_errors", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class ReplaceErrorHandlerNode
    extends ErrorHandlerBaseNode {
        private static final TruffleString T_REPLACEMENT = PythonUtils.tsLiteral("\ufffd");

        ReplaceErrorHandlerNode() {
        }

        @Specialization(guards={"isDecode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doDecodeException(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetEndNode getEndNode) {
            return this.factory().createTuple(new Object[]{T_REPLACEMENT, getEndNode.execute(inliningTarget, exception)});
        }

        @Specialization(guards={"isEncodeOrTranslate(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doEncodeOrTranslateException(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetStartNode getStartNode, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetEndNode getEndNode, @Cached TruffleString.RepeatNode repeatNode) {
            TruffleString replacement = ReplaceErrorHandlerNode.isEncode(inliningTarget, exception, pyObjectTypeCheck) ? StringLiterals.T_QUESTIONMARK : T_REPLACEMENT;
            int start = getStartNode.execute(inliningTarget, exception);
            int end = getEndNode.execute(inliningTarget, exception);
            int n = end - start;
            TruffleString result = n < 1 ? StringLiterals.T_EMPTY_STRING : repeatNode.execute((AbstractTruffleString)replacement, n, PythonUtils.TS_ENCODING);
            return this.factory().createTuple(new Object[]{result, end});
        }

        @Specialization(guards={"isNeither(inliningTarget, o, pyObjectTypeCheck)"}, limit="1")
        Object doFallback(Object o, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck) {
            throw this.wrongExceptionType(o);
        }
    }

    @Builtin(name="ignore_errors", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class IgnoreErrorHandlerNode
    extends ErrorHandlerBaseNode {
        IgnoreErrorHandlerNode() {
        }

        @Specialization(guards={"isDecode(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doDecodeException(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeDecodeErrorBuiltins.PyUnicodeDecodeErrorGetEndNode getEndNode) {
            return this.factory().createTuple(new Object[]{StringLiterals.T_EMPTY_STRING, getEndNode.execute(inliningTarget, exception)});
        }

        @Specialization(guards={"isEncodeOrTranslate(inliningTarget, exception, pyObjectTypeCheck)"}, limit="1")
        Object doEncodeOrTranslateException(PBaseException exception, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck, @Cached UnicodeEncodeErrorBuiltins.PyUnicodeEncodeOrTranslateErrorGetEndNode getEndNode) {
            return this.factory().createTuple(new Object[]{StringLiterals.T_EMPTY_STRING, getEndNode.execute(inliningTarget, exception)});
        }

        @Specialization(guards={"isNeither(inliningTarget, o, pyObjectTypeCheck)"}, limit="1")
        Object doFallback(Object o, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive PyObjectTypeCheck pyObjectTypeCheck) {
            throw this.wrongExceptionType(o);
        }
    }

    @Builtin(name="strict_errors", minNumOfPositionalArgs=1, parameterNames={"e"})
    static abstract class StrictErrorHandlerNode
    extends ErrorHandlerBaseNode {
        StrictErrorHandlerNode() {
        }

        @Specialization
        Object doException(PBaseException exception) {
            throw this.getRaiseNode().raiseExceptionObject(exception);
        }

        @Fallback
        Object doFallback(Object o) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CODEC_MUST_PASS_EXCEPTION_INSTANCE);
        }
    }

    static abstract class ErrorHandlerBaseNode
    extends PythonUnaryBuiltinNode {
        ErrorHandlerBaseNode() {
        }

        static boolean isDecode(Node inliningTarget, Object o, PyObjectTypeCheck pyObjectTypeCheck) {
            return pyObjectTypeCheck.execute(inliningTarget, o, (Object)PythonBuiltinClassType.UnicodeDecodeError);
        }

        static boolean isEncode(Node inliningTarget, Object o, PyObjectTypeCheck pyObjectTypeCheck) {
            return pyObjectTypeCheck.execute(inliningTarget, o, (Object)PythonBuiltinClassType.UnicodeEncodeError);
        }

        static boolean isTranslate(Node inliningTarget, Object o, PyObjectTypeCheck pyObjectTypeCheck) {
            return pyObjectTypeCheck.execute(inliningTarget, o, (Object)PythonBuiltinClassType.UnicodeTranslateError);
        }

        static boolean isEncodeOrTranslate(Node inliningTarget, Object o, PyObjectTypeCheck pyObjectTypeCheck) {
            return ErrorHandlerBaseNode.isEncode(inliningTarget, o, pyObjectTypeCheck) || ErrorHandlerBaseNode.isTranslate(inliningTarget, o, pyObjectTypeCheck);
        }

        static boolean isEncodeOrDecode(Node inliningTarget, Object o, PyObjectTypeCheck pyObjectTypeCheck) {
            return ErrorHandlerBaseNode.isEncode(inliningTarget, o, pyObjectTypeCheck) || ErrorHandlerBaseNode.isDecode(inliningTarget, o, pyObjectTypeCheck);
        }

        static boolean isNeither(Node inliningTarget, Object o, PyObjectTypeCheck pyObjectTypeCheck) {
            return !ErrorHandlerBaseNode.isDecode(inliningTarget, o, pyObjectTypeCheck) && !ErrorHandlerBaseNode.isEncode(inliningTarget, o, pyObjectTypeCheck) && !ErrorHandlerBaseNode.isTranslate(inliningTarget, o, pyObjectTypeCheck);
        }

        PException wrongExceptionType(Object o) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DONT_KNOW_HOW_TO_HANDLE_P_IN_ERROR_CALLBACK, o);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetErrorHandlerNode
    extends Node {
        public abstract ErrorHandler execute(Node var1, TruffleString var2);

        @Specialization
        static ErrorHandler doIt(Node inliningTarget, TruffleString errors, @Cached(inline=false) TruffleString.EqualNode equalNode, @Cached InlinedConditionProfile strictProfile, @Cached InlinedConditionProfile surrogateEscapeProfile, @Cached InlinedConditionProfile replaceProfile, @Cached InlinedConditionProfile ignoreProfile, @Cached InlinedConditionProfile backslashReplaceProfile, @Cached InlinedConditionProfile surrogatePassProfile, @Cached InlinedConditionProfile xmlCharRefReplaceProfile) {
            if (strictProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_STRICT, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING))) {
                return ErrorHandler.STRICT;
            }
            if (surrogateEscapeProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_SURROGATEPASS, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING))) {
                return ErrorHandler.SURROGATEESCAPE;
            }
            if (replaceProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_REPLACE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING))) {
                return ErrorHandler.REPLACE;
            }
            if (ignoreProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_IGNORE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING))) {
                return ErrorHandler.IGNORE;
            }
            if (backslashReplaceProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_BACKSLASHREPLACE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING))) {
                return ErrorHandler.BACKSLASHREPLACE;
            }
            if (surrogatePassProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_SURROGATEPASS, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING))) {
                return ErrorHandler.SURROGATEPASS;
            }
            if (xmlCharRefReplaceProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_XMLCHARREFREPLACE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING))) {
                return ErrorHandler.XMLCHARREFREPLACE;
            }
            return ErrorHandler.OTHER;
        }
    }

    public static final class ErrorHandler
    extends Enum<ErrorHandler> {
        public static final /* enum */ ErrorHandler UNKNOWN = new ErrorHandler();
        public static final /* enum */ ErrorHandler STRICT = new ErrorHandler();
        public static final /* enum */ ErrorHandler SURROGATEESCAPE = new ErrorHandler();
        public static final /* enum */ ErrorHandler REPLACE = new ErrorHandler();
        public static final /* enum */ ErrorHandler IGNORE = new ErrorHandler();
        public static final /* enum */ ErrorHandler BACKSLASHREPLACE = new ErrorHandler();
        public static final /* enum */ ErrorHandler SURROGATEPASS = new ErrorHandler();
        public static final /* enum */ ErrorHandler XMLCHARREFREPLACE = new ErrorHandler();
        public static final /* enum */ ErrorHandler OTHER = new ErrorHandler();
        private static final /* synthetic */ ErrorHandler[] $VALUES;

        public static ErrorHandler[] values() {
            return (ErrorHandler[])$VALUES.clone();
        }

        public static ErrorHandler valueOf(String name) {
            return Enum.valueOf(ErrorHandler.class, name);
        }

        public int getNativeValue() {
            return this.ordinal();
        }

        private static /* synthetic */ ErrorHandler[] $values() {
            return new ErrorHandler[]{UNKNOWN, STRICT, SURROGATEESCAPE, REPLACE, IGNORE, BACKSLASHREPLACE, SURROGATEPASS, XMLCHARREFREPLACE, OTHER};
        }

        static {
            $VALUES = ErrorHandler.$values();
            assert (UNKNOWN.getNativeValue() == 0);
            assert (STRICT.getNativeValue() == 1);
            assert (SURROGATEESCAPE.getNativeValue() == 2);
            assert (REPLACE.getNativeValue() == 3);
            assert (IGNORE.getNativeValue() == 4);
            assert (BACKSLASHREPLACE.getNativeValue() == 5);
            assert (SURROGATEPASS.getNativeValue() == 6);
            assert (XMLCHARREFREPLACE.getNativeValue() == 7);
            assert (OTHER.getNativeValue() == 8);
        }
    }
}

