/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;

public abstract class BasicSequenceStorage
extends SequenceStorage {
    public abstract Object getCopyOfInternalArrayObject();

    public abstract void setInternalArrayObject(Object var1);

    private static int capacityFor(int length) throws ArithmeticException {
        return Math.max(16, Math.multiplyExact(length, 2));
    }

    @Override
    public final void ensureCapacity(int newCapacity) throws ArithmeticException {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (newCapacity > this.capacity ? 1 : 0) != 0)) {
            this.increaseCapacityExactWithCopy(BasicSequenceStorage.capacityFor(newCapacity));
        }
    }

    protected abstract void increaseCapacityExactWithCopy(int var1);

    protected abstract void increaseCapacityExact(int var1);

    public void minimizeCapacity() {
        this.capacity = this.length;
    }
}

