/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import sun.misc.Unsafe;

@ExportLibrary(value=PosixSupportLibrary.class)
public final class NFIPosixSupport
extends PosixSupport {
    private static final String SUPPORTING_NATIVE_LIB_NAME = "posix";
    private static final int UNAME_BUF_LENGTH = 256;
    private static final int DIRENT_NAME_BUF_LENGTH = 256;
    private static final int PWD_OUTPUT_LEN = 5;
    private static final int PWD_BUFFER_MAX_SIZE = 0x1FFFFFFF;
    private static final int MAX_READ = 0x3FFFFFFF;
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(NFIPosixSupport.class);
    private static final Unsafe UNSAFE = PythonUtils.initUnsafe();
    private static final Object CRYPT_LOCK = new Object();
    private final PythonContext context;
    private final TruffleString nfiBackend;
    private volatile Object nfiLibrary;
    private final AtomicReferenceArray<Object> cachedFunctions;
    private int sysConfPwdSizeMax = -1;

    public NFIPosixSupport(PythonContext context, TruffleString nfiBackend) {
        assert (nfiBackend.equalsUncached((AbstractTruffleString)StringLiterals.T_NATIVE, PythonUtils.TS_ENCODING) || nfiBackend.equalsUncached((AbstractTruffleString)StringLiterals.T_LLVM_LANGUAGE, PythonUtils.TS_ENCODING));
        this.context = context;
        this.nfiBackend = nfiBackend;
        this.cachedFunctions = new AtomicReferenceArray(PosixNativeFunction.values().length);
        this.setEnv(context.getEnv());
    }

    @Override
    public void setEnv(TruffleLanguage.Env env) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return;
        }
        try {
            TruffleFile truffleFile = this.context.getEnv().getInternalTruffleFile(".").getAbsoluteFile();
            this.context.getEnv().setCurrentWorkingDirectory(truffleFile);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to change Truffle working directory", (Throwable)e);
        }
    }

    @ExportMessage
    public TruffleString getBackend() {
        return this.nfiBackend;
    }

    @ExportMessage
    public TruffleString strerror(int errorCode, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) {
        byte[] buf = new byte[1024];
        invokeNode2.call(this, PosixNativeFunction.call_strerror, errorCode, this.wrap(buf), buf.length);
        return NFIPosixSupport.cStringToTruffleString(buf, fromByteArrayNode, switchEncodingFromUtf8Node);
    }

    @ExportMessage
    public long getpid(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this, PosixNativeFunction.call_getpid, new Object[0]);
    }

    @ExportMessage
    public int umask(int mask, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_umask, mask);
        if (result < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return result;
    }

    @ExportMessage
    public int openat(int dirFd, Object pathname, int flags, int mode, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int fd = invokeNode2.callInt(this, PosixNativeFunction.call_openat, dirFd, this.pathToCString(pathname), flags, mode);
        if (fd < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return fd;
    }

    @ExportMessage
    public int close(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int rv = invokeNode2.callInt(this, PosixNativeFunction.call_close, fd);
        if (rv < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return rv;
    }

    @ExportMessage
    public PosixSupportLibrary.Buffer read(int fd, long length, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long count = Math.min(length, 0x3FFFFFFFL);
        PosixSupportLibrary.Buffer buffer = PosixSupportLibrary.Buffer.allocate(count);
        this.setErrno(invokeNode2, 0);
        long n = invokeNode2.callLong(this, PosixNativeFunction.call_read, fd, this.wrap(buffer), count);
        if (n < 0L) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return buffer.withLength(n);
    }

    @ExportMessage
    public long write(int fd, PosixSupportLibrary.Buffer data, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        this.setErrno(invokeNode2, 0);
        long n = invokeNode2.callLong(this, PosixNativeFunction.call_write, fd, this.wrap(data), data.length);
        if (n < 0L) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return n;
    }

    @ExportMessage
    public int dup(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int newFd = invokeNode2.callInt(this, PosixNativeFunction.call_dup, fd);
        if (newFd < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return newFd;
    }

    @ExportMessage
    public int dup2(int fd, int fd2, boolean inheritable, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int newFd = invokeNode2.callInt(this, PosixNativeFunction.call_dup2, fd, fd2, inheritable ? 1 : 0);
        if (newFd < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return newFd;
    }

    @ExportMessage
    public boolean getInheritable(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.get_inheritable, fd);
        if (result < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return result != 0;
    }

    @ExportMessage
    public void setInheritable(int fd, boolean inheritable, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        if (invokeNode2.callInt(this, PosixNativeFunction.set_inheritable, fd, inheritable ? 1 : 0) < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public int[] pipe(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int[] fds = new int[2];
        if (invokeNode2.callInt(this, PosixNativeFunction.call_pipe2, this.context.getEnv().asGuestValue((Object)fds)) != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return fds;
    }

    @ExportMessage
    public PosixSupportLibrary.SelectResult select(int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result;
        int largestFD = NFIPosixSupport.findMax(readfds, -1);
        largestFD = NFIPosixSupport.findMax(writefds, largestFD);
        largestFD = NFIPosixSupport.findMax(errorfds, largestFD);
        byte[] selected = new byte[readfds.length + writefds.length + errorfds.length];
        int nfds = largestFD == -1 ? 0 : largestFD + 1;
        long secs = -1L;
        long usecs = -1L;
        if (timeout != null) {
            secs = timeout.getSeconds();
            usecs = timeout.getMicroseconds();
        }
        if ((result = invokeNode2.callInt(this, PosixNativeFunction.call_select, nfds, this.wrap(readfds), readfds.length, this.wrap(writefds), writefds.length, this.wrap(errorfds), errorfds.length, secs, usecs, this.wrap(selected))) < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return new PosixSupportLibrary.SelectResult(NFIPosixSupport.selectFillInResult(readfds, selected, 0), NFIPosixSupport.selectFillInResult(writefds, selected, readfds.length), NFIPosixSupport.selectFillInResult(errorfds, selected, readfds.length + writefds.length));
    }

    private static boolean[] selectFillInResult(int[] fds, byte[] selected, int selectedOffset) {
        boolean[] res = new boolean[fds.length];
        for (int i = 0; i < fds.length; ++i) {
            res[i] = selected[selectedOffset + i] != 0;
        }
        return res;
    }

    private static int findMax(int[] items, int currentMax) {
        int max = currentMax;
        for (int item : items) {
            if (item <= max) continue;
            max = item;
        }
        return max;
    }

    @ExportMessage
    public long lseek(int fd, long offset, int how, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long res = invokeNode2.callLong(this, PosixNativeFunction.call_lseek, fd, offset, how);
        if (res < 0L) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return res;
    }

    @ExportMessage
    public void ftruncate(int fd, long length, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_ftruncate, fd, length);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public void fsync(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_fsync, fd);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    final void flock(int fd, int operation, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_flock, fd, operation);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public boolean getBlocking(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.get_blocking, fd);
        if (result < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return result != 0;
    }

    @ExportMessage
    public void setBlocking(int fd, boolean blocking, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        if (invokeNode2.callInt(this, PosixNativeFunction.set_blocking, fd, blocking ? 1 : 0) < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public int[] getTerminalSize(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int[] size = new int[2];
        if (invokeNode2.callInt(this, PosixNativeFunction.get_terminal_size, fd, this.context.getEnv().asGuestValue((Object)size)) != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return size;
    }

    @ExportMessage
    public long[] fstatat(int dirFd, Object pathname, boolean followSymlinks, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long[] out = new long[13];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_fstatat, dirFd, this.pathToCString(pathname), followSymlinks ? 1 : 0, this.wrap(out));
        if (res != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return out;
    }

    @ExportMessage
    public long[] fstat(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long[] out = new long[13];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_fstat, fd, this.wrap(out));
        if (res != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return out;
    }

    @ExportMessage
    public long[] statvfs(Object path, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long[] out = new long[11];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_statvfs, this.pathToCString(path), this.wrap(out));
        if (res != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return out;
    }

    @ExportMessage
    public long[] fstatvfs(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long[] out = new long[11];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_fstatvfs, fd, this.wrap(out));
        if (res != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return out;
    }

    @ExportMessage
    public Object[] uname(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        byte[] sys = new byte[256];
        byte[] node = new byte[256];
        byte[] rel = new byte[256];
        byte[] ver = new byte[256];
        byte[] machine = new byte[256];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_uname, this.wrap(sys), this.wrap(node), this.wrap(rel), this.wrap(ver), this.wrap(machine), 256);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return new Object[]{NFIPosixSupport.cStringToTruffleString(sys, fromByteArrayNode, switchEncodingFromUtf8Node), NFIPosixSupport.cStringToTruffleString(node, fromByteArrayNode, switchEncodingFromUtf8Node), NFIPosixSupport.cStringToTruffleString(rel, fromByteArrayNode, switchEncodingFromUtf8Node), NFIPosixSupport.cStringToTruffleString(ver, fromByteArrayNode, switchEncodingFromUtf8Node), NFIPosixSupport.cStringToTruffleString(machine, fromByteArrayNode, switchEncodingFromUtf8Node)};
    }

    @ExportMessage
    public void unlinkat(int dirFd, Object pathname, boolean rmdir, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_unlinkat, dirFd, this.pathToCString(pathname), rmdir ? 1 : 0);
        if (result != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void linkat(int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_linkat, oldFdDir, this.pathToCString(oldPath), newFdDir, this.pathToCString(newPath), flags);
        if (result != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void symlinkat(Object target, int linkpathDirFd, Object linkpath, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_symlinkat, this.pathToCString(target), linkpathDirFd, this.pathToCString(linkpath));
        if (result != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void mkdirat(int dirFd, Object pathname, int mode, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_mkdirat, dirFd, this.pathToCString(pathname), mode);
        if (result != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public Object getcwd(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int bufLen = 1024;
        while (true) {
            PosixSupportLibrary.Buffer buffer = PosixSupportLibrary.Buffer.allocate(bufLen);
            int n = invokeNode2.callInt(this, PosixNativeFunction.call_getcwd, this.wrap(buffer), bufLen);
            if (n == 0) {
                buffer = buffer.withLength(NFIPosixSupport.findZero(buffer.data));
                return buffer;
            }
            int errno = this.getErrno(invokeNode2);
            if (errno != OSErrorEnum.ERANGE.getNumber()) {
                throw this.newPosixException(invokeNode2, errno);
            }
            bufLen += 1024;
        }
    }

    @ExportMessage
    public void chdir(Object path, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_chdir, this.pathToCString(path));
        if (result != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void fchdir(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_fchdir, fd);
        if (result != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public boolean isatty(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_isatty, fd) != 0;
    }

    @ExportMessage
    public Object opendir(Object path, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long ptr = invokeNode2.callLong(this, PosixNativeFunction.call_opendir, this.pathToCString(path));
        if (ptr == 0L) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return ptr;
    }

    @ExportMessage
    public Object fdopendir(int fd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long ptr = invokeNode2.callLong(this, PosixNativeFunction.call_fdopendir, fd);
        if (ptr == 0L) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return ptr;
    }

    @ExportMessage
    public void closedir(Object dirStreamObj, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_closedir, dirStreamObj);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public Object readdir(Object dirStreamObj, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result;
        PosixSupportLibrary.Buffer name = PosixSupportLibrary.Buffer.allocate(256L);
        long[] out = new long[2];
        while ((result = invokeNode2.callInt(this, PosixNativeFunction.call_readdir, dirStreamObj, this.wrap(name), 256, this.wrap(out))) != 0 && name.data[0] == 46 && (name.data[1] == 0 || name.data[1] == 46 && name.data[2] == 0)) {
        }
        if (result != 0) {
            return new DirEntry(name.withLength(NFIPosixSupport.findZero(name.data)), out[0], (int)out[1]);
        }
        int errno = this.getErrno(invokeNode2);
        if (errno == 0) {
            return null;
        }
        throw this.newPosixException(invokeNode2, errno);
    }

    @ExportMessage
    public void rewinddir(Object dirStreamObj, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this, PosixNativeFunction.call_rewinddir, dirStreamObj);
    }

    @ExportMessage
    public Object dirEntryGetName(Object dirEntryObj) {
        DirEntry dirEntry = (DirEntry)dirEntryObj;
        return dirEntry.name;
    }

    @ExportMessage
    public long dirEntryGetInode(Object dirEntry) {
        DirEntry entry = (DirEntry)dirEntry;
        return entry.ino;
    }

    @ExportMessage
    public int dirEntryGetType(Object dirEntryObj) {
        DirEntry dirEntry = (DirEntry)dirEntryObj;
        return dirEntry.type;
    }

    @ExportMessage
    public void utimensat(int dirFd, Object pathname, long[] timespec, boolean followSymlinks, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        assert (PosixConstants.HAVE_UTIMENSAT.value);
        assert (timespec == null || timespec.length == 4);
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_utimensat, dirFd, this.pathToCString(pathname), this.wrap(timespec), followSymlinks ? 1 : 0);
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void futimens(int fd, long[] timespec, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        assert (PosixConstants.HAVE_FUTIMENS.value);
        assert (timespec == null || timespec.length == 4);
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_futimens, fd, this.wrap(timespec));
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void futimes(int fd, PosixSupportLibrary.Timeval[] timeval, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        assert (timeval == null || timeval.length == 2);
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_futimes, fd, this.wrap(timeval));
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void lutimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        assert (timeval == null || timeval.length == 2);
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_lutimes, this.pathToCString(filename), this.wrap(timeval));
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void utimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        assert (timeval == null || timeval.length == 2);
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_utimes, this.pathToCString(filename), this.wrap(timeval));
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void renameat(int oldDirFd, Object oldPath, int newDirFd, Object newPath, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_renameat, oldDirFd, this.pathToCString(oldPath), newDirFd, this.pathToCString(newPath));
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public boolean faccessat(int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_faccessat, dirFd, this.pathToCString(path), mode, effectiveIds ? 1 : 0, followSymlinks ? 1 : 0);
        if (ret != 0 && LOGGER.isLoggable(Level.FINE)) {
            NFIPosixSupport.log(Level.FINE, "faccessat return value: %d, errno: %d", ret, this.getErrno(invokeNode2));
        }
        return ret == 0;
    }

    @ExportMessage
    public void fchmodat(int dirFd, Object path, int mode, boolean followSymlinks, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_fchmodat, dirFd, this.pathToCString(path), mode, followSymlinks ? 1 : 0);
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public void fchmod(int fd, int mode, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int ret = invokeNode2.callInt(this, PosixNativeFunction.call_fchmod, fd, mode);
        if (ret != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public Object readlinkat(int dirFd, Object path, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        PosixSupportLibrary.Buffer buffer = PosixSupportLibrary.Buffer.allocate(PosixConstants.PATH_MAX.value);
        long n = invokeNode2.callLong(this, PosixNativeFunction.call_readlinkat, dirFd, this.pathToCString(path), this.wrap(buffer), PosixConstants.PATH_MAX.value);
        if (n < 0L) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return buffer.withLength(n);
    }

    @ExportMessage
    public void kill(long pid, int signal, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_kill, pid, signal);
        if (res == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public void killpg(long pgid, int signal, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_killpg, pgid, signal);
        if (res == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public long[] waitpid(long pid, int options, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int[] status = new int[1];
        boolean hasNohang = (options & PosixConstants.WNOHANG.getValueIfDefined()) != 0;
        int subOptions = options | PosixConstants.WNOHANG.getValueIfDefined();
        Object wrappedStatus = this.wrap(status);
        long res = invokeNode2.callLong(this, PosixNativeFunction.call_waitpid, pid, wrappedStatus, subOptions);
        while (res == 0L && !hasNohang) {
            TruffleSafepoint.setBlockedThreadInterruptible((Node)invokeNode2, ignored -> Thread.sleep(20L), null);
            res = invokeNode2.callLong(this, PosixNativeFunction.call_waitpid, pid, wrappedStatus, subOptions);
        }
        if (res < 0L) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return new long[]{res, status[0]};
    }

    @ExportMessage
    public boolean wcoredump(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wcoredump, status) != 0;
    }

    @ExportMessage
    public void abort(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this, PosixNativeFunction.call_abort, new Object[0]);
    }

    @ExportMessage
    public boolean wifcontinued(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wifcontinued, status) != 0;
    }

    @ExportMessage
    public boolean wifstopped(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wifstopped, status) != 0;
    }

    @ExportMessage
    public boolean wifsignaled(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wifsignaled, status) != 0;
    }

    @ExportMessage
    public boolean wifexited(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wifexited, status) != 0;
    }

    @ExportMessage
    public int wexitstatus(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wexitstatus, status);
    }

    @ExportMessage
    public int wtermsig(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wtermsig, status);
    }

    @ExportMessage
    public int wstopsig(int status, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_wstopsig, status);
    }

    @ExportMessage
    public long getuid(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this, PosixNativeFunction.call_getuid, new Object[0]);
    }

    @ExportMessage
    public long geteuid(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this, PosixNativeFunction.call_geteuid, new Object[0]);
    }

    @ExportMessage
    public long getgid(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this, PosixNativeFunction.call_getgid, new Object[0]);
    }

    @ExportMessage
    public long getppid(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this, PosixNativeFunction.call_getppid, new Object[0]);
    }

    @ExportMessage
    public void setpgid(long pid, long pgid, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_setpgid, pid, pgid);
        if (res < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public long getpgid(long pid, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long res = invokeNode2.callLong(this, PosixNativeFunction.call_getpgid, pid);
        if (res < 0L) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return res;
    }

    @ExportMessage
    public long getpgrp(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this, PosixNativeFunction.call_getpgrp, new Object[0]);
    }

    @ExportMessage
    public long getsid(long pid, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long res = invokeNode2.callLong(this, PosixNativeFunction.call_getsid, pid);
        if (res < 0L) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return res;
    }

    @ExportMessage
    public long setsid(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long res = invokeNode2.callLong(this, PosixNativeFunction.call_setsid, new Object[0]);
        if (res < 0L) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return res;
    }

    @ExportMessage
    public PosixSupportLibrary.OpenPtyResult openpty(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int[] outvars = new int[2];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_openpty, this.wrap(outvars));
        if (res == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return new PosixSupportLibrary.OpenPtyResult(outvars[0], outvars[1]);
    }

    @ExportMessage
    public TruffleString ctermid(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        byte[] buf = new byte[PosixConstants.L_ctermid.value];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_ctermid, this.wrap(buf));
        if (res == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return NFIPosixSupport.cStringToTruffleString(buf, fromByteArrayNode, switchEncodingFromUtf8Node);
    }

    @ExportMessage
    public void setenv(Object name, Object value, boolean overwrite, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_setenv, this.pathToCString(name), this.pathToCString(value), overwrite ? 1 : 0);
        if (res == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public void unsetenv(Object name, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_unsetenv, this.pathToCString(name));
        if (res == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public int forkExec(Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int cwdPos;
        int envPos;
        int argsPos;
        long dataLen;
        int offsetsLen;
        try {
            offsetsLen = executables.length + 1;
            dataLen = NFIPosixSupport.addLengthsOfCStrings(0L, executables);
            argsPos = offsetsLen;
            offsetsLen += args.length + 1;
            dataLen = NFIPosixSupport.addLengthsOfCStrings(dataLen, args);
            if (env != null) {
                envPos = offsetsLen;
                offsetsLen += env.length + 1;
                dataLen = NFIPosixSupport.addLengthsOfCStrings(dataLen, env);
            } else {
                envPos = -1;
            }
            if (cwd != null) {
                cwdPos = offsetsLen++;
                dataLen = PythonUtils.addExact(dataLen, ((PosixSupportLibrary.Buffer)cwd).length + 1L);
            } else {
                cwdPos = -1;
            }
        }
        catch (OverflowException e) {
            throw this.newPosixException(invokeNode2, OSErrorEnum.E2BIG.getNumber());
        }
        if (dataLen >= 0x7FFFFFFCL) {
            throw this.newPosixException(invokeNode2, OSErrorEnum.E2BIG.getNumber());
        }
        byte[] data = new byte[(int)dataLen];
        long[] offsets = new long[offsetsLen];
        long offset = 0L;
        offset = NFIPosixSupport.encodeCStringArray(data, offset, offsets, 0, executables);
        offset = NFIPosixSupport.encodeCStringArray(data, offset, offsets, argsPos, args);
        if (env != null) {
            offset = NFIPosixSupport.encodeCStringArray(data, offset, offsets, envPos, env);
        }
        if (cwd != null) {
            PosixSupportLibrary.Buffer buf = (PosixSupportLibrary.Buffer)cwd;
            int strLen = (int)buf.length;
            PythonUtils.arraycopy(buf.data, 0, data, (int)offset, strLen);
            offsets[cwdPos] = offset;
            offset += (long)strLen + 1L;
        }
        assert (offset == dataLen);
        int res = invokeNode2.callInt(this, PosixNativeFunction.fork_exec, this.wrap(data), this.wrap(offsets), offsets.length, argsPos, envPos, cwdPos, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds ? 1 : 0, restoreSignals ? 1 : 0, callSetsid ? 1 : 0, this.wrap(fdsToKeep), fdsToKeep.length);
        if (res == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return res;
    }

    @ExportMessage
    public void execv(Object pathname, Object[] args, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long dataLen;
        int offsetsLen = 1 + args.length + 1;
        long pathnameLen = ((PosixSupportLibrary.Buffer)pathname).length;
        try {
            dataLen = NFIPosixSupport.addLengthsOfCStrings(pathnameLen + 1L, args);
        }
        catch (OverflowException e) {
            throw this.newPosixException(invokeNode2, OSErrorEnum.E2BIG.getNumber());
        }
        if (dataLen >= 0x7FFFFFFEL) {
            throw this.newPosixException(invokeNode2, OSErrorEnum.E2BIG.getNumber());
        }
        byte[] data = new byte[(int)dataLen];
        long[] offsets = new long[offsetsLen];
        PythonUtils.arraycopy(((PosixSupportLibrary.Buffer)pathname).data, 0, data, 0, (int)pathnameLen);
        long offset = NFIPosixSupport.encodeCStringArray(data, pathnameLen + 1L, offsets, 1, args);
        assert (offset == dataLen);
        invokeNode2.call(this, PosixNativeFunction.call_execv, this.wrap(data), this.wrap(offsets), offsets.length);
        throw this.getErrnoAndThrowPosixException(invokeNode2);
    }

    @ExportMessage
    public int system(Object command, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_system, this.pathToCString(command));
    }

    private static long addLengthsOfCStrings(long prevLen, Object[] src) throws OverflowException {
        long len = prevLen;
        for (Object o : src) {
            len = PythonUtils.addExact(len, ((PosixSupportLibrary.Buffer)o).length);
        }
        return PythonUtils.addExact(len, (long)src.length);
    }

    private static long encodeCStringArray(byte[] data, long startOffset, long[] offsets, int startPos, Object[] src) {
        long offset = startOffset;
        for (int i = 0; i < src.length; ++i) {
            PosixSupportLibrary.Buffer buf = (PosixSupportLibrary.Buffer)src[i];
            int strLen = (int)buf.length;
            PythonUtils.arraycopy(buf.data, 0, data, (int)offset, strLen);
            offsets[startPos + i] = offset;
            offset += (long)(strLen + 1);
        }
        offsets[startPos + src.length] = -1L;
        return offset;
    }

    @ExportMessage
    public Object mmap(long length, int prot, int flags, int fd, long offset, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        long address = invokeNode2.callLong(this, PosixNativeFunction.call_mmap, length, prot, flags, fd, offset);
        if (address == 0L) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
        return new MMapHandle(address, length);
    }

    @ExportMessage
    public byte mmapReadByte(Object mmap, long index) {
        MMapHandle handle = (MMapHandle)mmap;
        if (index < 0L || index >= handle.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException();
        }
        return UNSAFE.getByte(handle.pointer + index);
    }

    @ExportMessage
    public void mmapWriteByte(Object mmap, long index, byte value) {
        MMapHandle handle = (MMapHandle)mmap;
        NFIPosixSupport.checkIndexAndLen(handle, index, 1L);
        UNSAFE.putByte(handle.pointer + index, value);
    }

    @ExportMessage
    public int mmapReadBytes(Object mmap, long index, byte[] bytes, int length) {
        MMapHandle handle = (MMapHandle)mmap;
        NFIPosixSupport.checkIndexAndLen(handle, index, length);
        UNSAFE.copyMemory(null, handle.pointer + index, bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, length);
        return length;
    }

    @ExportMessage
    public void mmapWriteBytes(Object mmap, long index, byte[] bytes, int length) {
        MMapHandle handle = (MMapHandle)mmap;
        NFIPosixSupport.checkIndexAndLen(handle, index, length);
        UNSAFE.copyMemory(bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, handle.pointer + index, length);
    }

    @ExportMessage
    public void mmapFlush(Object mmap, long offset, long length, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        MMapHandle handle = (MMapHandle)mmap;
        NFIPosixSupport.checkIndexAndLen(handle, offset, length);
        invokeNode2.call(this, PosixNativeFunction.call_msync, handle.pointer, offset, length);
    }

    @ExportMessage
    public void mmapUnmap(Object mmap, long length, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        MMapHandle handle = (MMapHandle)mmap;
        if (length != handle.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException();
        }
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_munmap, handle.pointer, length);
        if (result != 0) {
            throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
        }
    }

    @ExportMessage
    public long mmapGetPointer(Object mmap) {
        MMapHandle handle = (MMapHandle)mmap;
        return handle.pointer;
    }

    private static void checkIndexAndLen(MMapHandle handle, long index, long length) {
        if (length < 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException();
        }
        if (index < 0L || index + length > handle.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException();
        }
    }

    @ExportMessage
    public int socket(int domain, int type, int protocol, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_socket, domain, type, protocol);
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return result;
    }

    @ExportMessage
    public PosixSupportLibrary.AcceptResult accept(int sockfd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        UniversalSockAddrImpl addr = new UniversalSockAddrImpl(this);
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_accept, sockfd, this.wrap(addr.data), this.wrap(addr.lenAndFamily));
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        assert (addr.getLen() <= UniversalSockAddrImpl.MAX_SIZE);
        return new PosixSupportLibrary.AcceptResult(result, addr);
    }

    @ExportMessage
    public void bind(int sockfd, PosixSupportLibrary.UniversalSockAddr usa, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        UniversalSockAddrImpl addr = (UniversalSockAddrImpl)usa;
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_bind, sockfd, this.wrap(addr.data), addr.getLen());
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public void connect(int sockfd, PosixSupportLibrary.UniversalSockAddr usa, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        UniversalSockAddrImpl addr = (UniversalSockAddrImpl)usa;
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_connect, sockfd, this.wrap(addr.data), addr.getLen());
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public void listen(int sockfd, int backlog, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_listen, sockfd, backlog);
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public PosixSupportLibrary.UniversalSockAddr getpeername(int sockfd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        UniversalSockAddrImpl addr = new UniversalSockAddrImpl(this);
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_getpeername, sockfd, this.wrap(addr.data), this.wrap(addr.lenAndFamily));
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        assert (addr.getLen() <= UniversalSockAddrImpl.MAX_SIZE);
        return addr;
    }

    @ExportMessage
    public PosixSupportLibrary.UniversalSockAddr getsockname(int sockfd, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        UniversalSockAddrImpl addr = new UniversalSockAddrImpl(this);
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_getsockname, sockfd, this.wrap(addr.data), this.wrap(addr.lenAndFamily));
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        assert (addr.getLen() <= UniversalSockAddrImpl.MAX_SIZE);
        return addr;
    }

    @ExportMessage
    public int send(int sockfd, byte[] buf, int offset, int len, int flags, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        NFIPosixSupport.checkBounds(buf, offset, len);
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_send, sockfd, this.wrap(buf), offset, len, flags);
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return result;
    }

    @ExportMessage
    public int sendto(int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr usa, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        NFIPosixSupport.checkBounds(buf, offset, len);
        UniversalSockAddrImpl destAddr = (UniversalSockAddrImpl)usa;
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_sendto, sockfd, this.wrap(buf), offset, len, flags, this.wrap(destAddr.data), destAddr.getLen());
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return result;
    }

    @ExportMessage
    public int recv(int sockfd, byte[] buf, int offset, int len, int flags, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        NFIPosixSupport.checkBounds(buf, offset, len);
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_recv, sockfd, this.wrap(buf), offset, len, flags);
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return result;
    }

    @ExportMessage
    public PosixSupportLibrary.RecvfromResult recvfrom(int sockfd, byte[] buf, int offset, int len, int flags, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        NFIPosixSupport.checkBounds(buf, offset, len);
        UniversalSockAddrImpl srcAddr = new UniversalSockAddrImpl(this);
        int result = invokeNode2.callInt(this, PosixNativeFunction.call_recvfrom, sockfd, this.wrap(buf), offset, len, flags, this.wrap(srcAddr.data), this.wrap(srcAddr.lenAndFamily));
        if (result == -1) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        assert (srcAddr.getLen() <= UniversalSockAddrImpl.MAX_SIZE);
        return new PosixSupportLibrary.RecvfromResult(result, srcAddr);
    }

    @ExportMessage
    public void shutdown(int sockfd, int how, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_shutdown, sockfd, how);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public int getsockopt(int sockfd, int level, int optname, byte[] optval, int optlen, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        assert (optlen >= 0 && optval.length >= optlen);
        int[] bufLen = new int[]{optlen};
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_getsockopt, sockfd, level, optname, this.wrap(optval), this.wrap(bufLen));
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return bufLen[0];
    }

    @ExportMessage
    public void setsockopt(int sockfd, int level, int optname, byte[] optval, int optlen, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        assert (optlen >= 0 && optval.length >= optlen);
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_setsockopt, sockfd, level, optname, this.wrap(optval), optlen);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
    }

    @ExportMessage
    public int inet_addr(Object src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.call_inet_addr, this.pathToCString(src));
    }

    @ExportMessage
    public int inet_aton(Object src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.InvalidAddressException {
        long r = invokeNode2.callLong(this, PosixNativeFunction.call_inet_aton, this.pathToCString(src));
        if (r < 0L) {
            throw new PosixSupportLibrary.InvalidAddressException();
        }
        return (int)r;
    }

    @ExportMessage
    public Object inet_ntoa(int src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
        PosixSupportLibrary.Buffer buf = PosixSupportLibrary.Buffer.allocate(PosixConstants.INET_ADDRSTRLEN.value);
        int len = invokeNode2.callInt(this, PosixNativeFunction.call_inet_ntoa, src, this.wrap(buf));
        return buf.withLength(len);
    }

    @ExportMessage
    public byte[] inet_pton(int family, Object src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
        byte[] buf = new byte[family == PosixConstants.AF_INET.value ? 4 : 16];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_inet_pton, family, this.pathToCString(src), this.wrap(buf));
        if (res == 1) {
            return buf;
        }
        if (res == 0) {
            throw new PosixSupportLibrary.InvalidAddressException();
        }
        throw this.getErrnoAndThrowPosixException(invokeNode2);
    }

    @ExportMessage
    public Object inet_ntop(int family, byte[] src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        if (family == PosixConstants.AF_INET.value && src.length < 4 || family == PosixConstants.AF_INET6.value && src.length < 16) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid length of IPv4/6 address");
        }
        PosixSupportLibrary.Buffer buf = PosixSupportLibrary.Buffer.allocate(PosixConstants.INET6_ADDRSTRLEN.value);
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_inet_ntop, family, this.wrap(src), this.wrap(buf), PosixConstants.INET6_ADDRSTRLEN.value);
        if (res < 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return buf.withLength(NFIPosixSupport.findZero(buf.data));
    }

    @ExportMessage
    public Object gethostname(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        int maxLen = (PosixConstants.HOST_NAME_MAX.defined ? PosixConstants.HOST_NAME_MAX.getValueIfDefined() : PosixConstants._POSIX_HOST_NAME_MAX.value) + 1;
        PosixSupportLibrary.Buffer buf = PosixSupportLibrary.Buffer.allocate(maxLen);
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_gethostname, this.wrap(buf), maxLen);
        if (res != 0) {
            throw this.getErrnoAndThrowPosixException(invokeNode2);
        }
        return buf.withLength(NFIPosixSupport.findZero(buf.data));
    }

    @ExportMessage
    public Object[] getnameinfo(PosixSupportLibrary.UniversalSockAddr usa, int flags, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.GetAddrInfoException {
        PosixSupportLibrary.Buffer host = PosixSupportLibrary.Buffer.allocate(PosixConstants.NI_MAXHOST.value);
        PosixSupportLibrary.Buffer serv = PosixSupportLibrary.Buffer.allocate(PosixConstants.NI_MAXSERV.value);
        UniversalSockAddrImpl addr = (UniversalSockAddrImpl)usa;
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_getnameinfo, this.wrap(addr.data), addr.getLen(), this.wrap(host), PosixConstants.NI_MAXHOST.value, this.wrap(serv), PosixConstants.NI_MAXSERV.value, flags);
        if (res != 0) {
            throw new PosixSupportLibrary.GetAddrInfoException(res, this.gai_strerror(res, invokeNode2, fromByteArrayNode, switchEncodingFromUtf8Node));
        }
        return new Object[]{host.withLength(NFIPosixSupport.findZero(host.data)), serv.withLength(NFIPosixSupport.findZero(serv.data))};
    }

    @ExportMessage
    public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object node, Object service, int family, int sockType, int protocol, int flags, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.GetAddrInfoException {
        long[] ptr = new long[1];
        int res = invokeNode2.callInt(this, PosixNativeFunction.call_getaddrinfo, this.pathToCStringOrNull(node), this.pathToCStringOrNull(service), family, sockType, protocol, flags, this.wrap(ptr));
        if (res != 0) {
            throw new PosixSupportLibrary.GetAddrInfoException(res, this.gai_strerror(res, invokeNode2, fromByteArrayNode, switchEncodingFromUtf8Node));
        }
        assert (ptr[0] != 0L);
        return new AddrInfoCursorImpl(this, ptr[0], invokeNode2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public TruffleString crypt(TruffleString word, TruffleString salt, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="toUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingToUtf8Node, @Cached.Shared(value="tsCopyBytes") @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        int[] lenArray = new int[1];
        Object object = CRYPT_LOCK;
        synchronized (object) {
            long resultPtr = invokeNode2.callLong(this, PosixNativeFunction.call_crypt, this.stringToUTF8CString(word, switchEncodingToUtf8Node, copyToByteArrayNode), this.stringToUTF8CString(salt, switchEncodingToUtf8Node, copyToByteArrayNode), this.wrap(lenArray));
            if (resultPtr == 0L) {
                throw this.getErrnoAndThrowPosixException(invokeNode2);
            }
            int len = lenArray[0];
            byte[] resultBytes = new byte[len];
            UNSAFE.copyMemory(null, resultPtr, resultBytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, len);
            return NFIPosixSupport.createString(resultBytes, 0, resultBytes.length, false, fromByteArrayNode, switchEncodingFromUtf8Node);
        }
    }

    private TruffleString gai_strerror(int errorCode, InvokeNativeFunction invokeNode2, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) {
        byte[] buf = new byte[1024];
        invokeNode2.call(this, PosixNativeFunction.call_gai_strerror, errorCode, this.wrap(buf), buf.length);
        return NFIPosixSupport.cStringToTruffleString(buf, fromByteArrayNode, switchEncodingFromUtf8Node);
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult getpwuid(long uid, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        return this.getpw(PosixNativeFunction.call_getpwuid_r, uid, invokeNode2, fromByteArrayNode, switchEncodingFromUtf8Node);
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult getpwnam(Object name, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        return this.getpw(PosixNativeFunction.call_getpwname_r, this.pathToCString(name), invokeNode2, fromByteArrayNode, switchEncodingFromUtf8Node);
    }

    @ExportMessage
    public boolean hasGetpwentries() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public PosixSupportLibrary.PwdResult[] getpwentries(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        int sysConfMax = this.getSysConfPwdSizeMax(invokeNode2);
        int initialBufferSize = sysConfMax == -1 ? 1024 : sysConfMax;
        ArrayList<PosixSupportLibrary.PwdResult> result = new ArrayList<PosixSupportLibrary.PwdResult>();
        invokeNode2.call(this, PosixNativeFunction.call_setpwent, new Object[0]);
        long[] bufferSize = new long[1];
        long[] output = new long[5];
        byte[] buffer = new byte[initialBufferSize];
        try {
            while (true) {
                int code;
                Object pwPtr = invokeNode2.call(this, PosixNativeFunction.call_getpwent, this.wrap(bufferSize));
                if (invokeNode2.getResultInterop().isNull(pwPtr)) {
                    break;
                }
                if (bufferSize[0] < 0L || bufferSize[0] > 0x1FFFFFFFL) {
                    throw NFIPosixSupport.outOfMemoryPosixError();
                }
                if ((long)buffer.length < bufferSize[0]) {
                    buffer = new byte[(int)bufferSize[0]];
                }
                if ((code = invokeNode2.callInt(this, PosixNativeFunction.get_getpwent_data, pwPtr, this.wrap(buffer), buffer.length, this.wrap(output))) != 0) {
                    throw CompilerDirectives.shouldNotReachHere((String)"get_getpwent_data failed");
                }
                result.add(NFIPosixSupport.createPwdResult(buffer, output, fromByteArrayNode, switchEncodingFromUtf8Node));
            }
        }
        finally {
            invokeNode2.call(this, PosixNativeFunction.call_endpwent, new Object[0]);
        }
        return NFIPosixSupport.toPwdResultArray(result);
    }

    @CompilerDirectives.TruffleBoundary
    private static PosixSupportLibrary.PwdResult[] toPwdResultArray(ArrayList<PosixSupportLibrary.PwdResult> result) {
        return result.toArray(new PosixSupportLibrary.PwdResult[0]);
    }

    private PosixSupportLibrary.PwdResult getpw(PosixNativeFunction pwfun, Object pwfunArg, InvokeNativeFunction invokeNode2, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        int bufferSize;
        int sysConfMax = this.getSysConfPwdSizeMax(invokeNode2);
        int n = bufferSize = sysConfMax == -1 ? 1024 : sysConfMax;
        while (bufferSize < 0x1FFFFFFF) {
            byte[] data = new byte[bufferSize];
            long[] output = new long[5];
            int result = invokeNode2.callInt(this, pwfun, pwfunArg, this.wrap(data), data.length, this.wrap(output));
            if (result == -1) {
                return null;
            }
            if (result == 0) {
                return NFIPosixSupport.createPwdResult(data, output, fromByteArrayNode, switchEncodingFromUtf8Node);
            }
            if (result != OSErrorEnum.ERANGE.getNumber() || sysConfMax != -1) {
                throw this.newPosixException(invokeNode2, result);
            }
            bufferSize <<= 1;
        }
        throw NFIPosixSupport.outOfMemoryPosixError();
    }

    private static PosixSupportLibrary.PwdResult createPwdResult(byte[] data, long[] output, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        return new PosixSupportLibrary.PwdResult(NFIPosixSupport.extractZeroTerminatedString(data, output[0], fromByteArrayNode, switchEncodingFromUtf8Node), output[1], output[2], NFIPosixSupport.extractZeroTerminatedString(data, output[3], fromByteArrayNode, switchEncodingFromUtf8Node), NFIPosixSupport.extractZeroTerminatedString(data, output[4], fromByteArrayNode, switchEncodingFromUtf8Node));
    }

    private static TruffleString extractZeroTerminatedString(byte[] buffer, long longOffset, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingFromUtf8Node) throws PosixSupportLibrary.PosixException {
        int offset;
        int end;
        if (longOffset < 0L || longOffset >= (long)buffer.length) {
            throw NFIPosixSupport.outOfMemoryPosixError();
        }
        for (end = offset = (int)longOffset; end < buffer.length && buffer[end] != 0; ++end) {
        }
        if (end == buffer.length) {
            throw CompilerDirectives.shouldNotReachHere((String)"Could not find the end of the string");
        }
        return NFIPosixSupport.createString(buffer, offset, end - offset, true, fromByteArrayNode, switchEncodingFromUtf8Node);
    }

    private static PosixSupportLibrary.PosixException outOfMemoryPosixError() throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.PosixException(OSErrorEnum.ENOMEM.getNumber(), OSErrorEnum.ENOMEM.getMessage());
    }

    private int getSysConfPwdSizeMax(InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.sysConfPwdSizeMax == -1 ? 1 : 0) != 0)) {
            long sysConfMaxLong = invokeNode2.callLong(this, PosixNativeFunction.get_sysconf_getpw_r_size_max, new Object[0]);
            if (sysConfMaxLong != -1L && (sysConfMaxLong < 0L || sysConfMaxLong > 0x1FFFFFFFL)) {
                throw NFIPosixSupport.outOfMemoryPosixError();
            }
            this.sysConfPwdSizeMax = (int)sysConfMaxLong;
        }
        return this.sysConfPwdSizeMax;
    }

    @ExportMessage
    public Object createPathFromString(TruffleString path, @Cached.Shared(value="toUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared(value="tsCopyBytes") @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        return NFIPosixSupport.checkPath(NFIPosixSupport.getStringBytes(path, switchEncodingNode, copyToByteArrayNode));
    }

    @ExportMessage
    public Object createPathFromBytes(byte[] path) {
        return NFIPosixSupport.checkPath(path);
    }

    @ExportMessage
    public TruffleString getPathAsString(Object path, @Cached.Shared(value="tsFromBytes") @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="fromUtf8") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
        PosixSupportLibrary.Buffer result = (PosixSupportLibrary.Buffer)path;
        if (result.length > Integer.MAX_VALUE) {
            throw CompilerDirectives.shouldNotReachHere((String)"Posix path cannot fit into a Java array");
        }
        return NFIPosixSupport.createString(result.data, 0, (int)result.length, true, fromByteArrayNode, switchEncodingNode);
    }

    @ExportMessage
    public PosixSupportLibrary.Buffer getPathAsBytes(Object path) {
        return (PosixSupportLibrary.Buffer)path;
    }

    private static TruffleString createString(byte[] src, int offset, int length, boolean copy, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        TruffleString utf8 = fromByteArrayNode.execute(src, offset, length, TruffleString.Encoding.UTF_8, copy);
        return switchEncodingNode.execute((AbstractTruffleString)utf8, PythonUtils.TS_ENCODING);
    }

    private static byte[] getStringBytes(TruffleString str, TruffleString.SwitchEncodingNode switchEncodingNode, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        TruffleString utf8 = switchEncodingNode.execute((AbstractTruffleString)str, TruffleString.Encoding.UTF_8);
        byte[] bytes = new byte[utf8.byteLength(TruffleString.Encoding.UTF_8)];
        copyToByteArrayNode.execute((AbstractTruffleString)utf8, 0, bytes, 0, bytes.length, TruffleString.Encoding.UTF_8);
        return bytes;
    }

    private static PosixSupportLibrary.Buffer checkPath(byte[] path) {
        for (byte b : path) {
            if (b != 0) continue;
            return null;
        }
        return PosixSupportLibrary.Buffer.wrap(path);
    }

    private int getErrno(InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this, PosixNativeFunction.get_errno, new Object[0]);
    }

    private void setErrno(InvokeNativeFunction invokeNode2, int errno) {
        invokeNode2.call(this, PosixNativeFunction.set_errno, errno);
    }

    private PosixSupportLibrary.PosixException getErrnoAndThrowPosixException(InvokeNativeFunction invokeNode2) throws PosixSupportLibrary.PosixException {
        throw this.newPosixException(invokeNode2, this.getErrno(invokeNode2));
    }

    @CompilerDirectives.TruffleBoundary
    private PosixSupportLibrary.PosixException newPosixException(InvokeNativeFunction invokeNode2, int errno) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.PosixException(errno, this.strerror(errno, invokeNode2, TruffleString.FromByteArrayNode.getUncached(), TruffleString.SwitchEncodingNode.getUncached()));
    }

    private Object wrap(byte[] bytes) {
        return this.context.getEnv().asGuestValue((Object)bytes);
    }

    private Object wrap(long[] longs) {
        return this.context.getEnv().asGuestValue((Object)longs);
    }

    private Object wrap(int[] ints) {
        return this.context.getEnv().asGuestValue((Object)ints);
    }

    private Object wrap(PosixSupportLibrary.Timeval[] timeval) {
        long[] lArray;
        if (timeval == null) {
            lArray = null;
        } else {
            long[] lArray2 = new long[4];
            lArray2[0] = timeval[0].getSeconds();
            lArray2[1] = timeval[0].getMicroseconds();
            lArray2[2] = timeval[1].getSeconds();
            lArray = lArray2;
            lArray2[3] = timeval[1].getMicroseconds();
        }
        long[] longs = lArray;
        return this.wrap(longs);
    }

    private Object wrap(PosixSupportLibrary.Buffer buffer) {
        return this.context.getEnv().asGuestValue((Object)buffer.data);
    }

    private static TruffleString cStringToTruffleString(byte[] buf, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        return NFIPosixSupport.createString(buf, 0, NFIPosixSupport.findZero(buf), true, fromByteArrayNode, switchEncodingNode);
    }

    private static int findZero(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            return i;
        }
        return buf.length;
    }

    private Object pathToCStringOrNull(Object path) {
        return path == null ? this.context.getEnv().asGuestValue(null) : this.bufferToCString((PosixSupportLibrary.Buffer)path);
    }

    private Object pathToCString(Object path) {
        return this.bufferToCString((PosixSupportLibrary.Buffer)path);
    }

    private Object bufferToCString(PosixSupportLibrary.Buffer path) {
        return this.wrap(NFIPosixSupport.nullTerminate(path.data, (int)path.length));
    }

    private Object stringToUTF8CString(TruffleString input, @Cached TruffleString.SwitchEncodingNode switchEncodingToUtf8Node, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        byte[] utf8 = NFIPosixSupport.getStringBytes(input, switchEncodingToUtf8Node, copyToByteArrayNode);
        return this.wrap(NFIPosixSupport.nullTerminate(utf8, utf8.length));
    }

    private static byte[] nullTerminate(byte[] str, int length) {
        byte[] terminated = new byte[length + 1];
        PythonUtils.arraycopy(str, 0, terminated, 0, length);
        return terminated;
    }

    private static void checkBounds(byte[] buf, int offset, int length) {
        if (length < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException();
        }
        if (offset < 0 || offset + length > buf.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void log(Level level, String fmt, Object ... args) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, String.format(fmt, args));
        }
    }

    private static enum PosixNativeFunction {
        get_errno("():sint32"),
        set_errno("(sint32):void"),
        call_mmap("(sint64, sint32, sint32, sint32, sint64):sint64"),
        call_munmap("(sint64, sint64):sint32"),
        call_msync("(sint64, sint64, sint64):void"),
        call_strerror("(sint32, [sint8], sint32):void"),
        call_getpid("():sint64"),
        call_umask("(sint32):sint32"),
        call_openat("(sint32, [sint8], sint32, sint32):sint32"),
        call_close("(sint32):sint32"),
        call_read("(sint32, [sint8], uint64):sint64"),
        call_write("(sint32, [sint8], uint64):sint64"),
        call_dup("(sint32):sint32"),
        call_dup2("(sint32, sint32, sint32):sint32"),
        call_pipe2("([sint32]):sint32"),
        call_select("(sint32, [sint32], sint32, [sint32], sint32, [sint32], sint32, sint64, sint64, [sint8]):sint32"),
        call_lseek("(sint32, sint64, sint32):sint64"),
        call_ftruncate("(sint32, sint64):sint32"),
        call_fsync("(sint32):sint32"),
        call_flock("(sint32, sint32):sint32"),
        call_fstatat("(sint32, [sint8], sint32, [sint64]):sint32"),
        call_fstat("(sint32, [sint64]):sint32"),
        call_statvfs("([sint8], [sint64]):sint32"),
        call_fstatvfs("(sint32, [sint64]):sint32"),
        call_uname("([sint8], [sint8], [sint8], [sint8], [sint8], sint32):sint32"),
        call_unlinkat("(sint32, [sint8], sint32):sint32"),
        call_linkat("(sint32, [sint8], sint32, [sint8], sint32):sint32"),
        call_symlinkat("([sint8], sint32, [sint8]):sint32"),
        call_mkdirat("(sint32, [sint8], sint32):sint32"),
        call_getcwd("([sint8], uint64):sint32"),
        call_chdir("([sint8]):sint32"),
        call_fchdir("(sint32):sint32"),
        call_isatty("(sint32):sint32"),
        call_opendir("([sint8]):sint64"),
        call_fdopendir("(sint32):sint64"),
        call_closedir("(sint64):sint32"),
        call_readdir("(sint64, [sint8], uint64, [sint64]):sint32"),
        call_rewinddir("(sint64):void"),
        call_utimensat("(sint32, [sint8], [sint64], sint32):sint32"),
        call_futimens("(sint32, [sint64]):sint32"),
        call_futimes("(sint32, [sint64]):sint32"),
        call_lutimes("([sint8], [sint64]):sint32"),
        call_utimes("([sint8], [sint64]):sint32"),
        call_renameat("(sint32, [sint8], sint32, [sint8]):sint32"),
        call_faccessat("(sint32, [sint8], sint32, sint32, sint32):sint32"),
        call_fchmodat("(sint32, [sint8], sint32, sint32):sint32"),
        call_fchmod("(sint32, sint32):sint32"),
        call_readlinkat("(sint32, [sint8], [sint8], uint64):sint64"),
        get_inheritable("(sint32):sint32"),
        set_inheritable("(sint32, sint32):sint32"),
        get_blocking("(sint32):sint32"),
        set_blocking("(sint32, sint32):sint32"),
        get_terminal_size("(sint32, [sint32]):sint32"),
        call_kill("(sint64, sint32):sint32"),
        call_killpg("(sint64, sint32):sint32"),
        call_abort("():void"),
        call_waitpid("(sint64, [sint32], sint32):sint64"),
        call_wcoredump("(sint32):sint32"),
        call_wifcontinued("(sint32):sint32"),
        call_wifstopped("(sint32):sint32"),
        call_wifsignaled("(sint32):sint32"),
        call_wifexited("(sint32):sint32"),
        call_wexitstatus("(sint32):sint32"),
        call_wtermsig("(sint32):sint32"),
        call_wstopsig("(sint32):sint32"),
        call_getuid("():sint64"),
        call_geteuid("():sint64"),
        call_getgid("():sint64"),
        call_getppid("():sint64"),
        call_getpgid("(sint64):sint64"),
        call_setpgid("(sint64,sint64):sint32"),
        call_getpgrp("():sint64"),
        call_getsid("(sint64):sint64"),
        call_setsid("():sint64"),
        call_openpty("([sint32]):sint32"),
        call_ctermid("([sint8]):sint32"),
        call_setenv("([sint8], [sint8], sint32):sint32"),
        call_unsetenv("([sint8]):sint32"),
        fork_exec("([sint8], [sint64], sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, sint32, [sint32], sint64):sint32"),
        call_execv("([sint8], [sint64], sint32):void"),
        call_system("([sint8]):sint32"),
        call_getpwuid_r("(uint64,[sint8],sint32,[uint64]):sint32"),
        call_getpwname_r("([sint8],[sint8],sint32,[uint64]):sint32"),
        call_setpwent("():void"),
        call_endpwent("():void"),
        call_getpwent("([sint64]):pointer"),
        get_getpwent_data("(pointer,[sint8],sint32,[uint64]):sint32"),
        get_sysconf_getpw_r_size_max("():sint64"),
        call_socket("(sint32, sint32, sint32):sint32"),
        call_accept("(sint32, [sint8], [sint32]):sint32"),
        call_bind("(sint32, [sint8], sint32):sint32"),
        call_connect("(sint32, [sint8], sint32):sint32"),
        call_listen("(sint32, sint32):sint32"),
        call_getpeername("(sint32, [sint8], [sint32]):sint32"),
        call_getsockname("(sint32, [sint8], [sint32]):sint32"),
        call_send("(sint32, [sint8], sint32, sint32, sint32):sint32"),
        call_sendto("(sint32, [sint8], sint32, sint32, sint32, [sint8], sint32):sint32"),
        call_recv("(sint32, [sint8], sint32, sint32, sint32):sint32"),
        call_recvfrom("(sint32, [sint8], sint32, sint32, sint32, [sint8], [sint32]):sint32"),
        call_shutdown("(sint32, sint32): sint32"),
        call_getsockopt("(sint32, sint32, sint32, [sint8], [sint32]):sint32"),
        call_setsockopt("(sint32, sint32, sint32, [sint8], sint32):sint32"),
        call_inet_addr("([sint8]):sint32"),
        call_inet_aton("([sint8]):sint64"),
        call_inet_ntoa("(sint32, [sint8]):sint32"),
        call_inet_pton("(sint32, [sint8], [sint8]):sint32"),
        call_inet_ntop("(sint32, [sint8], [sint8], sint32):sint32"),
        call_gethostname("([sint8], sint64):sint32"),
        call_getnameinfo("([sint8], sint32, [sint8], sint32, [sint8], sint32, sint32):sint32"),
        call_getaddrinfo("([sint8], [sint8], sint32, sint32, sint32, sint32, [sint64]):sint32"),
        call_freeaddrinfo("(sint64):void"),
        call_gai_strerror("(sint32, [sint8], sint32):void"),
        get_addrinfo_members("(sint64, [sint32], [sint64], [sint8]):sint32"),
        get_sockaddr_in_members("([sint8], [sint32]):void"),
        get_sockaddr_in6_members("([sint8], [sint32], [sint8]):void"),
        get_sockaddr_un_members("([sint8], sint32, [sint8]):sint32"),
        set_sockaddr_in_members("([sint8], sint32, sint32):sint32"),
        set_sockaddr_in6_members("([sint8], sint32, [sint8], sint32, sint32):sint32"),
        set_sockaddr_un_members("([sint8], [sint8], sint32):sint32"),
        call_crypt("([sint8], [sint8], [sint32]):sint64");

        private final String signature;

        private PosixNativeFunction(String signature) {
            this.signature = signature;
        }
    }

    protected static final class InvokeNativeFunction
    extends Node {
        private static final InvokeNativeFunction UNCACHED = new InvokeNativeFunction(InteropLibrary.getUncached(), InteropLibrary.getUncached());
        @Node.Child
        private InteropLibrary functionInterop;
        @Node.Child
        private InteropLibrary resultInterop;

        public InvokeNativeFunction(InteropLibrary functionInterop, InteropLibrary resultInterop) {
            this.functionInterop = functionInterop;
            this.resultInterop = resultInterop;
        }

        @NeverDefault
        public static InvokeNativeFunction create() {
            return new InvokeNativeFunction((InteropLibrary)InteropLibrary.getFactory().createDispatched(2), null);
        }

        public static InvokeNativeFunction getUncached() {
            return UNCACHED;
        }

        public Object call(NFIPosixSupport posix, PosixNativeFunction function, Object ... args) {
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (posix.nfiLibrary == null ? 1 : 0) != 0)) {
                InvokeNativeFunction.loadLibrary(posix);
            }
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (posix.cachedFunctions.get(function.ordinal()) == null ? 1 : 0) != 0)) {
                InvokeNativeFunction.loadFunction(posix, posix.nfiLibrary, function);
            }
            Object funObject = posix.cachedFunctions.get(function.ordinal());
            try {
                return this.functionInterop.execute(funObject, args);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        public long callLong(NFIPosixSupport posix, PosixNativeFunction function, Object ... args) {
            try {
                return this.getResultInterop().asLong(this.call(posix, function, args));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        public int callInt(NFIPosixSupport posix, PosixNativeFunction function, Object ... args) {
            try {
                return this.getResultInterop().asInt(this.call(posix, function, args));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        public byte callByte(NFIPosixSupport posix, PosixNativeFunction function, Object ... args) {
            try {
                return this.getResultInterop().asByte(this.call(posix, function, args));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        private static String getLibPath(PythonContext context) {
            CompilerAsserts.neverPartOfCompilation();
            String libPythonName = PythonContext.getSupportLibName(NFIPosixSupport.SUPPORTING_NATIVE_LIB_NAME);
            TruffleFile homePath = context.getEnv().getInternalTruffleFile(context.getCAPIHome().toJavaStringUncached());
            TruffleFile file = homePath.resolve(libPythonName);
            return file.getPath();
        }

        @CompilerDirectives.TruffleBoundary
        private static void loadLibrary(NFIPosixSupport posix) {
            String path = InvokeNativeFunction.getLibPath(posix.context);
            String backend = posix.nfiBackend.toJavaStringUncached();
            TruffleLanguage.Env env = posix.context.getEnv();
            if (!env.getInternalLanguages().containsKey("nfi")) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, ErrorMessages.NFI_NOT_AVAILABLE, "PosixModuleBackend", "native");
            }
            Object withClause = backend.equals("native") ? "" : "with " + backend;
            String src = String.format("%sload (RTLD_LOCAL) \"%s\"", withClause, path);
            Source loadSrc = Source.newBuilder((String)"nfi", (CharSequence)src, (String)"load:posix").internal(true).build();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Loading native library: %s", src));
            }
            try {
                posix.nfiLibrary = env.parseInternal(loadSrc, new String[0]).call(new Object[0]);
            }
            catch (Throwable e) {
                throw new UnsupportedOperationException(String.format("Could not load posix support library from path '%s'. Troubleshooting: \nCheck permissions of the file.\nMissing runtime Maven dependency 'org.graalvm.truffle:truffle-nfi-libffi' (should be a dependency of `org.graalvm.polyglot:python{-community}`)?", path));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void loadFunction(NFIPosixSupport posix, Object library, PosixNativeFunction function) {
            try {
                InteropLibrary interop = InteropLibrary.getUncached();
                SignatureLibrary sigs = SignatureLibrary.getUncached();
                String sig = String.format("with %s %s", posix.nfiBackend, function.signature);
                Source sigSrc = Source.newBuilder((String)"nfi", (CharSequence)sig, (String)"posix-nfi-signature").internal(true).build();
                Object signature = posix.context.getEnv().parseInternal(sigSrc, new String[0]).call(new Object[0]);
                Object unbound = interop.readMember(library, function.name());
                posix.cachedFunctions.set(function.ordinal(), sigs.bind(signature, unbound));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)function.name(), (Throwable)e);
            }
        }

        public InteropLibrary getResultInterop() {
            if (this.resultInterop == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.resultInterop = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(2)));
            }
            return this.resultInterop;
        }
    }

    protected static class DirEntry {
        final PosixSupportLibrary.Buffer name;
        final long ino;
        final int type;

        DirEntry(PosixSupportLibrary.Buffer name, long ino, int type) {
            this.name = name;
            this.ino = ino;
            this.type = type;
        }

        public String toString() {
            return "DirEntry{name='" + new String(this.name.data, 0, (int)this.name.length) + "', ino=" + this.ino + ", type=" + this.type + "}";
        }
    }

    private static final class MMapHandle {
        private final long pointer;
        private final long length;

        public MMapHandle(long pointer, long length) {
            this.pointer = pointer;
            this.length = length;
        }
    }

    @ExportLibrary(value=PosixSupportLibrary.UniversalSockAddrLibrary.class)
    protected static class UniversalSockAddrImpl
    implements PosixSupportLibrary.UniversalSockAddr {
        static final int MAX_SIZE = PosixConstants.SIZEOF_STRUCT_SOCKADDR_STORAGE.value;
        private final NFIPosixSupport nfiPosixSupport;
        private final byte[] data = new byte[MAX_SIZE];
        private final int[] lenAndFamily;

        UniversalSockAddrImpl(NFIPosixSupport nfiPosixSupport) {
            this.lenAndFamily = new int[]{0, PosixConstants.AF_UNSPEC.value};
            this.nfiPosixSupport = nfiPosixSupport;
        }

        @ExportMessage
        int getFamily() {
            return this.lenAndFamily[1];
        }

        @ExportMessage
        PosixSupportLibrary.Inet4SockAddr asInet4SockAddr(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            if (this.getFamily() != PosixConstants.AF_INET.value) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Only AF_INET socket address can be converted to Inet4SockAddr");
            }
            assert (this.getLen() == PosixConstants.SIZEOF_STRUCT_SOCKADDR_IN.value);
            int[] members = new int[2];
            invokeNode2.call(this.nfiPosixSupport, PosixNativeFunction.get_sockaddr_in_members, this.nfiPosixSupport.wrap(this.data), this.nfiPosixSupport.wrap(members));
            return new PosixSupportLibrary.Inet4SockAddr(members[0], members[1]);
        }

        @ExportMessage
        PosixSupportLibrary.Inet6SockAddr asInet6SockAddr(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            if (this.getFamily() != PosixConstants.AF_INET6.value) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Only AF_INET6 socket address can be converted to Inet6SockAddr");
            }
            assert (this.getLen() == PosixConstants.SIZEOF_STRUCT_SOCKADDR_IN6.value);
            int[] members = new int[3];
            byte[] address = new byte[16];
            invokeNode2.call(this.nfiPosixSupport, PosixNativeFunction.get_sockaddr_in6_members, this.nfiPosixSupport.wrap(this.data), this.nfiPosixSupport.wrap(members), this.nfiPosixSupport.wrap(address));
            return new PosixSupportLibrary.Inet6SockAddr(members[0], address, members[1], members[2]);
        }

        @ExportMessage
        PosixSupportLibrary.UnixSockAddr asUnixSockAddr(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            if (this.getFamily() != PosixConstants.AF_UNIX.value) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Only AF_UNIX socket address can be converted to UnixSockAddr");
            }
            assert (this.getLen() <= PosixConstants.OFFSETOF_STRUCT_SOCKADDR_UN_SUN_PATH.value + PosixConstants.SIZEOF_STRUCT_SOCKADDR_UN_SUN_PATH.value);
            byte[] pathBuf = new byte[PosixConstants.SIZEOF_STRUCT_SOCKADDR_UN_SUN_PATH.value];
            int pathLen = invokeNode2.callInt(this.nfiPosixSupport, PosixNativeFunction.get_sockaddr_un_members, this.nfiPosixSupport.wrap(this.data), this.getLen(), this.nfiPosixSupport.wrap(pathBuf));
            return new PosixSupportLibrary.UnixSockAddr(pathBuf, 0, pathLen);
        }

        int getLen() {
            return this.lenAndFamily[0];
        }

        void setLenAndFamily(int len, int family) {
            this.lenAndFamily[0] = len;
            this.lenAndFamily[1] = family;
        }
    }

    @ExportLibrary(value=PosixSupportLibrary.AddrInfoCursorLibrary.class)
    protected static class AddrInfoCursorImpl
    implements PosixSupportLibrary.AddrInfoCursor {
        private final NFIPosixSupport nfiPosixSupport;
        private long head;
        private AddrInfo info;

        AddrInfoCursorImpl(NFIPosixSupport nfiPosixSupport, long head, InvokeNativeFunction invokeNode2) {
            this.nfiPosixSupport = nfiPosixSupport;
            this.head = head;
            this.info = new AddrInfo();
            this.info.update(head, nfiPosixSupport, invokeNode2);
        }

        @ExportMessage
        void release(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            this.checkReleased();
            invokeNode2.call(this.nfiPosixSupport, PosixNativeFunction.call_freeaddrinfo, this.head);
            this.head = 0L;
        }

        @ExportMessage
        boolean next(@Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            this.checkReleased();
            long nextPtr = this.info.getNextPtr();
            if (nextPtr == 0L) {
                return false;
            }
            this.info.update(nextPtr, this.nfiPosixSupport, invokeNode2);
            return true;
        }

        @ExportMessage
        int getFlags() {
            this.checkReleased();
            return this.info.getFlags();
        }

        @ExportMessage
        int getFamily() {
            this.checkReleased();
            return this.info.getFamily();
        }

        @ExportMessage
        int getSockType() {
            this.checkReleased();
            return this.info.getSockType();
        }

        @ExportMessage
        int getProtocol() {
            this.checkReleased();
            return this.info.getProtocol();
        }

        @ExportMessage
        Object getCanonName() {
            this.checkReleased();
            long namePtr = this.info.getCanonNamePtr();
            if (namePtr == 0L) {
                return null;
            }
            int nameLen = this.info.getCanonNameLen();
            byte[] buf = new byte[nameLen];
            UNSAFE.copyMemory(null, namePtr, buf, Unsafe.ARRAY_BYTE_BASE_OFFSET, nameLen);
            return PosixSupportLibrary.Buffer.wrap(buf);
        }

        @ExportMessage
        PosixSupportLibrary.UniversalSockAddr getSockAddr() {
            UniversalSockAddrImpl addr = new UniversalSockAddrImpl(this.nfiPosixSupport);
            PythonUtils.arraycopy(this.info.socketAddress, 0, addr.data, 0, this.info.getAddrLen());
            addr.setLenAndFamily(this.info.getAddrLen(), this.info.getAddrFamily());
            return addr;
        }

        private void checkReleased() {
            if (this.head == 0L) {
                throw CompilerDirectives.shouldNotReachHere((String)"AddrInfoCursor has already been released");
            }
        }
    }

    @ExportMessage
    static class CreateUniversalSockAddr {
        CreateUniversalSockAddr() {
        }

        @Specialization
        static PosixSupportLibrary.UniversalSockAddr inet4(NFIPosixSupport receiver, PosixSupportLibrary.Inet4SockAddr src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            UniversalSockAddrImpl addr = new UniversalSockAddrImpl(receiver);
            int len = invokeNode2.callInt(receiver, PosixNativeFunction.set_sockaddr_in_members, receiver.wrap(addr.data), src.getPort(), src.getAddress());
            addr.setLenAndFamily(len, PosixConstants.AF_INET.value);
            return addr;
        }

        @Specialization
        static PosixSupportLibrary.UniversalSockAddr inet6(NFIPosixSupport receiver, PosixSupportLibrary.Inet6SockAddr src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            UniversalSockAddrImpl addr = new UniversalSockAddrImpl(receiver);
            int len = invokeNode2.callInt(receiver, PosixNativeFunction.set_sockaddr_in6_members, receiver.wrap(addr.data), src.getPort(), receiver.wrap(src.getAddress()), src.getFlowInfo(), src.getScopeId());
            addr.setLenAndFamily(len, PosixConstants.AF_INET6.value);
            return addr;
        }

        @Specialization
        static PosixSupportLibrary.UniversalSockAddr unix(NFIPosixSupport receiver, PosixSupportLibrary.UnixSockAddr src, @Cached.Shared(value="invoke") @Cached InvokeNativeFunction invokeNode2) {
            UniversalSockAddrImpl addr = new UniversalSockAddrImpl(receiver);
            byte[] path = src.getPath();
            assert (path.length <= PosixConstants.SIZEOF_STRUCT_SOCKADDR_UN_SUN_PATH.value);
            int len = invokeNode2.callInt(receiver, PosixNativeFunction.set_sockaddr_un_members, receiver.wrap(addr.data), receiver.wrap(path), path.length);
            addr.setLenAndFamily(len, PosixConstants.AF_UNIX.value);
            return addr;
        }
    }

    private static class AddrInfo {
        private final int[] intData = new int[7];
        private final long[] longData = new long[2];
        private final byte[] socketAddress = new byte[UniversalSockAddrImpl.MAX_SIZE];

        private AddrInfo() {
        }

        private void update(long ptr, NFIPosixSupport nfiPosixSupport, InvokeNativeFunction invokeNode2) {
            int res = invokeNode2.callInt(nfiPosixSupport, PosixNativeFunction.get_addrinfo_members, ptr, nfiPosixSupport.wrap(this.intData), nfiPosixSupport.wrap(this.longData), nfiPosixSupport.wrap(this.socketAddress));
            if (res != 0) {
                throw CompilerDirectives.shouldNotReachHere((String)"the length of ai_canonname does not fit into an int");
            }
        }

        int getFlags() {
            return this.intData[0];
        }

        int getFamily() {
            return this.intData[1];
        }

        int getSockType() {
            return this.intData[2];
        }

        int getProtocol() {
            return this.intData[3];
        }

        int getAddrLen() {
            return this.intData[4];
        }

        int getAddrFamily() {
            return this.intData[5];
        }

        int getCanonNameLen() {
            assert (this.getCanonNamePtr() != 0L);
            return this.intData[6];
        }

        long getCanonNamePtr() {
            return this.longData[0];
        }

        long getNextPtr() {
            return this.longData[1];
        }
    }

    @ExportMessage
    public static class DirEntryGetPath {
        @Specialization(guards={"endsWithSlash(scandirPath)"})
        static PosixSupportLibrary.Buffer withSlash(NFIPosixSupport receiver, DirEntry dirEntry, Object scandirPath) {
            PosixSupportLibrary.Buffer scandirPathBuffer = (PosixSupportLibrary.Buffer)scandirPath;
            int pathLen = scandirPathBuffer.data.length;
            int nameLen = (int)dirEntry.name.length;
            byte[] buf = new byte[pathLen + nameLen];
            PythonUtils.arraycopy(scandirPathBuffer.data, 0, buf, 0, pathLen);
            PythonUtils.arraycopy(dirEntry.name.data, 0, buf, pathLen, nameLen);
            return PosixSupportLibrary.Buffer.wrap(buf);
        }

        @Specialization(guards={"!endsWithSlash(scandirPath)"})
        static PosixSupportLibrary.Buffer withoutSlash(NFIPosixSupport receiver, DirEntry dirEntry, Object scandirPath) {
            PosixSupportLibrary.Buffer scandirPathBuffer = (PosixSupportLibrary.Buffer)scandirPath;
            int pathLen = scandirPathBuffer.data.length;
            int nameLen = (int)dirEntry.name.length;
            byte[] buf = new byte[pathLen + 1 + nameLen];
            PythonUtils.arraycopy(scandirPathBuffer.data, 0, buf, 0, pathLen);
            buf[pathLen] = 47;
            PythonUtils.arraycopy(dirEntry.name.data, 0, buf, pathLen + 1, nameLen);
            return PosixSupportLibrary.Buffer.wrap(buf);
        }

        protected static boolean endsWithSlash(Object path) {
            PosixSupportLibrary.Buffer b = (PosixSupportLibrary.Buffer)path;
            return b.data[b.data.length - 1] == 47;
        }
    }
}

