/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectSizeGenericNode;
import com.oracle.graal.python.lib.PyObjectSizeNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class PyObjectSizeNode
extends PNodeWithContext {
    public static int executeUncached(Frame frame, Object object) {
        return PyObjectSizeNodeGen.getUncached().execute(frame, null, object);
    }

    public static int executeUncached(Object object) {
        return PyObjectSizeNodeGen.getUncached().execute(null, null, object);
    }

    public final int executeCached(Frame frame, Object object) {
        return this.execute(frame, (Node)this, object);
    }

    public abstract int execute(Frame var1, Node var2, Object var3);

    public abstract int execute(Frame var1, Node var2, PTuple var3);

    protected abstract Object executeObject(Frame var1, Node var2, Object var3);

    @Specialization
    static int doTruffleString(TruffleString str, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode) {
        return codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
    static int doList(Node inliningTarget, PList object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode) {
        return object.getSequenceStorage().length();
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
    static int doTuple(Node inliningTarget, PTuple object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode) {
        return object.getSequenceStorage().length();
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
    static int doDict(Node inliningTarget, PDict object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="hashingStorageLen") @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage());
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
    static int doSet(Node inliningTarget, PSet object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="hashingStorageLen") @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage());
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
    @HostCompilerDirectives.InliningCutoff
    static int doPString(Node inliningTarget, PString object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached(inline=false) StringNodes.StringLenNode lenNode) {
        return lenNode.execute(object);
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
    static int doPBytes(Node inliningTarget, PBytesLike object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode) {
        return object.getSequenceStorage().length();
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static int doOthers(VirtualFrame frame, Object object, @Cached(inline=false) PyObjectSizeGenericNode genericNode) {
        return genericNode.execute((Frame)frame, object);
    }

    static int checkLen(PRaiseNode raiseNode, int len) {
        if (len < 0) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.LEN_SHOULD_RETURN_GT_ZERO);
        }
        return len;
    }

    public static int convertAndCheckLen(VirtualFrame frame, Node inliningTarget, Object result, PyNumberIndexNode indexNode, CastToJavaIntLossyNode castLossy, PyNumberAsSizeNode asSizeNode, PRaiseNode raiseNode) {
        int len;
        Object index = indexNode.execute((Frame)frame, inliningTarget, result);
        try {
            len = asSizeNode.executeExact((Frame)frame, inliningTarget, index);
        }
        catch (PException e) {
            int len2 = castLossy.execute(inliningTarget, index);
            PyObjectSizeNode.checkLen(raiseNode, len2);
            throw e;
        }
        return PyObjectSizeNode.checkLen(raiseNode, len);
    }

    @NeverDefault
    public static PyObjectSizeNode create() {
        return PyObjectSizeNodeGen.create();
    }

    public static PyObjectSizeNode getUncached() {
        return PyObjectSizeNodeGen.getUncached();
    }
}

