/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptors;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectLookupAttrNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupInheritedSlotNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class, SpecialMethodNames.class, PGuards.class})
public abstract class PyObjectLookupAttr
extends Node {
    public static Object executeUncached(Object type, Object name) {
        return PyObjectLookupAttrNodeGen.getUncached().execute(null, null, type, name);
    }

    public final Object executeCached(Frame frame, Object receiver, Object name) {
        return this.execute(frame, this, receiver, name);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

    protected static boolean hasNoGetAttr(Object lazyClass) {
        Object slotValue = null;
        if (lazyClass instanceof PythonBuiltinClassType) {
            slotValue = SpecialMethodSlot.GetAttr.getValue((PythonBuiltinClassType)((Object)lazyClass));
        } else if (lazyClass instanceof PythonManagedClass) {
            slotValue = SpecialMethodSlot.GetAttr.getValue((PythonManagedClass)lazyClass);
        }
        return slotValue == PNone.NO_VALUE;
    }

    protected static boolean getAttributeIs(Object lazyClass, BuiltinMethodDescriptor expected) {
        Object slotValue = null;
        if (lazyClass instanceof PythonBuiltinClassType) {
            slotValue = SpecialMethodSlot.GetAttribute.getValue((PythonBuiltinClassType)((Object)lazyClass));
        } else if (lazyClass instanceof PythonManagedClass) {
            slotValue = SpecialMethodSlot.GetAttribute.getValue((PythonManagedClass)lazyClass);
        }
        return slotValue == expected;
    }

    protected static boolean isObjectGetAttribute(Object lazyClass) {
        return PyObjectLookupAttr.getAttributeIs(lazyClass, BuiltinMethodDescriptors.OBJ_GET_ATTRIBUTE);
    }

    protected static boolean isModuleGetAttribute(Object lazyClass) {
        return PyObjectLookupAttr.getAttributeIs(lazyClass, BuiltinMethodDescriptors.MODULE_GET_ATTRIBUTE);
    }

    protected static boolean isTypeGetAttribute(Object lazyClass) {
        return PyObjectLookupAttr.getAttributeIs(lazyClass, BuiltinMethodDescriptors.TYPE_GET_ATTRIBUTE);
    }

    protected static boolean isBuiltinTypeType(Object type) {
        return type == PythonBuiltinClassType.PythonClass;
    }

    protected static boolean isTypeSlot(TruffleString name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        return SpecialMethodSlot.canBeSpecial(name, codePointLengthNode, codePointAtIndexNode) || name.equalsUncached((AbstractTruffleString)SpecialMethodNames.T_MRO, PythonUtils.TS_ENCODING);
    }

    @Specialization(guards={"isObjectGetAttribute(type)", "hasNoGetAttr(type)", "name == cachedName", "isNoValue(descr)"}, limit="3")
    static Object doBuiltinObject(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached.Exclusive @Cached GetClassNode getClass, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(value="create(name)") LookupAttributeInMRONode lookupName, @Bind(value="lookupName.execute(type)") Object descr, @Cached.Shared @Cached(inline=false) ReadAttributeFromObjectNode readNode) {
        return readNode.execute(object, cachedName);
    }

    @Specialization(guards={"isModuleGetAttribute(type)", "hasNoGetAttr(type)", "name == cachedName", "isNoValue(descr)"}, limit="1")
    static Object doBuiltinModule(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached.Exclusive @Cached GetClassNode getClass, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(value="create(name)") LookupAttributeInMRONode lookupName, @Bind(value="lookupName.execute(type)") Object descr, @Cached.Shared @Cached(inline=false) ReadAttributeFromObjectNode readNode, @Cached.Exclusive @Cached(inline=false) ReadAttributeFromObjectNode readGetattr, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached InlinedConditionProfile noValueFound, @Cached(inline=false) CallNode callGetattr) {
        Object value = readNode.execute(object, cachedName);
        if (noValueFound.profile(inliningTarget, value == PNone.NO_VALUE)) {
            Object getAttr = readGetattr.execute(object, SpecialMethodNames.T___GETATTR__);
            if (getAttr != PNone.NO_VALUE) {
                try {
                    return callGetattr.execute((Frame)frame, getAttr, new Object[]{name});
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                    return PNone.NO_VALUE;
                }
            }
            return PNone.NO_VALUE;
        }
        return value;
    }

    @Specialization(guards={"isTypeGetAttribute(type)", "isBuiltinTypeType(type)", "!isTypeSlot(name, codePointLengthNode, codePointAtIndexNode)"}, limit="1")
    static Object doBuiltinTypeType(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached.Exclusive @Cached GetClassNode getClass, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(inline=false) LookupAttributeInMRONode.Dynamic readNode, @Cached.Exclusive @Cached InlinedConditionProfile valueFound, @Cached.Shared @Cached(value="create(Get)", inline=false) LookupInheritedSlotNode lookupValueGet, @Cached.Exclusive @Cached InlinedConditionProfile noGetMethod, @Cached.Shared @Cached(inline=false) CallTernaryMethodNode invokeValueGet, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        Object value = readNode.execute(object, name);
        if (valueFound.profile(inliningTarget, value != PNone.NO_VALUE)) {
            Object valueGet = lookupValueGet.execute(value);
            if (noGetMethod.profile(inliningTarget, valueGet == PNone.NO_VALUE)) {
                return value;
            }
            if (PGuards.isCallableOrDescriptor(valueGet)) {
                try {
                    return invokeValueGet.execute((Frame)frame, valueGet, value, PNone.NONE, object);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                    return PNone.NO_VALUE;
                }
            }
        }
        return PNone.NO_VALUE;
    }

    @Specialization(guards={"isTypeGetAttribute(type)", "hasNoGetAttr(type)", "name == cachedName", "isNoValue(metaClassDescr)"}, replaces={"doBuiltinTypeType"}, limit="1")
    static Object doBuiltinType(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached.Exclusive @Cached GetClassNode getClass, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(value="create(name)", inline=false) LookupAttributeInMRONode lookupInMetaclassHierachy, @Bind(value="lookupInMetaclassHierachy.execute(type)") Object metaClassDescr, @Cached(value="create(name)", inline=false) LookupAttributeInMRONode readNode, @Cached.Exclusive @Cached InlinedConditionProfile valueFound, @Cached.Shared @Cached(value="create(Get)", inline=false) LookupInheritedSlotNode lookupValueGet, @Cached.Exclusive @Cached InlinedConditionProfile noGetMethod, @Cached.Shared @Cached(inline=false) CallTernaryMethodNode invokeValueGet, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
        Object value = readNode.execute(object);
        if (valueFound.profile(inliningTarget, value != PNone.NO_VALUE)) {
            Object valueGet = lookupValueGet.execute(value);
            if (noGetMethod.profile(inliningTarget, valueGet == PNone.NO_VALUE)) {
                return value;
            }
            if (PGuards.isCallableOrDescriptor(valueGet)) {
                try {
                    return invokeValueGet.execute((Frame)frame, valueGet, value, PNone.NONE, object);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                    return PNone.NO_VALUE;
                }
            }
        }
        return PNone.NO_VALUE;
    }

    @Specialization(replaces={"doBuiltinObject", "doBuiltinModule", "doBuiltinType"})
    static Object getDynamicAttr(Frame frame, Node inliningTarget, Object receiver, Object name, @Cached.Exclusive @Cached GetClassNode getClass, @Cached(parameters={"GetAttribute"}, inline=false) LookupSpecialMethodSlotNode lookupGetattribute, @Cached(parameters={"GetAttr"}, inline=false) LookupSpecialMethodSlotNode lookupGetattr, @Cached(inline=false) CallBinaryMethodNode callGetattribute, @Cached(inline=false) CallBinaryMethodNode callGetattr, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        Object result;
        Object type = getClass.execute(inliningTarget, receiver);
        Object getattribute = lookupGetattribute.execute(frame, type, receiver);
        if (!callGetattr.isAdoptable() && (result = PyObjectLookupAttr.readAttributeQuickly(type, getattribute, receiver, name, codePointLengthNode, codePointAtIndexNode)) != null) {
            if (result == PNone.NO_VALUE) {
                Object getattr = lookupGetattr.execute(frame, type, receiver);
                if (getattr != PNone.NO_VALUE) {
                    try {
                        return callGetattr.executeObject(frame, getattr, receiver, name);
                    }
                    catch (PException e) {
                        e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                        return PNone.NO_VALUE;
                    }
                }
                return PNone.NO_VALUE;
            }
            return result;
        }
        try {
            return callGetattribute.executeObject(frame, getattribute, receiver, name);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
            Object getattr = lookupGetattr.execute(frame, type, receiver);
            if (getattr != PNone.NO_VALUE) {
                try {
                    return callGetattr.executeObject(frame, getattr, receiver, name);
                }
                catch (PException e2) {
                    e2.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                }
            }
            return PNone.NO_VALUE;
        }
    }

    @NeverDefault
    public static PyObjectLookupAttr create() {
        return PyObjectLookupAttrNodeGen.create();
    }

    public static PyObjectLookupAttr getUncached() {
        return PyObjectLookupAttrNodeGen.getUncached();
    }

    static Object readAttributeQuickly(Object type, Object getattribute, Object receiver, Object name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (name instanceof TruffleString) {
            ReadAttributeFromObjectNode readUncached;
            Object result;
            TruffleString stringName;
            if (getattribute == BuiltinMethodDescriptors.OBJ_GET_ATTRIBUTE && type instanceof PythonManagedClass) {
                ReadAttributeFromObjectNode readUncached2;
                Object descr;
                PythonAbstractClass base;
                TruffleString stringName2 = (TruffleString)name;
                PythonAbstractClass[] bases = ((PythonManagedClass)type).getBaseClasses();
                if (bases.length == 1 && (base = bases[0]) instanceof PythonBuiltinClass && ((PythonBuiltinClass)base).getType() == PythonBuiltinClassType.PythonObject && (codePointAtIndexNode.execute((AbstractTruffleString)stringName2, 0, PythonUtils.TS_ENCODING) != 95 || codePointAtIndexNode.execute((AbstractTruffleString)stringName2, 1, PythonUtils.TS_ENCODING) != 95) && (descr = (readUncached2 = ReadAttributeFromObjectNode.getUncached()).execute(type, stringName2)) == PNone.NO_VALUE) {
                    return readUncached2.execute(receiver, stringName2);
                }
            } else if (getattribute == BuiltinMethodDescriptors.MODULE_GET_ATTRIBUTE && type == PythonBuiltinClassType.PythonModule && !SpecialMethodSlot.canBeSpecial(stringName = (TruffleString)name, codePointLengthNode, codePointAtIndexNode) && (result = (readUncached = ReadAttributeFromObjectNode.getUncached()).execute(receiver, stringName)) != PNone.NO_VALUE) {
                return result;
            }
        }
        return null;
    }
}

