/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyFloatAsDoubleNodeGen;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyFloatAsDoubleNode
extends PNodeWithContext {
    public static double executeUncached(Object object) {
        return PyFloatAsDoubleNodeGen.getUncached().execute(null, null, object);
    }

    public abstract double execute(VirtualFrame var1, Node var2, Object var3);

    @Specialization
    static double doDouble(double object) {
        return object;
    }

    @Specialization
    static double doPFloat(PFloat object) {
        return object.getValue();
    }

    @Specialization
    static double doInt(int object) {
        return object;
    }

    @Specialization
    static double doLong(long object) {
        return object;
    }

    @Specialization
    static double doBoolean(boolean object) {
        return object ? 1.0 : 0.0;
    }

    @Specialization(guards={"isFloatSubtype(inliningTarget, object, getClassNode, isSubtype)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static double doNative(Node inliningTarget, PythonAbstractNativeObject object, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(inline=false) IsSubtypeNode isSubtype, @Cached(inline=false) CStructAccess.ReadDoubleNode read) {
        return read.readFromObj(object, CFields.PyFloatObject__ob_fval);
    }

    @Specialization(guards={"!isDouble(object)", "!isInteger(object)", "!isBoolean(object)", "!isPFloat(object)", "!isFloatSubtype(inliningTarget, object, getClassNode, isSubtype)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static double doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(inline=false) IsSubtypeNode isSubtype, @Cached(parameters={"Float"}, inline=false) LookupSpecialMethodSlotNode lookup, @Cached(inline=false) CallUnaryMethodNode call, @Cached.Exclusive @Cached GetClassNode resultClassNode, @Cached.Exclusive @Cached BuiltinClassProfiles.InlineIsBuiltinClassProfile resultProfile, @Cached.Exclusive @Cached(inline=false) IsSubtypeNode resultSubtypeNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached CastToJavaDoubleNode cast, @Cached(inline=false) WarningsModuleBuiltins.WarnNode warnNode, @Cached PRaiseNode.Lazy raiseNode) {
        Object type = getClassNode.execute(inliningTarget, object);
        Object floatDescr = lookup.execute((Frame)frame, type, object);
        if (floatDescr != PNone.NO_VALUE) {
            Object result = call.executeObject((Frame)frame, floatDescr, object);
            Object resultType = resultClassNode.execute(inliningTarget, result);
            if (!resultProfile.profileClass(inliningTarget, resultType, PythonBuiltinClassType.PFloat)) {
                if (!resultSubtypeNode.execute(resultType, (Object)PythonBuiltinClassType.PFloat)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_FLOAT, object, result);
                }
                warnNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, object, SpecialMethodNames.T___FLOAT__, "float", result, "float");
            }
            return cast.execute(inliningTarget, result);
        }
        if (indexCheckNode.execute(inliningTarget, object)) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, object);
            return cast.execute(inliningTarget, index);
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_REAL_NUMBER, object);
    }

    static boolean isFloatSubtype(Node inliningTarget, Object object, GetClassNode getClass, IsSubtypeNode isSubtype) {
        return CExtNodes.FromNativeSubclassNode.isFloatSubtype(null, inliningTarget, object, getClass, isSubtype);
    }
}

