/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.lib.PyDictCheckExactNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(value=PyDictCheckExactNode.class)
public final class PyDictCheckExactNodeGen {
    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static PyDictCheckExactNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static PyDictCheckExactNode inline(@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=PyDictCheckExactNode.class)
    @DenyReplace
    private static final class Uncached
    extends PyDictCheckExactNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof PDict) {
                PDict arg1Value_ = (PDict)arg1Value;
                if (PGuards.isBuiltinDict(arg1Value_)) {
                    return PyDictCheckExactNode.doBuiltinDict(arg1Value_);
                }
                if (!PGuards.isBuiltinDict(arg1Value_)) {
                    return PyDictCheckExactNode.doOtherDict(arg1Value_);
                }
            }
            if (!PGuards.isDict(arg1Value)) {
                return PyDictCheckExactNode.doOther(arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=PyDictCheckExactNode.class)
    @DenyReplace
    private static final class Inlined
    extends PyDictCheckExactNode {
        private final InlineSupport.StateField state_0_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(PyDictCheckExactNode.class));
            this.state_0_ = target.getState(0, 3);
        }

        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0) {
                if ((state_0 & 3) != 0 && arg1Value instanceof PDict) {
                    PDict arg1Value_ = (PDict)arg1Value;
                    if ((state_0 & 1) != 0 && PGuards.isBuiltinDict(arg1Value_)) {
                        return PyDictCheckExactNode.doBuiltinDict(arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && !PGuards.isBuiltinDict(arg1Value_)) {
                        return PyDictCheckExactNode.doOtherDict(arg1Value_);
                    }
                }
                if ((state_0 & 4) != 0 && !PGuards.isDict(arg1Value)) {
                    return PyDictCheckExactNode.doOther(arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof PDict) {
                PDict arg1Value_ = (PDict)arg1Value;
                if (PGuards.isBuiltinDict(arg1Value_)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PyDictCheckExactNode.doBuiltinDict(arg1Value_);
                }
                if (!PGuards.isBuiltinDict(arg1Value_)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PyDictCheckExactNode.doOtherDict(arg1Value_);
                }
            }
            if (!PGuards.isDict(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 4);
                return PyDictCheckExactNode.doOther(arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

