/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ssl.CertUtils;
import com.oracle.graal.python.builtins.objects.ssl.PSSLContext;
import com.oracle.graal.python.builtins.objects.ssl.PSSLSocket;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipher;
import com.oracle.graal.python.builtins.objects.ssl.SSLOperationNode;
import com.oracle.graal.python.builtins.objects.ssl.SSLSocketBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.ssl.SSLSocketBuiltinsFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSSLSocket})
public final class SSLSocketBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SSLSocketBuiltinsFactory.getFactories();
    }

    @Builtin(name="compression", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CompressionNode
    extends PythonUnaryBuiltinNode {
        CompressionNode() {
        }

        @Specialization
        static Object get(PSSLSocket self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="selected_alpn_protocol", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SelectedAlpnProtocol
    extends PythonUnaryBuiltinNode {
        SelectedAlpnProtocol() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object get(PSSLSocket socket) {
            String protocol = socket.getEngine().getApplicationProtocol();
            return protocol != null && !protocol.isEmpty() ? PythonUtils.toTruffleStringUncached(protocol) : PNone.NONE;
        }
    }

    @Builtin(name="shared_ciphers", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SharedCiphers
    extends PythonUnaryBuiltinNode {
        SharedCiphers() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object get(PSSLSocket socket) {
            List<SSLCipher> ciphers = socket.getContext().computeEnabledCiphers(socket.getEngine());
            Object[] result = new Object[ciphers.size()];
            for (int i = 0; i < ciphers.size(); ++i) {
                SSLCipher cipher = ciphers.get(i);
                result[i] = this.factory().createTuple(new Object[]{cipher.getOpensslName(), cipher.getProtocol(), cipher.getStrengthBits()});
            }
            return this.factory().createList(result);
        }
    }

    @Builtin(name="cipher", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CipherNode
    extends PythonUnaryBuiltinNode {
        CipherNode() {
        }

        @Specialization
        Object getCipher(PSSLSocket self) {
            if (!self.isHandshakeComplete()) {
                return PNone.NONE;
            }
            SSLCipher cipher = CipherNode.getCipher(self.getEngine());
            if (cipher == null) {
                return PNone.NONE;
            }
            return this.factory().createTuple(new Object[]{cipher.getOpensslName(), cipher.getProtocol(), cipher.getStrengthBits()});
        }

        @CompilerDirectives.TruffleBoundary
        private static SSLCipher getCipher(SSLEngine engine) {
            SSLSession session = engine.getSession();
            String cipherSuite = session.getCipherSuite();
            if (cipherSuite != null) {
                return SSLCipher.valueOf(cipherSuite);
            }
            return null;
        }
    }

    @Builtin(name="get_channel_binding", minNumOfPositionalArgs=1, parameterNames={"$self", "sb_type"})
    @ArgumentClinic(name="sb_type", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_TLS_UNIQUE")
    @GenerateNodeFactory
    static abstract class GetChannelBinding
    extends PythonBinaryClinicBuiltinNode {
        static final TruffleString T_TLS_UNIQUE = PythonUtils.tsLiteral("tls-unique");

        GetChannelBinding() {
        }

        @Specialization
        Object getChannelBinding(PSSLSocket self, TruffleString sbType) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_CHANNEL_BINDING_NOT_IMPLEMENTED, sbType);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLSocketBuiltinsClinicProviders.GetChannelBindingClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="getpeercert", minNumOfPositionalArgs=1, parameterNames={"$self", "der"})
    @ArgumentClinic(name="der", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")
    @GenerateNodeFactory
    static abstract class GetPeerCertNode
    extends PythonBinaryClinicBuiltinNode {
        GetPeerCertNode() {
        }

        @Specialization(guards={"der"})
        Object getPeerCertDER(PSSLSocket self, boolean der) {
            if (!self.isHandshakeComplete()) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.HANDSHAKE_NOT_DONE_YET);
            }
            Certificate certificate = GetPeerCertNode.getCertificate(self.getEngine());
            if (certificate != null) {
                try {
                    return this.factory().createBytes(GetPeerCertNode.getEncoded(certificate));
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    // empty catch block
                }
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!der"})
        PDict getPeerCertDict(PSSLSocket self, boolean der) {
            if (!self.isHandshakeComplete()) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.HANDSHAKE_NOT_DONE_YET);
            }
            Certificate certificate = GetPeerCertNode.getCertificate(self.getEngine());
            if (certificate instanceof X509Certificate) {
                try {
                    return CertUtils.decodeCertificate(this.getContext().factory(), (X509Certificate)certificate);
                }
                catch (CertificateParsingException e) {
                    return this.factory().createDict();
                }
            }
            return this.factory().createDict();
        }

        @CompilerDirectives.TruffleBoundary
        private static Certificate getCertificate(SSLEngine engine) {
            try {
                Certificate[] certificates = engine.getSession().getPeerCertificates();
                if (certificates.length != 0) {
                    return certificates[0];
                }
                return null;
            }
            catch (SSLPeerUnverifiedException e) {
                return null;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] getEncoded(Certificate certificate) throws CertificateEncodingException {
            return certificate.getEncoded();
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLSocketBuiltinsClinicProviders.GetPeerCertNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="session_reused", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SessionReusedNode
    extends PythonUnaryBuiltinNode {
        SessionReusedNode() {
        }

        @Specialization
        static Object get(PSSLSocket self) {
            return false;
        }
    }

    @Builtin(name="session", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class SessionNode
    extends PythonBinaryBuiltinNode {
        SessionNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object get(PSSLSocket self, Object none) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(obj)"})
        Object set(PSSLSocket self, Object obj) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="owner", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class OwnerNode
    extends PythonBinaryBuiltinNode {
        OwnerNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object get(PSSLSocket self, Object none) {
            return self.getOwner() != null ? self.getOwner() : PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object set(PSSLSocket self, Object obj) {
            self.setOwner(obj);
            return PNone.NONE;
        }
    }

    @Builtin(name="pending", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class PendingNode
    extends PythonUnaryBuiltinNode {
        PendingNode() {
        }

        @Specialization
        static int getPending(PSSLSocket self) {
            return self.getApplicationInboundBIO().getPending();
        }
    }

    @Builtin(name="version", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class VersionNode
    extends PythonUnaryBuiltinNode {
        VersionNode() {
        }

        @Specialization
        static Object getVersion(PSSLSocket self, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (self.isHandshakeComplete()) {
                return fromJavaStringNode.execute(VersionNode.getProtocol(self.getEngine()), PythonUtils.TS_ENCODING);
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static String getProtocol(SSLEngine engine) {
            return engine.getSession().getProtocol();
        }
    }

    @Builtin(name="server_hostname", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ServerHostnameNode
    extends PythonUnaryBuiltinNode {
        ServerHostnameNode() {
        }

        @Specialization
        static Object get(PSSLSocket self) {
            return self.getServerHostname() != null ? self.getServerHostname() : PNone.NONE;
        }
    }

    @Builtin(name="server_side", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ServerSideNode
    extends PythonUnaryBuiltinNode {
        ServerSideNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static boolean get(PSSLSocket self) {
            return !self.getEngine().getUseClientMode();
        }
    }

    @Builtin(name="context", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ContextNode
    extends PythonUnaryBuiltinNode {
        ContextNode() {
        }

        @Specialization
        static PSSLContext getContext(PSSLSocket self) {
            return self.getContext();
        }
    }

    @Builtin(name="shutdown", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ShutdownNode
    extends PythonUnaryBuiltinNode {
        ShutdownNode() {
        }

        @Specialization
        Object shutdown(VirtualFrame frame, PSSLSocket self, @Cached SSLOperationNode sslOperationNode) {
            sslOperationNode.shutdown(frame, self);
            return self.getSocket() != null ? self.getSocket() : PNone.NONE;
        }
    }

    @Builtin(name="do_handshake", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DoHandshakeNode
    extends PythonUnaryBuiltinNode {
        DoHandshakeNode() {
        }

        @Specialization
        Object doHandshake(VirtualFrame frame, PSSLSocket self, @Cached SSLOperationNode sslOperationNode) {
            sslOperationNode.handshake(frame, self);
            return PNone.NONE;
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBinaryClinicBuiltinNode {
        WriteNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        Object write(VirtualFrame frame, PSSLSocket self, Object buffer, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached SSLOperationNode sslOperationNode) {
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int length = bufferLib.getBufferLength(buffer);
                ByteBuffer input = PythonUtils.wrapByteBuffer(bytes, 0, length);
                sslOperationNode.write(frame, self, input);
                Integer n = length;
                return n;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLSocketBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "len", "buffer"})
    @ArgumentClinic(name="len", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonTernaryClinicBuiltinNode {
        ReadNode() {
        }

        @Specialization(guards={"isNoValue(buffer)"})
        Object read(VirtualFrame frame, PSSLSocket self, int len, PNone buffer, @Cached.Shared @Cached SSLOperationNode sslOperationNode) {
            if (len == 0) {
                return this.factory().createBytes(new byte[0]);
            }
            if (len < 0) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.SIZE_SHOULD_NOT_BE_NEGATIVE);
            }
            ByteBuffer output = PythonUtils.allocateByteBuffer(len);
            sslOperationNode.read(frame, self, output);
            PythonUtils.flipBuffer(output);
            return this.factory().createBytes(PythonUtils.getBufferArray(output), PythonUtils.getBufferLimit(output));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isNoValue(bufferObj)"}, limit="3")
        Object readInto(VirtualFrame frame, PSSLSocket self, int len, Object bufferObj, @CachedLibrary(value="bufferObj") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached SSLOperationNode sslOperationNode) {
            Object buffer = bufferAcquireLib.acquireWritableWithTypeError(bufferObj, "read", frame, this);
            try {
                int bufferLen = bufferLib.getBufferLength(buffer);
                int toReadLen = len;
                if (len <= 0 || len > bufferLen) {
                    toReadLen = bufferLen;
                }
                if (toReadLen == 0) {
                    Integer n = 0;
                    return n;
                }
                boolean directWrite = bufferLib.hasInternalByteArray(buffer);
                byte[] bytes = directWrite ? bufferLib.getInternalByteArray(buffer) : new byte[toReadLen];
                ByteBuffer output = PythonUtils.wrapByteBuffer(bytes, 0, toReadLen);
                sslOperationNode.read(frame, self, output);
                PythonUtils.flipBuffer(output);
                int readBytes = PythonUtils.getBufferRemaining(output);
                if (!directWrite) {
                    bufferLib.writeFromByteArray(buffer, 0, bytes, 0, readBytes);
                }
                Integer n = readBytes;
                return n;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLSocketBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }
    }
}

