/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.IsliceBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PIslice;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PIslice})
public final class IsliceBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IsliceBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object setState(PIslice self, Object state, @Bind(value="this") Node inliningTarget, @Cached CastToJavaIntLossyNode castInt) {
            try {
                self.setCnt(castInt.execute(inliningTarget, state));
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isNone(self.getIterable())"})
        Object reduceNoIterable(VirtualFrame frame, PIslice self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive GetClassNode getClassNode, @Cached PyObjectGetIter getIter) {
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = this.factory().createTuple(new Object[]{getIter.execute((Frame)frame, inliningTarget, this.factory().createList()), 0});
            return this.factory().createTuple(new Object[]{type, tuple, 0});
        }

        @Specialization(guards={"!isNone(self.getIterable())"})
        Object reduce(PIslice self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive GetClassNode getClassNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            PNone stop = self.getStop() == -1 ? PNone.NONE : Integer.valueOf(self.getStop());
            PTuple tuple = this.factory().createTuple(new Object[]{self.getIterable(), self.getNext(), stop, self.getStep()});
            return this.factory().createTuple(new Object[]{type, tuple, self.getCnt()});
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isNone(self.getIterable())"})
        Object next(PIslice self) {
            throw this.raiseStopIteration();
        }

        @Specialization(guards={"!isNone(self.getIterable())"})
        Object next(VirtualFrame frame, PIslice self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedBranchProfile nextExceptionProfile, @Cached InlinedBranchProfile nextExceptionProfile2, @Cached InlinedBranchProfile setNextProfile) {
            Object item;
            Object it = self.getIterable();
            int stop = self.getStop();
            while (loopProfile.profile(inliningTarget, self.getCnt() < self.getNext())) {
                try {
                    item = nextNode.execute(frame, it, PNone.NO_VALUE);
                }
                catch (PException e) {
                    nextExceptionProfile.enter(inliningTarget);
                    self.setIterable(PNone.NONE);
                    throw e;
                }
                self.setCnt(self.getCnt() + 1);
            }
            if (stop != -1 && self.getCnt() >= stop) {
                self.setIterable(PNone.NONE);
                throw this.raiseStopIteration();
            }
            try {
                item = nextNode.execute(frame, it, PNone.NO_VALUE);
            }
            catch (PException e) {
                nextExceptionProfile2.enter(inliningTarget);
                self.setIterable(PNone.NONE);
                throw e;
            }
            self.setCnt(self.getCnt() + 1);
            int oldNext = self.getNext();
            self.setNext(self.getNext() + self.getStep());
            if (self.getNext() < oldNext || stop != -1 && self.getNext() > stop) {
                setNextProfile.enter(inliningTarget);
                self.setNext(stop);
            }
            return item;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PIslice self) {
            return self;
        }
    }
}

