/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictViewBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictItemsView})
public final class DictViewBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DictViewBuiltinsFactory.getFactories();
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GreaterThanNode
    extends DictViewRichcompareNode {
        GreaterThanNode() {
        }

        @Override
        protected boolean reverse() {
            return true;
        }

        @Override
        protected boolean lenCompare(int lenSelf, int lenOther) {
            return lenSelf > lenOther;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LessThanNode
    extends DictViewRichcompareNode {
        LessThanNode() {
        }

        @Override
        protected boolean reverse() {
            return false;
        }

        @Override
        protected boolean lenCompare(int lenSelf, int lenOther) {
            return lenSelf < lenOther;
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GreaterEqualNode
    extends DictViewRichcompareNode {
        GreaterEqualNode() {
        }

        @Override
        protected boolean reverse() {
            return true;
        }

        @Override
        protected boolean lenCompare(int lenSelf, int lenOther) {
            return lenSelf >= lenOther;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LessEqualNode
    extends DictViewRichcompareNode {
        LessEqualNode() {
        }

        @Override
        protected boolean reverse() {
            return false;
        }

        @Override
        protected boolean lenCompare(int lenSelf, int lenOther) {
            return lenSelf <= lenOther;
        }
    }

    @Builtins(value={@Builtin(name="__xor__", minNumOfPositionalArgs=2), @Builtin(name="__rxor__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    public static abstract class XorNode
    extends PythonBinaryBuiltinNode {
        protected static HashingStorage xor(VirtualFrame frame, Node inliningTarget, HashingStorageNodes.HashingStorageXor xorNode, HashingStorage left, HashingStorage right) {
            return xorNode.execute((Frame)frame, inliningTarget, left, right);
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="xorNode") @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            return this.factory().createSet(XorNode.xor(frame, inliningTarget, xorNode, self.getWrappedDict().getDictStorage(), other.getDictStorage()));
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PDictView.PDictKeysView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="xorNode") @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            return this.factory().createSet(XorNode.xor(frame, inliningTarget, xorNode, self.getWrappedDict().getDictStorage(), other.getWrappedDict().getDictStorage()));
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constructSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="xorNode") @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            return this.factory().createSet(XorNode.xor(frame, inliningTarget, xorNode, self.getWrappedDict().getDictStorage(), constructSetNode.executeWith((Frame)frame, other).getDictStorage()));
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="xorNode") @Cached HashingStorageNodes.HashingStorageXor xorNode, @Cached.Shared(value="constructSet") @Cached SetNodes.ConstructSetNode constructSetNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            return this.factory().createSet(XorNode.xor(frame, inliningTarget, xorNode, selfSet.getDictStorage(), other.getDictStorage()));
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PDictView.PDictItemsView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="xorNode") @Cached HashingStorageNodes.HashingStorageXor xorNode, @Cached.Shared(value="constructSet") @Cached SetNodes.ConstructSetNode constructSetNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            PSet otherSet = constructSetNode.executeWith((Frame)frame, other);
            return this.factory().createSet(XorNode.xor(frame, inliningTarget, xorNode, selfSet.getDictStorage(), otherSet.getDictStorage()));
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constructSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="xorNode") @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            return this.factory().createSet(XorNode.xor(frame, inliningTarget, xorNode, constructSetNode.executeWith((Frame)frame, self).getDictStorage(), constructSetNode.executeWith((Frame)frame, other).getDictStorage()));
        }
    }

    @Builtins(value={@Builtin(name="__or__", minNumOfPositionalArgs=2), @Builtin(name="__ror__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    public static abstract class OrNode
    extends PythonBinaryBuiltinNode {
        protected static HashingStorage union(Node inliningTarget, HashingStorageNodes.HashingStorageCopy copyNode, HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, HashingStorage left, HashingStorage right) {
            return left.union(inliningTarget, right, copyNode, addAllToOther);
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="copy") @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            return this.factory().createSet(OrNode.union(inliningTarget, copyNode, addAllToOther, self.getWrappedDict().getDictStorage(), other.getDictStorage()));
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PDictView.PDictKeysView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="copy") @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            return this.factory().createSet(OrNode.union(inliningTarget, copyNode, addAllToOther, self.getWrappedDict().getDictStorage(), other.getWrappedDict().getDictStorage()));
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="copy") @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            return this.factory().createSet(OrNode.union(inliningTarget, copyNode, addAllToOther, self.getWrappedDict().getDictStorage(), constructSetNode.executeWith((Frame)frame, other).getDictStorage()));
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="copy") @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached.Shared @Cached SetNodes.ConstructSetNode constructSetNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            return this.factory().createSet(OrNode.union(inliningTarget, copyNode, addAllToOther, selfSet.getDictStorage(), other.getDictStorage()));
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PDictView.PDictItemsView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="copy") @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached.Shared @Cached SetNodes.ConstructSetNode constructSetNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            PSet otherSet = constructSetNode.executeWith((Frame)frame, other);
            return this.factory().createSet(OrNode.union(inliningTarget, copyNode, addAllToOther, selfSet.getDictStorage(), otherSet.getDictStorage()));
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="copy") @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            HashingStorage selfStorage = constructSetNode.executeWith((Frame)frame, self).getDictStorage();
            HashingStorage otherStorage = constructSetNode.executeWith((Frame)frame, other).getDictStorage();
            return this.factory().createSet(OrNode.union(inliningTarget, copyNode, addAllToOther, selfStorage, otherStorage));
        }
    }

    @Builtins(value={@Builtin(name="__and__", minNumOfPositionalArgs=2), @Builtin(name="__rand__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class AndNode
    extends PythonBinaryBuiltinNode {
        AndNode() {
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intersect") @Cached HashingStorageNodes.HashingStorageIntersect intersectNode) {
            HashingStorage left = self.getWrappedDict().getDictStorage();
            HashingStorage right = other.getDictStorage();
            HashingStorage intersectedStorage = intersectNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(intersectedStorage);
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PDictView.PDictKeysView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intersect") @Cached HashingStorageNodes.HashingStorageIntersect intersectNode) {
            HashingStorage left = self.getWrappedDict().getDictStorage();
            HashingStorage right = other.getWrappedDict().getDictStorage();
            HashingStorage intersectedStorage = intersectNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(intersectedStorage);
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="intersect") @Cached HashingStorageNodes.HashingStorageIntersect intersectNode) {
            HashingStorage left = self.getWrappedDict().getDictStorage();
            HashingStorage right = constructSetNode.executeWith((Frame)frame, other).getDictStorage();
            HashingStorage intersectedStorage = intersectNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(intersectedStorage);
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intersect") @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            HashingStorage left = selfSet.getDictStorage();
            HashingStorage right = other.getDictStorage();
            HashingStorage intersectedStorage = intersectNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(intersectedStorage);
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PDictView.PDictItemsView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intersect") @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            PSet otherSet = constructSetNode.executeWith((Frame)frame, other);
            HashingStorage left = selfSet.getDictStorage();
            HashingStorage right = otherSet.getDictStorage();
            HashingStorage intersectedStorage = intersectNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(intersectedStorage);
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="intersect") @Cached HashingStorageNodes.HashingStorageIntersect intersectNode) {
            HashingStorage left = constructSetNode.executeWith((Frame)frame, self).getDictStorage();
            HashingStorage right = constructSetNode.executeWith((Frame)frame, other).getDictStorage();
            HashingStorage intersectedStorage = intersectNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(intersectedStorage);
        }
    }

    @Builtins(value={@Builtin(name="__sub__", minNumOfPositionalArgs=2), @Builtin(name="__rsub__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @GenerateNodeFactory
    static abstract class SubNode
    extends PythonBinaryBuiltinNode {
        SubNode() {
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, self.getWrappedDict().getDictStorage(), other.getDictStorage());
            return this.factory().createSet(storage);
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PDictView.PDictKeysView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, self.getWrappedDict().getDictStorage(), other.getWrappedDict().getDictStorage());
            return this.factory().createSet(storage);
        }

        @Specialization
        PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage left = self.getWrappedDict().getDictStorage();
            HashingStorage right = constructSetNode.executeWith((Frame)frame, other).getDictStorage();
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(storage);
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, selfSet.getDictStorage(), other.getDictStorage());
            return this.factory().createSet(storage);
        }

        @Specialization
        PBaseSet doNotIterable(VirtualFrame frame, PDictView.PDictItemsView self, PDictView.PDictItemsView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            PSet selfSet = constructSetNode.executeWith((Frame)frame, self);
            PSet otherSet = constructSetNode.executeWith((Frame)frame, other);
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, selfSet.getDictStorage(), otherSet.getDictStorage());
            return this.factory().createSet(storage);
        }

        @Specialization
        PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage left = constructSetNode.executeWith((Frame)frame, self).getDictStorage();
            HashingStorage right = constructSetNode.executeWith((Frame)frame, other).getDictStorage();
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, left, right);
            return this.factory().createSet(storage);
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        EqNode eqNode;

        private EqNode getEqNode() {
            if (this.eqNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.eqNode = (EqNode)this.insert(DictViewBuiltinsFactory.EqNodeFactory.create());
            }
            return this.eqNode;
        }

        @Specialization
        public Object notEqual(VirtualFrame frame, Object self, Object other) {
            Object result = this.getEqNode().execute(frame, self, other);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                return result;
            }
            assert (result instanceof Boolean);
            return (Boolean)result == false;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends DictViewRichcompareNode {
        @Override
        protected boolean reverse() {
            return false;
        }

        @Override
        protected boolean lenCompare(int lenSelf, int lenOther) {
            return lenSelf == lenOther;
        }
    }

    protected static abstract class DictViewRichcompareNode
    extends PythonBinaryBuiltinNode {
        protected DictViewRichcompareNode() {
        }

        protected boolean reverse() {
            CompilerAsserts.neverPartOfCompilation();
            throw new IllegalStateException("subclass should have implemented reverse");
        }

        protected boolean lenCompare(int lenSelf, int lenOther) {
            CompilerAsserts.neverPartOfCompilation();
            throw new IllegalStateException("subclass should have implemented lenCompare");
        }

        @Specialization
        boolean doView(VirtualFrame frame, PDictView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen selfLenNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen otherLenNode, @Cached.Shared @Cached ContainedInNode allContained) {
            int lenOther;
            int lenSelf = selfLenNode.execute(inliningTarget, self.getWrappedDict().getDictStorage());
            return this.lenCompare(lenSelf, lenOther = otherLenNode.execute(inliningTarget, other.getDictStorage())) && (this.reverse() ? allContained.execute(frame, other, self) : allContained.execute(frame, self, other));
        }

        @Specialization
        boolean doView(VirtualFrame frame, PDictView self, PDictView other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen selfLenNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen otherLenNode, @Cached.Shared @Cached ContainedInNode allContained) {
            int lenOther;
            int lenSelf = selfLenNode.execute(inliningTarget, self.getWrappedDict().getDictStorage());
            return this.lenCompare(lenSelf, lenOther = otherLenNode.execute(inliningTarget, other.getWrappedDict().getDictStorage())) && (this.reverse() ? allContained.execute(frame, other, self) : allContained.execute(frame, self, other));
        }

        @Fallback
        static PNotImplemented wrongTypes(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    protected static abstract class ContainedInNode
    extends PNodeWithContext {
        @Node.Child
        private GetNextNode next;
        @Node.Child
        private LookupAndCallBinaryNode contains;
        @Node.Child
        private CoerceToBooleanNode cast;
        private final boolean checkAll;

        public ContainedInNode(boolean checkAll) {
            this.checkAll = checkAll;
        }

        private GetNextNode getNext() {
            if (this.next == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.next = (GetNextNode)this.insert(GetNextNode.create());
            }
            return this.next;
        }

        private LookupAndCallBinaryNode getContains() {
            if (this.contains == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.contains = (LookupAndCallBinaryNode)this.insert(LookupAndCallBinaryNode.create(SpecialMethodSlot.Contains));
            }
            return this.contains;
        }

        private CoerceToBooleanNode getCast() {
            if (this.cast == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cast = (CoerceToBooleanNode)this.insert(CoerceToBooleanNode.createIfTrueNode());
            }
            return this.cast;
        }

        public abstract boolean execute(VirtualFrame var1, Object var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public boolean doIt(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached PyObjectGetIter getIterNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopProfile) {
            Object iterator = getIterNode.execute((Frame)frame, inliningTarget, self);
            boolean ok = this.checkAll;
            int i = 0;
            try {
                while (loopConditionProfile.profile(inliningTarget, this.checkAll && ok || !this.checkAll && !ok)) {
                    Object item = this.getNext().execute((Frame)frame, iterator);
                    ok = this.getCast().executeBooleanCached(frame, this.getContains().executeObject(frame, other, item));
                    ++i;
                }
                LoopNode.reportLoopCount((Node)this, (int)(i < 0 ? Integer.MAX_VALUE : i));
            }
            catch (PException e) {
                try {
                    e.expectStopIteration(inliningTarget, stopProfile);
                    LoopNode.reportLoopCount((Node)this, (int)(i < 0 ? Integer.MAX_VALUE : i));
                }
                catch (Throwable throwable) {
                    LoopNode.reportLoopCount((Node)this, (int)(i < 0 ? Integer.MAX_VALUE : i));
                    throw throwable;
                }
            }
            return ok;
        }

        @NeverDefault
        static ContainedInNode create() {
            return DictViewBuiltinsFactory.ContainedInNodeGen.create(true);
        }

        @NeverDefault
        static ContainedInNode create(boolean all) {
            return DictViewBuiltinsFactory.ContainedInNodeGen.create(all);
        }
    }

    @Builtin(name="isdisjoint", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IsDisjointNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"self == other"})
        static boolean disjointSame(PDictView self, PDictView other, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared HashingStorageNodes.HashingStorageLen len) {
            return len.execute(inliningTarget, self.getWrappedDict().getDictStorage()) == 0;
        }

        @Specialization(guards={"self != other"})
        static boolean disjointNotSame(VirtualFrame frame, PDictView self, PDictView other, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared HashingStorageNodes.HashingStorageLen len, @Cached @Cached.Shared InlinedConditionProfile sizeProfile, @Cached @Cached.Shared PyObjectSizeNode sizeNode, @Cached(value="create(false)") @Cached.Shared ContainedInNode contained) {
            return IsDisjointNode.disjointImpl(frame, inliningTarget, self, other, len, sizeProfile, sizeNode, contained);
        }

        @Specialization
        static boolean disjoint(VirtualFrame frame, PDictView self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared HashingStorageNodes.HashingStorageLen len, @Cached @Cached.Shared InlinedConditionProfile sizeProfile, @Cached @Cached.Shared PyObjectSizeNode sizeNode, @Cached(value="create(false)") @Cached.Shared ContainedInNode contained) {
            return IsDisjointNode.disjointImpl(frame, inliningTarget, self, other, len, sizeProfile, sizeNode, contained);
        }

        private static boolean disjointImpl(VirtualFrame frame, Node inliningTarget, PDictView self, Object other, HashingStorageNodes.HashingStorageLen len, InlinedConditionProfile sizeProfile, PyObjectSizeNode sizeNode, ContainedInNode contained) {
            if (sizeProfile.profile(inliningTarget, len.execute(inliningTarget, self.getWrappedDict().getDictStorage()) <= sizeNode.execute((Frame)frame, inliningTarget, other))) {
                return !contained.execute(frame, self, other);
            }
            return !contained.execute(frame, other, self);
        }

        @Specialization(guards={"!isAnySet(other)", "!isDictView(other)"})
        static boolean disjoint(VirtualFrame frame, PDictView self, Object other, @Cached(value="create(false)") @Cached.Shared ContainedInNode contained) {
            return !contained.execute(frame, other, self);
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"len.execute(inliningTarget, self.getWrappedDict().getDictStorage()) == 0"}, limit="1")
        static boolean containsEmpty(PDictView self, Object key, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen len) {
            return false;
        }

        @Specialization
        static boolean contains(VirtualFrame frame, PDictView.PDictKeysView self, Object key, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return getItem.hasKey((Frame)frame, inliningTarget, self.getWrappedDict().getDictStorage(), key);
        }

        @Specialization
        static boolean contains(VirtualFrame frame, PDictView.PDictItemsView self, PTuple key, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached InlinedConditionProfile tupleLenProfile, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getTupleItemNode) {
            SequenceStorage tupleStorage = key.getSequenceStorage();
            if (tupleLenProfile.profile(inliningTarget, tupleStorage.length() != 2)) {
                return false;
            }
            HashingStorage dictStorage = self.getWrappedDict().getDictStorage();
            Object value = getItem.execute((Frame)frame, inliningTarget, dictStorage, getTupleItemNode.execute(tupleStorage, 0));
            if (value != null) {
                return eqNode.compare((Frame)frame, inliningTarget, value, getTupleItemNode.execute(tupleStorage, 1));
            }
            return false;
        }

        protected static boolean isFallback(Object self, Object key) {
            return !(self instanceof PDictView) || self instanceof PDictView.PDictItemsView && !(key instanceof PTuple);
        }

        @Specialization(guards={"isFallback(self, key)"})
        static boolean contains(Object self, Object key) {
            return false;
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object getReversedKeysViewIter(PDictView.PDictKeysView self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetReverseIterator getReverseIterator) {
            HashingStorage storage = self.getWrappedDict().getDictStorage();
            return this.factory().createDictKeyIterator(getReverseIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }

        @Specialization
        Object getReversedItemsViewIter(PDictView.PDictItemsView self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetReverseIterator getReverseIterator) {
            HashingStorage storage = self.getWrappedDict().getDictStorage();
            return this.factory().createDictItemIterator(getReverseIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object getKeysViewIter(PDictView.PDictKeysView self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="len") @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared(value="getit") @Cached HashingStorageNodes.HashingStorageGetIterator getIterator) {
            HashingStorage storage = self.getWrappedDict().getDictStorage();
            return this.factory().createDictKeyIterator(getIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }

        @Specialization
        Object getItemsViewIter(PDictView.PDictItemsView self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="len") @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared(value="getit") @Cached HashingStorageNodes.HashingStorageGetIterator getIterator) {
            HashingStorage storage = self.getWrappedDict().getDictStorage();
            return this.factory().createDictItemIterator(getIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object len(PDictView self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen len) {
            return len.execute(inliningTarget, self.getWrappedDict().getDictStorage());
        }
    }

    @Builtin(name="mapping", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class MappingNode
    extends PythonUnaryBuiltinNode {
        MappingNode() {
        }

        @Specialization
        Object mapping(PDictView self) {
            return this.factory().createMappingproxy(self.getWrappedDict());
        }
    }
}

