/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageFactory;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.KeywordsStorage;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class HashingStorage {
    public final HashingStorage union(Node inliningTarget, HashingStorage other, HashingStorageNodes.HashingStorageCopy copyNode, HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
        HashingStorage newStore = copyNode.execute(inliningTarget, this);
        return addAllToOther.execute(null, inliningTarget, other, newStore);
    }

    public final HashingStorage unionCached(HashingStorage other, HashingStorageNodes.HashingStorageCopy copyNode, HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
        HashingStorage newStore = copyNode.executeCached(this);
        return addAllToOther.executeCached(null, other, newStore);
    }

    public static HashingStorage addKeyValuesToStorage(VirtualFrame frame, ArrayBuilder<KeyValue> elements, HashingStorage storage, Node inliningTarget, HashingStorageNodes.HashingStorageSetItem setItem) {
        for (int i = 0; i < elements.size(); ++i) {
            Object key = elements.get((int)i).key;
            Object value = elements.get((int)i).value;
            storage = setItem.execute((Frame)frame, inliningTarget, storage, key, value);
        }
        return storage;
    }

    public static HashingStorage addKeyValuesToStorage(VirtualFrame frame, PDict self, Object other, Object keyAttr, Node inliningTarget, ObjectToArrayPairNode toArrayPair, HashingStorageNodes.HashingStorageSetItem setItem) {
        ArrayBuilder<KeyValue> elements = toArrayPair.execute(frame, other, keyAttr);
        HashingStorage storage = self.getDictStorage();
        return HashingStorage.addKeyValuesToStorage(frame, elements, storage, inliningTarget, setItem);
    }

    @CompilerDirectives.ValueType
    protected static final class KeyValue {
        final Object key;
        final Object value;

        private KeyValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    @GenerateCached
    @GenerateInline(value=false)
    public static abstract class ObjectToArrayPairNode
    extends PNodeWithContext {
        public abstract ArrayBuilder<KeyValue> execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"!isNoValue(keyAttr)"})
        static ArrayBuilder<KeyValue> partialMerge(VirtualFrame frame, Object mapping, Object keyAttr, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectGetIter getIter, @Cached.Shared @Cached(neverDefault=false) PyIterNextNode nextNode, @Cached.Shared @Cached PyObjectGetItem getItemNode, @Cached CallVarargsMethodNode callKeysMethod) {
            Object keyObj;
            Object keysIterable = callKeysMethod.execute((Frame)frame, keyAttr, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS);
            Object keysIt = getIter.execute((Frame)frame, inliningTarget, keysIterable);
            ArrayBuilder<KeyValue> elements = new ArrayBuilder<KeyValue>();
            while ((keyObj = nextNode.execute((Frame)frame, keysIt)) != null) {
                Object valueObj = getItemNode.execute((Frame)frame, inliningTarget, mapping, keyObj);
                elements.add(new KeyValue(keyObj, valueObj));
            }
            return elements;
        }

        @Specialization
        static ArrayBuilder<KeyValue> partialMergeFromSeq2(VirtualFrame frame, Object iterable, PNone keyAttr, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectGetIter getIter, @Cached.Shared @Cached(neverDefault=false) PyIterNextNode nextNode, @Cached.Shared @Cached PyObjectGetItem getItemNode, @Cached ListNodes.FastConstructListNode createListNode, @Cached SequenceNodes.LenNode seqLenNode, @Cached PRaiseNode.Lazy raise, @Cached InlinedConditionProfile lengthTwoProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isTypeErrorProfile) throws PException {
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            ArrayBuilder<KeyValue> elements = new ArrayBuilder<KeyValue>();
            int len = 2;
            try {
                Object next;
                while ((next = nextNode.execute((Frame)frame, it)) != null) {
                    PSequence element = createListNode.execute((Frame)frame, inliningTarget, next);
                    assert (element != null);
                    len = seqLenNode.execute(inliningTarget, element);
                    if (lengthTwoProfile.profile(inliningTarget, len != 2)) {
                        throw raise.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.DICT_UPDATE_SEQ_ELEM_HAS_LENGTH_2_REQUIRED, elements.size(), len);
                    }
                    Object key = getItemNode.execute((Frame)frame, inliningTarget, element, 0);
                    Object value = getItemNode.execute((Frame)frame, inliningTarget, element, 1);
                    elements.add(new KeyValue(key, value));
                }
            }
            catch (PException e) {
                if (!lengthTwoProfile.profile(inliningTarget, len != 2) && isTypeErrorProfile.profileException(inliningTarget, e, PythonErrorType.TypeError)) {
                    throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CONVERT_DICT_UPDATE_SEQ, elements.size());
                }
                throw e;
            }
            return elements;
        }
    }

    public static abstract class InitNode
    extends PNodeWithContext
    implements IndirectCallNode {
        private final Assumption dontNeedExceptionState = Truffle.getRuntime().createAssumption();
        private final Assumption dontNeedCallerFrame = Truffle.getRuntime().createAssumption();

        @Override
        public Assumption needNotPassFrameAssumption() {
            return this.dontNeedCallerFrame;
        }

        @Override
        public Assumption needNotPassExceptionAssumption() {
            return this.dontNeedExceptionState;
        }

        public abstract HashingStorage execute(VirtualFrame var1, Object var2, PKeyword[] var3);

        protected boolean isEmpty(PKeyword[] kwargs) {
            return kwargs.length == 0;
        }

        @Specialization(guards={"isNoValue(iterable)", "isEmpty(kwargs)"})
        static HashingStorage doEmpty(PNone iterable, PKeyword[] kwargs) {
            return EmptyStorage.INSTANCE;
        }

        @Specialization(guards={"isNoValue(iterable)", "!isEmpty(kwargs)"})
        static HashingStorage doKeywords(PNone iterable, PKeyword[] kwargs) {
            return new KeywordsStorage(kwargs);
        }

        protected static boolean isPDict(Object o) {
            return o instanceof PHashingCollection;
        }

        @Specialization(guards={"isEmpty(kwargs)", "!hasIterAttrButNotBuiltin(inliningTarget, dictLike, getClassNode, lookupIter)"}, limit="1")
        static HashingStorage doPDict(PHashingCollection dictLike, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageCopy copyNode) {
            return copyNode.execute(inliningTarget, dictLike.getDictStorage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isEmpty(kwargs)", "!hasIterAttrButNotBuiltin(inliningTarget, iterable, getClassNode, lookupIter)"}, limit="1")
        HashingStorage doPDictKwargs(VirtualFrame frame, PHashingCollection iterable, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            PythonContext contextRef = PythonContext.get(this);
            PythonLanguage language = PythonLanguage.get(this);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, contextRef, this);
            try {
                HashingStorage iterableDictStorage = iterable.getDictStorage();
                HashingStorage dictStorage = copyNode.execute(inliningTarget, iterableDictStorage);
                HashingStorage hashingStorage = addAllToOther.execute((Frame)frame, inliningTarget, (HashingStorage)new KeywordsStorage(kwargs), dictStorage);
                return hashingStorage;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, contextRef, state);
            }
        }

        protected static boolean hasIterAttrButNotBuiltin(Node inliningTarget, Object col, GetClassNode getClassNode, LookupCallableSlotInMRONode lookupIter) {
            Object attr = lookupIter.execute(getClassNode.execute(inliningTarget, col));
            return attr != PNone.NO_VALUE && !(attr instanceof PBuiltinMethod) && !(attr instanceof PBuiltinFunction);
        }

        @Specialization(guards={"!isNoValue(arg)", "!isPDict(arg) || hasIterAttrButNotBuiltin(inliningTarget, arg, getClassNode, lookupIter)"}, limit="2")
        static HashingStorage updateArg(VirtualFrame frame, Object arg, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter, @Cached.Exclusive @Cached PyObjectLookupAttr lookupKeysAttributeNode, @Cached.Exclusive @Cached ObjectToArrayPairNode toArrayPair, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached InlinedConditionProfile hasKwds) {
            Object keyAttr = lookupKeysAttributeNode.execute((Frame)frame, inliningTarget, arg, SpecialMethodNames.T_KEYS);
            ArrayBuilder<KeyValue> elements = toArrayPair.execute(frame, arg, keyAttr);
            HashingStorage storage = PDict.createNewStorage(elements.size() + kwargs.length);
            storage = HashingStorage.addKeyValuesToStorage(frame, elements, storage, inliningTarget, setItem);
            if (hasKwds.profile(inliningTarget, kwargs.length > 0)) {
                storage = addAllToOther.execute((Frame)frame, inliningTarget, (HashingStorage)new KeywordsStorage(kwargs), storage);
            }
            return storage;
        }

        @NeverDefault
        public static InitNode create() {
            return HashingStorageFactory.InitNodeGen.create();
        }
    }
}

