/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextDictBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextTupleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtParseArgumentsNodeFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.GetNextVaArgNode;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.ArrayList;

public abstract class CExtParseArgumentsNode {
    static final int FORMAT_LOWER_S = 115;
    static final int FORMAT_UPPER_S = 83;
    static final int FORMAT_LOWER_Z = 122;
    static final int FORMAT_UPPER_Z = 90;
    static final int FORMAT_LOWER_Y = 121;
    static final int FORMAT_UPPER_Y = 89;
    static final int FORMAT_LOWER_U = 117;
    static final int FORMAT_UPPER_U = 85;
    static final int FORMAT_LOWER_E = 101;
    static final int FORMAT_LOWER_B = 98;
    static final int FORMAT_UPPER_B = 66;
    static final int FORMAT_LOWER_H = 104;
    static final int FORMAT_UPPER_H = 72;
    static final int FORMAT_LOWER_I = 105;
    static final int FORMAT_UPPER_I = 73;
    static final int FORMAT_LOWER_L = 108;
    static final int FORMAT_UPPER_L = 76;
    static final int FORMAT_LOWER_K = 107;
    static final int FORMAT_UPPER_K = 75;
    static final int FORMAT_LOWER_N = 110;
    static final int FORMAT_LOWER_C = 99;
    static final int FORMAT_UPPER_C = 67;
    static final int FORMAT_LOWER_F = 102;
    static final int FORMAT_LOWER_D = 100;
    static final int FORMAT_UPPER_D = 68;
    static final int FORMAT_UPPER_O = 79;
    static final int FORMAT_LOWER_W = 119;
    static final int FORMAT_LOWER_P = 112;
    static final int FORMAT_PAR_OPEN = 40;
    static final int FORMAT_PAR_CLOSE = 41;

    private static boolean skipOptionalArg(Object arg, boolean optional) {
        return arg == null && optional;
    }

    public static abstract class SplitFormatStringNode
    extends Node {
        public abstract TruffleString[] execute(TruffleString var1);

        @Specialization(guards={"cachedFormat.equals(format)"}, limit="1")
        static TruffleString[] doCached(TruffleString format, @Cached(value="format") TruffleString cachedFormat, @Cached(value="extractFormatOnly(format)", dimensions=1) TruffleString[] cachedResult) {
            return cachedResult;
        }

        @Specialization(replaces={"doCached"})
        static TruffleString[] doGeneric(TruffleString format, @Cached ConditionProfile hasFunctionNameProfile, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleString.CodePointLengthNode lengthNode) {
            int len = lengthNode.execute((AbstractTruffleString)format, PythonUtils.TS_ENCODING);
            int colonIdx = indexOfCodePointNode.execute((AbstractTruffleString)format, 58, 0, len, PythonUtils.TS_ENCODING);
            if (hasFunctionNameProfile.profile(colonIdx >= 0)) {
                return new TruffleString[]{substringNode.execute((AbstractTruffleString)format, 0, colonIdx, PythonUtils.TS_ENCODING, false), substringNode.execute((AbstractTruffleString)format, colonIdx + 1, len - colonIdx - 1, PythonUtils.TS_ENCODING, false)};
            }
            return new TruffleString[]{format, StringLiterals.T_EMPTY_STRING};
        }

        static TruffleString[] extractFormatOnly(TruffleString format) {
            return SplitFormatStringNode.doGeneric(format, ConditionProfile.getUncached(), TruffleString.IndexOfCodePointNode.getUncached(), TruffleString.SubstringNode.getUncached(), TruffleString.CodePointLengthNode.getUncached());
        }
    }

    static final class ParseArgumentsException
    extends ControlFlowException {
        private static final long serialVersionUID = 1L;

        ParseArgumentsException() {
        }

        static ParseArgumentsException raise() {
            CompilerDirectives.transferToInterpreter();
            throw new ParseArgumentsException();
        }
    }

    static abstract class ConverterCheckResultNode
    extends Node {
        ConverterCheckResultNode() {
        }

        public abstract void execute(int var1) throws ParseArgumentsException;

        @Specialization(guards={"statusCode != 0"})
        static void doSuccess(int statusCode) {
        }

        @Specialization(guards={"statusCode == 0"})
        static void doError(int statusCode, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtNodes.PRaiseNativeNode raiseNode) throws ParseArgumentsException {
            boolean errOccurred;
            PException currentException = getThreadStateNode.getCurrentException(inliningTarget);
            boolean bl = errOccurred = currentException != null;
            if (!errOccurred) {
                raiseNode.raiseInt(null, 0, PythonBuiltinClassType.TypeError, ErrorMessages.CONVERTER_FUNC_FAILED_TO_SET_ERROR, new Object[0]);
            }
            throw ParseArgumentsException.raise();
        }
    }

    static abstract class ExecuteConverterNode
    extends Node {
        private static final Source NFI_SIGNATURE = Source.newBuilder((String)"nfi", (CharSequence)"(POINTER,POINTER):SINT32", (String)"exec").build();

        ExecuteConverterNode() {
        }

        public abstract void execute(Object var1, Object var2, Object var3);

        @Specialization(guards={"!converterLib.isExecutable(converter)"})
        static void doExecuteConverterNative(Object converter, Object inputArgument, Object outputArgument, @Cached(value="parseSignature()", allowUncached=true) Object signature, @CachedLibrary(value="signature") SignatureLibrary signatureLib, @CachedLibrary(limit="1") InteropLibrary converterLib, @CachedLibrary(limit="1") InteropLibrary resultLib, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached.Exclusive @Cached CExtNodes.PRaiseNativeNode raiseNode, @Cached.Exclusive @Cached ConverterCheckResultNode checkResultNode) {
            Object boundConverter = signatureLib.bind(signature, converter);
            ExecuteConverterNode.doExecuteConverterGeneric(boundConverter, inputArgument, outputArgument, converterLib, resultLib, toNativeNode, raiseNode, checkResultNode);
        }

        @Specialization(limit="5", guards={"converterLib.isExecutable(converter)"})
        static void doExecuteConverterGeneric(Object converter, Object inputArgument, Object outputArgument, @CachedLibrary(value="converter") InteropLibrary converterLib, @CachedLibrary(limit="1") InteropLibrary resultLib, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached.Exclusive @Cached CExtNodes.PRaiseNativeNode raiseNode, @Cached.Exclusive @Cached ConverterCheckResultNode checkResultNode) {
            try {
                Object result = converterLib.execute(converter, new Object[]{toNativeNode.execute(inputArgument), outputArgument});
                if (resultLib.fitsInInt(result)) {
                    checkResultNode.execute(resultLib.asInt(result));
                    return;
                }
                CompilerDirectives.transferToInterpreter();
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.CALLING_ARG_CONVERTER_FAIL_UNEXPECTED_RETURN, result);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreter();
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.CALLING_ARG_CONVERTER_FAIL_INCOMPATIBLE_PARAMS, e.getSuppliedValues());
            }
            catch (ArityException e) {
                CompilerDirectives.transferToInterpreter();
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.CALLING_ARG_CONVERTER_FAIL_EXPECTED_D_GOT_P, e.getExpectedMinArity(), e.getActualArity());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.ARG_CONVERTED_NOT_EXECUTABLE, new Object[0]);
            }
            throw ParseArgumentsException.raise();
        }

        static Object parseSignature() {
            return PythonContext.get(null).getEnv().parseInternal(NFI_SIGNATURE, new String[0]).call(new Object[0]);
        }
    }

    static abstract class GetArgNode
    extends Node {
        GetArgNode() {
        }

        public abstract Object execute(ParserState var1, Object var2, TruffleString[] var3, boolean var4) throws InteropException;

        @Specialization(guards={"kwds == null", "!keywordsOnly"})
        static Object doNoKeywords(ParserState state, Object kwds, TruffleString[] kwdnames, boolean keywordsOnly, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="lenNode") @Cached SequenceNodes.LenNode lenNode, @Cached.Shared(value="getItemNode") @Cached PythonCextTupleBuiltins.PyTuple_GetItem getItemNode, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) {
            Object out = null;
            assert (!keywordsOnly);
            int l = lenNode.execute(inliningTarget, state.v.argv);
            if (state.v.argnum < l) {
                out = getItemNode.execute(state.v.argv, state.v.argnum);
            }
            if (out == null && !state.restOptional) {
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.TypeError, ErrorMessages.S_MISSING_REQUIRED_ARG_POS_D, state.funName, state.v.argnum);
                throw ParseArgumentsException.raise();
            }
            ++state.v.argnum;
            return out;
        }

        @Specialization(replaces={"doNoKeywords"})
        Object doGeneric(ParserState state, Object kwds, TruffleString[] kwdnames, boolean keywordsOnly, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="lenNode") @Cached SequenceNodes.LenNode lenNode, @Cached.Shared(value="getItemNode") @Cached PythonCextTupleBuiltins.PyTuple_GetItem getItemNode, @Cached PythonCextDictBuiltins.PyDict_GetItem getDictItemNode, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) {
            TruffleString kwdname;
            int l;
            Object out = null;
            if (!keywordsOnly && state.v.argnum < (l = lenNode.execute(inliningTarget, state.v.argv))) {
                out = getItemNode.execute(state.v.argv, state.v.argnum);
            }
            if (kwds != null && out == null && state.v.prev == null && kwdnames != null && (kwdname = kwdnames[state.v.argnum]) != null && (out = getDictItemNode.execute(kwds, kwdname)) == PythonContext.get(this).getNativeNull()) {
                out = null;
            }
            if (out == null && !state.restOptional) {
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.TypeError, ErrorMessages.S_MISSING_REQUIRED_ARG_POS_D, state.funName, state.v.argnum);
                throw ParseArgumentsException.raise();
            }
            ++state.v.argnum;
            return out;
        }
    }

    @ImportStatic(value={CExtParseArgumentsNode.class})
    static abstract class ConvertExtendedArgNode
    extends Node {
        ConvertExtendedArgNode() {
        }

        public abstract void execute(int var1, int var2, int var3, Object var4, Object var5) throws InteropException;

        @Specialization(guards={"c == FORMAT_LOWER_E"})
        void doEncodedString(int c, int la1, int la2, Object arg, Object varargs, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.AsCharPointerNode asCharPointerNode, @Cached GetNextVaArgNode getVaArgNode, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CApiTransitions.NativeToPythonNode argToJavaNode, @Cached PyObjectSizeNode sizeNode, @Cached CExtNodes.PRaiseNativeNode raiseNode) throws InteropException, ParseArgumentsException {
            Object encoding = getVaArgNode.execute(varargs);
            if (la1 == 115) {
                boolean recodeStrings = true;
            } else if (la1 == 116) {
                boolean recodeStrings = false;
            } else {
                throw ConvertExtendedArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.ESTAR_FORMAT_SPECIFIERS_NOT_ALLOWED, arg);
            }
            writePointerNode.write(getVaArgNode.execute(varargs), asCharPointerNode.execute(arg, true));
            if (la2 == 35) {
                int size = sizeNode.execute(null, inliningTarget, argToJavaNode.execute(arg));
                writeLongNode.write(getVaArgNode.execute(varargs), size);
            }
        }

        private static ParseArgumentsException raise(CExtNodes.PRaiseNativeNode raiseNode, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            CompilerDirectives.transferToInterpreter();
            raiseNode.executeInt(null, 0, errType, format, arguments);
            throw ParseArgumentsException.raise();
        }
    }

    @ImportStatic(value={CExtParseArgumentsNode.class})
    static abstract class ConvertParArgNode
    extends Node {
        ConvertParArgNode() {
        }

        public abstract void execute(ParserState var1, Object var2, int var3, TruffleString[] var4) throws InteropException;

        @Specialization(guards={"c == FORMAT_PAR_OPEN"})
        static void doParOpen(ParserState state, Object kwds, int c, TruffleString[] kwdnames, @Bind(value="this") Node inliningTarget, @Cached PySequenceCheckNode sequenceCheckNode, @Cached TupleNodes.ConstructTupleNode constructTupleNode, @Cached PythonObjectFactory factory, @Cached GetArgNode getArgNode, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) throws InteropException, ParseArgumentsException {
            Object arg = getArgNode.execute(state, kwds, kwdnames, state.restKeywordsOnly);
            if (CExtParseArgumentsNode.skipOptionalArg(arg, state.restOptional)) {
                state.open(new PositionalArgStack(factory.createEmptyTuple(), state.v));
                return;
            }
            if (!sequenceCheckNode.execute(inliningTarget, arg)) {
                throw ConvertParArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_GOT_P, "tuple", arg);
            }
            try {
                state.open(new PositionalArgStack(constructTupleNode.execute(null, arg), state.v));
                return;
            }
            catch (PException e) {
                throw ConvertParArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.FAILED_TO_CONVERT_SEQ, new Object[0]);
            }
        }

        @Specialization(guards={"c == FORMAT_PAR_CLOSE"})
        static void doParClose(ParserState state, Object kwds, int c, TruffleString[] kwdnames, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) throws ParseArgumentsException {
            if (state.v.prev == null) {
                CompilerDirectives.transferToInterpreter();
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.LEFT_BRACKET_WO_RIGHT_BRACKET_IN_ARG, new Object[0]);
                throw ParseArgumentsException.raise();
            }
            int len = state.v.argv.getSequenceStorage().length();
            if (len > state.v.argnum) {
                throw ConvertParArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_SEQ_OF_LENGTH_D_NOT_D, state.v.argnum, len);
            }
            state.close();
        }

        private static ParseArgumentsException raise(CExtNodes.PRaiseNativeNode raiseNode, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            CompilerDirectives.transferToInterpreter();
            raiseNode.executeInt(null, 0, errType, format, arguments);
            throw ParseArgumentsException.raise();
        }
    }

    @ImportStatic(value={CExtParseArgumentsNode.class})
    static abstract class ConvertArgNode
    extends Node {
        ConvertArgNode() {
        }

        public abstract void execute(int var1, int var2, Object var3, Object var4) throws InteropException;

        @Specialization(guards={"c == FORMAT_LOWER_Y"})
        void doBufferR(int c, int la, Object arg, Object varargs, @Cached GetNextVaArgNode getVaArgNode, @Cached CExtNodes.PCallCapiFunction callGetBufferRwNode, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached CApiTransitions.PythonToNativeNode argToSulongNode, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) throws InteropException {
            if (la == 42) {
                Object pybufferPtr = getVaArgNode.execute(varargs);
                this.getbuffer(callGetBufferRwNode, raiseNode, arg, argToSulongNode, pybufferPtr, true);
            } else {
                Object voidPtr = getVaArgNode.execute(varargs);
                int count = this.convertbuffer(callGetBufferRwNode, raiseNode, arg, argToSulongNode, voidPtr);
                if (la == 35) {
                    writeLongNode.write(getVaArgNode.execute(varargs), count);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization(guards={"c == FORMAT_LOWER_S || c == FORMAT_LOWER_Z"})
        static void doCString(int c, int la, Object arg, Object varargs, @Cached GetNextVaArgNode getVaArgNode, @Cached CExtNodes.AsCharPointerNode asCharPointerNode, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached CStructAccess.WriteIntNode writeIntNode, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached StringNodes.StringLenNode stringLenNode, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) throws InteropException, ParseArgumentsException {
            if (la == 42) {
                getVaArgNode.execute(varargs);
                return;
            } else if (la == 35) {
                if (c == 122 && PGuards.isPNone(arg)) {
                    writePointerNode.write(getVaArgNode.execute(varargs), toNativeNode.execute(PythonContext.get(toNativeNode).getNativeNull()));
                    writeIntNode.write(getVaArgNode.execute(varargs), 0);
                    return;
                } else {
                    if (!PGuards.isString(arg)) throw ConvertArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_GOT_P, c == 122 ? "str or None" : "str", arg);
                    writePointerNode.write(getVaArgNode.execute(varargs), asCharPointerNode.execute(arg, true));
                    writeLongNode.write(getVaArgNode.execute(varargs), stringLenNode.execute(arg));
                }
                return;
            } else if (c == 122 && PGuards.isPNone(arg)) {
                writePointerNode.write(getVaArgNode.execute(varargs), toNativeNode.execute(PythonContext.get(toNativeNode).getNativeNull()));
                return;
            } else {
                if (!PGuards.isString(arg)) throw ConvertArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_GOT_P, c == 122 ? "str or None" : "str", arg);
                writePointerNode.write(getVaArgNode.execute(varargs), asCharPointerNode.execute(arg));
            }
        }

        @Specialization(guards={"c == FORMAT_UPPER_O"})
        static void doObject(int c, int la, Object arg, Object varargs, @Bind(value="this") Node inliningTarget, @Cached GetNextVaArgNode getVaArgNode, @Cached ExecuteConverterNode executeConverterNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached CApiTransitions.NativeToPythonNode typeToJavaNode, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) throws InteropException, ParseArgumentsException {
            if (la == 33) {
                Object argValue = getVaArgNode.execute(varargs);
                Object typeObject = typeToJavaNode.execute(argValue);
                assert (PGuards.isClassUncached(typeObject));
                if (!isSubtypeNode.execute(getClassNode.execute(inliningTarget, arg), typeObject)) {
                    raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_OBJ_TYPE_P_GOT_P, typeObject, arg);
                    throw ParseArgumentsException.raise();
                }
                writePointerNode.write(getVaArgNode.execute(varargs), toNativeNode.execute(arg));
            } else if (la == 38) {
                Object converter = getVaArgNode.execute(varargs);
                Object output = getVaArgNode.execute(varargs);
                executeConverterNode.execute(converter, arg, output);
            } else {
                writePointerNode.write(getVaArgNode.execute(varargs), toNativeNode.execute(arg));
            }
        }

        @Specialization(guards={"c == FORMAT_LOWER_W"})
        void doBufferRW(int c, int la, Object arg, Object varargs, @Cached GetNextVaArgNode getVaArgNode, @Cached CExtNodes.PCallCapiFunction callGetBufferRwNode, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached.Shared(value="raiseNode") @Cached CExtNodes.PRaiseNativeNode raiseNode) throws InteropException, ParseArgumentsException {
            if (la != 42) {
                throw ConvertArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_USE_OF_W_FORMAT_CHAR, new Object[0]);
            }
            Object pybufferPtr = getVaArgNode.execute(varargs);
            this.getbuffer(callGetBufferRwNode, raiseNode, arg, toNativeNode, pybufferPtr, false);
        }

        private void getbuffer(CExtNodes.PCallCapiFunction callGetBufferRwNode, CExtNodes.PRaiseNativeNode raiseNode, Object arg, CExtToNativeNode toSulongNode, Object pybufferPtr, boolean readOnly) throws ParseArgumentsException {
            NativeCAPISymbol funSymbol = readOnly ? NativeCAPISymbol.FUN_GET_BUFFER_R : NativeCAPISymbol.FUN_GET_BUFFER_RW;
            Object rc = callGetBufferRwNode.call(PythonContext.get(this).getCApiContext(), funSymbol, toSulongNode.execute(arg), pybufferPtr);
            if (!(rc instanceof Number)) {
                throw ConvertArgNode.raise(raiseNode, PythonBuiltinClassType.SystemError, ErrorMessages.RETURNED_UNEXPECTE_RET_CODE_EXPECTED_INT_BUT_WAS_S, funSymbol, rc.getClass());
            }
            int i = ConvertArgNode.intValue((Number)rc);
            if (i == -1) {
                throw ConvertArgNode.converterr(raiseNode, readOnly ? ErrorMessages.READ_ONLY_BYTELIKE_OBJ : ErrorMessages.READ_WRITE_BYTELIKE_OBJ, arg);
            }
            if (i == -2) {
                throw ConvertArgNode.converterr(raiseNode, ErrorMessages.CONTIGUOUS_BUFFER, arg);
            }
        }

        private static ParseArgumentsException converterr(CExtNodes.PRaiseNativeNode raiseNode, TruffleString msg, Object arg) {
            if (arg == PNone.NONE) {
                throw ConvertArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_S_NOT_NONE, msg);
            }
            throw ConvertArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_S_NOT_P, msg, arg);
        }

        private int convertbuffer(CExtNodes.PCallCapiFunction callConvertbuffer, CExtNodes.PRaiseNativeNode raiseNode, Object arg, CExtToNativeNode toSulong, Object voidPtr) {
            Object rc = callConvertbuffer.call(PythonContext.get(this).getCApiContext(), NativeCAPISymbol.FUN_CONVERTBUFFER, toSulong.execute(arg), voidPtr);
            if (!(rc instanceof Number)) {
                throw CompilerDirectives.shouldNotReachHere((String)"wrong result of internal function");
            }
            int i = ConvertArgNode.intValue((Number)rc);
            if (i == -1) {
                throw ConvertArgNode.converterr(raiseNode, ErrorMessages.READ_WRITE_BYTELIKE_OBJ, arg);
            }
            if (i == -2) {
                throw ConvertArgNode.converterr(raiseNode, ErrorMessages.CONTIGUOUS_BUFFER, arg);
            }
            if (i == -3) {
                throw ConvertArgNode.converterr(raiseNode, ErrorMessages.READ_ONLY_BYTELIKE_OBJ, arg);
            }
            return i;
        }

        @CompilerDirectives.TruffleBoundary
        private static int intValue(Number rc) {
            return rc.intValue();
        }

        private static ParseArgumentsException raise(CExtNodes.PRaiseNativeNode raiseNode, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            CompilerDirectives.transferToInterpreter();
            raiseNode.executeInt(null, 0, errType, format, arguments);
            throw ParseArgumentsException.raise();
        }
    }

    @CompilerDirectives.ValueType
    static final class PositionalArgStack {
        private final PTuple argv;
        private int argnum;
        private final PositionalArgStack prev;

        PositionalArgStack(PTuple argv, PositionalArgStack prev) {
            this.argv = argv;
            this.prev = prev;
        }
    }

    @CompilerDirectives.ValueType
    static final class ParserState {
        private final TruffleString funName;
        private boolean restOptional;
        private boolean restKeywordsOnly;
        private PositionalArgStack v;

        ParserState(TruffleString funName, PositionalArgStack v) {
            this.funName = funName;
            this.restOptional = false;
            this.restKeywordsOnly = false;
            this.v = v;
        }

        void restOptional() {
            this.restOptional = true;
        }

        void restKeywordsOnly() {
            this.restKeywordsOnly = true;
        }

        void open(PositionalArgStack nestedArgs) {
            this.restKeywordsOnly = false;
            this.v = nestedArgs;
        }

        void close() {
            this.restKeywordsOnly = false;
            this.v = this.v.prev;
        }
    }

    static abstract class ConvertSingleArgNode
    extends Node {
        ConvertSingleArgNode() {
        }

        public abstract int execute(ParserState var1, Object var2, TruffleString var3, int var4, int var5, TruffleString[] var6, Object var7, TruffleString.CodePointAtIndexNode var8) throws InteropException;

        private static char charFromPString(PString arg, TruffleString.ReadCharUTF16Node readCharNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
            if (arg.isMaterialized()) {
                return readCharNode.execute((AbstractTruffleString)switchEncodingNode.execute((AbstractTruffleString)arg.getMaterialized(), TruffleString.Encoding.UTF_16), 0);
            }
            if (arg.isNativeCharSequence()) {
                return ConvertSingleArgNode.charFromNativePString(arg);
            }
            throw CompilerDirectives.shouldNotReachHere((String)"PString is neither materialized nor native");
        }

        @CompilerDirectives.TruffleBoundary
        private static char charFromNativePString(PString arg) {
            assert (arg.isNativeCharSequence());
            return arg.getNativeCharSequence().charAt(0);
        }

        private static ParseArgumentsException raise(CExtNodes.PRaiseNativeNode raiseNode, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            CompilerDirectives.transferToInterpreter();
            raiseNode.executeInt(null, 0, errType, format, arguments);
            throw ParseArgumentsException.raise();
        }

        @Specialization
        int doArg(ParserState state, Object kwds, TruffleString format, int formatIdx, int formatLength, TruffleString[] kwdnames, Object varargs, TruffleString.CodePointAtIndexNode codepointAtIndexNode, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode, @Cached SequenceStorageNodes.GetItemDynamicNode getItemNode, @Cached CExtCommonNodes.AsNativeDoubleNode asDoubleNode, @Cached CExtNodes.AsNativeComplexNode asComplexNode, @Cached StringNodes.StringLenNode stringLenNode, @Cached TruffleString.ReadCharUTF16Node readCharNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBytesProfile, @Cached GetArgNode getArgNode, @Cached GetNextVaArgNode getVaArgNode, @Cached GetNextVaArgNode getOutVarNode, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CStructAccess.WriteByteNode writeByteNode, @Cached CStructAccess.WriteI16Node writeI16Node, @Cached CStructAccess.WriteIntNode writeIntNode, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached CStructAccess.WriteFloatNode writeFloatNode, @Cached CStructAccess.WriteDoubleNode writeDoubleNode, @Cached PyObjectIsTrueNode isTrueNode, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached CExtNodes.PRaiseNativeNode raiseNode, @Cached ConvertParArgNode convertParArgNode, @Cached ConvertExtendedArgNode convertExtendedArgNode, @Cached ConvertArgNode convertArgNode) throws InteropException {
            try {
                int c = ConvertSingleArgNode.codePoint(format, formatIdx, codepointAtIndexNode);
                switch (c) {
                    case 66: 
                    case 67: 
                    case 68: 
                    case 72: 
                    case 73: 
                    case 75: 
                    case 76: 
                    case 83: 
                    case 85: 
                    case 89: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 102: 
                    case 104: 
                    case 105: 
                    case 107: 
                    case 108: 
                    case 110: 
                    case 112: {
                        Object arg = getArgNode.execute(state, kwds, kwdnames, state.restKeywordsOnly);
                        Object outVar = getOutVarNode.execute(varargs);
                        if (!CExtParseArgumentsNode.skipOptionalArg(arg, state.restOptional)) {
                            switch (c) {
                                case 83: {
                                    if (isBytesProfile.profileObject(inliningTarget, arg, PythonBuiltinClassType.PBytes)) {
                                        writePointerNode.write(outVar, toNativeNode.execute(arg));
                                        break;
                                    }
                                    throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_NOT_P, "bytes", arg);
                                }
                                case 98: {
                                    long ival = asNativePrimitiveNode.toInt64(arg, true);
                                    if (ival < 0L) {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.OverflowError, ErrorMessages.UNSIGNED_BYTE_INT_LESS_THAN_MIN, new Object[0]);
                                    }
                                    if (ival > 255L) {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.OverflowError, ErrorMessages.UNSIGNED_BYTE_INT_GREATER_THAN_MAX, new Object[0]);
                                    }
                                    writeByteNode.write(outVar, (byte)ival);
                                    break;
                                }
                                case 66: {
                                    writeByteNode.write(outVar, (byte)asNativePrimitiveNode.toInt64(arg, false));
                                    break;
                                }
                                case 104: {
                                    long ival = asNativePrimitiveNode.toInt64(arg, true);
                                    if (ival < -32768L) {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.OverflowError, ErrorMessages.SIGNED_SHORT_INT_LESS_THAN_MIN, new Object[0]);
                                    }
                                    if (ival > 32767L) {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.OverflowError, ErrorMessages.SIGNED_SHORT_INT_GREATER_THAN_MAX, new Object[0]);
                                    }
                                    writeI16Node.write(outVar, (short)ival);
                                    break;
                                }
                                case 72: {
                                    writeI16Node.write(outVar, (short)asNativePrimitiveNode.toInt64(arg, false));
                                    break;
                                }
                                case 105: {
                                    long ival = asNativePrimitiveNode.toInt64(arg, true);
                                    if (ival < Integer.MIN_VALUE) {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.OverflowError, ErrorMessages.SIGNED_INT_LESS_THAN_MIN, new Object[0]);
                                    }
                                    if (ival > Integer.MAX_VALUE) {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.OverflowError, ErrorMessages.SIGNED_INT_GREATER_THAN_MAX, new Object[0]);
                                    }
                                    writeIntNode.write(outVar, (int)ival);
                                    break;
                                }
                                case 73: {
                                    writeIntNode.write(outVar, (int)asNativePrimitiveNode.toInt64(arg, false));
                                    break;
                                }
                                case 76: 
                                case 108: {
                                    writeLongNode.write(outVar, asNativePrimitiveNode.toInt64(arg, true));
                                    break;
                                }
                                case 75: 
                                case 107: {
                                    writeLongNode.write(outVar, asNativePrimitiveNode.toUInt64(arg, false));
                                    break;
                                }
                                case 110: {
                                    if (arg instanceof PythonNativeVoidPtr) {
                                        writePointerNode.write(outVar, ((PythonNativeVoidPtr)arg).getPointerObject());
                                        break;
                                    }
                                    writeLongNode.write(outVar, asNativePrimitiveNode.toInt64(arg, true));
                                    break;
                                }
                                case 99: {
                                    SequenceStorage s = null;
                                    if (arg instanceof PBytes) {
                                        s = ((PBytes)arg).getSequenceStorage();
                                    } else if (arg instanceof PByteArray) {
                                        s = ((PByteArray)arg).getSequenceStorage();
                                    }
                                    if (s != null && s.length() == 1) {
                                        writeByteNode.write(outVar, (byte)((Integer)getItemNode.execute(inliningTarget, s, 0)).intValue());
                                        break;
                                    }
                                    throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_BYTE_STRING_LEGTH1_NOT_P, arg);
                                }
                                case 67: {
                                    char singleChar;
                                    if (!PGuards.isString(arg) || stringLenNode.execute(arg) != 1) {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_UNICODE_CHAR_NOT_P, arg);
                                    }
                                    if (TruffleStringMigrationHelpers.isJavaString(arg)) {
                                        singleChar = ((String)arg).charAt(0);
                                    } else if (arg instanceof TruffleString) {
                                        singleChar = readCharNode.execute((AbstractTruffleString)switchEncodingNode.execute((AbstractTruffleString)((TruffleString)arg), TruffleString.Encoding.UTF_16), 0);
                                    } else if (arg instanceof PString) {
                                        singleChar = ConvertSingleArgNode.charFromPString((PString)arg, readCharNode, switchEncodingNode);
                                    } else {
                                        throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.SystemError, ErrorMessages.UNSUPPORTED_STR_TYPE, arg.getClass());
                                    }
                                    writeIntNode.write(outVar, singleChar);
                                    break;
                                }
                                case 102: {
                                    writeFloatNode.write(outVar, (float)asDoubleNode.executeDouble(arg));
                                    break;
                                }
                                case 100: {
                                    writeDoubleNode.write(outVar, asDoubleNode.executeDouble(arg));
                                    break;
                                }
                                case 68: {
                                    PComplex complex = asComplexNode.execute(arg);
                                    writeDoubleNode.writeArrayElement(outVar, 0L, complex.getReal());
                                    writeDoubleNode.writeArrayElement(outVar, 1L, complex.getImag());
                                    break;
                                }
                                case 112: {
                                    writeIntNode.write(outVar, isTrueNode.execute(null, inliningTarget, arg) ? 1 : 0);
                                    break;
                                }
                                case 89: {
                                    if (isBytesProfile.profileObject(inliningTarget, arg, PythonBuiltinClassType.PByteArray)) {
                                        writePointerNode.write(outVar, toNativeNode.execute(arg));
                                        break;
                                    }
                                    throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_NOT_P, "bytearray", arg);
                                }
                                case 85: {
                                    if (isBytesProfile.profileObject(inliningTarget, arg, PythonBuiltinClassType.PString)) {
                                        writePointerNode.write(outVar, toNativeNode.execute(arg));
                                        break;
                                    }
                                    throw ConvertSingleArgNode.raise(raiseNode, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_NOT_P, "str", arg);
                                }
                                default: {
                                    throw CompilerDirectives.shouldNotReachHere();
                                }
                            }
                        }
                        return formatIdx + 1;
                    }
                    case 101: {
                        int la1 = formatIdx + 1 < formatLength ? ConvertSingleArgNode.codePoint(format, formatIdx + 1, codepointAtIndexNode) : 32;
                        int la2 = formatIdx + 2 < formatLength ? ConvertSingleArgNode.codePoint(format, formatIdx + 2, codepointAtIndexNode) : 32;
                        Object arg = getArgNode.execute(state, kwds, kwdnames, state.restKeywordsOnly);
                        if (CExtParseArgumentsNode.skipOptionalArg(arg, state.restOptional)) {
                            getVaArgNode.execute(varargs);
                            getVaArgNode.execute(varargs);
                            if (la2 == 35) {
                                getVaArgNode.execute(varargs);
                            }
                        } else {
                            convertExtendedArgNode.execute(c, la1, la2, arg, varargs);
                        }
                        return la2 == 35 ? formatIdx + 3 : formatIdx + 2;
                    }
                    case 79: 
                    case 90: 
                    case 115: 
                    case 117: 
                    case 119: 
                    case 121: 
                    case 122: {
                        int la = formatIdx + 1 < formatLength ? ConvertSingleArgNode.codePoint(format, formatIdx + 1, codepointAtIndexNode) : 32;
                        Object arg = getArgNode.execute(state, kwds, kwdnames, state.restKeywordsOnly);
                        if (CExtParseArgumentsNode.skipOptionalArg(arg, state.restOptional)) {
                            getVaArgNode.execute(varargs);
                            if (la == 35 || la == 33 || la == 38) {
                                getVaArgNode.execute(varargs);
                            }
                        } else {
                            convertArgNode.execute(c, la, arg, varargs);
                        }
                        if (la == 35 || la == 33 || la == 38 || la == 42) {
                            return formatIdx + 2;
                        }
                        return formatIdx + 1;
                    }
                    case 40: 
                    case 41: {
                        convertParArgNode.execute(state, kwds, c, kwdnames);
                        return formatIdx + 1;
                    }
                    case 124: {
                        if (state.restOptional) {
                            raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_FORMAT_STRING_PIPE_SPECIFIED_TWICE, c);
                            throw ParseArgumentsException.raise();
                        }
                        state.restOptional();
                        return formatIdx + 1;
                    }
                    case 36: {
                        if (state.restKeywordsOnly) {
                            raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_FORMAT_STRING_PIPE_SPECIFIED_TWICE, c);
                            throw ParseArgumentsException.raise();
                        }
                        state.restKeywordsOnly();
                        return formatIdx + 1;
                    }
                }
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.TypeError, ErrorMessages.UNRECOGNIZED_FORMAT_CHAR, c);
                throw ParseArgumentsException.raise();
            }
            catch (PException e) {
                CompilerDirectives.transferToInterpreter();
                CExtNodesFactory.TransformExceptionToNativeNodeGen.getUncached().execute(null, e);
                throw ParseArgumentsException.raise();
            }
        }

        private static int codePoint(TruffleString format, int formatIdx, TruffleString.CodePointAtIndexNode codepointAtIndexNode) {
            return codepointAtIndexNode.execute((AbstractTruffleString)format, formatIdx, PythonUtils.TS_ENCODING);
        }
    }

    @ImportStatic(value={PGuards.class, PythonUtils.class})
    public static abstract class ParseTupleAndKeywordsNode
    extends Node {
        public abstract int execute(TruffleString var1, Object var2, Object var3, Object var4, Object var5, Object var6);

        @Idempotent
        static int tsLength(TruffleString.CodePointLengthNode lengthNode, TruffleString s) {
            return lengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
        @Specialization(guards={"isDictOrNull(kwds)", "eqNode.execute(cachedFormat, format, TS_ENCODING)", "tsLength(lengthNode, cachedFormat) <= 8"}, limit="5")
        int doSpecial(TruffleString funName, PTuple argv, Object kwds, TruffleString format, Object kwdnames, Object varargs, @Bind(value="this") Node inliningTarget, @Cached(value="format", allowUncached=true) TruffleString cachedFormat, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode codepointAtIndexNode, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CStructAccess.ReadPointerNode read, @Cached CExtNodes.FromCharPointerNode fromPtr, @Cached(value="createConvertArgNodes(cachedFormat, lengthNode)") ConvertSingleArgNode[] convertArgNodes, @Cached HashingStorageNodes.HashingStorageLen kwdsLenNode, @Cached CExtNodes.PRaiseNativeNode raiseNode, @Cached TruffleString.EqualNode eqNode) {
            try {
                PDict kwdsDict = null;
                if (kwds != null && kwdsLenNode.execute(inliningTarget, ((PDict)kwds).getDictStorage()) != 0) {
                    kwdsDict = (PDict)kwds;
                }
                int length = lengthNode.execute((AbstractTruffleString)format, PythonUtils.TS_ENCODING);
                ParserState state = new ParserState(funName, new PositionalArgStack(argv, null));
                TruffleString[] kwdNameStrings = ParseTupleAndKeywordsNode.extractNames(kwdnames, lib, read, fromPtr);
                int i = 0;
                while (i < length) {
                    i = convertArgNodes[i].execute(state, kwdsDict, format, i, length, kwdNameStrings, varargs, codepointAtIndexNode);
                }
                ParseTupleAndKeywordsNode.checkExcessArgs(argv, state, raiseNode);
                return 1;
            }
            catch (ParseArgumentsException | InteropException e) {
                return 0;
            }
        }

        private static TruffleString[] extractNames(Object kwdnames, InteropLibrary lib, CStructAccess.ReadPointerNode read, CExtNodes.FromCharPointerNode fromPtr) {
            Object element;
            if (kwdnames == null || PGuards.isNullOrZero(kwdnames, lib)) {
                return null;
            }
            ArrayList<TruffleString> list = new ArrayList<TruffleString>();
            int i = 0;
            while (!PGuards.isNullOrZero(element = read.readArrayElement(kwdnames, i++), lib)) {
                list.add(fromPtr.execute(element, false));
            }
            return list.toArray(new TruffleString[list.size()]);
        }

        @Specialization(guards={"isDictOrNull(kwds)"}, replaces={"doSpecial"})
        @ReportPolymorphism.Megamorphic
        int doGeneric(TruffleString funName, PTuple argv, Object kwds, TruffleString format, Object kwdnames, Object varargs, @Bind(value="this") Node inliningTarget, @Cached ConvertSingleArgNode convertArgNode, @Cached HashingStorageNodes.HashingStorageLen kwdsLenNode, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode codepointAtIndexNode, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CStructAccess.ReadPointerNode read, @Cached CExtNodes.FromCharPointerNode fromPtr, @Cached CExtNodes.PRaiseNativeNode raiseNode) {
            try {
                PDict kwdsDict = null;
                if (kwds != null && kwdsLenNode.execute(inliningTarget, ((PDict)kwds).getDictStorage()) != 0) {
                    kwdsDict = (PDict)kwds;
                }
                int length = lengthNode.execute((AbstractTruffleString)format, PythonUtils.TS_ENCODING);
                ParserState state = new ParserState(funName, new PositionalArgStack(argv, null));
                TruffleString[] kwdNameStrings = ParseTupleAndKeywordsNode.extractNames(kwdnames, lib, read, fromPtr);
                int i = 0;
                while (i < length) {
                    i = convertArgNode.execute(state, kwdsDict, format, i, length, kwdNameStrings, varargs, codepointAtIndexNode);
                }
                ParseTupleAndKeywordsNode.checkExcessArgs(argv, state, raiseNode);
                return 1;
            }
            catch (ParseArgumentsException | InteropException e) {
                return 0;
            }
        }

        private static void checkExcessArgs(PTuple argv, ParserState state, CExtNodes.PRaiseNativeNode raiseNode) {
            int argvLen = argv.getSequenceStorage().length();
            if (argvLen > state.v.argnum) {
                raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_AT_MOST_D_ARGS_GOT_D, state.v.argnum, argvLen);
                throw ParseArgumentsException.raise();
            }
        }

        @Fallback
        int error(TruffleString funName, Object argv, Object kwds, Object format, Object kwdnames, Object varargs, @Cached CExtNodes.PRaiseNativeNode raiseNode) {
            return raiseNode.raiseIntWithoutFrame(0, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC, new Object[0]);
        }

        static ConvertSingleArgNode[] createConvertArgNodes(TruffleString format, TruffleString.CodePointLengthNode lengthNode) {
            ConvertSingleArgNode[] convertArgNodes = new ConvertSingleArgNode[lengthNode.execute((AbstractTruffleString)format, PythonUtils.TS_ENCODING)];
            for (int i = 0; i < convertArgNodes.length; ++i) {
                convertArgNodes[i] = CExtParseArgumentsNodeFactory.ConvertSingleArgNodeGen.create();
            }
            return convertArgNodes;
        }

        static boolean isDictOrNull(Object object) {
            return object == null || object instanceof PDict;
        }
    }
}

