/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.buffer;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

public abstract class BufferAcquireGenerateUncachedNode
extends PNodeWithContext
implements IndirectCallNode {
    public abstract boolean hasBuffer(Object var1);

    public abstract Object acquireReadonly(VirtualFrame var1, Object var2);

    public abstract Object acquireWritable(VirtualFrame var1, Object var2);

    public abstract PythonBufferAccessLibrary getAccessLib();

    public abstract void release(VirtualFrame var1, Object var2);

    @NeverDefault
    public static BufferAcquireGenerateUncachedNode create(int limit) {
        return new IndirectCallHelperCachedNode(limit);
    }

    public static BufferAcquireGenerateUncachedNode getUncached(int limit) {
        return IndirectCallHelperUncachedNode.INSTANCE;
    }

    static final class IndirectCallHelperCachedNode
    extends BufferAcquireGenerateUncachedNode {
        @Node.Child
        private PythonBufferAcquireLibrary lib;
        @Node.Child
        private PythonBufferAccessLibrary accessLib;
        private final int limit;
        @CompilerDirectives.CompilationFinal
        private Assumption nativeCodeDoesntNeedExceptionState;
        @CompilerDirectives.CompilationFinal
        private Assumption nativeCodeDoesntNeedMyFrame;

        IndirectCallHelperCachedNode(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean hasBuffer(Object receiver) {
            return this.lib.hasBuffer(receiver);
        }

        @Override
        public Object acquireReadonly(VirtualFrame frame, Object receiver) {
            return this.ensureAcquireLib().acquireReadonly(receiver, frame, this.getContext(), this.getLanguage(), this);
        }

        @Override
        public Object acquireWritable(VirtualFrame frame, Object receiver) {
            return this.ensureAcquireLib().acquireWritable(receiver, frame, this.getContext(), this.getLanguage(), this);
        }

        @Override
        public void release(VirtualFrame frame, Object receiver) {
            this.getAccessLib().release(receiver, frame, this.getContext(), this.getLanguage(), this);
        }

        @Override
        public Assumption needNotPassFrameAssumption() {
            if (this.nativeCodeDoesntNeedMyFrame == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nativeCodeDoesntNeedMyFrame = Truffle.getRuntime().createAssumption();
            }
            return this.nativeCodeDoesntNeedMyFrame;
        }

        @Override
        public Assumption needNotPassExceptionAssumption() {
            if (this.nativeCodeDoesntNeedExceptionState == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nativeCodeDoesntNeedExceptionState = Truffle.getRuntime().createAssumption();
            }
            return this.nativeCodeDoesntNeedExceptionState;
        }

        private PythonBufferAcquireLibrary ensureAcquireLib() {
            if (this.lib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lib = (PythonBufferAcquireLibrary)this.insert((Node)((PythonBufferAcquireLibrary)PythonBufferAcquireLibrary.getFactory().createDispatched(this.limit)));
            }
            return this.lib;
        }

        @Override
        public PythonBufferAccessLibrary getAccessLib() {
            if (this.accessLib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.accessLib = (PythonBufferAccessLibrary)this.insert((Node)((PythonBufferAccessLibrary)PythonBufferAccessLibrary.getFactory().createDispatched(this.limit)));
            }
            return this.accessLib;
        }
    }

    static final class IndirectCallHelperUncachedNode
    extends BufferAcquireGenerateUncachedNode {
        private static final IndirectCallHelperUncachedNode INSTANCE = new IndirectCallHelperUncachedNode();

        IndirectCallHelperUncachedNode() {
        }

        @Override
        public boolean hasBuffer(Object receiver) {
            return PythonBufferAcquireLibrary.getUncached().hasBuffer(receiver);
        }

        @Override
        public Object acquireReadonly(VirtualFrame frame, Object receiver) {
            return PythonBufferAcquireLibrary.getUncached().acquireReadonly(receiver);
        }

        @Override
        public Object acquireWritable(VirtualFrame frame, Object receiver) {
            return PythonBufferAcquireLibrary.getUncached().acquireWritable(receiver);
        }

        @Override
        public void release(VirtualFrame frame, Object receiver) {
            PythonBufferAccessLibrary.getUncached().release(receiver);
        }

        @Override
        public PythonBufferAccessLibrary getAccessLib() {
            return PythonBufferAccessLibrary.getUncached();
        }

        @Override
        public Assumption needNotPassFrameAssumption() {
            return Assumption.NEVER_VALID;
        }

        @Override
        public Assumption needNotPassExceptionAssumption() {
            return Assumption.NEVER_VALID;
        }

        @Override
        public boolean calleeNeedsCallerFrame() {
            return true;
        }

        @Override
        public boolean calleeNeedsExceptionState() {
            return true;
        }

        @Override
        public void setCalleeNeedsCallerFrame() {
        }

        @Override
        public void setCalleeNeedsExceptionState() {
        }

        public boolean isAdoptable() {
            return false;
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }
    }
}

