/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObjectFactory;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupInheritedAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.CastToListExpressionNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashSet;

@ExportLibrary(value=InteropLibrary.class)
@ImportStatic(value={SpecialMethodNames.class})
public abstract class PythonAbstractObject
extends DynamicObject
implements TruffleObject,
Comparable<Object> {
    private static final TruffleString T_PRIVATE_PREFIX = PythonUtils.tsLiteral("__");
    private static final int PRIVATE_PREFIX_LENGTH = T_PRIVATE_PREFIX.codePointLengthUncached(PythonUtils.TS_ENCODING);
    private PythonNativeWrapper nativeWrapper;
    protected static final SpecialMethodSlot Iter = SpecialMethodSlot.Iter;
    protected static final SpecialMethodSlot Next = SpecialMethodSlot.Next;
    protected static final SpecialMethodSlot Len = SpecialMethodSlot.Len;
    protected static final Shape ABSTRACT_SHAPE = Shape.newBuilder().build();
    private static final TruffleString T_DATETIME_MODULE_NAME = StringLiterals.T_DATETIME;
    private static final TruffleString T_TIME_MODULE_NAME = StringLiterals.T_TIME;
    private static final TruffleString T_DATE_TYPE = StringLiterals.T_DATE;
    private static final TruffleString T_DATETIME_TYPE = StringLiterals.T_DATETIME;
    private static final TruffleString T_TIME_TYPE = StringLiterals.T_TIME;
    private static final TruffleString T_STRUCT_TIME_TYPE = StringLiterals.T_STRUCT_TIME;
    private static final HiddenKey NEXT_ELEMENT = new HiddenKey("next_element");

    protected PythonAbstractObject(Shape shape) {
        super(shape);
    }

    protected PythonAbstractObject() {
        super(ABSTRACT_SHAPE);
    }

    public final PythonNativeWrapper getNativeWrapper() {
        return this.nativeWrapper;
    }

    public final void setNativeWrapper(PythonNativeWrapper nativeWrapper) {
        assert (this.nativeWrapper == null);
        assert (!CApiGuards.isSpecialSingleton(this));
        this.nativeWrapper = nativeWrapper;
    }

    public final void clearNativeWrapper() {
        this.nativeWrapper = null;
    }

    @ExportMessage
    public void writeMember(String key, Object value, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PInteropSetAttributeNode setAttributeNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrErrorProfile, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, UnknownIdentifierException {
        boolean mustRelease = gil.acquire();
        try {
            setAttributeNode.execute(this, fromJavaStringNode.execute(key, PythonUtils.TS_ENCODING), value);
        }
        catch (PException e) {
            e.expectAttributeError(inliningTarget, attrErrorProfile);
            throw UnknownIdentifierException.create((String)key);
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object readMember(String key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Exclusive @Cached PyObjectLookupAttr lookup, @Cached.Exclusive @Cached GilNode gil) throws UnknownIdentifierException {
        Object value;
        boolean mustRelease = gil.acquire();
        try {
            value = lookup.execute(null, inliningTarget, this, fromJavaStringNode.execute(key, PythonUtils.TS_ENCODING));
        }
        finally {
            gil.release(mustRelease);
        }
        if (value != PNone.NO_VALUE) {
            return value;
        }
        throw UnknownIdentifierException.create((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasArrayElements(@Bind(value="$node") Node inliningTarget, @Cached PySequenceCheckNode check, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached(parameters={"Len"}) LookupCallableSlotInMRONode lookupLen, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = check.execute(inliningTarget, this) && lookupLen.execute(getClassNode.executeCached(this)) != PNone.NO_VALUE;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object readArrayElement(long key, @CachedLibrary(value="this") InteropLibrary interopLib, @Cached.Shared(value="getItemNode") @Cached PInteropSubscriptNode getItemNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            if (interopLib.hasArrayElements((Object)this)) {
                try {
                    Object object = getItemNode.execute(this, key);
                    return object;
                }
                catch (PException e) {
                    throw InvalidArrayIndexException.create((long)key);
                }
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public void writeArrayElement(long key, Object value, @CachedLibrary(value="this") InteropLibrary interopLib, @Cached PInteropSubscriptAssignNode setItemNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            if (interopLib.hasArrayElements((Object)this)) {
                try {
                    setItemNode.execute(this, key, value);
                }
                catch (PException e) {
                    throw InvalidArrayIndexException.create((long)key);
                }
            }
            throw UnsupportedMessageException.create();
        }
        catch (Throwable throwable) {
            gil.release(mustRelease);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeArrayElement(long key, @Bind(value="$node") Node inliningTarget, @CachedLibrary(value="this") InteropLibrary interopLib, @Cached.Exclusive @Cached PInteropDeleteItemNode deleteItemNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, InvalidArrayIndexException {
        block6: {
            boolean mustRelease = gil.acquire();
            try {
                if (interopLib.hasArrayElements((Object)this)) {
                    try {
                        deleteItemNode.execute(inliningTarget, this, key);
                        break block6;
                    }
                    catch (PException e) {
                        throw InvalidArrayIndexException.create((long)key);
                    }
                }
                throw UnsupportedMessageException.create();
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public long getArraySize(@CachedLibrary(value="this") InteropLibrary interopLib, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached PyObjectSizeNode sizeNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        if (!interopLib.hasArrayElements((Object)this)) {
            throw UnsupportedMessageException.create();
        }
        try {
            long len = sizeNode.execute(null, inliningTarget, this);
            if (len >= 0L) {
                long l = len;
                return l;
            }
        }
        finally {
            gil.release(mustRelease);
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementReadable(long idx, @CachedLibrary(value="this") InteropLibrary interopLib, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached PyObjectSizeNode sizeNode, @Cached.Shared(value="getItemNode") @Cached PInteropSubscriptNode getItemNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        if (!interopLib.hasArrayElements((Object)this)) {
            return false;
        }
        try {
            boolean bl = this.isInBounds(sizeNode.execute(null, inliningTarget, this), getItemNode, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementModifiable(long idx, @CachedLibrary(value="this") InteropLibrary interopLib, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached PyObjectSizeNode sizeNode, @Cached.Shared(value="getItemNode") @Cached PInteropSubscriptNode getItemNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        if (!interopLib.hasArrayElements((Object)this)) {
            return false;
        }
        try {
            boolean bl = !(this instanceof PTuple) && !(this instanceof PBytes) && this.isInBounds(sizeNode.execute(null, inliningTarget, this), getItemNode, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementInsertable(long idx, @CachedLibrary(value="this") InteropLibrary interopLib, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached PyObjectSizeNode sizeNode, @Cached.Shared(value="getItemNode") @Cached PInteropSubscriptNode getItemNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        if (!interopLib.hasArrayElements((Object)this)) {
            return false;
        }
        try {
            boolean bl = !(this instanceof PTuple) && !(this instanceof PBytes) && !this.isInBounds(sizeNode.execute(null, inliningTarget, this), getItemNode, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementRemovable(long idx, @CachedLibrary(value="this") InteropLibrary interopLib, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached PyObjectSizeNode sizeNode, @Cached.Shared(value="getItemNode") @Cached PInteropSubscriptNode getItemNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        if (!interopLib.hasArrayElements((Object)this)) {
            return false;
        }
        try {
            boolean bl = !(this instanceof PTuple) && !(this instanceof PBytes) && this.isInBounds(sizeNode.execute(null, inliningTarget, this), getItemNode, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    private boolean isInBounds(int len, PInteropSubscriptNode getItemNode, long idx) {
        if (0L <= idx && idx < (long)len) {
            try {
                getItemNode.execute(this, idx);
                return true;
            }
            catch (PException e) {
                return false;
            }
        }
        return false;
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public boolean isMemberReadable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 1);
    }

    @ExportMessage
    public boolean isMemberModifiable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 8);
    }

    @ExportMessage
    public boolean isMemberInsertable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 64);
    }

    @ExportMessage
    public boolean isMemberInvocable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 32);
    }

    @ExportMessage
    public boolean isMemberRemovable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 16);
    }

    @ExportMessage
    public boolean hasMemberReadSideEffects(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 2);
    }

    @ExportMessage
    public boolean hasMemberWriteSideEffects(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object invokeMember(String member, Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Exclusive @Cached LookupInheritedAttributeNode.Dynamic lookupGetattributeNode, @Cached.Exclusive @Cached CallBinaryMethodNode callGetattributeNode, @Cached.Exclusive @Cached PExecuteNode executeNode2, @Cached.Exclusive @Cached InlinedConditionProfile profileGetattribute, @Cached.Exclusive @Cached InlinedConditionProfile profileMember, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attributeErrorProfile, @Cached.Exclusive @Cached GilNode gil) throws UnknownIdentifierException, UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            Object memberObj;
            try {
                Object attrGetattribute = lookupGetattributeNode.execute(inliningTarget, this, SpecialMethodNames.T___GETATTRIBUTE__);
                if (profileGetattribute.profile(inliningTarget, attrGetattribute == PNone.NO_VALUE)) {
                    throw UnknownIdentifierException.create((String)member);
                }
                memberObj = callGetattributeNode.executeObject(attrGetattribute, this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING));
                if (profileMember.profile(inliningTarget, memberObj == PNone.NO_VALUE)) {
                    throw UnknownIdentifierException.create((String)member);
                }
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, attributeErrorProfile);
                throw UnknownIdentifierException.create((String)member);
            }
            Object object = executeNode2.execute(memberObj, arguments);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public boolean isExecutable(@Bind(value="$node") Node inliningTarget, @Cached PyCallableCheckNode callableCheck) {
        return callableCheck.execute(inliningTarget, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object execute(Object[] arguments, @Cached.Exclusive @Cached PExecuteNode executeNode2, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            Object object = executeNode2.execute(this, arguments);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object getMembers(boolean includeInternal, @Bind(value="$node") Node inliningTarget, @Cached CastToListExpressionNode.CastToListInteropNode castToList, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClass, @Cached PyMappingCheckNode checkMapping, @Cached.Exclusive @Cached PyObjectLookupAttr lookupKeys, @Cached CallNode callKeys, @Cached.Shared(value="getItemNode") @Cached PInteropSubscriptNode getItemNode, @Cached SequenceNodes.LenNode lenNode, @Cached TypeNodes.GetMroNode getMroNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.RegionEqualNode regionEqualNode, @Cached TruffleString.ConcatNode concatNode, @Cached StringNodes.StringMaterializeNode materializeNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object object;
            HashSet<TruffleString> keys = new HashSet<TruffleString>();
            Object klass = getClass.executeCached(this);
            for (PythonAbstractClass o : getMroNode.execute(inliningTarget, klass)) {
                if (!(o instanceof PythonManagedClass)) continue;
                PythonAbstractObject.addKeysFromObject(keys, (PythonManagedClass)o, includeInternal, codePointLengthNode, regionEqualNode);
            }
            if (this instanceof PythonObject) {
                PythonAbstractObject.addKeysFromObject(keys, (PythonObject)this, includeInternal, codePointLengthNode, regionEqualNode);
            }
            if (includeInternal && checkMapping.execute(inliningTarget, this) && (object = lookupKeys.execute(null, inliningTarget, this, SpecialMethodNames.T_KEYS)) != PNone.NO_VALUE) {
                PList mapKeys = castToList.executeWithGlobalState(callKeys.execute(object, new Object[0]));
                int len = lenNode.execute(inliningTarget, mapKeys);
                for (int i = 0; i < len; ++i) {
                    Object key = getItemNode.execute(mapKeys, i);
                    TruffleString tsKey = null;
                    if (key instanceof TruffleString) {
                        tsKey = (TruffleString)key;
                    } else if (TruffleStringMigrationHelpers.isJavaString(key)) {
                        tsKey = PythonUtils.toTruffleStringUncached((String)key);
                    } else if (key instanceof PString) {
                        tsKey = materializeNode.execute(inliningTarget, (PString)key);
                    }
                    if (tsKey == null) continue;
                    keys.add(concatNode.execute((AbstractTruffleString)tsKey, (AbstractTruffleString)StringLiterals.T_LBRACKET, PythonUtils.TS_ENCODING, false));
                }
            }
            Keys keys2 = new Keys(keys.toArray(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY));
            return keys2;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public void removeMember(String member, @Bind(value="$node") Node inliningTarget, @Cached PInteropDeleteAttributeNode deleteAttributeNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrErrorProfile, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, UnknownIdentifierException {
        boolean mustRelease = gil.acquire();
        try {
            deleteAttributeNode.execute(this, member);
        }
        catch (PException e) {
            e.expectAttributeError(inliningTarget, attrErrorProfile);
            throw UnknownIdentifierException.create((String)member);
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isInstantiable(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isTypeNode") @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isTypeNode.execute(inliningTarget, this);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object instantiate(Object[] arguments, @CachedLibrary(value="this") InteropLibrary interopLib, @Cached.Exclusive @Cached PExecuteNode executeNode2, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        if (!interopLib.isInstantiable((Object)this)) {
            throw UnsupportedMessageException.create();
        }
        try {
            Object object = executeNode2.execute(this, arguments);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    private static void addKeysFromObject(HashSet<TruffleString> keys, PythonObject o, boolean includeInternal, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.RegionEqualNode regionEqualNode) {
        PDict dict = GetDictIfExistsNode.getUncached().execute(o);
        HashingStorage dictStorage = dict != null ? dict.getDictStorage() : new DynamicObjectStorage(o);
        HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(dictStorage);
        while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(dictStorage, it)) {
            TruffleString strKey;
            Object key = HashingStorageNodes.HashingStorageIteratorKey.executeUncached(dictStorage, it);
            if (key instanceof TruffleString) {
                strKey = (TruffleString)key;
            } else {
                if (!TruffleStringMigrationHelpers.isJavaString(key)) continue;
                strKey = PythonUtils.toTruffleStringUncached((String)key);
            }
            if (!includeInternal && PythonAbstractObject.startsWithPrivatePrefix(strKey, codePointLengthNode, regionEqualNode)) continue;
            keys.add(strKey);
        }
    }

    private static boolean startsWithPrivatePrefix(TruffleString strKey, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.RegionEqualNode regionEqualNode) {
        int strLen = codePointLengthNode.execute((AbstractTruffleString)strKey, PythonUtils.TS_ENCODING);
        return strLen >= PRIVATE_PREFIX_LENGTH && regionEqualNode.execute((AbstractTruffleString)strKey, 0, (AbstractTruffleString)T_PRIVATE_PREFIX, 0, PRIVATE_PREFIX_LENGTH, PythonUtils.TS_ENCODING);
    }

    private static Object readType(Node inliningTarget, ReadAttributeFromObjectNode readTypeNode, Object module, TruffleString typename, TypeNodes.IsTypeNode isTypeNode) {
        Object type = readTypeNode.execute(module, typename);
        if (isTypeNode.execute(inliningTarget, type)) {
            return type;
        }
        CompilerDirectives.transferToInterpreter();
        throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.PATCHED_DATETIME_CLASS, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isDate(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isTypeNode") @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached.Shared(value="readTypeNode") @Cached ReadAttributeFromObjectNode readTypeNode, @Cached.Shared(value="isSubtypeNode") @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached InlinedConditionProfile dateTimeModuleLoaded, @Cached.Exclusive @Cached InlinedConditionProfile timeModuleLoaded, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object objType = getClassNode.executeCached(this);
            PDict importedModules = PythonContext.get(getClassNode).getSysModules();
            Object module = importedModules.getItem(T_DATETIME_MODULE_NAME);
            if (dateTimeModuleLoaded.profile(inliningTarget, module != null) && (isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATETIME_TYPE, isTypeNode)) || isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATE_TYPE, isTypeNode)))) {
                boolean bl = true;
                return bl;
            }
            module = importedModules.getItem(T_TIME_MODULE_NAME);
            if (timeModuleLoaded.profile(inliningTarget, module != null) && isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_STRUCT_TIME_TYPE, isTypeNode))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public LocalDate asDate(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isTypeNode") @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached.Shared(value="readTypeNode") @Cached ReadAttributeFromObjectNode readTypeNode, @Cached.Shared(value="isSubtypeNode") @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached CastToJavaIntExactNode castToIntNode, @CachedLibrary(value="this") InteropLibrary lib, @Cached.Exclusive @Cached InlinedConditionProfile dateTimeModuleLoaded, @Cached.Exclusive @Cached InlinedConditionProfile timeModuleLoaded, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        Object objType = getClassNode.executeCached(this);
        PDict importedModules = PythonContext.get(getClassNode).getSysModules();
        Object module = importedModules.getItem(T_DATETIME_MODULE_NAME);
        if (dateTimeModuleLoaded.profile(inliningTarget, module != null) && (isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATETIME_TYPE, isTypeNode)) || isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATE_TYPE, isTypeNode)))) {
            try {
                int year = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "year"));
                int month = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "month"));
                int day = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "day"));
                LocalDate localDate = PythonAbstractObject.createLocalDate(year, month, day);
                return localDate;
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                throw UnsupportedMessageException.create();
            }
        }
        module = importedModules.getItem(T_TIME_MODULE_NAME);
        boolean bl = module != null;
        if (timeModuleLoaded.profile(inliningTarget, bl) && isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_STRUCT_TIME_TYPE, isTypeNode))) {
            try {
                int year = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "tm_year"));
                int month = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "tm_mon"));
                int day = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "tm_mday"));
                LocalDate localDate = PythonAbstractObject.createLocalDate(year, month, day);
                return localDate;
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isTime(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isTypeNode") @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached.Shared(value="readTypeNode") @Cached ReadAttributeFromObjectNode readTypeNode, @Cached.Shared(value="isSubtypeNode") @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached InlinedConditionProfile dateTimeModuleLoaded, @Cached.Exclusive @Cached InlinedConditionProfile timeModuleLoaded, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object objType = getClassNode.executeCached(this);
            PDict importedModules = PythonContext.get(getClassNode).getSysModules();
            Object module = importedModules.getItem(T_DATETIME_MODULE_NAME);
            if (dateTimeModuleLoaded.profile(inliningTarget, module != null) && (isSubtype.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATETIME_TYPE, isTypeNode)) || isSubtype.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_TIME_TYPE, isTypeNode)))) {
                boolean bl = true;
                return bl;
            }
            module = importedModules.getItem(T_TIME_MODULE_NAME);
            if (timeModuleLoaded.profile(inliningTarget, module != null) && isSubtype.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_STRUCT_TIME_TYPE, isTypeNode))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public LocalTime asTime(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isTypeNode") @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached.Shared(value="readTypeNode") @Cached ReadAttributeFromObjectNode readTypeNode, @Cached.Shared(value="isSubtypeNode") @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached CastToJavaIntExactNode castToIntNode, @CachedLibrary(value="this") InteropLibrary lib, @Cached.Exclusive @Cached InlinedConditionProfile dateTimeModuleLoaded, @Cached.Exclusive @Cached InlinedConditionProfile timeModuleLoaded, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        Object objType = getClassNode.executeCached(this);
        PDict importedModules = PythonContext.get(getClassNode).getSysModules();
        Object module = importedModules.getItem(T_DATETIME_MODULE_NAME);
        if (dateTimeModuleLoaded.profile(inliningTarget, module != null) && (isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATETIME_TYPE, isTypeNode)) || isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_TIME_TYPE, isTypeNode)))) {
            try {
                int hour = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "hour"));
                int min = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "minute"));
                int sec = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "second"));
                int micro = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "microsecond"));
                LocalTime localTime = PythonAbstractObject.createLocalTime(hour, min, sec, micro);
                return localTime;
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                throw UnsupportedMessageException.create();
            }
        }
        module = importedModules.getItem(T_TIME_MODULE_NAME);
        boolean bl = module != null;
        if (timeModuleLoaded.profile(inliningTarget, bl) && isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_STRUCT_TIME_TYPE, isTypeNode))) {
            try {
                int hour = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "tm_hour"));
                int min = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "tm_min"));
                int sec = castToIntNode.execute(inliningTarget, lib.readMember((Object)this, "tm_sec"));
                LocalTime localTime = PythonAbstractObject.createLocalTime(hour, min, sec, 0);
                return localTime;
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isTimeZone(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isTypeNode") @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached.Shared(value="readTypeNode") @Cached ReadAttributeFromObjectNode readTypeNode, @Cached.Shared(value="isSubtypeNode") @Cached IsSubtypeNode isSubtype, @CachedLibrary(limit="2") InteropLibrary lib, @Cached.Exclusive @Cached InlinedConditionProfile dateTimeModuleLoaded, @Cached.Exclusive @Cached InlinedConditionProfile timeModuleLoaded, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object module;
            PDict importedModules;
            Object objType;
            block22: {
                objType = getClassNode.executeCached(this);
                importedModules = PythonContext.get(getClassNode).getSysModules();
                module = importedModules.getItem(T_DATETIME_MODULE_NAME);
                if (dateTimeModuleLoaded.profile(inliningTarget, module != null)) {
                    Object delta2;
                    Object tzinfo;
                    if (isSubtype.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATETIME_TYPE, isTypeNode))) {
                        try {
                            tzinfo = lib.readMember((Object)this, "tzinfo");
                            if (tzinfo != PNone.NONE && (delta2 = lib.invokeMember(tzinfo, "utcoffset", new Object[]{this})) != PNone.NONE) {
                                boolean bl = true;
                                return bl;
                            }
                            break block22;
                        }
                        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
                            boolean delta2 = false;
                            return delta2;
                        }
                    }
                    if (isSubtype.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_TIME_TYPE, isTypeNode))) {
                        try {
                            tzinfo = lib.readMember((Object)this, "tzinfo");
                            if (tzinfo != PNone.NONE && (delta2 = lib.invokeMember(tzinfo, "utcoffset", new Object[]{PNone.NONE})) != PNone.NONE) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            if (timeModuleLoaded.profile(inliningTarget, (module = importedModules.getItem(T_TIME_MODULE_NAME)) != null) && isSubtype.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_STRUCT_TIME_TYPE, isTypeNode))) {
                try {
                    Object tm_zone = lib.readMember((Object)this, "tm_zone");
                    if (tm_zone != PNone.NONE) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public ZoneId asTimeZone(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isTypeNode") @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached.Shared(value="readTypeNode") @Cached ReadAttributeFromObjectNode readTypeNode, @Cached.Shared(value="isSubtypeNode") @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached CastToJavaIntExactNode castToIntNode, @Cached.Exclusive @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Exclusive @Cached InlinedConditionProfile dateTimeModuleLoaded, @Cached.Exclusive @Cached InlinedConditionProfile timeModuleLoaded, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            block24: {
                Object module;
                PDict importedModules;
                Object objType;
                block23: {
                    if (!lib.isTimeZone((Object)this)) {
                        throw UnsupportedMessageException.create();
                    }
                    objType = getClassNode.executeCached(this);
                    importedModules = PythonContext.get(getClassNode).getSysModules();
                    module = importedModules.getItem(T_DATETIME_MODULE_NAME);
                    if (dateTimeModuleLoaded.profile(inliningTarget, module != null)) {
                        Object delta;
                        Object tzinfo;
                        if (isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_DATETIME_TYPE, isTypeNode))) {
                            try {
                                tzinfo = lib.readMember((Object)this, "tzinfo");
                                if (tzinfo != PNone.NONE && (delta = lib.invokeMember(tzinfo, "utcoffset", new Object[]{this})) != PNone.NONE) {
                                    int seconds = castToIntNode.execute(inliningTarget, lib.readMember(delta, "seconds"));
                                    ZoneId zoneId = PythonAbstractObject.createZoneId(seconds);
                                    return zoneId;
                                }
                                break block23;
                            }
                            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
                                throw UnsupportedMessageException.create();
                            }
                        }
                        if (isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_TIME_TYPE, isTypeNode))) {
                            try {
                                tzinfo = lib.readMember((Object)this, "tzinfo");
                                if (tzinfo != PNone.NONE && (delta = lib.invokeMember(tzinfo, "utcoffset", new Object[]{PNone.NONE})) != PNone.NONE) {
                                    int seconds = castToIntNode.execute(inliningTarget, lib.readMember(delta, "seconds"));
                                    ZoneId zoneId = PythonAbstractObject.createZoneId(seconds);
                                    return zoneId;
                                }
                            }
                            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
                                throw UnsupportedMessageException.create();
                            }
                        }
                    }
                }
                if (timeModuleLoaded.profile(inliningTarget, (module = importedModules.getItem(T_TIME_MODULE_NAME)) != null) && isSubtypeNode.execute(objType, PythonAbstractObject.readType(inliningTarget, readTypeNode, module, T_STRUCT_TIME_TYPE, isTypeNode))) {
                    Object tm_zone;
                    block25: {
                        try {
                            tm_zone = lib.readMember((Object)this, "tm_zone");
                            if (tm_zone == PNone.NONE) break block24;
                            Object tm_gmtoffset = lib.readMember((Object)this, "tm_gmtoff");
                            if (tm_gmtoffset == PNone.NONE) break block25;
                            int seconds = castToIntNode.execute(inliningTarget, tm_gmtoffset);
                            ZoneId zoneId = PythonAbstractObject.createZoneId(seconds);
                            return zoneId;
                        }
                        catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                            throw UnsupportedMessageException.create();
                        }
                    }
                    if (tm_zone instanceof TruffleString) {
                        ZoneId zoneId = PythonAbstractObject.createZoneId(toJavaStringNode.execute((AbstractTruffleString)((TruffleString)tm_zone)));
                        return zoneId;
                    }
                    if (TruffleStringMigrationHelpers.isJavaString(tm_zone)) {
                        ZoneId zoneId = PythonAbstractObject.createZoneId((String)tm_zone);
                        return zoneId;
                    }
                }
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static ZoneId createZoneId(int utcDeltaInSeconds) {
        return ZoneId.ofOffset("UTC", ZoneOffset.ofTotalSeconds(utcDeltaInSeconds));
    }

    @CompilerDirectives.TruffleBoundary
    private static ZoneId createZoneId(String zone) {
        return ZoneId.of(zone);
    }

    @CompilerDirectives.TruffleBoundary
    private static LocalTime createLocalTime(int hour, int min, int sec, int micro) {
        return LocalTime.of(hour, min, sec, micro * 1000);
    }

    @CompilerDirectives.TruffleBoundary
    private static LocalDate createLocalDate(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    public String toString() {
        return "<an abstract python object>";
    }

    @ExportMessage
    public boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    public Class<? extends TruffleLanguage<?>> getLanguage() {
        return PythonLanguage.class;
    }

    @CompilerDirectives.TruffleBoundary
    final TruffleString toStringBoundary() {
        return PythonUtils.toTruffleStringUncached(this.toString());
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object getMetaObject(@Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClass, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object object = getClass.executeCached(this);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public int identityHashCode(@Bind(value="$node") Node inliningTarget, @Cached ObjectNodes.GetIdentityHashNode getIdentityHashNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int n = getIdentityHashNode.execute(inliningTarget, this);
            return n;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int systemHashCode(Object value) {
        return System.identityHashCode(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String systemHashCodeAsHexString(Object value) {
        return Integer.toHexString(System.identityHashCode(value));
    }

    @CompilerDirectives.TruffleBoundary
    public static int objectHashCode(Object value) {
        return value.hashCode();
    }

    @CompilerDirectives.TruffleBoundary
    public static String objectHashCodeAsHexString(Object value) {
        return Integer.toHexString(value.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public TriState isIdenticalOrUndefined(Object otherInterop, @Cached PForeignToPTypeNode convert, @Cached.Exclusive @CachedLibrary(limit="3") InteropLibrary otherLib, @Cached IsNode isNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object other = convert.executeConvert(otherInterop);
            if (this == other) {
                TriState triState = TriState.TRUE;
                return triState;
            }
            if (otherLib.hasIdentity(other)) {
                TriState triState = isNode.execute(this, other) ? TriState.TRUE : TriState.FALSE;
                return triState;
            }
            TriState triState = TriState.UNDEFINED;
            return triState;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public boolean hasIterator(@Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter) {
        return !(lookupIter.execute(getClassNode.executeCached(this)) instanceof PNone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object getIterator(@CachedLibrary(value="this") InteropLibrary lib, @Bind(value="$node") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        if (lib.hasIterator((Object)this)) {
            boolean mustRelease = gil.acquire();
            try {
                Object object = getIter.execute(null, inliningTarget, this);
                return object;
            }
            finally {
                gil.release(mustRelease);
            }
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean isIterator(@Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached(parameters={"Next"}) LookupCallableSlotInMRONode lookupNext) {
        return lookupNext.execute(getClassNode.executeCached(this)) != PNone.NO_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasIteratorNextElement(@Bind(value="$node") Node inliningTarget, @CachedLibrary(value="this") InteropLibrary ilib, @Cached.Shared(value="dylib") @CachedLibrary(limit="2") DynamicObjectLibrary dylib, @Cached GetNextNode getNextNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionProfile, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        if (ilib.isIterator((Object)this)) {
            Object nextElement = dylib.getOrDefault((DynamicObject)this, (Object)NEXT_ELEMENT, null);
            if (nextElement != null) {
                return true;
            }
            boolean mustRelease = gil.acquire();
            try {
                nextElement = getNextNode.execute(null, this);
                dylib.put((DynamicObject)this, (Object)NEXT_ELEMENT, nextElement);
                boolean bl = true;
                return bl;
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopIteration, exceptionProfile);
                boolean bl = false;
                return bl;
            }
            finally {
                gil.release(mustRelease);
            }
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public Object getIteratorNextElement(@CachedLibrary(value="this") InteropLibrary ilib, @Cached.Shared(value="dylib") @CachedLibrary(limit="2") DynamicObjectLibrary dylib) throws StopIterationException, UnsupportedMessageException {
        if (ilib.hasIteratorNextElement((Object)this)) {
            Object nextElement = dylib.getOrDefault((DynamicObject)this, (Object)NEXT_ELEMENT, null);
            dylib.put((DynamicObject)this, (Object)NEXT_ELEMENT, null);
            return nextElement;
        }
        throw StopIterationException.create();
    }

    @GenerateUncached
    public static abstract class PInteropSetAttributeNode
    extends Node {
        public abstract void execute(Object var1, TruffleString var2, Object var3) throws UnsupportedMessageException, UnknownIdentifierException;

        @Specialization
        public static void doSpecialObject(PythonAbstractObject primary, TruffleString attrName, Object value, @Bind(value="this") Node inliningTarget, @Cached PForeignToPTypeNode convert, @Cached LookupInheritedAttributeNode.Dynamic lookupSetAttrNode, @Cached CallTernaryMethodNode callSetAttrNode, @Cached InlinedConditionProfile profile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrErrorProfile) throws UnsupportedMessageException, UnknownIdentifierException {
            Object attrSetattr = lookupSetAttrNode.execute(inliningTarget, primary, SpecialMethodNames.T___SETATTR__);
            if (profile.profile(inliningTarget, attrSetattr != PNone.NO_VALUE)) {
                try {
                    callSetAttrNode.execute(null, attrSetattr, primary, attrName, convert.executeConvert(value));
                }
                catch (PException e) {
                    e.expectAttributeError(inliningTarget, attrErrorProfile);
                    throw UnknownIdentifierException.create((String)attrName.toJavaStringUncached());
                }
            } else {
                throw UnsupportedMessageException.create();
            }
        }

        public static PInteropSetAttributeNode getUncached() {
            return PythonAbstractObjectFactory.PInteropSetAttributeNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @ImportStatic(value={SpecialMethodSlot.class})
    public static abstract class PInteropSubscriptNode
    extends Node {
        public abstract Object execute(Object var1, Object var2);

        @Specialization
        static Object doSpecialObject(Object primary, Object index, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(parameters={"GetItem"}) LookupCallableSlotInMRONode lookupInMRONode, @Cached CallBinaryMethodNode callGetItemNode, @Cached PRaiseNode raiseNode, @Cached InlinedConditionProfile profile) {
            Object attrGetItem = lookupInMRONode.execute(getClassNode.execute(inliningTarget, primary));
            if (profile.profile(inliningTarget, attrGetItem == PNone.NO_VALUE)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_SUBSCRIPTABLE, primary);
            }
            return callGetItemNode.executeObject(attrGetItem, primary, index);
        }

        public static PInteropSubscriptNode getUncached() {
            return PythonAbstractObjectFactory.PInteropSubscriptNodeGen.getUncached();
        }
    }

    @GenerateUncached
    public static abstract class PInteropSubscriptAssignNode
    extends Node {
        public abstract void execute(PythonAbstractObject var1, Object var2, Object var3) throws UnsupportedMessageException;

        @Specialization
        static void doSpecialObject(PythonAbstractObject primary, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached PForeignToPTypeNode convert, @Cached PInteropGetAttributeNode getAttributeNode, @Cached CallBinaryMethodNode callSetItemNode, @Cached InlinedConditionProfile profile) throws UnsupportedMessageException {
            Object attrSetitem = getAttributeNode.execute(inliningTarget, primary, SpecialMethodNames.T___SETITEM__);
            if (!profile.profile(inliningTarget, attrSetitem != PNone.NO_VALUE)) {
                throw UnsupportedMessageException.create();
            }
            callSetItemNode.executeObject(attrSetitem, key, convert.executeConvert(value));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PInteropDeleteItemNode
    extends Node {
        public abstract void execute(Node var1, Object var2, Object var3) throws UnsupportedMessageException;

        @Specialization
        public static void doSpecialObject(Node inliningTarget, PythonAbstractObject primary, Object key, @Cached LookupInheritedAttributeNode.Dynamic lookupSetAttrNode, @Cached(inline=false) CallBinaryMethodNode callSetAttrNode, @Cached InlinedConditionProfile profile) throws UnsupportedMessageException {
            Object attrDelattr = lookupSetAttrNode.execute(inliningTarget, primary, SpecialMethodNames.T___DELITEM__);
            if (!profile.profile(inliningTarget, attrDelattr != PNone.NO_VALUE)) {
                throw UnsupportedMessageException.create();
            }
            callSetAttrNode.executeObject(attrDelattr, primary, key);
        }
    }

    @GenerateUncached
    public static abstract class PKeyInfoNode
    extends Node {
        private static final int READABLE = 1;
        private static final int READ_SIDE_EFFECTS = 2;
        private static final int WRITE_SIDE_EFFECTS = 4;
        private static final int MODIFIABLE = 8;
        private static final int REMOVABLE = 16;
        private static final int INVOCABLE = 32;
        private static final int INSERTABLE = 64;

        public abstract boolean execute(Object var1, TruffleString var2, int var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean access(Object object, TruffleString attrKeyName, int type, @Bind(value="this") Node inliningTarget, @Cached(value="createForceType()") ReadAttributeFromObjectNode readTypeAttrNode, @Cached ReadAttributeFromObjectNode readObjectAttrNode, @Cached PyCallableCheckNode callableCheck, @Cached LookupInheritedAttributeNode.Dynamic getGetNode, @Cached LookupInheritedAttributeNode.Dynamic getSetNode, @Cached LookupInheritedAttributeNode.Dynamic getDeleteNode, @Cached GetClassNode getClassNode, @Cached IsImmutable isImmutable, @Cached TypeNodes.GetMroNode getMroNode, @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                Object owner = object;
                Object attr = PNone.NO_VALUE;
                Object klass = getClassNode.execute(inliningTarget, object);
                for (PythonAbstractClass c : getMroNode.execute(inliningTarget, klass)) {
                    attr = readTypeAttrNode.execute(c, attrKeyName);
                    if (attr == PNone.NO_VALUE) continue;
                    owner = c;
                    break;
                }
                if (attr == PNone.NO_VALUE) {
                    attr = readObjectAttrNode.execute(owner, attrKeyName);
                }
                switch (type) {
                    case 1: {
                        boolean bl = attr != PNone.NO_VALUE;
                        return bl;
                    }
                    case 64: {
                        boolean bl = attr == PNone.NO_VALUE && !isImmutable.execute(inliningTarget, object);
                        return bl;
                    }
                    case 16: {
                        boolean bl = attr != PNone.NO_VALUE && !isImmutable.execute(inliningTarget, owner);
                        return bl;
                    }
                    case 8: {
                        if (attr != PNone.NO_VALUE) {
                            if (owner == object) {
                                boolean bl = !isImmutable.execute(inliningTarget, owner);
                                return bl;
                            }
                            if (getSetNode.execute(inliningTarget, attr, SpecialMethodNames.T___SET__) == PNone.NO_VALUE) {
                                boolean bl = !isImmutable.execute(inliningTarget, object);
                                return bl;
                            }
                            if (getSetNode.execute(inliningTarget, attr, SpecialMethodNames.T___SET__) != PNone.NO_VALUE) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 32: {
                        if (attr != PNone.NO_VALUE) {
                            if (owner != object) {
                                if (attr instanceof PFunction || attr instanceof PBuiltinFunction) {
                                    boolean bl = true;
                                    return bl;
                                }
                                if (getGetNode.execute(inliningTarget, attr, SpecialMethodNames.T___GET__) != PNone.NO_VALUE) {
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            boolean bl = callableCheck.execute(inliningTarget, attr);
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 2: {
                        if (attr != PNone.NO_VALUE && owner != object && !(attr instanceof PFunction) && !(attr instanceof PBuiltinFunction)) {
                            boolean bl = getGetNode.execute(inliningTarget, attr, SpecialMethodNames.T___GET__) != PNone.NO_VALUE;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 4: {
                        if (attr != PNone.NO_VALUE && owner != object && !(attr instanceof PFunction) && !(attr instanceof PBuiltinFunction)) {
                            boolean bl = getSetNode.execute(inliningTarget, attr, SpecialMethodNames.T___SET__) != PNone.NO_VALUE || getDeleteNode.execute(inliningTarget, attr, SpecialMethodNames.T___DELETE__) != PNone.NO_VALUE;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    @GenerateUncached
    @ReportPolymorphism
    public static abstract class PExecuteNode
    extends Node {
        public abstract Object execute(Object var1, Object[] var2) throws UnsupportedMessageException;

        @Specialization(guards={"isBuiltinFunctionOrMethod(receiver)"})
        Object doVarargsBuiltinMethod(Object receiver, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached CallVarargsMethodNode callVarargsMethodNode, @Cached.Exclusive @Cached ArgumentsFromForeignNode convertArgsNode) {
            Object[] convertedArgs = convertArgsNode.execute(inliningTarget, arguments);
            return callVarargsMethodNode.execute(null, receiver, convertedArgs, PKeyword.EMPTY_KEYWORDS);
        }

        @Specialization(replaces={"doVarargsBuiltinMethod"})
        static Object doExecute(Object receiver, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Cached.Exclusive @Cached CallNode callNode, @Cached.Exclusive @Cached ArgumentsFromForeignNode convertArgsNode) throws UnsupportedMessageException {
            if (!callableCheck.execute(inliningTarget, receiver)) {
                throw UnsupportedMessageException.create();
            }
            Object[] convertedArgs = convertArgsNode.execute(inliningTarget, arguments);
            return callNode.execute((Frame)null, receiver, convertedArgs, PKeyword.EMPTY_KEYWORDS);
        }

        static boolean isBuiltinFunctionOrMethod(Object object) {
            return object instanceof PBuiltinMethod || object instanceof PBuiltinFunction;
        }

        public static PExecuteNode getUncached() {
            return PythonAbstractObjectFactory.PExecuteNodeGen.getUncached();
        }

        public Node copy() {
            return PythonAbstractObjectFactory.PExecuteNodeGen.create();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class Keys
    implements TruffleObject {
        private final Object[] keys;

        public Keys(Object[] keys) {
            this.keys = keys;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            try {
                return this.keys[(int)index];
            }
            catch (IndexOutOfBoundsException e) {
                CompilerDirectives.transferToInterpreter();
                throw InvalidArrayIndexException.create((long)index);
            }
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        long getArraySize(@Cached.Exclusive @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                long l = this.keys.length;
                return l;
            }
            finally {
                gil.release(mustRelease);
            }
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.keys.length;
        }
    }

    @GenerateUncached
    public static abstract class PInteropDeleteAttributeNode
    extends Node {
        public abstract void execute(Object var1, String var2) throws UnsupportedMessageException, UnknownIdentifierException;

        @Specialization
        public void doSpecialObject(PythonAbstractObject primary, String attrName, @Bind(value="this") Node inliningTarget, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached LookupInheritedAttributeNode.Dynamic lookupSetAttrNode, @Cached CallBinaryMethodNode callSetAttrNode, @Cached InlinedConditionProfile profile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrErrorProfile) throws UnsupportedMessageException, UnknownIdentifierException {
            Object attrDelattr = lookupSetAttrNode.execute(inliningTarget, primary, SpecialMethodNames.T___DELATTR__);
            if (profile.profile(inliningTarget, attrDelattr != PNone.NO_VALUE)) {
                try {
                    callSetAttrNode.executeObject(attrDelattr, primary, fromJavaStringNode.execute(attrName, PythonUtils.TS_ENCODING));
                }
                catch (PException e) {
                    e.expectAttributeError(inliningTarget, attrErrorProfile);
                    throw UnknownIdentifierException.create((String)attrName);
                }
            } else {
                throw UnsupportedMessageException.create();
            }
        }

        public static PInteropDeleteAttributeNode getUncached() {
            return PythonAbstractObjectFactory.PInteropDeleteAttributeNodeGen.getUncached();
        }
    }

    @ExportMessage
    public static class ToDisplayString {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"allowSideEffects"})
        public static TruffleString doSideEffecting(PythonAbstractObject receiver, boolean allowSideEffects, @Bind(value="$node") Node inliningTarget, @Cached ToDisplaySideEffectingNode toDisplayCallNode, @Cached.Exclusive @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                TruffleString truffleString = toDisplayCallNode.execute(inliningTarget, receiver);
                return truffleString;
            }
            finally {
                gil.release(mustRelease);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!allowSideEffects"})
        public static TruffleString doNonSideEffecting(PythonAbstractObject receiver, boolean allowSideEffects, @Cached.Exclusive @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                TruffleString truffleString = receiver.toStringBoundary();
                return truffleString;
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ToDisplaySideEffectingNode
    extends Node {
        public abstract TruffleString execute(Node var1, PythonAbstractObject var2);

        @Specialization
        public static TruffleString doDefault(Node inliningTarget, PythonAbstractObject receiver, @Cached(inline=false) ReadAttributeFromObjectNode readStr, @Cached(inline=false) CallNode callNode, @Cached CastToTruffleStringNode castStr, @Cached InlinedConditionProfile toStringUsed) {
            PythonContext context = PythonContext.get(inliningTarget);
            TruffleString names = context.getOption(PythonOptions.UseReprForPrintString) != false ? BuiltinNames.T_REPR : BuiltinNames.T_STR;
            TruffleString result = null;
            PythonModule builtins = context.getBuiltins();
            if (toStringUsed.profile(inliningTarget, builtins != null)) {
                Object toStrAttr = readStr.execute(builtins, names);
                try {
                    result = castStr.execute(inliningTarget, callNode.execute(toStrAttr, receiver));
                }
                catch (CannotCastException cannotCastException) {
                    // empty catch block
                }
            }
            if (toStringUsed.profile(inliningTarget, result != null)) {
                return result;
            }
            return receiver.toStringBoundary();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PInteropGetAttributeNode
    extends Node {
        public abstract Object execute(Node var1, Object var2, Object var3);

        public static Object executeUncached(Object object, Object attrName) {
            return PythonAbstractObjectFactory.PInteropGetAttributeNodeGen.getUncached().execute(null, object, attrName);
        }

        @Specialization(limit="2")
        static Object doIt(Node inliningTarget, Object object, Object attrName, @CachedLibrary(value="attrName") InteropLibrary libAttrName, @Cached PRaiseNode.Lazy raiseNode, @Cached LookupInheritedAttributeNode.Dynamic lookupGetattributeNode, @Cached(inline=false) CallBinaryMethodNode callGetattributeNode, @Cached LookupInheritedAttributeNode.Dynamic lookupGetattrNode, @Cached(inline=false) CallBinaryMethodNode callGetattrNode, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached InlinedConditionProfile hasGetattrProfile) {
            TruffleString attrNameStr;
            if (!libAttrName.isString(attrName)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, attrName);
            }
            try {
                attrNameStr = switchEncodingNode.execute((AbstractTruffleString)libAttrName.asTruffleString(attrName), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("should not be reached");
            }
            try {
                Object attrGetattribute = lookupGetattributeNode.execute(inliningTarget, object, SpecialMethodNames.T___GETATTRIBUTE__);
                return callGetattributeNode.executeObject(attrGetattribute, object, attrNameStr);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonBuiltinClassType.AttributeError, isBuiltinClassProfile);
                Object attrGetattr = lookupGetattrNode.execute(inliningTarget, object, SpecialMethodNames.T___GETATTR__);
                if (hasGetattrProfile.profile(inliningTarget, attrGetattr != PNone.NO_VALUE)) {
                    return callGetattrNode.executeObject(attrGetattr, object, attrNameStr);
                }
                throw pe;
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ArgumentsFromForeignNode
    extends Node {
        public abstract Object[] execute(Node var1, Object[] var2);

        @Specialization(guards={"arguments.length == cachedLen", "cachedLen < 6"}, limit="3")
        @ExplodeLoop
        static Object[] cached(Object[] arguments, @Cached.Shared @Cached(inline=false) PForeignToPTypeNode fromForeign, @Cached(value="arguments.length") int cachedLen) {
            Object[] convertedArgs = new Object[cachedLen];
            for (int i = 0; i < cachedLen; ++i) {
                convertedArgs[i] = fromForeign.executeConvert(arguments[i]);
            }
            return convertedArgs;
        }

        @Specialization(replaces={"cached"})
        static Object[] generic(Object[] arguments, @Cached.Shared @Cached(inline=false) PForeignToPTypeNode fromForeign) {
            Object[] convertedArgs = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                convertedArgs[i] = fromForeign.executeConvert(arguments[i]);
            }
            return convertedArgs;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsImmutable
    extends Node {
        public abstract boolean execute(Node var1, Object var2);

        @Specialization
        public static boolean isImmutable(Node inliningTarget, Object object, @Cached GetClassNode getClassNode) {
            if (object instanceof PythonBuiltinClass || object instanceof PythonBuiltinObject || PGuards.isNativeClass(object) || PGuards.isNativeObject(object)) {
                return true;
            }
            if (object instanceof PythonClass || object instanceof PythonModule) {
                return false;
            }
            Object klass = getClassNode.execute(inliningTarget, object);
            return klass instanceof PythonBuiltinClassType || klass instanceof PythonBuiltinClass || PGuards.isNativeClass(object);
        }
    }
}

