/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteDecodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalDecoderBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MultibyteStreamReader})
public final class MultibyteStreamReaderBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultibyteStreamWriterBuiltinsFactory.getFactories();
    }

    @Builtin(name="stream", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StreamMemberNode
    extends PythonUnaryBuiltinNode {
        StreamMemberNode() {
        }

        @Specialization
        Object stream(MultibyteStreamReaderObject self) {
            return self.stream;
        }
    }

    @Builtin(name="reset", minNumOfPositionalArgs=1, parameterNames={"$self"}, doc="reset($self, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class ResetNode
    extends PythonUnaryBuiltinNode {
        ResetNode() {
        }

        @Specialization
        static Object reset(MultibyteStreamReaderObject self) {
            self.codec.decreset(self.state);
            self.pendingsize = 0;
            return PNone.NONE;
        }
    }

    @Builtin(name="readlines", minNumOfPositionalArgs=1, parameterNames={"$self", "sizehintobj"}, doc="readlines($self, sizehintobj=None, /)\n--\n\n")
    @ArgumentClinic(name="sizehintobj", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlinesNode
    extends PythonBinaryClinicBuiltinNode {
        private static final TruffleString READ = PythonUtils.tsLiteral("read");

        ReadlinesNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteStreamReaderBuiltinsClinicProviders.ReadlinesNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object readlines(VirtualFrame frame, MultibyteStreamReaderObject self, long sizehint, @Cached StringBuiltins.SplitLinesNode splitLinesNode, @Cached IReadNode iReadNode) {
            TruffleString r = iReadNode.execute(frame, self, READ, sizehint);
            return splitLinesNode.execute(frame, r, true);
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "sizeobj"}, doc="readline($self, sizeobj=None, /)\n--\n\n")
    @ArgumentClinic(name="sizeobj", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends PythonTernaryClinicBuiltinNode {
        private static final TruffleString READLINE = PythonUtils.tsLiteral("readline");

        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteStreamReaderBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object readline(VirtualFrame frame, MultibyteStreamReaderObject self, long size, @Cached IReadNode iReadNode) {
            return iReadNode.execute(frame, self, READLINE, size);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "sizeobj"}, doc="read($self, sizeobj=None, /)\n--\n\n")
    @ArgumentClinic(name="sizeobj", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonTernaryClinicBuiltinNode {
        private static final TruffleString READ = PythonUtils.tsLiteral("read");

        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteStreamReaderBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object read(VirtualFrame frame, MultibyteStreamReaderObject self, long size, @Cached IReadNode iReadNode) {
            return iReadNode.execute(frame, self, READ, size);
        }
    }

    @GenerateInline(value=false)
    static abstract class IReadNode
    extends PNodeWithContext {
        IReadNode() {
        }

        abstract TruffleString execute(VirtualFrame var1, MultibyteStreamReaderObject var2, TruffleString var3, long var4);

        @Specialization
        TruffleString iread(VirtualFrame frame, MultibyteStreamReaderObject self, TruffleString method, long sizehint, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached GetClassNode getClassNode, @Cached PyBytesCheckNode bytesCheckNode, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached MultibyteCodecUtil.DecodeErrorNode decodeErrorNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (sizehint == 0L) {
                return StringLiterals.T_EMPTY_STRING;
            }
            MultibyteDecodeBuffer buf = null;
            while (true) {
                Object crestType;
                Object cres;
                if (!((cres = sizehint < 0L ? callMethod.execute((Frame)frame, inliningTarget, self.stream, method, new Object[0]) : callMethod.execute((Frame)frame, inliningTarget, self.stream, method, sizehint)) instanceof PBytes) && !bytesCheckNode.execute(inliningTarget, crestType = getClassNode.execute(inliningTarget, cres))) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.STREAM_FUNCTION_RETURNED_A_NON_BYTES_OBJECT_S, getNameNode.execute(inliningTarget, cres));
                }
                byte[] cresBytes = toBytesNode.execute(frame, cres);
                int cresBytesLen = cresBytes.length;
                boolean endoffile = cresBytesLen == 0;
                int rsize = cresBytesLen;
                if (self.pendingsize > 0) {
                    byte[] ctr = new byte[rsize += self.pendingsize];
                    PythonUtils.arraycopy(self.pending, 0, ctr, 0, self.pendingsize);
                    PythonUtils.arraycopy(cresBytes, 0, ctr, self.pendingsize, cresBytesLen);
                    cresBytes = ctr;
                    self.pendingsize = 0;
                }
                if (buf == null) {
                    buf = new MultibyteDecodeBuffer(cresBytes);
                } else {
                    buf.replaceInbuf(cresBytes);
                }
                if (rsize > 0) {
                    MultibyteIncrementalDecoderBuiltins.DecodeNode.decoderFeedBuffer(frame, self, buf, decodeErrorNode, raiseNode.get(inliningTarget));
                }
                if ((endoffile || sizehint < 0L) && !buf.isFull()) {
                    decodeErrorNode.execute(frame, self.codec, buf, self.errors, -2);
                }
                if (!buf.isFull()) {
                    MultibyteIncrementalDecoderBuiltins.DecodeNode.decoderAppendPending(self, buf, raiseNode.get(inliningTarget));
                }
                if (sizehint < 0L || buf.getOutpos() != 0 || rsize == 0) break;
                sizehint = 1L;
            }
            return buf.toTString();
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PNone init(MultibyteStreamReaderObject self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=2, parameterNames={"$cls", "stream", "errors"})
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonTernaryBuiltinNode {
        private static final TruffleString CODEC = PythonUtils.tsLiteral("codec");

        protected NewNode() {
        }

        @Specialization
        protected Object mbstreamreaderNew(VirtualFrame frame, Object type, Object stream, Object err, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached PyObjectGetAttr getAttr, @Cached TruffleString.EqualNode isEqual) {
            TruffleString errors = null;
            if (err != PNone.NO_VALUE) {
                errors = castToStringNode.execute(inliningTarget, err);
            }
            MultibyteStreamReaderObject self = this.factory().createMultibyteStreamReaderObject(type);
            Object codec = getAttr.execute((Frame)frame, inliningTarget, type, CODEC);
            if (!(codec instanceof MultibyteCodecObject)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CODEC_IS_UNEXPECTED_TYPE);
            }
            self.codec = ((MultibyteCodecObject)codec).codec;
            self.stream = stream;
            self.pendingsize = 0;
            self.errors = MultibyteCodecUtil.internalErrorCallback(errors, isEqual);
            self.state = self.codec.decinit(self.errors);
            return self;
        }
    }
}

