/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.MMapModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.MMapModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="mmap")
public final class MMapModuleBuiltins
extends PythonBuiltins {
    public static final TruffleString T_INIT_BUFFERPROTOCOL = PythonUtils.tsLiteral("mmap_init_bufferprotocol");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MMapModuleBuiltinsFactory.getFactories();
    }

    public MMapModuleBuiltins() {
        this.addBuiltinConstant("ACCESS_DEFAULT", (Object)0);
        this.addBuiltinConstant("ACCESS_READ", (Object)1);
        this.addBuiltinConstant("ACCESS_WRITE", (Object)2);
        this.addBuiltinConstant("ACCESS_COPY", (Object)3);
        this.addBuiltinConstant("ALLOCATIONGRANULARITY", (Object)4096);
        this.addBuiltinConstant("PAGESIZE", (Object)4096);
        for (PosixConstants.IntConstant c : PosixConstants.mmapFlags) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
        for (PosixConstants.IntConstant c : PosixConstants.mmapProtection) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.getContext().registerCApiHook(() -> CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_MMAP_INIT_BUFFERPROTOCOL, CApiTransitions.PythonToNativeNode.executeUncached((Object)PythonBuiltinClassType.PMMap)));
    }

    @Builtin(name="mmap", minNumOfPositionalArgs=3, parameterNames={"cls", "fd", "length", "flags", "prot", "access", "offset"}, constructsClass=PythonBuiltinClassType.PMMap)
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.LongIndex), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="FLAGS_DEFAULT"), @ArgumentClinic(name="prot", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="PROT_DEFAULT"), @ArgumentClinic(name="access", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ACCESS_ARG_DEFAULT"), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="0")})
    public static abstract class MMapNode
    extends PythonClinicBuiltinNode {
        protected static final int ACCESS_ARG_DEFAULT = 0;
        protected static final int FLAGS_DEFAULT = PosixConstants.MAP_SHARED.value;
        protected static final int PROT_DEFAULT = PosixConstants.PROT_WRITE.value | PosixConstants.PROT_READ.value;
        private static final int ANONYMOUS_FD = -1;

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapModuleBuiltinsClinicProviders.MMapNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!isIllegal(fd)"})
        PMMap doFile(VirtualFrame frame, Object clazz, int fd, long lengthIn, int flagsIn, int protIn, int accessIn, long offset, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupport, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            Object mmapHandle;
            int dupFd;
            this.checkLength(lengthIn);
            this.checkOffset(offset);
            int flags = flagsIn;
            int prot = protIn;
            int access = accessIn;
            switch (access) {
                case 1: {
                    flags = PosixConstants.MAP_SHARED.value;
                    prot = PosixConstants.PROT_READ.value;
                    break;
                }
                case 2: {
                    flags = PosixConstants.MAP_SHARED.value;
                    prot = PosixConstants.PROT_READ.value | PosixConstants.PROT_WRITE.value;
                    break;
                }
                case 3: {
                    flags = PosixConstants.MAP_PRIVATE.value;
                    prot = PosixConstants.PROT_READ.value | PosixConstants.PROT_WRITE.value;
                    break;
                }
                case 0: {
                    if ((prot & PosixConstants.PROT_READ.value) != 0 && (prot & PosixConstants.PROT_WRITE.value) != 0) break;
                    if ((prot & PosixConstants.PROT_WRITE.value) != 0) {
                        access = 2;
                        break;
                    }
                    access = 1;
                    break;
                }
                default: {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.MEM_MAPPED_OFFSET_INVALID_ACCESS);
                }
            }
            auditNode.audit(inliningTarget, "mmap.__new__", fd, lengthIn, access, offset);
            long length = lengthIn;
            if (fd != -1) {
                long[] fstatResult = null;
                try {
                    fstatResult = posixSupport.fstat(this.getPosixSupport(), fd);
                }
                catch (PosixSupportLibrary.PosixException posixException) {
                    // empty catch block
                }
                if (fstatResult != null && length == 0L) {
                    if (fstatResult[6] == 0L) {
                        throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_MMAP_AN_EMPTY_FILE);
                    }
                    if (offset >= fstatResult[6]) {
                        throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_S_IS_GREATER_THAN_FILE_SIZE, "offset");
                    }
                    length = fstatResult[6] - offset;
                } else if (fstatResult != null && (offset > fstatResult[6] || fstatResult[6] - offset < length)) {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_S_IS_GREATER_THAN_FILE_SIZE, "length");
                }
            }
            if (fd == -1) {
                dupFd = -1;
                flags |= PosixConstants.MAP_ANONYMOUS.value;
            } else {
                try {
                    dupFd = posixSupport.dup(this.getPosixSupport(), fd);
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            try {
                mmapHandle = posixSupport.mmap(this.getPosixSupport(), length, prot, flags, dupFd, offset);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return this.factory().createMMap(this.getContext(), clazz, mmapHandle, dupFd, length, access);
        }

        @Specialization(guards={"isIllegal(fd)"})
        PMMap doIllegal(Object clazz, int fd, long lengthIn, int flagsIn, int protIn, int accessIn, long offset) {
            throw this.raise(PythonBuiltinClassType.OSError);
        }

        protected static boolean isIllegal(int fd) {
            return fd < -1;
        }

        private void checkLength(long length) {
            if (length < 0L) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.MEM_MAPPED_LENGTH_MUST_BE_POSITIVE);
            }
        }

        private void checkOffset(long offset) {
            if (offset < 0L) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.MEM_MAPPED_OFFSET_MUST_BE_POSITIVE);
            }
        }
    }
}

