// CheckStyle: start generated
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

/**
 * Debug Info: <pre>
 *   Specialization {@link PyDictCheckExactNode#doBuiltinDict}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link PyDictCheckExactNode#doOtherDict}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link PyDictCheckExactNode#doOther}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(PyDictCheckExactNode.class)
@SuppressWarnings("javadoc")
public final class PyDictCheckExactNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static PyDictCheckExactNode getUncached() {
        return PyDictCheckExactNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul>
     */
    @NeverDefault
    public static PyDictCheckExactNode inline(@RequiredField(bits = 3, value = StateField.class) InlineTarget target) {
        return new PyDictCheckExactNodeGen.Inlined(target);
    }

    @GeneratedBy(PyDictCheckExactNode.class)
    @DenyReplace
    private static final class Inlined extends PyDictCheckExactNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link PyDictCheckExactNode#doBuiltinDict}
         *   1: SpecializationActive {@link PyDictCheckExactNode#doOtherDict}
         *   2: SpecializationActive {@link PyDictCheckExactNode#doOther}
         * </pre>
         */
        private final StateField state_0_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(PyDictCheckExactNode.class);
            this.state_0_ = target.getState(0, 3);
        }

        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0 /* is SpecializationActive[PyDictCheckExactNode.doBuiltinDict(PDict)] || SpecializationActive[PyDictCheckExactNode.doOtherDict(PDict)] || SpecializationActive[PyDictCheckExactNode.doOther(Object)] */) {
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[PyDictCheckExactNode.doBuiltinDict(PDict)] || SpecializationActive[PyDictCheckExactNode.doOtherDict(PDict)] */ && arg1Value instanceof PDict) {
                    PDict arg1Value_ = (PDict) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[PyDictCheckExactNode.doBuiltinDict(PDict)] */) {
                        if ((PGuards.isBuiltinDict(arg1Value_))) {
                            return PyDictCheckExactNode.doBuiltinDict(arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[PyDictCheckExactNode.doOtherDict(PDict)] */) {
                        if ((!(PGuards.isBuiltinDict(arg1Value_)))) {
                            return PyDictCheckExactNode.doOtherDict(arg1Value_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[PyDictCheckExactNode.doOther(Object)] */) {
                    if ((!(PGuards.isDict(arg1Value)))) {
                        return PyDictCheckExactNode.doOther(arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof PDict) {
                PDict arg1Value_ = (PDict) arg1Value;
                if ((PGuards.isBuiltinDict(arg1Value_))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[PyDictCheckExactNode.doBuiltinDict(PDict)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return PyDictCheckExactNode.doBuiltinDict(arg1Value_);
                }
                if ((!(PGuards.isBuiltinDict(arg1Value_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[PyDictCheckExactNode.doOtherDict(PDict)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return PyDictCheckExactNode.doOtherDict(arg1Value_);
                }
            }
            if ((!(PGuards.isDict(arg1Value)))) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[PyDictCheckExactNode.doOther(Object)] */;
                this.state_0_.set(arg0Value, state_0);
                return PyDictCheckExactNode.doOther(arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(PyDictCheckExactNode.class)
    @DenyReplace
    private static final class Uncached extends PyDictCheckExactNode {

        @TruffleBoundary
        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof PDict) {
                PDict arg1Value_ = (PDict) arg1Value;
                if ((PGuards.isBuiltinDict(arg1Value_))) {
                    return PyDictCheckExactNode.doBuiltinDict(arg1Value_);
                }
                if ((!(PGuards.isBuiltinDict(arg1Value_)))) {
                    return PyDictCheckExactNode.doOtherDict(arg1Value_);
                }
            }
            if ((!(PGuards.isDict(arg1Value)))) {
                return PyDictCheckExactNode.doOther(arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
