// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.objects.itertools.RepeatBuiltins.IterNode;
import com.oracle.graal.python.builtins.objects.itertools.RepeatBuiltins.LengthHintNode;
import com.oracle.graal.python.builtins.objects.itertools.RepeatBuiltins.NextNode;
import com.oracle.graal.python.builtins.objects.itertools.RepeatBuiltins.ReduceNode;
import com.oracle.graal.python.builtins.objects.itertools.RepeatBuiltins.ReprNode;
import com.oracle.graal.python.builtins.objects.str.StringUtils.SimpleTruffleStringFormatNode;
import com.oracle.graal.python.builtins.objects.str.StringUtilsFactory.SimpleTruffleStringFormatNodeGen;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrNodeGen;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNodeGen;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;

@GeneratedBy(RepeatBuiltins.class)
@SuppressWarnings("javadoc")
public final class RepeatBuiltinsFactory {

    public static List<NodeFactory<? extends PythonUnaryBuiltinNode>> getFactories() {
        return Arrays.asList(IterNodeFactory.getInstance(), NextNodeFactory.getInstance(), LengthHintNodeFactory.getInstance(), ReduceNodeFactory.getInstance(), ReprNodeFactory.getInstance());
    }

    @GeneratedBy(IterNode.class)
    public static final class IterNodeFactory implements NodeFactory<IterNode> {

        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        @Override
        public Class<IterNode> getNodeClass() {
            return IterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public IterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IterNode create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IterNode#iter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(IterNode.class)
        @SuppressWarnings("javadoc")
        public static final class IterNodeGen extends IterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IterNode#iter}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[RepeatBuiltins.IterNode.iter(PRepeat)] */ && arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    return IterNode.iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[RepeatBuiltins.IterNode.iter(PRepeat)] */;
                    this.state_0_ = state_0;
                    return IterNode.iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(NextNode.class)
    public static final class NextNodeFactory implements NodeFactory<NextNode> {

        private static final NextNodeFactory NEXT_NODE_FACTORY_INSTANCE = new NextNodeFactory();

        private NextNodeFactory() {
        }

        @Override
        public Class<NextNode> getNodeClass() {
            return NextNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public NextNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NextNode> getInstance() {
            return NEXT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NextNode create() {
            return new NextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NextNode#nextPos}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link NextNode#nextZero}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link NextNode#nextNeg}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre>
         */
        @GeneratedBy(NextNode.class)
        @SuppressWarnings("javadoc")
        public static final class NextNodeGen extends NextNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NextNode#nextPos}
             *   1: SpecializationActive {@link NextNode#nextZero}
             *   2: SpecializationActive {@link NextNode#nextNeg}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[RepeatBuiltins.NextNode.nextPos(PRepeat)] || SpecializationActive[RepeatBuiltins.NextNode.nextZero(PRepeat)] || SpecializationActive[RepeatBuiltins.NextNode.nextNeg(PRepeat)] */ && arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[RepeatBuiltins.NextNode.nextPos(PRepeat)] */) {
                        if ((arg0Value_.getCnt() > 0)) {
                            return NextNode.nextPos(arg0Value_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[RepeatBuiltins.NextNode.nextZero(PRepeat)] */) {
                        if ((arg0Value_.getCnt() == 0)) {
                            return nextZero(arg0Value_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[RepeatBuiltins.NextNode.nextNeg(PRepeat)] */) {
                        if ((arg0Value_.getCnt() < 0)) {
                            return NextNode.nextNeg(arg0Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    if ((arg0Value_.getCnt() > 0)) {
                        state_0 = state_0 | 0b1 /* add SpecializationActive[RepeatBuiltins.NextNode.nextPos(PRepeat)] */;
                        this.state_0_ = state_0;
                        return NextNode.nextPos(arg0Value_);
                    }
                    if ((arg0Value_.getCnt() == 0)) {
                        state_0 = state_0 | 0b10 /* add SpecializationActive[RepeatBuiltins.NextNode.nextZero(PRepeat)] */;
                        this.state_0_ = state_0;
                        return nextZero(arg0Value_);
                    }
                    if ((arg0Value_.getCnt() < 0)) {
                        state_0 = state_0 | 0b100 /* add SpecializationActive[RepeatBuiltins.NextNode.nextNeg(PRepeat)] */;
                        this.state_0_ = state_0;
                        return NextNode.nextNeg(arg0Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(LengthHintNode.class)
    public static final class LengthHintNodeFactory implements NodeFactory<LengthHintNode> {

        private static final LengthHintNodeFactory LENGTH_HINT_NODE_FACTORY_INSTANCE = new LengthHintNodeFactory();

        private LengthHintNodeFactory() {
        }

        @Override
        public Class<LengthHintNode> getNodeClass() {
            return LengthHintNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public LengthHintNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<LengthHintNode> getInstance() {
            return LENGTH_HINT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LengthHintNode create() {
            return new LengthHintNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link LengthHintNode#hintPos}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link LengthHintNode#hintNeg}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(LengthHintNode.class)
        @SuppressWarnings("javadoc")
        public static final class LengthHintNodeGen extends LengthHintNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LengthHintNode#hintPos}
             *   1: SpecializationActive {@link LengthHintNode#hintNeg}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private LengthHintNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[RepeatBuiltins.LengthHintNode.hintPos(PRepeat)] || SpecializationActive[RepeatBuiltins.LengthHintNode.hintNeg(PRepeat)] */ && arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[RepeatBuiltins.LengthHintNode.hintPos(PRepeat)] */) {
                        if ((arg0Value_.getCnt() >= 0)) {
                            return LengthHintNode.hintPos(arg0Value_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[RepeatBuiltins.LengthHintNode.hintNeg(PRepeat)] */) {
                        if ((arg0Value_.getCnt() < 0)) {
                            return hintNeg(arg0Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    if ((arg0Value_.getCnt() >= 0)) {
                        state_0 = state_0 | 0b1 /* add SpecializationActive[RepeatBuiltins.LengthHintNode.hintPos(PRepeat)] */;
                        this.state_0_ = state_0;
                        return LengthHintNode.hintPos(arg0Value_);
                    }
                    if ((arg0Value_.getCnt() < 0)) {
                        state_0 = state_0 | 0b10 /* add SpecializationActive[RepeatBuiltins.LengthHintNode.hintNeg(PRepeat)] */;
                        this.state_0_ = state_0;
                        return hintNeg(arg0Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(ReduceNode.class)
    public static final class ReduceNodeFactory implements NodeFactory<ReduceNode> {

        private static final ReduceNodeFactory REDUCE_NODE_FACTORY_INSTANCE = new ReduceNodeFactory();

        private ReduceNodeFactory() {
        }

        @Override
        public Class<ReduceNode> getNodeClass() {
            return ReduceNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ReduceNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ReduceNode> getInstance() {
            return REDUCE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReduceNode create() {
            return new ReduceNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReduceNode#reducePos}
         *     Activation probability: 0.65000
         *     With/without class size: 14/0 bytes
         *   Specialization {@link ReduceNode#reduceNeg}
         *     Activation probability: 0.35000
         *     With/without class size: 9/0 bytes
         * </pre>
         */
        @GeneratedBy(ReduceNode.class)
        @SuppressWarnings("javadoc")
        public static final class ReduceNodeGen extends ReduceNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reducePos}
             *   Parameter: {@link GetClassNode} getClass
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_GET_CLASS = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_0_UPDATER.subUpdater(2, 17), ReferenceField.create(MethodHandles.lookup(), "getClass_field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReduceNode#reducePos}
             *   1: SpecializationActive {@link ReduceNode#reduceNeg}
             *   2-18: InlinedCache
             *        Specialization: {@link ReduceNode#reducePos}
             *        Parameter: {@link GetClassNode} getClass
             *        Inline method: {@link GetClassNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reducePos}
             *   Parameter: {@link GetClassNode} getClass
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getClass_field1_;

            private ReduceNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[RepeatBuiltins.ReduceNode.reducePos(PRepeat, Node, GetClassNode)] || SpecializationActive[RepeatBuiltins.ReduceNode.reduceNeg(PRepeat, Node, GetClassNode)] */ && arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[RepeatBuiltins.ReduceNode.reducePos(PRepeat, Node, GetClassNode)] */) {
                        if ((arg0Value_.getCnt() >= 0)) {
                            Node inliningTarget__ = (this);
                            return reducePos(arg0Value_, inliningTarget__, INLINED_GET_CLASS);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[RepeatBuiltins.ReduceNode.reduceNeg(PRepeat, Node, GetClassNode)] */) {
                        if ((arg0Value_.getCnt() < 0)) {
                            Node inliningTarget__1 = (this);
                            return reduceNeg(arg0Value_, inliningTarget__1, INLINED_GET_CLASS);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    {
                        Node inliningTarget__ = null;
                        if ((arg0Value_.getCnt() >= 0)) {
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[RepeatBuiltins.ReduceNode.reducePos(PRepeat, Node, GetClassNode)] */;
                            this.state_0_ = state_0;
                            return reducePos(arg0Value_, inliningTarget__, INLINED_GET_CLASS);
                        }
                    }
                    {
                        Node inliningTarget__1 = null;
                        if ((arg0Value_.getCnt() < 0)) {
                            inliningTarget__1 = (this);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[RepeatBuiltins.ReduceNode.reduceNeg(PRepeat, Node, GetClassNode)] */;
                            this.state_0_ = state_0;
                            return reduceNeg(arg0Value_, inliningTarget__1, INLINED_GET_CLASS);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(ReprNode.class)
    public static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#reprPos}
         *     Activation probability: 0.65000
         *     With/without class size: 14/0 bytes
         *   Specialization {@link ReprNode#reprNeg}
         *     Activation probability: 0.35000
         *     With/without class size: 9/0 bytes
         * </pre>
         */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        public static final class ReprNodeGen extends ReprNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField STATE_1_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link GetClassNode} getClass
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_GET_CLASS = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_0_UPDATER.subUpdater(2, 17), ReferenceField.create(MethodHandles.lookup(), "getClass_field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectGetAttr} getAttrNode
             *   Inline method: {@link PyObjectGetAttrNodeGen#inline}</pre>
             */
            private static final PyObjectGetAttr INLINED_GET_ATTR = PyObjectGetAttrNodeGen.inline(InlineTarget.create(PyObjectGetAttr.class, STATE_0_UPDATER.subUpdater(19, 2), ReferenceField.create(MethodHandles.lookup(), "getAttr_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getAttr_field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectReprAsObjectNode} reprNode
             *   Inline method: {@link PyObjectReprAsObjectNodeGen#inline}</pre>
             */
            private static final PyObjectReprAsObjectNode INLINED_REPR = PyObjectReprAsObjectNodeGen.inline(InlineTarget.create(PyObjectReprAsObjectNode.class, STATE_1_UPDATER.subUpdater(0, 23), ReferenceField.create(MethodHandles.lookup(), "repr_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "repr_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "repr_field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "repr_field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "repr_field5_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link CastToTruffleStringNode} castNode
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}</pre>
             */
            private static final CastToTruffleStringNode INLINED_CAST_TO_TRUFFLE_STRING = CastToTruffleStringNodeGen.inline(InlineTarget.create(CastToTruffleStringNode.class, STATE_0_UPDATER.subUpdater(21, 8), ReferenceField.create(MethodHandles.lookup(), "castToTruffleString_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "castToTruffleString_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "castToTruffleString_field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReprNode#reprPos}
             *   1: SpecializationActive {@link ReprNode#reprNeg}
             *   2-18: InlinedCache
             *        Specialization: {@link ReprNode#reprPos}
             *        Parameter: {@link GetClassNode} getClass
             *        Inline method: {@link GetClassNodeGen#inline}
             *   19-20: InlinedCache
             *        Specialization: {@link ReprNode#reprPos}
             *        Parameter: {@link PyObjectGetAttr} getAttrNode
             *        Inline method: {@link PyObjectGetAttrNodeGen#inline}
             *   21-28: InlinedCache
             *        Specialization: {@link ReprNode#reprPos}
             *        Parameter: {@link CastToTruffleStringNode} castNode
             *        Inline method: {@link CastToTruffleStringNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-22: InlinedCache
             *        Specialization: {@link ReprNode#reprPos}
             *        Parameter: {@link PyObjectReprAsObjectNode} reprNode
             *        Inline method: {@link PyObjectReprAsObjectNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link GetClassNode} getClass
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getClass_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectGetAttr} getAttrNode
             *   Inline method: {@link PyObjectGetAttrNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getAttr_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectGetAttr} getAttrNode
             *   Inline method: {@link PyObjectGetAttrNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getAttr_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectReprAsObjectNode} reprNode
             *   Inline method: {@link PyObjectReprAsObjectNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectReprAsObjectNode} reprNode
             *   Inline method: {@link PyObjectReprAsObjectNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectReprAsObjectNode} reprNode
             *   Inline method: {@link PyObjectReprAsObjectNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectReprAsObjectNode} reprNode
             *   Inline method: {@link PyObjectReprAsObjectNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link PyObjectReprAsObjectNode} reprNode
             *   Inline method: {@link PyObjectReprAsObjectNodeGen#inline}
             *   Inline field: {@link Node} field5</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link CastToTruffleStringNode} castNode
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node castToTruffleString_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link CastToTruffleStringNode} castNode
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node castToTruffleString_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link CastToTruffleStringNode} castNode
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node castToTruffleString_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#reprPos}
             *   Parameter: {@link SimpleTruffleStringFormatNode} simpleTruffleStringFormatNode</pre>
             */
            @Child private SimpleTruffleStringFormatNode formatter;

            private ReprNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[RepeatBuiltins.ReprNode.reprPos(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)] || SpecializationActive[RepeatBuiltins.ReprNode.reprNeg(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)] */ && arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[RepeatBuiltins.ReprNode.reprPos(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)] */) {
                        {
                            SimpleTruffleStringFormatNode formatter_ = this.formatter;
                            if (formatter_ != null) {
                                if ((arg0Value_.getCnt() >= 0)) {
                                    Node inliningTarget__ = (this);
                                    return ReprNode.reprPos(frameValue, arg0Value_, inliningTarget__, INLINED_GET_CLASS, INLINED_GET_ATTR, INLINED_REPR, INLINED_CAST_TO_TRUFFLE_STRING, formatter_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[RepeatBuiltins.ReprNode.reprNeg(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)] */) {
                        {
                            SimpleTruffleStringFormatNode formatter_1 = this.formatter;
                            if (formatter_1 != null) {
                                if ((arg0Value_.getCnt() < 0)) {
                                    Node inliningTarget__1 = (this);
                                    return ReprNode.reprNeg(frameValue, arg0Value_, inliningTarget__1, INLINED_GET_CLASS, INLINED_GET_ATTR, INLINED_REPR, INLINED_CAST_TO_TRUFFLE_STRING, formatter_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private TruffleString executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PRepeat) {
                    PRepeat arg0Value_ = (PRepeat) arg0Value;
                    {
                        Node inliningTarget__ = null;
                        if ((arg0Value_.getCnt() >= 0)) {
                            inliningTarget__ = (this);
                            SimpleTruffleStringFormatNode formatter_;
                            SimpleTruffleStringFormatNode formatter__shared = this.formatter;
                            if (formatter__shared != null) {
                                formatter_ = formatter__shared;
                            } else {
                                formatter_ = this.insert((SimpleTruffleStringFormatNodeGen.create()));
                                if (formatter_ == null) {
                                    throw new IllegalStateException("Specialization 'reprPos(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)' contains a shared cache with name 'simpleTruffleStringFormatNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.formatter == null) {
                                VarHandle.storeStoreFence();
                                this.formatter = formatter_;
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[RepeatBuiltins.ReprNode.reprPos(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)] */;
                            this.state_0_ = state_0;
                            return ReprNode.reprPos(frameValue, arg0Value_, inliningTarget__, INLINED_GET_CLASS, INLINED_GET_ATTR, INLINED_REPR, INLINED_CAST_TO_TRUFFLE_STRING, formatter_);
                        }
                    }
                    {
                        Node inliningTarget__1 = null;
                        if ((arg0Value_.getCnt() < 0)) {
                            inliningTarget__1 = (this);
                            SimpleTruffleStringFormatNode formatter_1;
                            SimpleTruffleStringFormatNode formatter_1_shared = this.formatter;
                            if (formatter_1_shared != null) {
                                formatter_1 = formatter_1_shared;
                            } else {
                                formatter_1 = this.insert((SimpleTruffleStringFormatNodeGen.create()));
                                if (formatter_1 == null) {
                                    throw new IllegalStateException("Specialization 'reprNeg(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)' contains a shared cache with name 'simpleTruffleStringFormatNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.formatter == null) {
                                VarHandle.storeStoreFence();
                                this.formatter = formatter_1;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[RepeatBuiltins.ReprNode.reprNeg(VirtualFrame, PRepeat, Node, GetClassNode, PyObjectGetAttr, PyObjectReprAsObjectNode, CastToTruffleStringNode, SimpleTruffleStringFormatNode)] */;
                            this.state_0_ = state_0;
                            return ReprNode.reprNeg(frameValue, arg0Value_, inliningTarget__1, INLINED_GET_CLASS, INLINED_GET_ATTR, INLINED_REPR, INLINED_CAST_TO_TRUFFLE_STRING, formatter_1);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    int counter = 0;
                    counter += Integer.bitCount((state_0 & 0b11));
                    if (counter == 1) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
}
