// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.builtins.modules.hashlib.ShakeDigestObjectBuiltins.DigestNode;
import com.oracle.graal.python.builtins.modules.hashlib.ShakeDigestObjectBuiltins.DigestSizeNode;
import com.oracle.graal.python.builtins.modules.hashlib.ShakeDigestObjectBuiltins.HexdigestNode;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes.ByteToHexNode;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodesFactory.ByteToHexNodeFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(ShakeDigestObjectBuiltins.class)
@SuppressWarnings("javadoc")
public final class ShakeDigestObjectBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(DigestSizeNodeFactory.getInstance(), DigestNodeFactory.getInstance(), HexdigestNodeFactory.getInstance());
    }

    @GeneratedBy(DigestSizeNode.class)
    static final class DigestSizeNodeFactory implements NodeFactory<DigestSizeNode> {

        private static final DigestSizeNodeFactory DIGEST_SIZE_NODE_FACTORY_INSTANCE = new DigestSizeNodeFactory();

        private DigestSizeNodeFactory() {
        }

        @Override
        public Class<DigestSizeNode> getNodeClass() {
            return DigestSizeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public DigestSizeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<DigestSizeNode> getInstance() {
            return DIGEST_SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DigestSizeNode create() {
            return new DigestSizeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DigestSizeNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(DigestSizeNode.class)
        @SuppressWarnings("javadoc")
        static final class DigestSizeNodeGen extends DigestSizeNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DigestSizeNode#get}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private DigestSizeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ShakeDigestObjectBuiltins.DigestSizeNode.get(DigestObject)] */ && arg0Value instanceof DigestObject) {
                    DigestObject arg0Value_ = (DigestObject) arg0Value;
                    return DigestSizeNode.get(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private int executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof DigestObject) {
                    DigestObject arg0Value_ = (DigestObject) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ShakeDigestObjectBuiltins.DigestSizeNode.get(DigestObject)] */;
                    this.state_0_ = state_0;
                    return DigestSizeNode.get(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(DigestNode.class)
    static final class DigestNodeFactory implements NodeFactory<DigestNode> {

        private static final DigestNodeFactory DIGEST_NODE_FACTORY_INSTANCE = new DigestNodeFactory();

        private DigestNodeFactory() {
        }

        @Override
        public Class<DigestNode> getNodeClass() {
            return DigestNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public DigestNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<DigestNode> getInstance() {
            return DIGEST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DigestNode create() {
            return new DigestNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DigestNode#digest}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(DigestNode.class)
        @SuppressWarnings("javadoc")
        static final class DigestNodeGen extends DigestNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DigestNode#digest}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private DigestNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ShakeDigestObjectBuiltins.DigestNode.digest(DigestObject, int)] */ && arg0Value instanceof DigestObject) {
                    DigestObject arg0Value_ = (DigestObject) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        return digest(arg0Value_, arg1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private PBytes executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof DigestObject) {
                    DigestObject arg0Value_ = (DigestObject) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ShakeDigestObjectBuiltins.DigestNode.digest(DigestObject, int)] */;
                        this.state_0_ = state_0;
                        return digest(arg0Value_, arg1Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(HexdigestNode.class)
    static final class HexdigestNodeFactory implements NodeFactory<HexdigestNode> {

        private static final HexdigestNodeFactory HEXDIGEST_NODE_FACTORY_INSTANCE = new HexdigestNodeFactory();

        private HexdigestNodeFactory() {
        }

        @Override
        public Class<HexdigestNode> getNodeClass() {
            return HexdigestNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public HexdigestNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<HexdigestNode> getInstance() {
            return HEXDIGEST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HexdigestNode create() {
            return new HexdigestNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link HexdigestNode#hexdigest}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(HexdigestNode.class)
        @SuppressWarnings("javadoc")
        static final class HexdigestNodeGen extends HexdigestNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HexdigestNode#hexdigest}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HexdigestNode#hexdigest}
             *   Parameter: {@link ByteToHexNode} toHexNode</pre>
             */
            @Child private ByteToHexNode toHexNode_;

            private HexdigestNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ShakeDigestObjectBuiltins.HexdigestNode.hexdigest(DigestObject, int, ByteToHexNode)] */ && arg0Value instanceof DigestObject) {
                    DigestObject arg0Value_ = (DigestObject) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        {
                            ByteToHexNode toHexNode__ = this.toHexNode_;
                            if (toHexNode__ != null) {
                                return hexdigest(arg0Value_, arg1Value_, toHexNode__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof DigestObject) {
                    DigestObject arg0Value_ = (DigestObject) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        ByteToHexNode toHexNode__ = this.insert((ByteToHexNodeFactory.create()));
                        Objects.requireNonNull(toHexNode__, "Specialization 'hexdigest(DigestObject, int, ByteToHexNode)' cache 'toHexNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.toHexNode_ = toHexNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ShakeDigestObjectBuiltins.HexdigestNode.hexdigest(DigestObject, int, ByteToHexNode)] */;
                        this.state_0_ = state_0;
                        return hexdigest(arg0Value_, arg1Value_, toHexNode__);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
