/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.util;

import com.oracle.graal.python.enterprise.builtins.objects.pickle.PickleUtils;
import com.oracle.graal.python.util.PythonUtils;

public class ByteArrayView {
    private final byte[] bytes;
    private int offset;

    public ByteArrayView(byte[] bytes) {
        this(bytes, 0);
    }

    public ByteArrayView(byte[] bytes, int offset) {
        this.bytes = bytes;
        this.offset = offset;
        this.validateOffset(0);
    }

    private void validateOffset(int n) {
        assert (this.offset + n >= 0 && this.offset + n <= this.bytes.length);
    }

    public void add(int n) {
        this.validateOffset(n);
        this.offset += n;
    }

    public void sub(int n) {
        this.add(-n);
    }

    public byte[] getBytes(int len) {
        assert (len >= 0 && len + this.offset >= 0 && len + this.offset <= this.bytes.length);
        if (this.offset == 0 && len == this.bytes.length) {
            return this.bytes;
        }
        byte[] arr = new byte[len];
        PythonUtils.arraycopy((Object)this.bytes, (int)this.offset, (Object)arr, (int)0, (int)len);
        return arr;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte get(int i) {
        return this.bytes[this.offset + i];
    }

    public int getUnsigned(int i) {
        return this.get(i) & 0xFF;
    }

    public void put(int i, byte value) {
        this.bytes[this.offset + i] = value;
    }

    public void writeSize64(int value) {
        PickleUtils.writeSize64(this.bytes, this.offset, value);
    }

    public void memmove(int off, int num) {
        PythonUtils.arraycopy((Object)this.bytes, (int)(this.offset + off), (Object)this.bytes, (int)this.offset, (int)num);
    }
}

