/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.pickle;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.enterprise.builtins.nodes.EnterpriseErrorMessages;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.MemoTable;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PPickler;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PPicklerMemoProxy;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PickleUtils;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PicklerBuiltinsClinicProviders;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PicklerBuiltinsFactory;
import com.oracle.graal.python.enterprise.builtins.runtime.object.EnterprisePythonObjectFactory;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Pickler})
public class PicklerBuiltins
extends PythonBuiltins {
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PicklerBuiltinsFactory.getFactories();
    }

    @Builtin(name="persistent_id", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class PicklerPersistentIdNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        Object get(PPickler self, PNone none) {
            Object persFunc = self.getPersFunc();
            if (persFunc == null) {
                throw this.raise(PythonBuiltinClassType.AttributeError, PickleUtils.T_METHOD_PERSISTENT_ID);
            }
            return PickleUtils.reconstructMethod(this.factory(), persFunc, self.getPersFuncSelf());
        }

        @Specialization(guards={"!isNoValue(obj)", "!isDeleteMarker(obj)"})
        Object set(PPickler self, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck) {
            if (PGuards.isDeleteMarker((Object)obj)) {
                throw this.raise(PythonBuiltinClassType.TypeError, EnterpriseErrorMessages.ATRIBUTE_DELETION_NOT_SUPPORTED);
            }
            if (!callableCheck.execute(inliningTarget, obj)) {
                throw this.raise(PythonBuiltinClassType.TypeError, EnterpriseErrorMessages.ATTR_MUST_BE_A_CALLABLE, new Object[]{PickleUtils.T_METHOD_PERSISTENT_ID, "one argument"});
            }
            self.setPersFuncSelf(null);
            self.setPersFunc(obj);
            return PNone.NONE;
        }
    }

    @Builtin(name="memo", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class PicklerMemoNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        Object get(PPickler self, PNone none) {
            return EnterprisePythonObjectFactory.createPicklerMemoProxy(this.factory(), self);
        }

        @Specialization(guards={"!isNoValue(obj)", "!isDeleteMarker(obj)"})
        Object set(VirtualFrame frame, PPickler self, Object obj, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached PyObjectSizeNode sizeNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorValue iterValue) {
            MemoTable newMemo;
            if (obj instanceof PPicklerMemoProxy) {
                PPickler pickler = ((PPicklerMemoProxy)((Object)obj)).getPickler();
                newMemo = pickler.getMemo().copy();
            } else if (obj instanceof PDict) {
                newMemo = new MemoTable();
                HashingStorage dictStorage = getHashingStorageNode.execute(frame, inliningTarget, obj);
                HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, dictStorage);
                while (iterNext.execute(inliningTarget, dictStorage, it)) {
                    Object value = iterValue.execute(inliningTarget, dictStorage, it);
                    if (!(value instanceof PTuple) || sizeNode.execute((Frame)frame, inliningTarget, value) != 2) {
                        throw this.raise(PythonBuiltinClassType.TypeError, EnterpriseErrorMessages.VALUES_MUST_BE_2TUPLES, new Object[]{"memo"});
                    }
                    SequenceStorage tupleStorage = getSequenceStorageNode.execute(inliningTarget, value);
                    int memoId = asSizeNode.executeExact((Frame)frame, inliningTarget, getItemNode.execute(frame, tupleStorage, (Object)0));
                    Object memoObj = getItemNode.execute(frame, tupleStorage, (Object)1);
                    newMemo.set(memoObj, memoId);
                }
            } else {
                throw this.raise(PythonBuiltinClassType.TypeError, EnterpriseErrorMessages.ATTR_MUST_BE_A_OR_B_NOT_C, new Object[]{"memo", "PicklerMemoProxy", "dict", obj});
            }
            self.setMemo(newMemo);
            return PNone.NONE;
        }
    }

    @Builtin(name="fast", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class PicklerFastNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        Object get(PPickler self, PNone none) {
            return self.getFast();
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)"})
        Object set(VirtualFrame frame, PPickler self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongAsLongNode asLongNode) {
            self.setFast((int)asLongNode.execute((Frame)frame, inliningTarget, value));
            return PNone.NONE;
        }
    }

    @Builtin(name="bin", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class PicklerBinNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        Object get(PPickler self, PNone none) {
            return self.getBin();
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)"})
        Object set(VirtualFrame frame, PPickler self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongAsLongNode asLongNode) {
            self.setBin((int)asLongNode.execute((Frame)frame, inliningTarget, value));
            return PNone.NONE;
        }
    }

    @Builtin(name="dispatch_table", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    public static abstract class PicklerDispatchTableNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        Object get(PPickler self, PNone none) {
            Object dispatchTable = self.getDispatchTable();
            if (dispatchTable == null) {
                throw this.raise(PythonBuiltinClassType.AttributeError, PickleUtils.T_ATTR_DISPATCH_TABLE);
            }
            return dispatchTable;
        }

        @Specialization(guards={"isDeleteMarker(marker)"})
        Object delete(PPickler self, Object marker) {
            Object dispatchTable = self.getDispatchTable();
            if (dispatchTable == null) {
                throw this.raise(PythonBuiltinClassType.AttributeError, PickleUtils.T_ATTR_DISPATCH_TABLE);
            }
            self.setDispatchTable(null);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)"})
        Object set(PPickler self, Object value) {
            self.setDispatchTable(value);
            return PNone.NONE;
        }
    }

    @Builtin(name="__sizeof__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerSizeofNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object sizeof(PPickler self) {
            return -1;
        }
    }

    @Builtin(name="clear_memo", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerClearMemoNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object clearMemo(PPickler self) {
            self.clearMemo();
            return PNone.NONE;
        }
    }

    @Builtin(name="dump", minNumOfPositionalArgs=2, parameterNames={"$self", "obj"})
    @GenerateNodeFactory
    public static abstract class PicklerDumpNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object dump(VirtualFrame frame, PPickler self, Object obj, @Cached PPickler.FlushToFileNode flushToFileNode, @Cached PPickler.DumpNode dumpNode) {
            if (self.getWrite() == null) {
                throw this.raise(PythonBuiltinClassType.PicklingError, EnterpriseErrorMessages.INIT_CALLED_WITH, new Object[]{"Pickler", self});
            }
            self.clearBuffer();
            dumpNode.execute(frame, self, obj);
            flushToFileNode.execute(frame, self);
            return PNone.NONE;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "file", "protocol", "fix_imports", "buffer_callback"})
    @ArgumentsClinic(value={@ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="4", useDefaultForNone=true), @ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    public static abstract class PicklerInitNode
    extends PythonClinicBuiltinNode {
        protected ArgumentClinicProvider getArgumentClinic() {
            return PicklerBuiltinsClinicProviders.PicklerInitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object init(VirtualFrame frame, PPickler self, Object file, int protocol, boolean fixImports, Object bufferCallback, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup) {
            self.setProtocol((PNodeWithRaise)this, protocol, fixImports);
            self.setOutputStream(frame, inliningTarget, (PNodeWithRaise)this, lookup, file);
            self.setBufferCallback((PNodeWithRaise)this, bufferCallback);
            self.initInternals(frame, inliningTarget, lookup);
            return PNone.NONE;
        }
    }
}

