/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.python.embedding.VirtualFileSystemImpl;

public final class VirtualFileSystem
implements AutoCloseable {
    final VirtualFileSystemImpl impl;
    final FileSystem delegatingFileSystem;

    private static Path getMountPointAsPath(String mp) {
        Path mountPoint = Path.of(mp, new String[0]);
        if (mp.endsWith(VirtualFileSystemImpl.PLATFORM_SEPARATOR) || !mountPoint.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Virtual filesystem mount point must be set to an absolute path without a trailing separator: '%s'", mp));
        }
        return mountPoint;
    }

    private VirtualFileSystem(Predicate<Path> extractFilter, Path mountPoint, HostIO allowHostIO, Class<?> resourceLoadingClass, String resourceDirectory, boolean caseInsensitive) {
        this.impl = new VirtualFileSystemImpl(extractFilter, mountPoint, resourceDirectory, allowHostIO, resourceLoadingClass, caseInsensitive);
        this.delegatingFileSystem = VirtualFileSystemImpl.createDelegatingFileSystem(this.impl);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VirtualFileSystem create() {
        return VirtualFileSystem.newBuilder().build();
    }

    public String getMountPoint() {
        return this.impl.mountPoint.toString();
    }

    @Override
    public void close() throws IOException {
        this.impl.close();
    }

    public static enum HostIO {
        NONE,
        READ,
        READ_WRITE;

    }

    public static final class Builder {
        private static final Predicate<Path> DEFAULT_EXTRACT_FILTER = p -> {
            String s = p.toString();
            return s.endsWith(".so") || s.endsWith(".dylib") || s.endsWith(".pyd") || s.endsWith(".dll") || s.endsWith(".ttf");
        };
        private static final String DEFAULT_WINDOWS_MOUNT_POINT = "X:\\graalpy_vfs";
        private static final String DEFAULT_UNIX_MOUNT_POINT = "/graalpy_vfs";
        private Path mountPoint;
        private Predicate<Path> extractFilter = DEFAULT_EXTRACT_FILTER;
        private HostIO allowHostIO = HostIO.READ_WRITE;
        private boolean caseInsensitive = VirtualFileSystemImpl.isWindows();
        private Class<?> resourceLoadingClass;
        private String resourceDirectory;

        private Builder() {
        }

        public Builder resourceDirectory(String directory) {
            if (directory.startsWith("/")) {
                throw new IllegalArgumentException("Use relative resources path, i.e., not starting with '/'.");
            }
            this.resourceDirectory = directory;
            return this;
        }

        public Builder caseInsensitive(boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public Builder allowHostIO(HostIO b) {
            this.allowHostIO = b;
            return this;
        }

        public Builder windowsMountPoint(String windowsMountPoint) {
            if (VirtualFileSystemImpl.isWindows()) {
                this.mountPoint = VirtualFileSystem.getMountPointAsPath(windowsMountPoint);
            }
            return this;
        }

        public Builder unixMountPoint(String unixMountPoint) {
            if (!VirtualFileSystemImpl.isWindows()) {
                this.mountPoint = VirtualFileSystem.getMountPointAsPath(unixMountPoint);
            }
            return this;
        }

        public Builder resourceLoadingClass(Class<?> c) {
            this.resourceLoadingClass = c;
            return this;
        }

        public Builder extractFilter(Predicate<Path> filter) {
            this.extractFilter = filter == null ? null : p -> filter.test((Path)p) || DEFAULT_EXTRACT_FILTER.test((Path)p);
            return this;
        }

        public VirtualFileSystem build() {
            if (this.mountPoint == null) {
                this.mountPoint = VirtualFileSystemImpl.isWindows() ? Path.of(DEFAULT_WINDOWS_MOUNT_POINT, new String[0]) : Path.of(DEFAULT_UNIX_MOUNT_POINT, new String[0]);
            }
            return new VirtualFileSystem(this.extractFilter, this.mountPoint, this.allowHostIO, this.resourceLoadingClass, this.resourceDirectory, this.caseInsensitive);
        }
    }
}

