/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.IOAccess;
import org.graalvm.python.embedding.utils.VirtualFileSystem;

public class GraalPyResources {
    public static Context createContext() {
        return GraalPyResources.contextBuilder().build();
    }

    public static Context.Builder contextBuilder() {
        VirtualFileSystem vfs = VirtualFileSystem.create();
        return GraalPyResources.contextBuilder(vfs);
    }

    public static Context.Builder contextBuilder(VirtualFileSystem vfs) {
        return GraalPyResources.createContextBuilder().allowIO(IOAccess.newBuilder().allowHostSocketAccess(true).fileSystem((FileSystem)vfs).build()).option("python.Executable", vfs.vfsVenvPath() + (VirtualFileSystem.isWindows() ? "\\Scripts\\python.exe" : "/bin/python")).option("python.PythonHome", vfs.vfsHomePath()).option("python.PythonPath", vfs.vfsSrcPath() + File.pathSeparator + vfs.vfsProjPath()).option("python.InputFilePath", vfs.vfsSrcPath());
    }

    public static Context.Builder contextBuilder(Path resourcesDirectory) {
        String execPath = resourcesDirectory.resolve("venv/bin/python").toAbsolutePath().toString();
        String homePath = resourcesDirectory.resolve("home").toAbsolutePath().toString();
        String srcPath = resourcesDirectory.resolve("src").toAbsolutePath().toString();
        return GraalPyResources.createContextBuilder().allowIO(IOAccess.ALL).option("python.Executable", execPath).option("python.PythonHome", homePath).option("python.PythonPath", srcPath).option("python.InputFilePath", srcPath);
    }

    private static Context.Builder createContextBuilder() {
        return Context.newBuilder((String[])new String[0]).allowExperimentalOptions(false).allowAllAccess(false).allowHostAccess(HostAccess.ALL).allowCreateThread(true).allowNativeAccess(true).allowPolyglotAccess(PolyglotAccess.ALL).option("python.PosixModuleBackend", "java").option("python.DontWriteBytecodeFlag", "true").option("python.VerboseFlag", System.getenv("PYTHONVERBOSE") != null ? "true" : "false").option("log.python.level", System.getenv("PYTHONVERBOSE") != null ? "FINE" : "SEVERE").option("python.WarnOptions", System.getenv("PYTHONWARNINGS") == null ? "" : System.getenv("PYTHONWARNINGS")).option("python.AlwaysRunExcepthook", "true").option("python.ForceImportSite", "true").option("engine.WarnInterpreterOnly", "false").option("python.CheckHashPycsMode", "never");
    }

    public static Path getNativeExecutablePath() {
        if (ImageInfo.inImageRuntimeCode()) {
            String pn = null;
            pn = ProcessProperties.getArgumentVectorBlockSize() > 0 ? ProcessProperties.getArgumentVectorProgramName() : ProcessProperties.getExecutableName();
            if (pn != null) {
                return Paths.get(pn, new String[0]).toAbsolutePath();
            }
        }
        return null;
    }

    public static void extractVirtualFileSystemResources(VirtualFileSystem vfs, Path resourcesDirectory) throws IOException {
        if (Files.exists(resourcesDirectory, new LinkOption[0]) && !Files.isDirectory(resourcesDirectory, new LinkOption[0])) {
            throw new IOException(String.format("%s has to be a directory", resourcesDirectory.toString()));
        }
        vfs.extractResources(resourcesDirectory);
    }
}

