/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.tools.vfs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.graalvm.python.embedding.tools.exec.GraalPyRunner;
import org.graalvm.python.embedding.tools.exec.SubprocessLog;

public final class VFSUtils {
    public static final String VFS_ROOT = "org.graalvm.python.vfs";
    public static final String VFS_HOME = "home";
    public static final String VFS_VENV = "venv";
    public static final String VFS_FILESLIST = "fileslist.txt";

    public static void generateVFSFilesList(Path vfs) throws IOException {
        Path filesList = vfs.resolve(VFS_FILESLIST);
        if (!Files.isDirectory(vfs, new LinkOption[0])) {
            throw new IOException(String.format("'%s' has to exist and be a directory.\n", vfs.toString()));
        }
        HashSet<String> ret = new HashSet<String>();
        String rootPath = VFSUtils.makeDirPath(vfs.toAbsolutePath());
        int rootEndIdx = rootPath.lastIndexOf(File.separator, rootPath.lastIndexOf(File.separator) - 1);
        ret.add(rootPath.substring(rootEndIdx));
        try (Stream<Path> s = Files.walk(vfs, new FileVisitOption[0]);){
            s.forEach(p -> {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    String dirPath = VFSUtils.makeDirPath(p.toAbsolutePath());
                    ret.add(dirPath.substring(rootEndIdx));
                } else if (Files.isRegularFile(p, new LinkOption[0])) {
                    ret.add(p.toAbsolutePath().toString().substring(rootEndIdx));
                }
            });
        }
        Object[] a = ret.toArray(new String[ret.size()]);
        Arrays.sort(a);
        try (FileWriter wr = new FileWriter(filesList.toFile());){
            for (Object f : a) {
                if (((String)f).charAt(0) == '\\') {
                    f = ((String)f).replace("\\", "/");
                }
                wr.write((String)f);
                wr.write("\n");
            }
        }
    }

    private static String makeDirPath(Path p) {
        Object ret = p.toString();
        if (!((String)ret).endsWith(File.separator)) {
            ret = (String)ret + File.separator;
        }
        return ret;
    }

    public static void copyGraalPyHome(Set<String> classpath, Path home, Collection<String> pythonHomeIncludes, Collection<String> pythonHomeExcludes, SubprocessLog log) throws IOException, InterruptedException {
        log.log(String.format("Copying std lib to '%s'\n", home));
        String stdlibHome = null;
        String coreHome = null;
        String pathsOutputPrefix = "<=outputpaths=>";
        CollectOutputLog outputLog = new CollectOutputLog();
        GraalPyRunner.run(classpath, outputLog, "-c", "print('" + pathsOutputPrefix + "', __graalpython__.get_python_home_paths(), sep='')");
        for (String l : outputLog.output) {
            if (!l.startsWith(pathsOutputPrefix)) continue;
            String[] s = l.substring(pathsOutputPrefix.length()).split(File.pathSeparator);
            stdlibHome = s[0];
            coreHome = s[1];
        }
        assert (stdlibHome != null);
        assert (coreHome != null);
        Path target = home.resolve("lib-graalpython");
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        Path source = Paths.get(coreHome, new String[0]);
        Predicate<Path> filter = f -> {
            if (Files.isDirectory(f, new LinkOption[0])) {
                if (f.getFileName().toString().equals("__pycache__") || f.getFileName().toString().equals("standalone")) {
                    return true;
                }
            } else {
                if (f.getFileName().endsWith(".py") || f.getFileName().endsWith(".txt") || f.getFileName().endsWith(".c") || f.getFileName().endsWith(".md") || f.getFileName().endsWith(".patch") || f.getFileName().endsWith(".toml") || f.getFileName().endsWith("PKG-INFO")) {
                    return true;
                }
                if (!VFSUtils.isIncluded(f.toAbsolutePath().toString(), pythonHomeIncludes)) {
                    return true;
                }
            }
            return VFSUtils.isExcluded(f.toAbsolutePath().toString(), pythonHomeExcludes);
        };
        VFSUtils.copyFolder(source, source, target, filter);
        target = home.resolve("lib-python").resolve("3");
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        source = Paths.get(stdlibHome, new String[0]);
        filter = f -> {
            if (Files.isDirectory(f, new LinkOption[0])) {
                if (f.getFileName().toString().equals("idlelib") || f.getFileName().toString().equals("ensurepip") || f.getFileName().toString().equals("tkinter") || f.getFileName().toString().equals("turtledemo") || f.getFileName().toString().equals("__pycache__")) {
                    return true;
                }
            } else {
                if (f.getFileName().toString().equals("libpythonvm.dll")) {
                    return true;
                }
                if (!VFSUtils.isIncluded(f.toAbsolutePath().toString(), pythonHomeIncludes)) {
                    return true;
                }
            }
            return VFSUtils.isExcluded(f.toAbsolutePath().toString(), pythonHomeExcludes);
        };
        VFSUtils.copyFolder(source, source, target, filter);
    }

    private static boolean isIncluded(String filePath, Collection<String> includes) {
        if (includes == null || includes.isEmpty()) {
            return true;
        }
        return VFSUtils.pathMatches(filePath, includes);
    }

    private static boolean isExcluded(String filePath, Collection<String> excludes) {
        if (excludes == null || excludes.isEmpty()) {
            return false;
        }
        return VFSUtils.pathMatches(filePath, excludes);
    }

    private static boolean pathMatches(String filePath, Collection<String> includes) {
        String path = filePath;
        if (File.separator.equals("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        for (String i : includes) {
            Pattern pattern = Pattern.compile(i);
            Matcher matcher = pattern.matcher(path);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private static void copyFolder(final Path sourceRoot, Path file, final Path targetRoot, final Predicate<Path> filter) throws IOException {
        Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                if (filter.test(f)) {
                    return FileVisitResult.CONTINUE;
                }
                if (Files.isDirectory(f, new LinkOption[0])) {
                    VFSUtils.copyFolder(sourceRoot, f, targetRoot, filter);
                } else {
                    Path relFile = sourceRoot.relativize(f);
                    Path targetPath = targetRoot.resolve(relFile.toString());
                    Path parent = targetPath.getParent();
                    if (parent == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!Files.exists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    if (Files.exists(targetPath, new LinkOption[0])) {
                        Files.delete(targetPath);
                    }
                    Files.copy(f, targetPath, new CopyOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static class CollectOutputLog
    implements SubprocessLog {
        private final List<String> output = new ArrayList<String>();

        private CollectOutputLog() {
        }

        @Override
        public void subProcessOut(CharSequence var1) {
            this.output.add(var1.toString());
        }

        @Override
        public void subProcessErr(CharSequence var1) {
            System.err.println(var1);
        }

        @Override
        public void log(CharSequence var1) {
        }
    }
}

